// Ticker TrailCD.mq4
// 

#property copyright "mandorr@gmail.com"
#property indicator_separate_window
#property indicator_buffers 1

#property indicator_color1 MediumVioletRed
#property indicator_width1 2
#property indicator_style1 0
#property indicator_maximum  120
#property indicator_minimum -120

extern int TrailFast=25;     //  
extern int TrailSlow=65;     //  
extern int CountBars=1000;   //   

int count;
int price;
int price_prev;

int trail_fast;
int trail_slow;

double ticker[10];           //  
double buffer[];

void init()
   {
   SetIndexBuffer(0,buffer);
   SetIndexLabel(0,"Value");
   SetIndexDrawBegin(0,0);

   count=ArrayResize(ticker,CountBars);
   count=0;
   price_prev=0;

   trail_fast=0; if (TrailFast>0) trail_fast=TrailFast;
   trail_slow=0; if (TrailSlow>0) trail_slow=TrailSlow;
   }

void start()
   {
   int i, value_fast, value_slow;
   if (trail_fast>=trail_slow) {Print("  "); return;}
   price=MathRound(Bid/Point);
   if (price_prev==0)
      {
      count=0;
      price_prev=price;
      ticker[0]=price*Point;
      buffer[0]=0;
      IndicatorShortName("Ticker ("+count+") TrailCD ("+trail_fast+","+trail_slow+")");
      return;
      }
   if (price==price_prev) return;
   price_prev=price;
   for (i=count; i>=0; i--)
      {
      ticker[i+1]=ticker[i];
      }
   ticker[0]=price*Point;
   if (count<CountBars-1) count++;
   price=MathRound(ticker[count]/Point);
   value_fast=price;
   value_slow=price;
   for (i=count; i>=0; i--)
      {
      price=MathRound(ticker[i]/Point);
      if (value_fast<price-trail_fast) value_fast=price-trail_fast;
      if (value_fast>price+trail_fast) value_fast=price+trail_fast;
      if (value_slow<price-trail_slow) value_slow=price-trail_slow;
      if (value_slow>price+trail_slow) value_slow=price+trail_slow;
      buffer[i]=100*(value_fast-value_slow)/(trail_slow-trail_fast);
      }
   IndicatorShortName("Ticker ("+count+") TrailCD ("+trail_fast+","+trail_slow+")");
   }

