// Ticker.mq4
// 

#property copyright "mandorr@gmail.com"
#property indicator_separate_window
#property indicator_buffers 2

#property indicator_color1 Gray
#property indicator_width1 1
#property indicator_style1 0

#property indicator_color2 Red
#property indicator_width2 1
#property indicator_style2 2


extern int PeriodSMA=10;     //   
extern int CountBars=1000;   //   

int count;
int price;
int price_prev;

double period;

double ticker[100];           //  
double signal[100];           //   
double buffer0[];
double buffer1[];

void init()
   {
   SetIndexBuffer(0,buffer0);
   SetIndexLabel(0,"Value");
   SetIndexDrawBegin(0,0);

   SetIndexBuffer(1,buffer1);
   SetIndexLabel(1,"Signal");
   SetIndexDrawBegin(1,0);

   count=ArrayResize(ticker,CountBars);
   count=ArrayResize(signal,CountBars);
   count=0;
   ArrayInitialize(signal,EMPTY_VALUE); // EMPTY_VALUE=+2147483647
   price_prev=0;
   period=MathMax(1,PeriodSMA);
   }

void start()
   {
   int i;
   double sum;
   price=MathRound(Bid/Point);
   if (price_prev==0)
      {
      count=0;
      price_prev=price;
      ticker[0]=price*Point;
      buffer0[0]=ticker[0];
      IndicatorShortName("Ticker ("+count+") SMA ("+DoubleToStr(period,0)+")");
      return;
      }
   if (price==price_prev) return;
   price_prev=price;
   for (i=count; i>=0; i--)
      {
      ticker[i+1]=ticker[i];
      signal[i+1]=signal[i];
      }
   ticker[0]=price*Point;
   if (count<CountBars-1) count++;
   if (count>=period-1)
      {
      sum=0;
      for (i=0; i<=period-1; i++) sum+=ticker[i];
      signal[0]=sum/period;
      }
   for (i=0; i<=count; i++)
      {
      buffer0[i]=ticker[i];
      buffer1[i]=signal[i];
      }
   IndicatorShortName("Ticker ("+count+") SMA ("+DoubleToStr(period,0)+")");
   }

