//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
#property copyright ""
#property link      ""
#property link      ""
#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 1
#define   labelNames "Tickwatcher"

//---- user selectable stuff
extern string __1    = "Chose pairs";
extern string pair_1 = "GBPUSD";
extern string pair_2 = "USDCAD";
extern string pair_3 = "AUDUSD";
extern string __2    = "Chose timeframes";
extern bool   show4h      = true;
extern bool   showDaily   = true;
extern bool   showWeekly  = true;
extern bool   showMonthly = true;

//
//
//
//
//

#define maxLabels 75
int totalLabels;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   IndicatorShortName("Tickwatcher");
   totalLabels =  0;
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   for(int i = 1; i < totalLabels ; i++)
      { 
         ObjectDelete(labelNames+i); deleteObject(i);
      }
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int m = 80;
   
      totalLabels = 0;
      if (iClose(pair_1,0,2)!=0 )
         {
               showPair(pair_1,m);
               m = m + 270;
         }               
      if (iClose(pair_2,0,2)!=0 )
         {
               showPair(pair_2,m);
               m = m + 270;
         }               
      if (iClose(pair_3,0,2)!=0 )
         {
               showPair(pair_3,m);
               m = m + 270;
         }               
      
      //
      //
      //
      //
      //
      
            for (m = totalLabels+1;m <= maxLabels; m++)
               ObjectDelete(labelNames+m);
      
      //
      //
      //
      //
      //
      
      return(0);
}

//
//
//
//
//

void showPair(string pair, int xdistance)
{
 
   int currentY = 15;
   
   //
   //
   //
   //
   //
     
   double adx_h4  = iADX(pair,PERIOD_H4,14,PRICE_CLOSE,0,0);
   double di_p_h4 = iADX(pair,PERIOD_H4,14,PRICE_CLOSE,1,0);
   double di_m_h4 = iADX(pair,PERIOD_H4,14,PRICE_CLOSE,2,0);

   double adx_d1  = iADX(pair,PERIOD_D1,14,PRICE_CLOSE,0,0);
   double di_p_d1 = iADX(pair,PERIOD_D1,14,PRICE_CLOSE,1,0);
   double di_m_d1 = iADX(pair,PERIOD_D1,14,PRICE_CLOSE,2,0);
   
   double adx_w1  = iADX(pair,PERIOD_W1,14,PRICE_CLOSE,0,0);
   double di_p_w1 = iADX(pair,PERIOD_W1,14,PRICE_CLOSE,1,0);
   double di_m_w1 = iADX(pair,PERIOD_W1,14,PRICE_CLOSE,2,0);
   
   double adx_m1  = iADX(pair,PERIOD_MN1,14,PRICE_CLOSE,0,0);
   double di_p_m1 = iADX(pair,PERIOD_MN1,14,PRICE_CLOSE,1,0);
   double di_m_m1 = iADX(pair,PERIOD_MN1,14,PRICE_CLOSE,2,0);

   //
   //
   //
   //
   //
      
   double haso_h4 = iCustom(pair,PERIOD_H4 ,"Heiken_Ashi_Smoothed_Alert",2,6,3,2,false,false,5,0);
   double hasc_h4 = iCustom(pair,PERIOD_H4 ,"Heiken_Ashi_Smoothed_Alert",2,6,3,2,false,false,6,0);
   double haso_d1 = iCustom(pair,PERIOD_D1 ,"Heiken_Ashi_Smoothed_Alert",2,6,3,2,false,false,5,0);
   double hasc_d1 = iCustom(pair,PERIOD_D1 ,"Heiken_Ashi_Smoothed_Alert",2,6,3,2,false,false,6,0);
   double haso_w1 = iCustom(pair,PERIOD_W1 ,"Heiken_Ashi_Smoothed_Alert",2,6,3,2,false,false,5,0);
   double hasc_w1 = iCustom(pair,PERIOD_W1 ,"Heiken_Ashi_Smoothed_Alert",2,6,3,2,false,false,6,0);
   double haso_m1 = iCustom(pair,PERIOD_MN1,"Heiken_Ashi_Smoothed_Alert",2,6,3,2,false,false,5,0);
   double hasc_m1 = iCustom(pair,PERIOD_MN1,"Heiken_Ashi_Smoothed_Alert",2,6,3,2,false,false,6,0);
   
   //---- define colors and arrows 
 
   color   adx_color_h4,adx_color_d1,adx_color_w1,adx_color_m1;
   string  adx_arrow_h4,adx_arrow_d1,adx_arrow_w1,adx_arrow_m1;
   color   has_color_h4,has_color_d1,has_color_w1,has_color_m1;
   string  has_arrow_h4,has_arrow_d1,has_arrow_w1,has_arrow_m1;
   
         has_color_h4 = setHColor(haso_h4,hasc_h4);
         has_color_d1 = setHColor(haso_d1,hasc_d1);
         has_color_w1 = setHColor(haso_w1,hasc_w1);
         has_color_m1 = setHColor(haso_m1,hasc_m1);
         has_arrow_h4 = setHArrow(haso_h4,hasc_h4);
         has_arrow_d1 = setHArrow(haso_d1,hasc_d1);
         has_arrow_w1 = setHArrow(haso_w1,hasc_w1);
         has_arrow_m1 = setHArrow(haso_m1,hasc_m1);
               
   //
   //
   //
   //
   //
   
   
      string  adx_value_h4  = adx_h4;
      string  adx_value_d1  = adx_d1;
      string  adx_value_w1  = adx_w1;
      string  adx_value_m1  = adx_m1;
              adx_color_h4  = setColor(adx_h4 ,di_p_h4 ,di_m_h4);
              adx_color_d1  = setColor(adx_d1 ,di_p_d1 ,di_m_d1);
              adx_color_w1  = setColor(adx_w1 ,di_p_w1 ,di_m_w1);
              adx_color_m1  = setColor(adx_m1 ,di_p_m1 ,di_m_m1);
              adx_arrow_h4  = setArrow(adx_h4 ,di_p_h4 ,di_m_h4);
              adx_arrow_d1  = setArrow(adx_d1 ,di_p_d1 ,di_m_d1);
              adx_arrow_w1  = setArrow(adx_w1 ,di_p_w1 ,di_m_w1);
              adx_arrow_m1  = setArrow(adx_m1 ,di_p_m1 ,di_m_m1);
   

      setObject(next(),pair,xdistance,2);
      if (show4h)     { setLabel( "4 hours:",xdistance    ,currentY,adx_value_h4 ,adx_color_h4 ,adx_arrow_h4); currentY += 13;}
      if (showDaily)  { setLabel( "1 day:"  ,xdistance    ,currentY,adx_value_d1 ,adx_color_d1 ,adx_arrow_d1); currentY += 13;}
      if (showWeekly) { setLabel( "1 week:" ,xdistance    ,currentY,adx_value_w1 ,adx_color_w1 ,adx_arrow_w1); currentY += 13;}
      if (showMonthly){ setLabel( "1 month:",xdistance    ,currentY,adx_value_m1 ,adx_color_m1 ,adx_arrow_m1);}
      currentY = 15;
      if (show4h)     { setLabel( "4 hours:",xdistance+150,currentY,"     "      ,has_color_h4 ,has_arrow_h4,false); currentY += 13;}
      if (showDaily)  { setLabel( "1 day:"  ,xdistance+150,currentY,"     "      ,has_color_d1 ,has_arrow_d1,false); currentY += 13;}
      if (showWeekly) { setLabel( "1 week:" ,xdistance+150,currentY,"     "      ,has_color_w1 ,has_arrow_w1,false); currentY += 13;}
      if (showMonthly){ setLabel( "1 month:",xdistance+150,currentY,"     "      ,has_color_m1 ,has_arrow_m1,false);}
}



//+------------------------------------------------------------------+
//| Custom functions and procedures                                  |
//+------------------------------------------------------------------+

string next()
{
   totalLabels += 1;
      return(totalLabels);
}  
color setHColor(double first,double second)
{
   color retColor;
   if (NormalizeDouble(first,Digits) <NormalizeDouble(second,Digits))  retColor = Red;
   if (NormalizeDouble(first,Digits) >NormalizeDouble(second,Digits))  retColor = Lime;
   if (NormalizeDouble(first,Digits)==NormalizeDouble(second,Digits))  retColor = LightSkyBlue;
   return(retColor);
}  
color setColor(double first,double second,double third)
{
   color retColor;
   if ((first < 23) && (first  !=    0)) { retColor = LightSkyBlue; }
   if ((first >=23) && (second > third)) { retColor = Lime; }
   if ((first >=23) && (second < third)) { retColor = Red; }
   return(retColor);
}  

//
//
//    ---- assign arrows 
//             strong up:   { adx_arrow_ = ""; } 
//             strong down: { adx_arrow_ = ""; }
//             up:          { adx_arrow_ = ""; } 
//             down:        { adx_arrow_ = ""; }
//             range: { adx_arrow_ = "h"; }
//             use wingdings for these, the h is squiggly line
//
//

string setHArrow(double first, double second)
{
   string arrow;

   if (NormalizeDouble(first,Digits) <NormalizeDouble(second,Digits))  arrow = "";
   if (NormalizeDouble(first,Digits) >NormalizeDouble(second,Digits))  arrow = "";
   if (NormalizeDouble(first,Digits)==NormalizeDouble(second,Digits))  arrow = "h";
   return(arrow);
}
string setArrow(double first, double second, double third)
{
   string arrow;
   
   if ( first <  23 && first != 0)                      { arrow = "h"; }
   if ((first >= 23 && first < 28) && (second > third)) { arrow = ""; }
   if ((first >= 23 && first < 28) && (second < third)) { arrow = ""; }
   if ( first >= 28                && (second > third)) { arrow = ""; }
   if ( first >= 28                && (second < third)) { arrow = ""; }
   return(arrow);
}

//
//
//
//
//

void setLabel(string text,int x,int y,string value, color theColor, string arrow, bool isADX=true)
{
     string addition = " HAS ";
     int    last     = 90;
     
     if (isADX) {addition = " ADX "; last=128;}
      
         setObject(next(),text                            ,x     ,y);
         setObject(next(),addition+StringSubstr(value,0,5),x+55  ,y,theColor);
         setObject(next(),arrow                           ,x+last,y,theColor,"Wingdings");
}

//
//
//
//
//

void setObject(string name,string text,int x,int y,color theColor = LightSteelBlue, string font = "Lucida Sans Regular")
{
      string indNames = "Tickwatcher";
      int    window   = WindowFind(indNames);  
      
      if (ObjectFind(labelNames+name) == -1)
            {
               ObjectCreate(labelNames+name,OBJ_LABEL,window,0,0);
                  ObjectSet(labelNames+name,OBJPROP_CORNER,0);
            }               

            //
            //
            //
            //
            //
            
            ObjectSet(labelNames+name,OBJPROP_XDISTANCE,x);
            ObjectSet(labelNames+name,OBJPROP_YDISTANCE,y);
            ObjectSetText(labelNames+name,text,9,font,theColor);
}
void deleteObject(int name)
{
  if (ObjectFind(labelNames+name) > 0) ObjectDelete(labelNames+name);
}
//+------------------------------------------------------------------+