//+------------------------------------------------------------------+
//|                                                        SmCCI.mq4 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 Lime
//---- input parameters

extern int per=8;


//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,ExtMapBuffer2);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   double malim, mared, delma;
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   for(int i=0; i<limit; i++)
   {
      malim=iMA(NULL,0,per,0,MODE_SMA,PRICE_TYPICAL,i);
      mared=iMA(NULL,0,per,0,MODE_SMA,PRICE_TYPICAL,i+5);
      delma=MathRound((malim-mared)/Point);
      ExtMapBuffer1[i]=0;
      ExtMapBuffer2[i]=0;
      if (delma>0) ExtMapBuffer1[i]=delma;
      if (delma<0) ExtMapBuffer2[i]=delma;
   }
   
   return(0);
  }
//+------------------------------------------------------------------+