//+------------------------------------------------------------------+
//|                                                        SmWPR.mq4 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Gold
#property indicator_color2 Red
#property indicator_color3 DeepSkyBlue
//---- input parameters
extern int       per=8;
extern int       sdvig=5;
extern int       x_prd=0;
extern int       t3_period=8;
extern double    b=0.7;
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];

double e1, e2, e3, e4, e5, e6, c1, c2, c3, c4, n, w1, w2, b2, b3;
double shift, malim, mared, t3;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
    
   SetIndexStyle(0,DRAW_LINE, STYLE_SOLID, 1);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM, STYLE_SOLID, 1);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexStyle(2,DRAW_HISTOGRAM, STYLE_SOLID, 1);
   SetIndexBuffer(2,ExtMapBuffer3);
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {   int shift;
      b2=b*b;
      b3=b2*b;
      c1=-b3;
      c2=(3*(b2+b3));
      c3=-3*(2*b2+b+b3);
      c4=(1+3*b+b3+3*b2);
      n=t3_period;

      if (n<1) {n=1;}
      n = 1 + 0.5*(n-1);
      w1 = 2 / (n + 1);
      w2 = 1 - w1;

      /*for(int shift=Bars-1; shift>0; shift--)
      {
         ExtMapBuffer1[shift]=0;
         ExtMapBuffer2[shift]=0;
         ExtMapBuffer3[shift]=0;
      }*/
   
      for(shift=Bars-per; shift>0; shift--)
      {
         malim=iMA(NULL, 0, per, 0, MODE_EMA, PRICE_CLOSE,shift);
         mared=iMA(NULL, 0, per, 0, MODE_EMA, PRICE_CLOSE,shift+sdvig);
         
         e1 = w1*malim + w2*e1;
         e2 = w1*e1 + w2*e2;
         e3 = w1*e2 + w2*e3;
         e4 = w1*e3 + w2*e4;
         e5 = w1*e4 + w2*e5;
         e6 = w1*e5 + w2*e6;

         t3 = c1*e6 + c2*e5 + c3*e4 + c4*e3;
         
         
         ExtMapBuffer1[shift]=t3;
         ExtMapBuffer2[shift]=mared;
         if (t3>mared) {ExtMapBuffer3[shift]=mared;} 
     }
   
   return(0);
  }
//+------------------------------------------------------------------+