//+------------------------------------------------------------------+ 
//|                                             TrendStrengthEVO.mq4 | 
//|                                                                  | 
//|                                                                  | 
//|                                               modified by nnjeim |
//+------------------------------------------------------------------+ 
#property copyright "forex-tsd" 
#property link      "http://www.forex-tsd.com" 

#property indicator_separate_window 
#property indicator_buffers 2 

#property indicator_color1 Lime 
#property indicator_color2 Crimson 

#property indicator_level1 0

extern int SEMA=14;
extern int MEMA=34;
extern int LEMA=50;

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double AVE[];
//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int init() 
  { 
   IndicatorBuffers(3);  

   IndicatorShortName("TrendStrength EVO"); 
    
   SetIndexBuffer(0,ExtMapBuffer1); 
   SetIndexStyle(0, DRAW_HISTOGRAM, STYLE_SOLID, 2); 
   SetIndexDrawBegin(0,2); 
   SetIndexLabel(0,"ExtMapBuffer1");   
   
   SetIndexBuffer(1,ExtMapBuffer2); 
   SetIndexStyle(1, DRAW_HISTOGRAM, STYLE_SOLID, 2); 
   SetIndexDrawBegin(1,2); 
   SetIndexLabel(1,"ExtMapBuffer2");   

   SetIndexBuffer(2,AVE);              
//---- indicators 
//---- 
   return(0); 
  } 
//+------------------------------------------------------------------+ 
//| Custor indicator deinitialization function                       | 
//+------------------------------------------------------------------+ 
int deinit() 
  { 
//---- TODO: add your code here 
    
//---- 
   return(0); 
  } 
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int start() 
  { 
   int    shift,counted_bars=IndicatorCounted(); 
   double  ma1, ma2, ma3; 
               

  //---- check for possible errors 
     if(counted_bars<0) return(-1); 
  //---- last counted bar will be recounted 
     if(counted_bars>0) counted_bars--; 
   shift=Bars-1; 
   while(shift>=0) 
     {
     
   ma1=iMA(NULL,0,SEMA,0,MODE_EMA,PRICE_CLOSE,shift);     
   ma2=ma1-iMA(NULL,0,MEMA,0,MODE_EMA,PRICE_CLOSE,shift); 
   ma3=ma1-iMA(NULL,0,LEMA,0,MODE_EMA,PRICE_CLOSE,shift); 
         
         
   AVE[shift]=(ma2+ma3)/2;
            
    if (AVE[shift]>AVE[shift+1]) 
     {
     ExtMapBuffer1[shift]=AVE[shift]; 
     ExtMapBuffer2[shift]=0;
     }
     else 
     {
     ExtMapBuffer2[shift]=AVE[shift];
     ExtMapBuffer1[shift]=0;
     }   
     shift--;// 
     } 
         
//---- 
   return(0); 
  } 
//+------------------------------------------------------------------+ 

