//+------------------------------------------------------------------+
//|                                                    DoubleCCI.mq4 |
//|                   Copyright  2005, Jason Robinson (jnrtrading). |
//|                                      http://www.jnrtrading.co.uk |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, Jason Robinson (jnrtrading)."
#property link      "http://www.jnrtrading.co.uk"

#property indicator_separate_window
#property indicator_buffers 8                    
#property indicator_color1 LimeGreen
#property indicator_color2 Crimson
#property indicator_color3 Orange
#property indicator_color4 Yellow
#property indicator_color5 White
#property indicator_color6 Aqua
#property indicator_color7 Magenta               
#property indicator_color8 Yellow
#property indicator_level1 100
#property indicator_level2 200
#property indicator_level3 300
#property indicator_level4 -300
#property indicator_level5 -200
#property indicator_level6 -100
#property indicator_level7 50
#property indicator_level8 -50


//---- input parameters
extern int TrendCCI_Period = 50;
extern int EntryCCI_Period = 14;
extern int TurboCCI_Period = 6;                  
extern bool Zero_Cross_Alert;
extern bool Automatic_Timeframe_Setting;
extern int M1_TrendCCI_Period = 50;
extern int M1_EntryCCI_Period = 14;
extern int M1_TurboCCI_Period = 6;
extern int M5_TrendCCI_Period = 50;
extern int M5_EntryCCI_Period = 14;
extern int M5_TurboCCI_Period = 6;
extern int M15_TrendCCI_Period = 50;
extern int M15_EntryCCI_Period = 14;
extern int M15_TurboCCI_Period = 6;
extern int M30_TrendCCI_Period = 50;
extern int M30_EntryCCI_Period = 20;
extern int M30_TurboCCI_Period = 6;
extern int H1_TrendCCI_Period = 50;
extern int H1_EntryCCI_Period = 20;
extern int H1_TurboCCI_Period = 6;
extern int H4_TrendCCI_Period = 50;
extern int H4_EntryCCI_Period = 20;
extern int H4_TurboCCI_Period = 6;
extern int D1_TrendCCI_Period = 50;
extern int D1_EntryCCI_Period = 20;
extern int D1_TurboCCI_Period = 6;
extern int W1_TrendCCI_Period = 50;
extern int W1_EntryCCI_Period = 20;
extern int W1_TurboCCI_Period = 6;
extern int MN_TrendCCI_Period = 50;
extern int MN_EntryCCI_Period = 20;
extern int MN_TurboCCI_Period = 6;


double TrendCCI[];
double EntryCCI[];
double TurboCCI[];                  
double CCITrendUp[];
double CCITrendDown[];
double CCINoTrend[];
double CCITimeBar[];
double ZeroLine[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_HISTOGRAM, 0, 2);
   SetIndexBuffer(0, CCITrendUp);
   SetIndexStyle(1, DRAW_HISTOGRAM, 0, 2);
   SetIndexBuffer(1, CCITrendDown);
   SetIndexStyle(2, DRAW_HISTOGRAM, 0, 2);
   SetIndexBuffer(2, CCINoTrend);
   SetIndexStyle(3, DRAW_HISTOGRAM, 0, 2);
   SetIndexBuffer(3, CCITimeBar);
   SetIndexStyle(4, DRAW_LINE, STYLE_SOLID, 2);
   SetIndexBuffer(4, TrendCCI);
   SetIndexLabel(4, "TrendCCI");
   SetIndexStyle(5, DRAW_LINE, STYLE_SOLID, 2);
   SetIndexBuffer(5, EntryCCI);
   SetIndexLabel(5, "EntryCCI");
   SetIndexStyle(6, DRAW_LINE, STYLE_SOLID, 1);           
   SetIndexBuffer(6, TurboCCI);
   SetIndexLabel(6, "TurboCCI");
   SetIndexStyle(7, DRAW_LINE, STYLE_SOLID, 1);
   SetIndexBuffer(7, ZeroLine);
   
   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {

   int limit, i, trendCCI, entryCCI, turboCCI;
   static datetime prevtime = 0;
   static int trendUp = 0;
   static int trendDown = 0;

   int counted_bars = IndicatorCounted();
//---- check for possible errors
   if(counted_bars < 0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars > 0) counted_bars--;

   limit=Bars-counted_bars;
   
   if (Automatic_Timeframe_Setting == true) {
      switch(Period()) {
         case 1: trendCCI = M1_TrendCCI_Period; entryCCI = M1_EntryCCI_Period; turboCCI = M1_TurboCCI_Period; break;
         case 5: trendCCI = M5_TrendCCI_Period; entryCCI = M5_EntryCCI_Period; turboCCI = M5_TurboCCI_Period; break;
         case 15: trendCCI = M15_TrendCCI_Period; entryCCI = M15_EntryCCI_Period; turboCCI = M15_TurboCCI_Period; break;
         case 30: trendCCI = M30_TrendCCI_Period; entryCCI = M30_EntryCCI_Period; turboCCI = M30_TurboCCI_Period; break;
         case 60: trendCCI = H1_TrendCCI_Period; entryCCI = H1_EntryCCI_Period; turboCCI = H1_TurboCCI_Period; break;
         case 240: trendCCI = H4_TrendCCI_Period; entryCCI = H4_EntryCCI_Period; turboCCI = H4_TurboCCI_Period; break;
         case 1440: trendCCI = D1_TrendCCI_Period; entryCCI = D1_EntryCCI_Period; turboCCI = D1_TurboCCI_Period; break;
         case 10080: trendCCI = W1_TrendCCI_Period; entryCCI = W1_EntryCCI_Period; turboCCI = W1_TurboCCI_Period; break;
         case 43200: trendCCI = MN_TrendCCI_Period; entryCCI = MN_EntryCCI_Period; turboCCI = MN_TurboCCI_Period; break;
      }
   }
   else {
      trendCCI = TrendCCI_Period;
      entryCCI = EntryCCI_Period;
      turboCCI = TurboCCI_Period;
   }
      IndicatorShortName("(TrendCCI: " + trendCCI + ", EntryCCI: " + entryCCI + ", TurboCCI: " + turboCCI + " ) ");
      for(i = limit; i >= 0; i--) {
         ZeroLine[i] = 0;
         TrendCCI[i] = iCCI(NULL, 0, trendCCI, PRICE_TYPICAL, i);
         EntryCCI[i] = iCCI(NULL, 0, entryCCI, PRICE_TYPICAL, i);
         TurboCCI[i] = iCCI(NULL, 0, turboCCI, PRICE_TYPICAL, i);         
      if (TrendCCI[i+1] < 0 && TrendCCI[i] >= 0) {
         if(trendDown < 4) {
            CCINoTrend[i] = 0;
            CCITrendUp[i] = TrendCCI[i];
            CCITrendDown[i] = 0;
            CCITimeBar[i] = 0;
         }
         else {
            trendUp = 0;
         }
      }
      if (TrendCCI[i] >= 0 ) {
         trendUp++;
         if(trendUp == 5) {
            CCITimeBar[i] = TrendCCI[i];
            CCINoTrend[i] = 0;
            CCITrendUp[i] = 0;
            CCITrendDown[i] = 0;
         }
         else if (trendUp > 5) {//(CCITimeBar[i+1] > 0 || CCITrendUp[i+1] > 0) {
            CCINoTrend[i] = 0;
            CCITrendUp[i] = TrendCCI[i];
            CCITrendDown[i] = 0;
            CCITimeBar[i] = 0;
        }
        else {
            CCINoTrend[i] = TrendCCI[i];
            CCITrendUp[i] = 0;
            CCITrendDown[i] = 0;
            CCITimeBar[i] = 0;
         }
      }
      
    
      if (TrendCCI[i+1] >= 0 && TrendCCI[i] < 0) {
         if(trendUp < 4) {
            CCINoTrend[i] = 0;
            CCITrendUp[i] = 0;
            CCITrendDown[i] = TrendCCI[i];
            CCITimeBar[i] = 0;
         }
         else {
            trendDown = 0;
         }
      }

      if (TrendCCI[i] <= 0 ) {
         trendDown++;
         if(trendDown == 5) {
            CCITimeBar[i] = TrendCCI[i];
            CCINoTrend[i] = 0;
            CCITrendUp[i] = 0;
            CCITrendDown[i] = 0;
         }
         else if (trendDown > 5) {//(CCITimeBar[i+1] < 0 || CCITrendDown[i+1] < 0) {
            CCINoTrend[i] = 0;
            CCITrendUp[i] = 0;
            CCITrendDown[i] = TrendCCI[i];
            CCITimeBar[i] = 0;
        }
        else {
            CCINoTrend[i] = TrendCCI[i];
            CCITrendUp[i] = 0;
            CCITrendDown[i] = 0;
            CCITimeBar[i] = 0;
         }
      }
      if (TrendCCI[i+1] == 0 && TrendCCI[i] >= 0 && CCITrendUp[i+2] > 0) {
         CCINoTrend[i] = 0;
         CCITrendUp[i] = TrendCCI[i];
         CCITrendDown[i] = 0;
         CCITimeBar[i] = 0;
     }
      
      
      
   }
   if (Zero_Cross_Alert == true) {
      if (prevtime == Time[0]) {
         return(0);
      }
      else {
         if(EntryCCI[0] < 0) {
            if((TrendCCI[0] < 0) && (TrendCCI[1] >= 0)) {
               Alert(Symbol(), " M", Period(), " Trend & Entry CCI Have both crossed below zero");
            }
         }
         else if(EntryCCI[0] > 0) {
            if((TrendCCI[0] > 0) && (TrendCCI[1] <= 0)) {
               Alert(Symbol(), " M", Period(), " Trend & Entry CCI Have both crossed above zero");
            }
         }
         
         prevtime = Time[0];
      }
   }
   //ObjectCreate("ZeroLine", OBJ_HLINE, WindowFind("(TrendCCI: \" + trendCCI + \", EntryCCI: \" + entryCCI + \") "), 0, 0);
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+