//+------------------------------------------------------------------+
//|                                                         USDX.mq4 |
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright ""
#property link      ""

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 RoyalBlue
//---- buffers
double ExtMapBuffer1[];

string base[]={"EURUSD","USDJPY","GBPUSD","USDCAD","USDSEK","USDCHF"};
string shortname;
double weight[]={-0.576,0.136,-0.119,0.091,0.042,0.036};
double factor=50.14348112;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexEmptyValue(0,factor);
   IndicatorDigits(2);
// modify for interbank fx mini
   if(StringFind(AccountCompany(),"interbank fx")>=0&&MarketInfo(Symbol(),MODE_LOTSIZE)==10000)
   {
   	for(int i=0;i<ArraySize(base);i++)
   		base[i]=base[i]+"m";
   }
   string nobase="";
   for(i=0;i<ArraySize(base);i++)
   {
   	if(MarketInfo(base[i],MODE_BID)==0)
   	{
   		if(nobase=="")
   			nobase=" missing "+base[i];
   		else
   			nobase=nobase+", "+base[i];
   		base[i]="";
   	}
   }
   IndicatorShortName(WindowExpertName()+nobase);
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int limit=Bars-IndicatorCounted();
   int shift;
   while(shift<limit)
   {
   	ExtMapBuffer1[shift]=1;
   	for(int i=0;i<ArraySize(base);i++)
   	{
   		if(base[i]!="")
   		{
   			double close=iClose(base[i],0,shift);
   			if(close!=0) // no data for this bar
   				ExtMapBuffer1[shift]*=MathPow(close,weight[i]);
   		}
   	}
   	ExtMapBuffer1[shift]*=factor;
   	shift++;
   }
   return(0);
}
//+------------------------------------------------------------------+