//+------------------------------------------------------------------+
//|                                                          Via.mq4 |
//|                                  Copyright 2007, Ralph Ronnquist |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright 2007, Ralph Ronnquist"
#property link      ""

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Silver
#property indicator_color2 Blue
#property indicator_color3 Red

//---- input parameters
extern string    via="EUR";
extern int offset = 0;
extern int profit = 4;
//---- indicator buffers
double price[];
double buy[];
double sell[];

//---- variables
string XXXvia;
string viaYYY;
bool Xinvert = false;
bool Yinvert = false;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
    SetIndexStyle( 0, DRAW_LINE );
    SetIndexBuffer( 0, price );
    SetIndexEmptyValue( 0, 0 );

    SetIndexStyle( 1, DRAW_ARROW );
    SetIndexArrow( 1, 241 );
    SetIndexBuffer( 1, buy );
    SetIndexEmptyValue( 1, 0 );

    SetIndexStyle( 2, DRAW_ARROW );
    SetIndexArrow( 2, 242 );
    SetIndexBuffer( 2, sell );
    SetIndexEmptyValue( 2, 0 );

    // Figure out the crossed symbols
    string XXX = StringSubstr( Symbol(), 0, 3 );
    string YYY = StringSubstr( Symbol(), 3, 3 );
    XXXvia = StringConcatenate( XXX, via );
    viaYYY = StringConcatenate( via, YYY );
    int a = MarketInfo( XXXvia, MODE_DIGITS );
    if ( a == 0 ) {
        XXXvia = StringConcatenate( via, XXX );
        Xinvert = true;
        a = MarketInfo( XXXvia, MODE_DIGITS );
    }
    
    int b = MarketInfo( viaYYY, MODE_DIGITS );
    if ( b == 0 ) {
        viaYYY = StringConcatenate( YYY, via );
        Yinvert = true;
        b = MarketInfo( viaYYY, MODE_DIGITS );
    }
    Print( "Presenting " + XXXvia + "*" + viaYYY + " " + a + " " + b );
    return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
    return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
    for ( int bar = Bars - IndicatorCounted(); bar >= 0; bar-- ) {
        indicate( bar );
    }
    return(0);
}

double getPrice(string symbol,int bar,bool invert)
{
    double a = iClose( symbol, Period(), bar );
    if ( a == 0 ) {
        Comment( symbol + " not loaded for " + bar );
        return( 0 );
    }
    if ( invert )
        return ( 1 / a );
    return ( a );
}

void indicate(int bar)
{
    double a = getPrice( XXXvia, bar, Xinvert );
    double b = getPrice( viaYYY, bar, Yinvert );
    price[ bar ] = NormalizeDouble( a * b, Digits ) + offset * Point;
    Comment( price[ bar ] );
    
    buy[ bar ] = 0;
    double level = Close[ bar+1 ] + ( MarketInfo( Symbol(), MODE_SPREAD ) + profit ) * Point;
    if ( price[ bar+1 ] > level && price[ bar+1 ] > High[ bar+1 ] )
        buy[ bar ] = price[ bar+1 ];

    sell[ bar ] = 0;
    level = price[ bar+1 ] + ( MarketInfo( Symbol(), MODE_SPREAD ) + profit ) * Point;
    if ( level < Close[ bar+1 ] && level < Low[ bar+1 ] )
        sell[ bar ] = price[ bar+1 ];

}

//+------------------------------------------------------------------+