//+------------------------------------------------------------------+
//|                                                WeightedCross.mq4 |
//|                                                             niva |
//|                                                        forex-tsd |
//+------------------------------------------------------------------+
#property copyright "niva"
#property link      "forex-tsd"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 Blue
//---- indicator parameters
extern int Fast_Period=13;
extern int Slow_Period=20;
//---- indicator buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
bool up=false;
bool down=false;
//----

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexBuffer(1,ExtMapBuffer2);
   string short_name = "WeightedCross";
   IndicatorShortName(short_name);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();

//---- check for possibble errors
   if (counted_bars<0) return(-1);
  //--- last counted bar will be recounted
   if (counted_bars>0) counted_bars--;
   
   int pos=Bars-counted_bars;
//----

   //----main calculation loop
   while(pos>=0)
   {
      ExtMapBuffer1[pos] = iMA(NULL,0,Fast_Period,8,MODE_LWMA,PRICE_CLOSE,pos);
      ExtMapBuffer2[pos] = iMA(NULL,0,Slow_Period,8,MODE_LWMA,PRICE_CLOSE,pos);
      pos--;
      }
      double difference=ExtMapBuffer1[1]-ExtMapBuffer2[2];
      if(difference>0 && up==false){
         Alert ("up cross");
         up=true;
         down=false;
      }
      if (difference<=0 && down==false){
         Alert ("down corss");
         down=true;
         up=false;
      }
      
   return(0);
  }
//+------------------------------------------------------------------+