//+------------------------------------------------------------------+
//|                                                    X0diagram.mq4 |
//|                                             Copyright  2005, 4e |
//|                                                                  |
//+------------------------------------------------------------------+

///////////////////////////////////////////////////////////////////////
//                             0
//   0   
//  : BoxSize -    
//                    ReversalBox - -   
//                    Candles = -     
//                    
//    indicator_color3     
///////////////////////////////////////////////////////////////////////





#property copyright "Copyright  2005, 4e"
#property link      "4ebur@mail.ru"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Red
#property indicator_color2 Blue
#property indicator_color3 White



extern double BoxSize = 100;
extern int ReversalBox = 3;
extern int Candles = 3000;



double PointArray[];
double FigureArray[];
double ZeroArray[];



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
SetIndexBuffer(0,PointArray);
SetIndexBuffer(1,FigureArray);
SetIndexBuffer(2,ZeroArray);


SetIndexStyle(0,DRAW_HISTOGRAM);
SetIndexStyle(1,DRAW_HISTOGRAM);
SetIndexStyle(2,DRAW_HISTOGRAM);

SetIndexEmptyValue(0,0);
SetIndexEmptyValue(1,0);
SetIndexEmptyValue(2,0);

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
     int    limit;
   int    counted_bars=IndicatorCounted();
 
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   
//----

double BoxPointSize = BoxSize * Point; //   
double ReversalSize = BoxPointSize * ReversalBox; //    
  
  
  
  
  
  //  
  for(int i=limit;i>0;i--)
    {
      PointArray[i] = 0;
      FigureArray[i] = 0;
      ZeroArray[i] = 0;
    
    
    }
    
    
  int  beginPoint; //  
  int  CurPoint; // 
  bool Direction; // 1  - ,  , 0-,  0
  int Localin; //  
  int LocalMax; //  
  double beginIndex; //   
  
  //   :    ,   ,    
  //      ( -  ,  - )

  
  Direction = (Close[Candles]-Open[Candles]) > 0;//   
  beginPoint = Candles; //   
  CurPoint = Candles;   //   
  LocalMax = Candles; //  
  Localin = Candles; //  
  beginIndex = Close[beginPoint]; //  
   
   
   
   for( i=Candles-1;i>0;i--)
    {
      CurPoint = i; //   
      LocalMax = Highest(NULL,0,MODE_CLOSE,beginPoint-CurPoint,CurPoint);
      Localin = Lowest(NULL,0,MODE_CLOSE,beginPoint-CurPoint,CurPoint);
      
         if(Direction) // 
            {
               if(Close[LocalMax]-Close[CurPoint] >= ReversalSize) //  
               {
                    int boxes  = MathFloor(((Close[LocalMax]-Close[beginPoint])/(BoxSize*Point))); //  - 
                     
                     for(int j=beginPoint;j>LocalMax-1;j--)
                     {
                        PointArray[j] = beginIndex + BoxSize*boxes*Point; // 
                        ZeroArray[j] = beginIndex;  // 
                     
                     }
                     
                   beginPoint = LocalMax-1; //      
                   beginIndex = beginIndex + BoxSize*(boxes-1)*Point; //      
                   Localin = CurPoint;
                   Direction = 0; //       
               }
            }
            
         
          else  // 
            {
               if(Close[CurPoint]-Close[Localin] >=ReversalSize) //  
               {
                     
                      boxes  = MathFloor(((Close[beginPoint]-Close[Localin])/(BoxSize*Point)));//  - 
                     
                     for( j=beginPoint;j>Localin-1;j--)
                     {
                        FigureArray[j] = beginIndex; // 
                        ZeroArray[j] = beginIndex-BoxSize*boxes*Point;   // 
                     
                     }
                     
                   beginPoint = Localin-1; //      
                   Direction = 1; //       
                   LocalMax = CurPoint; 
                   beginIndex = beginIndex - BoxSize*(boxes-1)*Point; //      
                     
                     
               }
            }
    }
   
   
   
   
   //   
  
  
   
   
   if(Direction)
   {
         LocalMax = Highest(NULL,0,MODE_CLOSE,beginPoint-CurPoint,CurPoint);
         boxes  = MathFloor(((Close[LocalMax]-Close[beginPoint])/(BoxSize*Point))); //  - 
         
         for(j=beginPoint;j>0;j--)
                     {
                        PointArray[j] = beginIndex + BoxSize*boxes*Point; // 
                        ZeroArray[j] = beginIndex;  // 
                     
                     }
      
   
   }
   
   else
   {
       Localin = Lowest(NULL,0,MODE_CLOSE,beginPoint-CurPoint,CurPoint);
      boxes  = MathFloor(((Close[beginPoint]-Close[Localin])/(BoxSize*Point)));//  - 
   
      for(j=beginPoint;j>0;j--)
                     {
                        FigureArray[j] =  beginIndex;// 
                        ZeroArray[j] = beginIndex - BoxSize*boxes*Point;  // 
                     
                     }
   
   
   }
   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+