//+------------------------------------------------------------------+
//|                                               maloma 4 XALIF.mq4 |
//+------------------------------------------------------------------+
#property copyright " Shimodax.      ."

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Gold
#property indicator_color2 Gold
#property indicator_color3 Coral
#property indicator_color4 Coral

//---- input parameters
extern string StartHour1st   = "05:00";
extern string EndHour1st     = "09:00";
extern string StartHour2nd   = "12:00";
extern string EndHour2nd     = "15:00";

double Zone1Upper[];
double Zone2Upper[];
double Zone1Lower[];
double Zone2Lower[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,Zone1Upper);
   SetIndexEmptyValue(0, 0.0);
	SetIndexLabel(0, "Upper Zone 1");

   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,Zone1Lower);
   SetIndexEmptyValue(1, 0.0);
   SetIndexLabel(1, "Lower Zone 1");

   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,Zone2Upper);
   SetIndexEmptyValue(2, 0.0);
   SetIndexLabel(2, "Upper Zone 2");

   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,Zone2Lower);
   SetIndexEmptyValue(3, 0.0);
   SetIndexLabel(3, "Lower Zone 2");

   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }

int start()
  {
   int counted_bars= IndicatorCounted(),
       lastbar, result;

   if (Bars<=100) 
      return(0);
      
   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars - counted_bars;
   
   Ranges(0, lastbar);
  }
//+------------------------------------------------------------------+

int Ranges(int offset, int lastbar)
{     
   int i, j, k,
       tidxstart[2]= { 0, 0}, 
       tidxend[2]= { 0, 0 };
   double thigh[2]= { 0.0, 0.0 }, 
           tlow[2]= { 99999.9, 99999.9 };
   string tfrom[3];
          tfrom[0]= StartHour1st;
          tfrom[1]= StartHour2nd;
          tfrom[2]= "12:00";
   string tto[3];
          tto[0]= EndHour1st;
          tto[1]= EndHour2nd;
          tto[2]= "24:00";
   string tday;
   bool inperiod= -1;
   datetime timet;
   

   //
   // search back for the beginning of the day
   //
   tday= TimeToStr(Time[lastbar], TIME_DATE);   
   for (  ; lastbar<Bars; lastbar++) {
      if (TimeToStr(Time[lastbar], TIME_DATE)!=tday) {
         lastbar--;
         break;      
      }
   }   

   //
   // find the high/low for the two periods and carry them forward through the day
   //
   tday= "XXX";
   for (i= lastbar; i>=offset; i--)
     {
         timet= Time[i];   // time of this bar
      
      string timestr= TimeToStr(timet, TIME_MINUTES),    // current time HH:MM
             thisday= TimeToStr(timet, TIME_DATE);       // current date
          
          
      //
      // for all three periods (first period, second period, rest of day)
      //
      for (j=0; j<3; j++)
        {      
         if (tfrom[j]<=timestr && timestr<tto[j])    // Bar[i] in this period
           {
            
            // for the current period find idxstart, idxend and compute high/low
            if (tidxstart[j]==0)
              {
               tidxstart[j]= i;
               tday= thisday;
              }
            
            tidxend[j]= i;
            
            thigh[j]= MathMax(thigh[j], High[i]);
            tlow[j]= MathMin(tlow[j], Low[i]);
            
            for (k= tidxstart[j]; k>=tidxend[j]; k--)
              {
               if (j==0)
                 {
                  Zone1Upper[k]= thigh[j];
                  Zone1Lower[k]= tlow[j];
                 }
               if (j==1)
                 {
                  Zone2Upper[k]= thigh[j];
                  Zone2Lower[k]= tlow[j];
                 }
              }
            
            inperiod= j;   // remember current period
            
            if (inperiod==2)   // inperiod==2 (end of day) is just to check completion of zone 2
              break;
         }
     }
      
      
      //
      // at the beginning of a new day reset everything
      //
      if (tday!="XXX" && tday!=thisday || TimeToStr(timet, TIME_MINUTES)>=tto[2]) {
         // Print("#", i, "new day ", thisday, "/", tday);
      
         tday= "XXX";
         
         inperiod= -1;
         
         for (j= 0; j<2; j++) {
            tidxstart[j]= 0;
            tidxend[j]= 0;
         
            thigh[j]= 0;
            tlow[j]= 99999;
         }
      }
   }

   return (0);       
}



