//+------------------------------------------------------------------+
//|                                                         XO_5.mq4 |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright " XO_5 "
#property link      " XO_5 "

#property indicator_separate_window
#property indicator_buffers 6
#property indicator_color1 PaleGreen
#property indicator_color2 LightCoral
#property indicator_color3 LimeGreen
#property indicator_color4 Red
#property indicator_color5 DarkGreen //for TF5
#property indicator_color6 Maroon // for TF5
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 2
#property indicator_width4 2
#property indicator_width5 1 // for TF5
#property indicator_width6 1 // for TF5

#property indicator_maximum 5                     
#property indicator_minimum -5

extern double KirPER=7;                            //10
extern int TF1=5;       // PERIOD_M5
extern int TF2=15;
extern int TF3=30;
extern int TF4=60;
extern int TF5=240;

extern int KirPER1=7;
extern int KirPER2=7;
extern int KirPER3=7;
extern int KirPER4=5;
extern int KirPER5=5;
//---- input parameters
/*************************************************************************
PERIOD_M1   1
PERIOD_M5   5
PERIOD_M15  15
PERIOD_M30  30 
PERIOD_H1   60
PERIOD_H4   240
PERIOD_D1   1440
PERIOD_W1   10080
PERIOD_MN1  43200
You must use the numeric value of the timeframe that you want to use
when you set the TimeFrame' value with the indicator inputs.
**************************************************************************/
//---- buffers

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {

//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM,EMPTY,2);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM,EMPTY,2);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexStyle(2,DRAW_HISTOGRAM,EMPTY,2);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexStyle(3,DRAW_HISTOGRAM,EMPTY,2);
   SetIndexBuffer(3,ExtMapBuffer4);
   SetIndexStyle(4,DRAW_HISTOGRAM,EMPTY,1);
   SetIndexBuffer(4,ExtMapBuffer5);   
   SetIndexStyle(5,DRAW_HISTOGRAM,EMPTY,1);
   SetIndexBuffer(5,ExtMapBuffer6);


 
   string short_name;
   short_name=("5 TF XO("+TF1+","+KirPER1+" "+TF2+","+KirPER2+" "+TF3+","+KirPER3+" "+TF4+","+KirPER4+" "+TF5+","+KirPER5+" )");
    IndicatorShortName(short_name);
     SetIndexLabel(0,short_name);  
  }
//----
   return(0);
 
//+------------------------------------------------------------------+
//| MTF Parabolic Sar                                         |
//+------------------------------------------------------------------+
int start()
  {
   int    i,limit,y=0,counted_bars=IndicatorCounted();
   
   limit=Bars-counted_bars;
   limit=Bars-counted_bars;
   int lastp15=0, lastp30=0, lastp60=0;
   for(i=0,y=0;i<limit;i++)
   {
      int p1,p2,p3,p4,p5;
      
      p1 = iBarShift( NULL, TF1, Time[i], false );
      p2 = iBarShift( NULL, TF2, Time[i], false );
      p3 = iBarShift( NULL, TF3, Time[i], false );
      p4 = iBarShift( NULL, TF4, Time[i], false );
      p5 = iBarShift( NULL, TF5, Time[i], false );
      
/***********************************************************   
   Add your main indicator loop below.  You can reference an existing
      indicator with its iName  or iCustom.
   Rule 1:  Add extern inputs above for all neccesary values   
   Rule 2:  Use 'TimeFrame' for the indicator time frame
   Rule 3:  Use 'y' for your indicator's shift value
 **********************************************************/  
      double totalUp = 0.0;
      double totalDown = 0.0;
      double TF5Up = 0.0;
      double TF5Down = 0.0;
   
      totalUp=iCustom(NULL,TF1,"XO",KirPER1,0,p1);
      totalDown=iCustom(NULL,TF1,"XO",KirPER1,1,p1); 
      totalUp= totalUp + iCustom(NULL,TF2,"XO",KirPER2,0,p2);
      totalDown= totalDown + iCustom(NULL,TF2,"XO",KirPER2,1,p2); 
      totalUp= totalUp + iCustom(NULL,TF3,"XO",KirPER3,0,p3);
      totalDown= totalDown + iCustom(NULL,TF3,"XO",KirPER3,1,p3); 
      totalUp= totalUp + iCustom(NULL,TF4,"XO",KirPER4,0,p4);
      totalDown= totalDown + iCustom(NULL,TF4,"XO",KirPER4,1,p4); 

      TF5Up = iCustom(NULL,TF5,"XO",KirPER5,0,p5); // value will be 1 or 0
      TF5Down = iCustom(NULL,TF5,"XO",KirPER5,1,p5);

      ExtMapBuffer1[i] = 0;
      ExtMapBuffer2[i] = 0;
      ExtMapBuffer3[i] = 0;
      ExtMapBuffer4[i] = 0;
      if ( totalUp == 4 || totalDown == -4 ) {
         ExtMapBuffer3[i] = totalUp;
         ExtMapBuffer4[i] = totalDown;
      } else {
         ExtMapBuffer1[i] = totalUp;
         ExtMapBuffer2[i] = totalDown;
      }
      

      ExtMapBuffer5[i] = 0;
      ExtMapBuffer6[i] = 0;
      if (TF5Up == 1)
      {
         ExtMapBuffer5[i] = 5;
      }
      else
      {
         ExtMapBuffer6[i] = -5;
      } 
   }  
   return(0);
  }
//+------------------------------------------------------------------+