//+------------------------------------------------------------------+
//|                                                          Z1.mq4 |
//|                                          Copyright  2007, .Beno |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, .Beno"
#property link      ""
#include <stdlib.mqh>

extern int expertId=197893;
extern string EAName="Z1";
extern double ProfitExit = 0.05; //% profit exit
extern double TrailingStop = 30;
extern string PARAMETERS_FILTER = "PARAMETERS FILTER";
extern bool UseHourTrade = False;
extern int FromHourTrade = 8;
extern int ToHourTrade = 120;

extern int       barsToCount = 2000;
extern double        UpperTarget1 = 1;
extern double        LowerTarget1 = -1;
extern double        UpperTarget2 = 2;
extern double        LowerTarget2 = -2;
extern double        UpperTarget3 = 3;
extern double        LowerTarget3 = -3;
extern double        UpperTarget4 = 4;
extern double        LowerTarget4 = -4;
extern double        UpperTarget5 = 5;
extern double        LowerTarget5 = -5;
extern double        UpperTarget6 = 6;
extern double        LowerTarget6 = -6;
extern double        UpperTarget7 = 7;
extern double        LowerTarget7 = -7;

extern double Lots = 0.01;

extern int    slippage=2;   	//slippage for market order processing



bool buysig,sellsig,closebuy,closesell;
int last,buys,sells,exitl,exit;
double curprof;




//+------------------------------------------------------------------+
//| Calculate open positions                                         |
//+------------------------------------------------------------------+
int CalculateCurrentOrders()  {
   buys=0; sells=0; curprof=0;
   string symbol=Symbol();
//----
   for(int i=0;i<OrdersTotal();i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==false) continue;
      if(OrderSymbol()==Symbol() && OrderMagicNumber()==expertId)
        {
         if(OrderType()==OP_BUY || OrderType()==OP_BUYSTOP)  buys++;
         if(OrderType()==OP_SELL || OrderType()==OP_SELLSTOP) sells++;
        }
     }
//---- return orders volume
   if(buys>0) return(buys);
   else       return(-sells);
}

//+------------------------------------------------------------------+
//| Check for open order conditions                                  |
//+------------------------------------------------------------------+
void CheckForSignals() {

   	

   	double zscore1=iCustom(NULL,0,"zscore",barsToCount,PRICE_CLOSE,1);
   	double zscore2=iCustom(NULL,0,"zscore",barsToCount,PRICE_CLOSE,1);
   	double zscore3=iCustom(NULL,0,"zscore",barsToCount,PRICE_CLOSE,1);
   	double zscore4=iCustom(NULL,0,"zscore",barsToCount,PRICE_CLOSE,1);
   	double zscore5=iCustom(NULL,0,"zscore",barsToCount,PRICE_CLOSE,1);
   	double zscore6=iCustom(NULL,0,"zscore",barsToCount,PRICE_CLOSE,1);
   	double zscore7=iCustom(NULL,0,"zscore",barsToCount,PRICE_CLOSE,1);



      buysig=false;
      sellsig=false;
      closebuy=false;
      closesell=false;
      exit=false;
   
    
      double HL1=UpperTarget1;
      double HL2=LowerTarget1;
      double HL3=UpperTarget2;
      double HL4=LowerTarget2;
      double HL5=UpperTarget3;
      double HL6=LowerTarget3;
      double HL7=UpperTarget4;
      double HL8=LowerTarget4;
      double HL9=UpperTarget5;
      double HL10=LowerTarget5;
      double HL11=UpperTarget6;
      double HL12=LowerTarget6;
      double HL13=UpperTarget7;
      double HL14=LowerTarget7;

     

    
      bool Long = zscore1 < HL2 || zscore2 < HL4 || zscore3 < HL6 || zscore4 < HL8 || zscore5 < HL10 || zscore6 < HL12 || zscore7 < HL14;
      bool Short = zscore1 > HL1 || zscore2 > HL3 || zscore3 > HL5 || zscore4 > HL7 || zscore5 > HL9 || zscore6 > HL11 || zscore7 > HL13;


      buysig = Long;
      sellsig = Short;

      closebuy=sellsig;
      closesell=buysig;
      

      if (curprof>=AccountBalance()*ProfitExit/100.0) {
         exit=true;
      }
}

void CheckForOpen() {

   if (last==Time[0]) return;

   int    res,ord;
   double entry,stop,profit;

   ord=CalculateCurrentOrders();

   if (ord!=0) CheckForClose();

   ord=CalculateCurrentOrders();

//---- buy conditions
   if (buys < buysig)  {
		res=OpenAtMarket(OP_BUY,Lots);
		if (res<0) Print("Error opening BUY order : ",ErrorDescription(GetLastError()));
		else last=Time[0];
   }
//---- sell conditions
   if (sells < sellsig)  {
		res=OpenAtMarket(OP_SELL,Lots);
		if (res<=0) Print("Error opening SELL order : ",ErrorDescription(GetLastError()));
		else last=Time[0];
   }
}
  
int OpenAtMarket(int mode,double lot) {
   int    res,tr,col;
   double openprice,sl,tp;
   //tries=0;
   while (res<=0) {
      tr=0; while (tr<5 && !IsTradeAllowed()) { tr++; Sleep(2000); }
      RefreshRates();
      if (mode==OP_SELL) {
         openprice=Bid; 
         col=Red;
      } else {
         //openprice=nd(Ask);
         openprice=Ask;
         col=Blue;
      }
      res=OrderSend(Symbol(),mode,lot,openprice,slippage,0,0,EAName+expertId,expertId,0,col);
      //tries++;
   }
   return(res);

}
  
//+------------------------------------------------------------------+
//| Check for close order conditions                                 |
//+------------------------------------------------------------------+
void CheckForClose()  {
	int total;
//----
	total=OrdersTotal();
   for(int i=total;i>=0;i--)
       {
      if(!OrderSelect(i,SELECT_BY_POS,MODE_TRADES))  continue;
      if(OrderMagicNumber()!=expertId || OrderSymbol()!=Symbol()) continue;
      //---- check order type 
      if(OrderType()==OP_BUY && (exit || closebuy)) CloseAtMarket(OrderTicket(),OrderLots());
      if(OrderType()==OP_SELL && (exit || closesell)) CloseAtMarket(OrderTicket(),OrderLots());
     }

}

bool CloseAtMarket(int ticket,double lot) {
   bool bres=false; int tr;
      while (!bres) {
      tr=0; while (tr<5 && !IsTradeAllowed()) { tr++; Sleep(2000); }
      RefreshRates();
      bres=OrderClose(ticket,lot,OrderClosePrice(),slippage,White);
      if (!bres) Print("Error closing order : ",ErrorDescription(GetLastError()));
      
   }
}

//+------------------------------------------------------------------+
//| Start function                                                   |
//+------------------------------------------------------------------+
void start()  {

   //---- check for history and trading
     if (UseHourTrade){
   if((Hour()>=FromHourTrade)&&(Hour()<=ToHourTrade))
      Comment("Trading Hours");
   else
     {
      Comment("Non-trading Hours");
      return(0);
     }
   }
   
   if(Bars<100 || IsTradeAllowed()==false) return;

   //---- check for signals
   CheckForSignals();

   CheckForOpen();
   

   
   
   
}

