//+----------------------------------------------------------------------+
//|ZigZag                               |
//|----------------------------------------------------------------------+
//|                                                                      |
//|ExtIndicator -   ,             |
//|                                             |
//|           0 - Zigzag  ,                     |
//|           1 - Zigzag ,                                         |
//|           2 -     Ensign                |
//|           3 - ZigZag Ensign    minBars           |
//|           4 - ZigZag,  tauber                              |
//|           5 -                              |
//|           6 - DT-ZigZag   ZigZag_new_nen3.mq4                |
//|           7 - DT-ZigZag   DT_ZZ.mq4 ( klot)        |
//|           8 - DT-ZigZag   CZigZag.mq4 ( Candid)    |
//|           9 -         RSI     |
//|                                                                      |
//|minBars -   (  )                  |
//|minSize -     (  )  |
//|                                                                      |
//|Price -  ,    RSI   RSI            |
//|                                                                      |
//|PRICE_CLOSE    0                                          |
//|PRICE_OPEN     1                                          |
//|PRICE_HIGH     2                                      |
//|PRICE_LOW      3                                       |
//|PRICE_MEDIAN   4  , (high+low)/2                           |
//|PRICE_TYPICAL  5  , (high+low+close)/3                    |
//|PRICE_WEIGHTED 6   , (high+low+close+close)/4   |
//|                                                                      |
//|ExtDeviation  ExtBackstep -    ZigZag  MT4    |
//|                                                                      |
//|minPercent -   ( ,  0.5)       |
//|                -  ,  minSize=0; |
//|GrossPeriod -  ,    ( ),|
//|       ZigZag   DT-ZigZag   |
//|ZigZagHighLow - ,                   |
//|                 ,    ..               |
//|true -                                              |
//|false -   ZigZag,     ""              |
//|----------------------------------------------------------------------|
//|ExtHidden - 0 -      .             |
//|            1 -     ,        |
//|                  >0.14  <5.                    |
//|            2 -     ,   -    |
//|                    ( 0.447, 0.886, 2.236, |
//|                3.14, 3,618    Gartley)         |
//|            3 -  ,    2            |
//|                                                 |
//|            4 -        |
//|            5 -   .   ZigZag         |
//|                                                                      |
//|ExtFiboZigZag -   "ZiaZag Fibonacci"                    |
//|                                                                      |
//|ExtFractal -   (, ),            |
//|                                    |
//|                                                                      |
//|ExtFractalEnd -  ,                |
//|                            |
//|                 ExtFractalEnd=0           |
//|                  .                        |
//|                  ExtFractalEnd=1                  |
//|                                                                      |
//|ExtDelta - ()   .               |
//|             .                            |
//|                    0<ExtDelta<1                            |
//|                                                                      |
//|ExtDeltaType -    0 -    " "    |
//|                  1 -   (%- )<ExtDelta     |
//|                  2 - ((%- )/ )<ExtDelta  |
//|                                                                      |
//|chHL     = true     -          |
//|PeakDet  = true     -             |
//|                                                            |
//|                                                                      |
//|ExtFiboType = true -                             |
//|              false -                                  |
//|                                                                      |
//|ExtFiboCorrectionExpansion = false -                |
//|                           = true  -               |
//|                                                                      |
//|ExtFiboDinamic -     .            |
//|                           |
//|                 ZigZag-a.                                            |
//|                                                                      |
//|ExtFiboStatic -                   |
//|                                                                      |
//|ExtFiboStaticNum -   ZigZag-a,       |
//|                     . 1<ExtFiboStaticNum<=9|
//|                                                                      |
//|ExtSizeTxt -                                |
//|                                                                      |
//|ExtLine -                                |
//|                                                                      |
//|ExtPesavento -                                |
//|                                                                      |
//|ExtGartley886 -    .886                                |
//|                                                                      |
//|ExtNotFibo -                              |
//|                                                                      |
//|ExtFiboS  ExtFiboD -      .     |
//|                                                                      |
//|infoTF -    5  .                |
//|           .    .   |
//|             .                |
//|                                                                      |
//|chHL_PeakDet_or_vts - true -            |
//|  ( )     ZigZag. |
//|  false -   i-vts.                                  |
//|                                                                      |
//|NumberOfBars -    (0-)  i-vts.            |
//|                                                                      |
//|NumberOfVTS - ,   ,    i-vts.     |
//|NumberOfVTS1 -      i-vts.           |
//|                                                                      |
//|----------------------------------------------------------------------|
//|                                               |
//|----------------------------------------------------------------------|
//|ExtPitchforkDinamic > 0 (=1)        |
//|                ZigZag                        |
//|             =2 50%                                            |
//|             =3 50%                                               |
//|             =4                                             |
//|                                                                      |
//|ExtPitchforkStatic > 0 (=1)          |
//|              ZigZag   ExtPitchforkStaticNum        |
//|             =2 50%                                            |
//|             =3 50%                                               |
//|             =4                                             |
//|                                                                      |
//|3<ExtPitchforkStaticNum<=9 -   ZigZag,           |
//|                                             |
//|                                                                      |
//|ExtLinePitchforkS                                                    | 
//|ExtLinePitchforkD                |
//|ExtPitchforkStaticColor -                  |
//|ExtPitchforkStyle -    .                          |
//|             0 -                                         |
//|             1 -                                        |
//|             2 -                                       |
//|             3 - -                                |
//|             4 - -                |
//|             5-10 -                         |
//|                                                                      |
//|ExtFiboFanDinamic -    -         |
//|ExtFiboFanStatic -    -           |
//|                                   |
//|                                                                      |
//|ExtFiboFanD -    -                    |
//|                                                                      |
//|ExtFiboFanS -    -                     |
//|ExtFiboFanExp -    . true=8, false=4          |
//|ExtFiboFanHidden -            |
//|                                                                      |
//|ExtFiboFanMedianaStaticColor                                         |
//|ExtFiboFanMedianaDinamicColor -                |
//|                             |
//|                                                                      |
//|                     |
//|ExtFiboTime1 -     1.                        |
//|                                                                      |
//|ExtFiboTime2 -     2.                        |
//|                                                                      |
//|ExtFiboTime1C -      1.                   |
//|                                                                      |
//|ExtFiboTime2C -      2.                   |
//|                                                                      |
//|ExtUTL -                     |
//|ExtLTL -                      |
//|                                                                      |
//|ExtUWL -                           |
//|ExtLWL -                            |
//|                                                                      |
//|                |
//|                                                                      |
//|ExtRLine -                   |
//|                                                                      |
//|ExtRLineBase -                        |
//|                                                                      |
//|ExtPitchforkCandle -        |
//|ExtPitchfork_1_HighLow -       -   |
//|                  |
//|ExtDateTimePitchfork_1, ExtDateTimePitchfork_2,                       |
//|ExtDateTimePitchfork_3 -     ,       |
//|                                             |
//|----------------------------------------------------------------------|
//|                                                                      |
//|ExtFiboFanColor -     .     |
//|                                                                      |
//|ExtFiboFanNum -   ZigZag-a,          |
//|                   . 1<ExtFiboStaticNum<=9       |
//|                                                                      |
//|----------------------------------------------------------------------|
//|                                                                      |
//|ExtFiboExpansion -  ,              |
//|                 < 2                    |
//|                 = 2                    |
//|                 >2  <=9               |
//|                                                                      |
//|ExtFiboExpansionColor -             |
//|----------------------------------------------------------------------|
//|ExtVLStaticColor -  Versum Levels      |
//|ExtVLDinamicColor -  Versum Levels     |
//|                                                                      |
//|ExtVLStaticNum -   ,              |
//|                 Versum Levels                                        |
//|----------------------------------------------------------------------|
//|ExtBack -                             |
//|ExtSave -                  |
//|          Fibo Time                                                   |
//|                                                                      |
//|ExtAlert -                 |
//|              ZigZag                           |
//|                                                                      |
//|ExtStyleZZ - = true -    ZigZag      |
//|             = false - Zigzag             |
//|                                                                      |
//|ExtComplekt -   .     |
//|                    .   |
//|                     . |
//+----------------------------------------------------------------------+
#property copyright "nen"
#property link      "http://onix-trade.net/forum/index.php?s=&showtopic=118&view=findpost&p=129958"
//  http://onix-trade.net/forum/index.php?s=&showtopic=373&view=findpost&p=72865

#property indicator_separate_window
#property indicator_buffers 6
#property indicator_color1 Aqua 
#property indicator_color2 Green
#property indicator_color3 Orange
#property indicator_color4 LightSkyBlue
#property indicator_color5 LemonChiffon
#property indicator_color6 Yellow
//===================================
//---- indicator parameters
extern int    ExtIndicator = 9;
extern int    minBars = 6;
extern int    minSize = 55;
//   ZigZag  
extern int    ExtDeviation = 3;
extern int    ExtBackstep = 3;
//   nen-ZigZag
extern int    GrossPeriod=240;
extern int    Price = 0;
//----
extern double minPercent = 5;
//----
extern int    ExtHidden = 1;
extern bool   ZigZagHighLow=true;
extern bool   ExtFiboZigZag = false;
extern int    ExtFractal = 7;
extern int    ExtFractalEnd = 7;
extern double ExtDelta = 0.04;
extern int    ExtDeltaType = 2;
extern int    ExtPPWithBars = 0;
//-------------------------------------
extern bool   ExtFiboType = true;
extern bool   ExtFiboCorrectionExpansion = false;
extern bool   ExtFiboDinamic = false;
extern bool   ExtFiboStatic = false;
extern int    ExtFiboStaticNum = 2;
extern int    ExtSizeTxt = 7;
extern color  ExtLine = DarkBlue;
extern color  ExtNotFibo = SlateGray;
extern color  ExtPesavento = Yellow;
extern color  ExtGartley886 = GreenYellow;
extern color  ExtFiboS = Teal;
extern color  ExtFiboD = Sienna;
//----------------------------------------------------------------------
//  ,     . .
//----------------------------------------------------------------------
//    
extern int    ExtPitchforkDinamic = 0;
extern int    ExtPitchforkStatic = 0;
extern int    ExtPitchforkStaticNum = 3;
extern color  ExtLinePitchforkS = MediumBlue;
extern color  ExtLinePitchforkD = MediumSlateBlue;
extern color  ExtPitchforkStaticColor = CLR_NONE;
extern int    ExtPitchforkStyle = 1;
//   
extern bool   ExtFiboFanDinamic = false;  //   
extern bool   ExtFiboFanStatic = false;   //      
extern bool   ExtFiboFanExp=true;
extern bool   ExtFiboFanHidden = false;
extern color  ExtFiboFanS = Teal;
extern color  ExtFiboFanD = Sienna;

extern color  ExtFiboFanMedianaStaticColor = CLR_NONE;
extern color  ExtFiboFanMedianaDinamicColor = CLR_NONE;

//   
extern bool   ExtFiboTime1 = false;
extern bool   ExtFiboTime2 = false;
extern color  ExtFiboTime1C = Teal;
extern color  ExtFiboTime2C = Sienna;
//extern color  ExtPivotZoneColor = CLR_NONE; //|ExtPivotZoneColor -    Pivot Zone                   |

//     
extern bool   ExtUTL = false;
extern bool   ExtLTL = false;
extern bool   ExtUWL = false;
extern bool   ExtLWL = false;

//   
extern bool   ExtRLine = true;
extern bool   ExtRLineBase =true;
//----------------------------------------------------------------------
extern bool     ExtPitchforkCandle = false;
extern bool     ExtPitchfork_1_HighLow = true;
extern datetime ExtDateTimePitchfork_1 = D'11.07.2006 00:00';
extern datetime ExtDateTimePitchfork_2 = D'19.07.2006 00:00';
extern datetime ExtDateTimePitchfork_3 = D'09.08.2006 00:00';
//----------------------------------------------------------------------
//  ,     . .
//----------------------------------------------------------------------
//  
extern int    ExtFiboFanNum = 0;
extern color  ExtFiboFanColor = CLR_NONE;
//  
extern int    ExtFiboExpansion = 0;
extern color  ExtFiboExpansionColor = Yellow;
//--------------------------------------
extern int    ExtVLStaticNum = 0;
extern color  ExtVLStaticColor = CLR_NONE;
extern color  ExtVLDinamicColor = CLR_NONE;
//--------------------------------------
extern bool   chHL = false;
extern bool   PeakDet = false;
//   i-vts
extern bool   chHL_PeakDet_or_vts = true;
extern int    NumberOfBars = 1000;     //    (0-)
extern int    NumberOfVTS  = 13;
extern int    NumberOfVTS1 = 1;
// --------------------------------
//  
extern bool   infoTF = false;
//     
extern bool   ExtBack = true;
//    , Fibo Time
extern bool   ExtSave = false;
extern bool   ExtStyleZZ = true;
extern bool   ExtAlert = false;
extern int    ExtComplekt=111;
//===================================

//   ZigZag 
//    ZigZag
double zz[];
//   ZigZag
double zzL[];
//   ZigZag
double zzH[];
//   nen-ZigZag
double nen_ZigZag[];
//    ZigZag
//double TempBuffer[1],ZigZagBuffer[1];
//   
//    (   )
double fi[]={0.382, 0.447, 0.5, 0.618, 0.707, 0.786, 0.841, 0.886, 1.0, 1.128, 1.272, 1.414, 1.5, 1.618, 2.0, 2.236, 2.414, 2.618, 3.14, 3.618, 4.0};
string fitxt[]={".382", ".447", ".5", ".618", ".707", ".786", ".841", ".886", "1.0", "1.128", "1.272", "1.414", "1.5", "1.618", "2.0", "2.236", "2.414", "2.618", "3.14", "3.618", "4.0"};
double fi1[]={0.146, 0.236, 0.382, 0.5, 0.618, 0.764, 0.854, 1.0, 1.236, 1.618};
string fitxt1[]={"0.146", "0.236", ".382", ".5", ".618", ".764", ".854", "1.0", "1.236", "1.618"};
string nameObj,nameObjtxt,save;
// 
bool descript_b=false;
// PPWithBars - ,    
// descript -  
string PPWithBars, descript;
//      afr -            
// afrl - , afrh - 
int afr[]={0,0,0,0,0,0,0,0,0,0};
double afrl[]={0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0}, afrh[]={0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
//  
double openTF[]={0.0,0.0,0.0,0.0,0.0}, closeTF[]={0.0,0.0,0.0,0.0,0.0}, lowTF[]={0.0,0.0,0.0,0.0,0.0}, highTF[]={0.0,0.0,0.0,0.0,0.0};
double close_TF=0;
string TF[]={"MN","W1","D1","H4","H1"};
bool afrm=true;
double ExtHL;
double HL,HLp,kk,kj,Angle;
// LowPrim,HighPrim,LowLast,HighLast -     
double LowPrim,HighPrim,LowLast,HighLast;
// numLowPrim,numHighPrim,numLowLast,numHighLast - 
int numLowPrim,numHighPrim,numLowLast,numHighLast,k,k1,k2,ki,kiPRZ=0,countLow1,countHigh1,shift,shift1;
//        
int timeFr1new;
//  
int countFr;
// ,         
int countBarEnd=0,TimeBarEnd;
// ,       
int numBar=0;
//  
int numOb;
// flagFrNew=true -          . =false -  .
bool flagFrNew=false;
//   
int perTF;
bool Demo;

int counted_bars, cbi, iBar;

int timeFirstBar=0;

//   ZigZag       Ensign
double ha[],la[],hi,li,si,sip,di,hm,lm,ham[],lam[],him,lim,lLast=0,hLast=0;
int fs=0,fsp,countBar;
int ai,aip,bi,bip,ai0,aip0,bi0,bip0;
datetime tai,tbi,taip,tbip,ti;
// fcount0 -       0  fcount0=true.
//    =false     
bool fh=false,fl=false,fcount0;

//    
double lLast_m=0, hLast_m=0;
int countBarExt; //   
int countBarl,countBarh;

//   nen-ZigZag
bool hi_nen;
bool init_zz=true;

//      
int mFibo[]={0,0}, mPitch[]={0,0,0}, mFan[]={0,0}, mExpansion[]={0,0,0}, mVL[]={0,0,0};
//       
int mPitchTime[]={0,0,0};
double mPitchCena[]={0.0,0.0,0.0};

//   vts
double ms[2];
//    RSI
string name_ZUP="ZUP_RSI_v48";
int NumWindow=0;
double HL_RSI;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   string aa,aa1;
   int aa2;

   IndicatorBuffers(8);

   if (ExtStyleZZ) {SetIndexStyle(0,DRAW_SECTION);}
   else {SetIndexStyle(0,DRAW_ARROW); SetIndexArrow(0,159);}
   SetIndexLabel(0,"ZUP"+ExtComplekt+" (zz"+ExtIndicator+")");
   if (ExtIndicator==6) SetIndexLabel(5,"ZUP"+ExtComplekt+" DT6_"+minBars+"/"+ExtDeviation+"/"+ExtBackstep+"/GP"+GrossPeriod+"");
   else if (ExtIndicator==7) SetIndexLabel(5,"ZUP"+ExtComplekt+" DT7_"+minBars+"/GP"+GrossPeriod+"");
   else if (ExtIndicator==8) SetIndexLabel(5,"ZUP"+ExtComplekt+" DT8_"+minBars+"/"+ExtDeviation+"/GP"+GrossPeriod+"");
   if (chHL_PeakDet_or_vts)
     {
      SetIndexLabel(1,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" H_PeakDet");
      SetIndexLabel(2,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" L_PeakDet");
      SetIndexLabel(3,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" H_chHL");
      SetIndexLabel(4,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" L_chHL");
     }
   else
     {
      SetIndexLabel(1,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" H_vts");
      SetIndexLabel(2,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" L_vts");
      SetIndexLabel(3,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" H_vts1");
      SetIndexLabel(4,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" L_vts1");
     }

   SetIndexBuffer(0,zz);
   SetIndexBuffer(5,nen_ZigZag);
   SetIndexBuffer(6,zzL);
   SetIndexBuffer(7,zzH);

   SetIndexStyle(5,DRAW_ARROW);
   SetIndexArrow(5,159);
//   
   SetIndexStyle(1,DRAW_LINE,STYLE_DOT);
   SetIndexStyle(2,DRAW_LINE,STYLE_DOT); 
   SetIndexBuffer(1,ham);
   SetIndexBuffer(2,lam);
//  
   SetIndexStyle(3,DRAW_LINE,STYLE_DOT);
   SetIndexStyle(4,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(3,ha);
   SetIndexBuffer(4,la);

   SetIndexEmptyValue(0,0.0);
   SetIndexEmptyValue(1,0.0);
   SetIndexEmptyValue(2,0.0);
   SetIndexEmptyValue(3,0.0);
   SetIndexEmptyValue(4,0.0);
   SetIndexEmptyValue(5,0.0);
   SetIndexEmptyValue(6,0.0);
   SetIndexEmptyValue(7,0.0);

   if (timeFirstBar==0) timeFirstBar=Time[Bars-1];

   if (ExtIndicator==1) if (minSize!=0) di=minSize*Point/2;
   if (ExtIndicator==2) {di=minSize*Point; countBar=minBars;}
   if (ExtIndicator==3) {countBar=minBars;}

//     
   if (ExtDelta<=0) ExtDelta=0.001;
   if (ExtDelta>1) ExtDelta=0.999;

   if (ExtHidden<0) ExtHidden=0;
   if (ExtHidden>5) ExtHidden=5;
 
   if (ExtDeltaType<0) ExtDeltaType=0;
   if (ExtDeltaType>3) ExtDeltaType=3;

   if (ExtFractalEnd>0)
     {
      if (ExtFractalEnd<1) ExtFractalEnd=1;
     }

   if (ExtPitchforkStatic>4) ExtPitchforkStatic=4;
   if (ExtPitchforkDinamic>4) ExtPitchforkDinamic=4;

//--------------------------------------------
   if (ExtPitchforkStaticNum<3) ExtPitchforkStaticNum=3;
   
   if (ExtFiboStaticNum<2) ExtFiboStaticNum=2;

   if (ExtFiboStaticNum>9)
     {
      aa=DoubleToStr(ExtFiboStaticNum,0);
      aa1=StringSubstr(aa,0,1);
      mFibo[0]=StrToInteger(aa1);
      aa1=StringSubstr(aa,1,1);
      mFibo[1]=StrToInteger(aa1);
     }
   else
     {
      mFibo[0]=ExtFiboStaticNum;
      mFibo[1]=ExtFiboStaticNum-1;
     }

   if (ExtFiboFanNum<1) ExtFiboFanNum=1;

   if (ExtFiboFanNum>9)
     {
      aa=DoubleToStr(ExtFiboFanNum,0);
      aa1=StringSubstr(aa,0,1);
      mFan[0]=StrToInteger(aa1);
      aa1=StringSubstr(aa,1,1);
      mFan[1]=StrToInteger(aa1);
     }
   else
     {
      mFan[0]=ExtFiboFanNum;
      mFan[1]=ExtFiboFanNum-1;
     }

   if (ExtPitchforkStaticNum>99)
     {
      aa=DoubleToStr(ExtPitchforkStaticNum,0);
      aa1=StringSubstr(aa,0,1);
      mPitch[0]=StrToInteger(aa1);
      aa1=StringSubstr(aa,1,1);
      mPitch[1]=StrToInteger(aa1);
      aa1=StringSubstr(aa,2,1);
      mPitch[2]=StrToInteger(aa1);
     }
   else
     {
      mPitch[0]=ExtPitchforkStaticNum;
      mPitch[1]=ExtPitchforkStaticNum-1;
      mPitch[2]=ExtPitchforkStaticNum-2;
     }

   if (ExtFiboExpansion<2) ExtFiboExpansion=0;
   
   if (ExtFiboExpansion>0)
     {
      if (ExtFiboExpansion>99)
        {
         aa=DoubleToStr(ExtFiboExpansion,0);
         aa1=StringSubstr(aa,0,1);
         mExpansion[0]=StrToInteger(aa1);
         aa1=StringSubstr(aa,1,1);
         mExpansion[1]=StrToInteger(aa1);
         aa1=StringSubstr(aa,2,1);
         mExpansion[2]=StrToInteger(aa1);
        }
      else
        {
         mExpansion[0]=ExtFiboExpansion;
         mExpansion[1]=ExtFiboExpansion-1;
         mExpansion[2]=ExtFiboExpansion-2;
        }
     }

   if (ExtVLStaticNum>0)
     {
      if (ExtVLStaticNum<2) ExtVLStaticNum=2;

      if (ExtVLStaticNum>99)
        {
         aa=DoubleToStr(ExtVLStaticNum,0);
         aa1=StringSubstr(aa,0,1);
         mVL[0]=StrToInteger(aa1);
         aa1=StringSubstr(aa,1,1);
         mVL[1]=StrToInteger(aa1);
         aa1=StringSubstr(aa,2,1);
         mVL[2]=StrToInteger(aa1);
        }
      else
        {
         mVL[0]=ExtVLStaticNum;
         mVL[1]=ExtVLStaticNum-1;
         mVL[2]=ExtVLStaticNum-2;
        }
     }
   
   if (ExtPitchforkCandle)
     {
      mPitchTime[0]=ExtDateTimePitchfork_1;
      mPitchTime[1]=ExtDateTimePitchfork_2;
      mPitchTime[2]=ExtDateTimePitchfork_3;

      if (ExtPitchfork_1_HighLow)
        {
         mPitchCena[0]=High[iBarShift(Symbol(),Period(),ExtDateTimePitchfork_1)];
         mPitchCena[1]=Low[iBarShift(Symbol(),Period(),ExtDateTimePitchfork_2)];
         mPitchCena[2]=High[iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)];
        }
      else
        {
         mPitchCena[0]=Low[iBarShift(Symbol(),Period(),ExtDateTimePitchfork_1)];
         mPitchCena[1]=High[iBarShift(Symbol(),Period(),ExtDateTimePitchfork_2)];
         mPitchCena[2]=Low[iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)];
        }
     }

   if (ExtSave)
     {
      MathSrand(LocalTime());
      save=MathRand();
     }
   
   Comment("                                                                  ");
   perTF=Period();
   Demo=IsDemo();
   delete_objects1();

   NumWindow=WindowFind(name_ZUP);

   return(0);
  }
//+------------------------------------------------------------------+
//| .       
//+------------------------------------------------------------------+
int deinit()
  {
  int i;
   delete_objects1();
   ObjectDelete("fiboS" + ExtComplekt);ObjectDelete("fiboD" + ExtComplekt);
   ObjectDelete("fiboFanS" + ExtComplekt);ObjectDelete("fiboFanD" + ExtComplekt);
   ObjectDelete("RLineD" + ExtComplekt);ObjectDelete("RLineS" + ExtComplekt);
   ObjectDelete("pitchforkD" + ExtComplekt);ObjectDelete("pitchforkS" + ExtComplekt);
   ObjectDelete("pmedianaD" + ExtComplekt);ObjectDelete("pmedianaS" + ExtComplekt);
   ObjectDelete("1-2pmedianaD" + ExtComplekt);ObjectDelete("1-2pmedianaS" + ExtComplekt);
   ObjectDelete("fiboTime1" + ExtComplekt);ObjectDelete("fiboTime2" + ExtComplekt);
   ObjectDelete("fiboExpansion" + ExtComplekt);
   ObjectDelete("UTL" + ExtComplekt);ObjectDelete("LTL" + ExtComplekt);
   ObjectDelete("UWL" + ExtComplekt);ObjectDelete("LWL" + ExtComplekt);
   ObjectDelete("CL" + ExtComplekt);
//   ObjectDelete("PivotZoneS" + ExtComplekt);
   ObjectDelete("FanMedianaStatic" + ExtComplekt);ObjectDelete("FanMedianaDinamic" + ExtComplekt);
   ObjectDelete("FiboFan" + ExtComplekt);

   for (i=0; i<7; i++)
     {
      nameObj="VLS"+i+" " + ExtComplekt;
      ObjectDelete(nameObj);
     }

   for (i=0; i<7; i++)
     {
      nameObj="VLD"+i+" " + ExtComplekt;
      ObjectDelete(nameObj);
     }


   return(0);
  }
//********************************************************
// 
int start()
  {
//  Print (NumWindow); 
   if (ExtIndicator==6 && Period()>GrossPeriod) 
     {
      for (iBar=Bars-1; iBar>0; iBar--) {zzL[iBar]=0.0; zzH[iBar]=0.0; zz[iBar]=0.0;}
      init_zz=true;
      return;
     }

   counted_bars=IndicatorCounted();
  
   if (perTF!=Period())
     {
      delete_objects1();  
      perTF=Period();
     }

   if (Demo!=IsDemo())
     {
      delete_objects1();  
      Demo=IsDemo();
      counted_bars=0;
     }

//-----------------------------------------
//
//     1.
//
//   . . 
//-----------------------------------------   
// zz[] - ,        ZigZag-a
// zzL[] -   
// zzH[] -   
//
//-----------------------------------------   
//
//     ,
//     .
//      ,
//    .
//
//   ,    .
//
//-----------------------------------------

if (ExtIndicator>0)
  {
   if (timeFirstBar==Time[Bars-1])
     {
      if (ExtIndicator==6) 
        {
         if (Bars-IndicatorCounted()>2)
           {
            cbi=Bars-1;
            for (iBar=cbi; iBar>0; iBar--) {zzL[iBar]=0.0; zzH[iBar]=0.0; zz[iBar]=0.0;}
            init_zz=true;
           }
         else cbi=Bars-IndicatorCounted()+1;
        }
      else cbi=Bars-IndicatorCounted()-1;
     }
   else
     {
      cbi=Bars-1;
      for (iBar=cbi; iBar>0; iBar--) {zzL[iBar]=0.0; zzH[iBar]=0.0; zz[iBar]=0.0;}
      if (ExtIndicator==6) 
        {
         init_zz=true;
        }
      timeFirstBar=Time[cbi];
     }
  }


if (ExtIndicator==0) ZigZag_();
if (ExtIndicator==1) ang_AZZ_();
if (ExtIndicator==2) Ensign_ZZ();
if (ExtIndicator==3) Ensign_ZZ();
if (ExtIndicator==4) ZigZag_tauber();
if (ExtIndicator==5) GannSwing();
if (ExtIndicator==6) nenZigZag(); // DT-ZigZag -  ,   ZigZag_new_nen3.mq4
if (ExtIndicator==7) nenZigZag(); // DT-ZigZag -  ,    klot - DT_ZZ.mq4
if (ExtIndicator==8) nenZigZag(); // DT-ZigZag -  ,    Candid - CZigZag.mq4
if (ExtIndicator==9) RSI_ZZ(); 
//if (ExtIndicator==7) ZigZag_new_nen1();


if (ExtHidden<5) //    . .
  {
   if(!chHL_PeakDet_or_vts) {i_vts(); i_vts1();}
   //  
   matriza();
   if (infoTF) if (close_TF!=Close[0]) info_TF();
  }


//-----------------------------------------
//   . .
//-----------------------------------------   

if (ExtHidden>0 && ExtHidden<5) //    . .
  {
//======================
//======================
//======================

//-----------------------------------------
//
//     2.
//
//   . .
//-----------------------------------------   

   if (Bars - counted_bars>2 || flagFrNew)
     {

      //     ,       
      if (countBarEnd==0)
        {
         if (ExtFractalEnd>0)
           {
            k=ExtFractalEnd;
            for (shift=0; shift<Bars && k>0; shift++) 
              { 
               if (zz[shift]>0 && zzH[shift]>0) {countBarEnd=shift; TimeBarEnd=Time[shift]; k--;}
              }
           }
         else 
           {
            countBarEnd=Bars-3;
            TimeBarEnd=Time[Bars-3];
           }
        }
      else
        {
         countBarEnd=iBarShift(Symbol(),Period(),TimeBarEnd); 
        }

     }
//-----------------------------------------
//   . .
//-----------------------------------------   


//-----------------------------------------
//
//     3.
//
//     , 
//  . .
//-----------------------------------------   
//     . .

if (Bars - counted_bars<3)
  {
   //     ,    
   for (shift1=0; shift1<Bars; shift1++) 
     {
      if (zz[shift1]>0.0 && (zzH[shift1]==zz[shift1] || zzL[shift1]==zz[shift1])) 
       {
        timeFr1new=Time[shift1];
        break;
       }
     }
   //  ,      .
   shift=iBarShift(Symbol(),Period(),afr[0]); 


   //    ZigZag
   if ((zzH[shift1]>0 && afrl[0]>0) || (zzL[shift1]>0 && afrh[0]>0))
     {
      ExtFiboStatic=false;
      ExtPitchforkStatic=0;
      ExtFiboExpansion=0;
      ExtFiboFanNum=0;
      
      if (ExtAlert)
       {
        Alert (Symbol(),"  ",Period(),"     ZigZag");
        PlaySound("catlaugh.wav");
       }
     }

   //      ,   

   //   
   if (timeFr1new!=afr[0])
     {
      flagFrNew=true;
      if (shift>=shift1) numBar=shift; else  numBar=shift1;
      afrm=true;
     }

   //       
   if (afrh[0]>0 && zz[shift]==0.0)
     {
      flagFrNew=true;
      if (numBar<shift) numBar=shift;
      afrm=true;
     }
   //       
   if (afrl[0]>0 && zz[shift]==0.0)
     {
      flagFrNew=true;
      if (numBar<shift) numBar=shift;
      afrm=true;
     }

//iRSI(NULL,0,minBars,Price,i)
//-----------3    ,      . .

//============= 1  . .
if (ExtIndicator!=9) HL_RSI=High[shift]; else HL_RSI=iRSI(NULL,0,minBars,Price,shift);
if (afrh[0]-HL_RSI!=0 && afrh[0]>0)
  {
   flagFrNew=true;
   numBar=0;
   delete_objects2(afr[0]);
   afrh[0]=HL_RSI;
   if (ExtFiboDinamic) screenFiboD();
   if (ExtPitchforkDinamic>0) screenPitchforkD();
   if (ExtFiboFanDinamic) screenFiboFanD();
   if (mFibo[1]==0 && ExtFiboStatic) screenFiboS();
   if (ExtVLDinamicColor>0) VLD();
   if (mVL[2]==0 && ExtVLStaticNum>0) VLS();
   if (ExtPitchforkStatic>0)
     {
      if (ExtPitchforkCandle)
        {
         if (iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)==0) screenPitchforkS();
        }
      else
        {
         if (mPitch[2]==0) screenPitchforkS();
        }
     }
   if (mExpansion[2]==0 && ExtFiboExpansion>0) FiboExpansion();
   if (mFan[1]==0 && ExtFiboFanNum>0 && ExtFiboFanColor>0) screenFiboFan();
  }
//============= 1  . .
//
//============= 1  . .
if (ExtIndicator!=9) HL_RSI=Low[shift]; else HL_RSI=iRSI(NULL,0,minBars,Price,shift);
if (afrl[0]-HL_RSI!=0 && afrl[0]>0)
  {
   flagFrNew=true;
   numBar=0;
   delete_objects2(afr[0]);
   afrl[0]=HL_RSI;
   if (ExtFiboDinamic) screenFiboD();
   if (ExtFiboFanDinamic) screenFiboFanD();
   if (mFibo[1]==0 && ExtFiboStatic) screenFiboS();
   if (ExtVLDinamicColor>0) VLD();
   if (mVL[2]==0 && ExtVLStaticNum>0) VLS();
   if (ExtPitchforkStatic>0)
     {
      if (ExtPitchforkCandle)
        {
         if (iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)==0) screenPitchforkS();
        }
      else
        {
         if (mPitch[2]==0) screenPitchforkS();
        }
     }
   if (mExpansion[2]==0 && ExtFiboExpansion>0) FiboExpansion();
   if (mFan[1]==0 && ExtFiboFanNum>0 && ExtFiboFanColor>0) screenFiboFan();
  }
//============= 1  . .
//-----------3    ,      . .


   //      ,    . .
   countBarEnd=iBarShift(Symbol(),Period(),TimeBarEnd); 
   for (k=0; k<5; k++)
     {

      //  .
      if (afrh[k]>0)
        {
         //  ,     
         shift=iBarShift(Symbol(),Period(),afr[k]); 
         if (zz[shift]==0)
           {
            flagFrNew=true;
            if (shift>numBar) numBar=shift;
            afrm=true;
            numHighPrim=shift; numHighLast=0;HighLast=0.0;
            for (k1=shift+1; k1<=countBarEnd; k1++)
              {
               if (zzH[k1]>0) 
                 {
                  if (ExtIndicator!=9) HL_RSI=High[k1]; else HL_RSI=iRSI(NULL,0,minBars,Price,k1);
                  if (ZigZagHighLow) HighLast=HL_RSI; else HighLast=zzH[k1];
                  numHighLast=k1;

                  nameObj="" + ExtComplekt + "ph" + Time[numHighPrim] + "_" + Time[numHighLast];

                  numOb=ObjectFind(nameObj);
                  if (numOb>-1)
                    {
                     ObjectDelete(nameObj); 

                     nameObjtxt="" + ExtComplekt + "phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

                     ObjectDelete(nameObjtxt);
                    }
                 }
              }
           }
        }
      
      //  .
      if (afrl[k]>0)
        {
         //  ,     
         shift=iBarShift(Symbol(),Period(),afr[k]); 
         if (zz[shift]==0)
           {
            flagFrNew=true;
            if (shift>numBar) numBar=shift;

            afrm=true;
            numLowPrim=shift; numLowLast=0;LowLast=10000000;
            for (k1=shift+1; k1<=countBarEnd; k1++)
              {
               if (zzL[k1]>0) 
                 {
                  if (ExtIndicator!=9) HL_RSI=Low[k1]; else HL_RSI=iRSI(NULL,0,minBars,Price,k1);
                  if (ZigZagHighLow) LowLast=HL_RSI; else LowLast=zzL[k1];
                  numLowLast=k1;

                  nameObj="" + ExtComplekt + "pl" + Time[numLowPrim] + "_" + Time[numLowLast];

                  numOb=ObjectFind(nameObj);
                  if (numOb>-1)
                    {
                     ObjectDelete(nameObj); 

                     nameObjtxt="" + ExtComplekt + "pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

                     ObjectDelete(nameObjtxt);
                    }
                 }
              }
           }
        }
     }
   //      ,    . .

   //  . .
   matriza ();
   //  . .

  }
//     . .
//-----------------------------------------
//     , 
//  . .
//-----------------------------------------   


  //   . .
  countFractal();
  //   . .

//-----------------------------------------
//
//     4.
//
//    . .
//-----------------------------------------   
if (Bars - counted_bars>2)
  {
//-----------1  . .
//+--------------------------------------------------------------------------+
//|        0.886   ZigZag-a
//|     
//+--------------------------------------------------------------------------+

   numLowPrim=0; numLowLast=0;
   numHighPrim=0; numHighLast=0;

   LowPrim=0.0; LowLast=0.0;
   HighPrim=0.0; HighLast=0.0;
   
   Angle=-100;
   
   if (flagFrNew) countFr=1;
   else countFr=ExtFractal;

   for (k=0; (k<Bars-1 && countHigh1>0 && countFr>0); k++)
     {
      if (zzL[k]>0.0 && (zzL[k]<LowPrim || LowPrim==0.0) && HighPrim>0 && zzL[k]==zz[k])
        {
         if (ExtIndicator!=9) HL_RSI=Low[k]; else HL_RSI=iRSI(NULL,0,minBars,Price,k);
         if (ZigZagHighLow) LowPrim=HL_RSI; else LowPrim=zzL[k]; 
         numLowPrim=k;
        }
      if (zzH[k]>0.0 && zzH[k]==zz[k])
        {
         if (HighPrim>0) 
           {

            if (ExtIndicator!=9) HL_RSI=High[k]; else HL_RSI=iRSI(NULL,0,minBars,Price,k);
            if (ZigZagHighLow) HighLast=HL_RSI; else HighLast=zzH[k];
            numHighLast=k;

            HL=HighLast-LowPrim;
            kj=(HighPrim-HighLast)*1000/(numHighLast-numHighPrim);
            if (HL>0 && (Angle>=kj || Angle==-100))  //    
              {
               Angle=kj;
               //     
               HLp=HighPrim-LowPrim;
               k1=MathCeil((numHighPrim+numHighLast)/2);
               kj=HLp/HL;

               
               if (ExtPPWithBars==0) PPWithBars="";
               else
                 {
                  if (ExtPPWithBars==1) PPWithBars=" ("+(numHighLast-numHighPrim)+")";
                  else if (ExtPPWithBars==2) PPWithBars=" ("+(numHighLast-numLowPrim)+"-"+(numLowPrim-numHighPrim)+")";
                 }

               if (kj>0.14 && kj<=5)
                 {
                  //    ( ). %   
                  kk=kj;
                  k2=1;
                  if (!ExtFiboType)
                    {
                     if (ExtDeltaType==2) for (ki=kiPRZ;ki<=9;ki++) {if (MathAbs((fi1[ki]-kj)/fi1[ki])<=ExtDelta) {kk=fi1[ki]; k2=-1; break;}}
                     if (ExtDeltaType==1) for (ki=kiPRZ;ki<=9;ki++) {if (MathAbs(fi1[ki]-kj)<=ExtDelta) {kk=fi1[ki]; k2=-1; break;}}
                    }
                  else
                    {
                     if (ExtDeltaType==2) for (ki=kiPRZ;ki<=20;ki++) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                     if (ExtDeltaType==1) for (ki=kiPRZ;ki<=20;ki++) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                    }

                  if (k2<0)
                    //      0.886
                    {
                    if (ExtHidden!=4)
                      {
                       nameObj="" + ExtComplekt + "phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

                       ObjectCreate(nameObj,OBJ_TEXT,NumWindow,Time[k1],(HighPrim+HighLast)/2);

                       if (kk==0.447 ||  kk==0.886 || kk==2.236 || kk==3.14 || kk==3.618) // Gartley
                         {
                          descript=fitxt[ki];
                          ObjectSetText(nameObj,fitxt[ki]+PPWithBars,ExtSizeTxt,"Arial", ExtGartley886);
                         }
                       else
                         if (!ExtFiboType)
                           {
                            descript=fitxt1[ki];
                            ObjectSetText(nameObj, fitxt1[ki]+PPWithBars,ExtSizeTxt,"Arial",ExtPesavento);
                           }
                         else
                           {
                            descript=fitxt[ki];
                            ObjectSetText(nameObj, fitxt[ki]+PPWithBars,ExtSizeTxt,"Arial",ExtPesavento);
                           }
                      }
                     }
                  else
                    //   (   0.886)
                    {
                     if (ExtHidden==1 || ExtHidden==4)
                       {
                        nameObj="" + ExtComplekt + "phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

                        ObjectCreate(nameObj,OBJ_TEXT,NumWindow,Time[k1],(HighPrim+HighLast)/2);

                        descript=DoubleToStr(kk,3);
                        ObjectSetText(nameObj,""+DoubleToStr(kk,2)+PPWithBars,ExtSizeTxt,"Arial",ExtNotFibo);
                       }
                    }

                  if ((ExtHidden==2 && k2<0) || ExtHidden!=2)
                    {
                     nameObj="" + ExtComplekt + "ph" + Time[numHighPrim] + "_" + Time[numHighLast];
                     ObjectCreate(nameObj,OBJ_TREND,NumWindow,Time[numHighPrim],HighPrim,Time[numHighLast],HighLast);
                     //ObjectCreate(nameObj,OBJ_TRIANGLE,NumWindow,Time[numHighPrim],HighPrim,Time[numHighLast],HighLast);
                     if (descript_b) ObjectSetText(nameObj,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" PPesavento "+"Line High "+descript);
                     ObjectSet(nameObj,OBJPROP_RAY,false);
                     ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
                     ObjectSet(nameObj,OBJPROP_COLOR,ExtLine);
                     ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
                    
                    
                     //////////////////////////////////////////////////////////////////
                    }
                  if (ExtFiboZigZag) k=countBarEnd;
                 }
              }
           }
         else 
           {
            if (ExtIndicator!=9) HL_RSI=High[k]; else HL_RSI=iRSI(NULL,0,minBars,Price,k);
            if (ZigZagHighLow) HighPrim=HL_RSI; else HighPrim=zzH[k];
            numHighPrim=k;
           }
        }
       //    
       if (k>countBarEnd) 
         {
          k=numHighPrim+1; countHigh1--; countFr--;

          numLowPrim=0; numLowLast=0;
          numHighPrim=0; numHighLast=0;

          LowPrim=0.0; LowLast=0.0;
          HighPrim=0.0; HighLast=0.0;
   
          Angle=-100;
         }
     }
//-----------1  . .

//-----------2  . .
//+-------------------------------------------------------------------------+
//|        0.886   ZigZag-a
//|     
//+-------------------------------------------------------------------------+

   numLowPrim=0; numLowLast=0;
   numHighPrim=0; numHighLast=0;

   LowPrim=0.0; LowLast=0.0;
   HighPrim=0.0; HighLast=0.0;
   
   Angle=-100;

   if (flagFrNew) countFr=1;
   else countFr=ExtFractal;

   for (k=0; (k<Bars-1 && countLow1>0 && countFr>0); k++)
     {
      if (zzH[k]>HighPrim && LowPrim>0)
        {
         if (ExtIndicator!=9) HL_RSI=High[k]; else HL_RSI=iRSI(NULL,0,minBars,Price,k);
         if (ZigZagHighLow) HighPrim=HL_RSI; else HighPrim=zzH[k];
         numHighPrim=k;
        }

      if (zzL[k]>0.0 && zzL[k]==zz[k]) 
        {
         if (LowPrim>0) 
           {

            if (ExtIndicator!=9) HL_RSI=Low[k]; else HL_RSI=iRSI(NULL,0,minBars,Price,k);
            if (ZigZagHighLow) LowLast=HL_RSI; else LowLast=zzL[k];
            numLowLast=k;

            //      ( )
            HL=HighPrim-LowLast;
            kj=(LowPrim-LowLast)*1000/(numLowLast-numLowPrim);
            if (HL>0 && (Angle<=kj || Angle==-100))  //    
              {
               Angle=kj;

               HLp=HighPrim-LowPrim;
               k1=MathCeil((numLowPrim+numLowLast)/2);
               kj=HLp/HL;

               if (ExtPPWithBars==0) PPWithBars="";
               else if (ExtPPWithBars==1) PPWithBars=" ("+(numLowLast-numLowPrim)+")";
               else if (ExtPPWithBars==2) PPWithBars=" ("+(numLowLast-numHighPrim)+"-"+(numHighPrim-numLowPrim)+")";

               if ( kj>0.14 && kj<=5)
                 {
                  //    ( ). %   
                  kk=kj;
                  k2=1;

                  if (!ExtFiboType)
                    {
                     if (ExtDeltaType==2) for (ki=kiPRZ;ki<=9;ki++) {if (MathAbs((fi1[ki]-kj)/fi1[ki])<=ExtDelta) {kk=fi1[ki]; k2=-1; break;}}
                     if (ExtDeltaType==1) for (ki=kiPRZ;ki<=9;ki++) {if (MathAbs(fi1[ki]-kj)<=ExtDelta) {kk=fi1[ki]; k2=-1; break;}}
                    }
                  else
                    {
                     if (ExtDeltaType==2) for (ki=kiPRZ;ki<=20;ki++) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                     if (ExtDeltaType==1) for (ki=kiPRZ;ki<=20;ki++) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                    }

                  if (k2<0)
                  //      0.886
                    {
                     if (ExtHidden!=4)                  
                       {
                        nameObj="" + ExtComplekt + "pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

                        ObjectCreate(nameObj,OBJ_TEXT,NumWindow,Time[k1],(LowPrim+LowLast)/2);

                        if (kk==0.447 ||  kk==0.886 || kk==2.236 || kk==3.14 || kk==3.618) // Gartley
                          {
                           descript=fitxt[ki];
                           ObjectSetText(nameObj,fitxt[ki]+PPWithBars,ExtSizeTxt,"Arial", ExtGartley886);
                          }
                        else
                          if (!ExtFiboType)
                            {
                             descript=fitxt1[ki];
                             ObjectSetText(nameObj, fitxt1[ki]+PPWithBars,ExtSizeTxt,"Arial",ExtPesavento);
                            }
                          else
                            {
                             descript=fitxt[ki];
                             ObjectSetText(nameObj, fitxt[ki]+PPWithBars,ExtSizeTxt,"Arial",ExtPesavento);
                            }
                       }
                    }
                  else 
                    //   (   0.886)
                    { 
                     if (ExtHidden==1 || ExtHidden==4)
                       {
                        nameObj="" + ExtComplekt + "pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

                        ObjectCreate(nameObj,OBJ_TEXT,NumWindow,Time[k1],(LowPrim+LowLast)/2);

                        descript=DoubleToStr(kk,3);
                        ObjectSetText(nameObj,""+DoubleToStr(kk,2)+PPWithBars,ExtSizeTxt,"Arial",ExtNotFibo);
                       }
                     }
                     
                   if ((ExtHidden==2 && k2<0) || ExtHidden!=2)
                     {
                      nameObj="" + ExtComplekt + "pl" + Time[numLowPrim] + "_" + Time[numLowLast];

                      ObjectCreate(nameObj,OBJ_TREND,NumWindow,Time[numLowPrim],LowPrim,Time[numLowLast],LowLast);

                      if (descript_b) ObjectSetText(nameObj,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" PPesavento "+"Line Low "+descript);
                      ObjectSet(nameObj,OBJPROP_RAY,false);
                      ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
                      ObjectSet(nameObj,OBJPROP_COLOR,ExtLine);
                      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
                     }
                   if (ExtFiboZigZag) k=countBarEnd;
                  }
               }
           }
         else
           {
            numLowPrim=k; 
            if (ExtIndicator!=9) HL_RSI=Low[k]; else HL_RSI=iRSI(NULL,0,minBars,Price,k);
            if (ZigZagHighLow) LowPrim=HL_RSI; else LowPrim=zzL[k];
           }
        }
       //    
       if (k>countBarEnd) 
         {
          k=numLowPrim+1; countLow1--; countFr--;

          numLowPrim=0; numLowLast=0;
          numHighPrim=0; numHighLast=0;

          LowPrim=0.0; LowLast=0.0;
          HighPrim=0.0; HighLast=0.0;
  
          Angle=-100;
         }
     }

//-----------2  . .

  }
//-----------------------------------------
//    . .
//-----------------------------------------   

//======================
//======================
//======================
  } //    . .
// 
  } // start



//----------------------------------------------------
//    
//----------------------------------------------------

//--------------------------------------------------------
//   .   . .
//--------------------------------------------------------
void countFractal()
  {
   int shift;
   countLow1=0;
   countHigh1=0;
   if (flagFrNew)
     {
      for(shift=0; shift<=numBar; shift++)
        {
         if (zzL[shift]>0.0) {countLow1++;}
         if (zzH[shift]>0.0) {countHigh1++;}    
        }
      flagFrNew=false;
      numBar=0;  
      counted_bars=Bars-4;
     }
   else
     {
      for(shift=0; shift<=countBarEnd; shift++)
        {
         if (zzL[shift]>0.0) {countLow1++;}
         if (zzH[shift]>0.0) {countHigh1++;}
        }
     }
  }
//--------------------------------------------------------
//   .   . .
//--------------------------------------------------------

//--------------------------------------------------------
//  . .
//
//      .
//       ZigZag-a.
//
//         ,
//  ...
//------------------------------------------------------
void matriza()
  {
   if (afrm)
     {
      afrm=false;
      int shift,k;
      
      k=0;
      for (shift=0; shift<Bars && k<10; shift++)
        {
         if (zz[shift]>0)
           {
            afr[k]=Time[shift];
            if (ExtIndicator!=9)
              {
               if (zz[shift]==zzL[shift])
                 {
                  if (ZigZagHighLow) afrl[k]=Low[shift]; 
                  else
                    {
                     if (k==0) afrl[k]=Low[shift]; else  afrl[k]=zzL[shift];
                    }
                  afrh[k]=0.0;
                 }
               if (zz[shift]==zzH[shift])
                 {
                  if (ZigZagHighLow) afrh[k]=High[shift]; 
                  else
                    {
                     if (k==0) afrh[k]=High[shift]; else afrh[k]=zzH[shift];
                    }
                  afrl[k]=0.0;
                 }
              }
            else
              {
               if (zz[shift]==zzL[shift])
                 {
                  afrl[k]=iRSI(NULL,0,minBars,Price,shift); 
                  afrh[k]=0.0;
                 }
               if (zz[shift]==zzH[shift])
                 {
                  afrh[k]=iRSI(NULL,0,minBars,Price,shift); 
                  afrl[k]=0.0;
                 }
              }
            k++;
           }
        }
      //   
      if (ExtPitchforkStatic>0)
        {
         if (mPitch[2]>0) {screenPitchforkS(); ExtPitchforkStatic=0;}
         if (ExtPitchforkCandle)
           {
            if (iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)==0) screenPitchforkS();
           }
         else
           {
            if (mPitch[2]==0) screenPitchforkS();
           }
        }
      if (ExtPitchforkDinamic>0) {screenPitchforkD();}

      //     .
      if (ExtFiboStatic)
        {
         if (mFibo[1]>0) {ExtFiboStatic=false; screenFiboS();}
         if (mFibo[1]==0) screenFiboS();
        }
      if (ExtFiboDinamic) {screenFiboD();}

      //  
      if (ExtFiboExpansion>0)
        {
         if (mExpansion[2]>0) {FiboExpansion(); ExtFiboExpansion=0;}
         if (mExpansion[2]==0) FiboExpansion();
        }

      //  
      if (ExtFiboFanNum>0 && ExtFiboFanColor>0)
        {
         if (mFan[1]>0) {screenFiboFan(); ExtFiboFanNum=0;}
         if (mFan[1]==0) screenFiboFan();
        }
      if (ExtFiboFanDinamic) screenFiboFanD();

      //  Versum Levels
      if (ExtVLStaticColor>0)
        {
         if (mVL[2]>0) {ExtVLStaticNum=0; VLS();}
         if (mVL[2]==0) VLS();
        }
      if (ExtVLDinamicColor>0) {VLD();}
      
      ExtSave=false;
     }
  }
//--------------------------------------------------------
//  . .
//--------------------------------------------------------

//--------------------------------------------------------
//  Versum Levels . .
//--------------------------------------------------------
void VLS()
  {
   VL(mVL[0],mVL[1],mVL[2],ExtVLStaticColor,"VLS");
  }
//--------------------------------------------------------
//  Versum Levels . .
//--------------------------------------------------------

//--------------------------------------------------------
//  Versum Levels . .
//--------------------------------------------------------
void VLD()
  {
   VL(2,1,0,ExtVLDinamicColor,"VLD");
  }
//--------------------------------------------------------
//  Versum Levels . .
//--------------------------------------------------------

//--------------------------------------------------------
// Versum Levels. .
//--------------------------------------------------------
void VL(int na,int nb,int nc,color color_line,string vl)
  {
   double line_pesavento[7]={0.236, 0.382, 0.447, 0.5, 0.618, 0.786, 0.886}, line_fibo[7]={0.236, 0.382, 0.455, 0.5, 0.545, 0.618, 0.764};
   int c_bar1, c_bar2, i;
   double H_L, mediana, tangens, cena;

   c_bar1=iBarShift(Symbol(),Period(),afr[na])-iBarShift(Symbol(),Period(),afr[nb]); //     AB
   c_bar2=iBarShift(Symbol(),Period(),afr[nb])-iBarShift(Symbol(),Period(),afr[nc]); //     
   if (afrl[na]>0)
    {
     H_L=afrh[nb]-afrl[nc]; //   

     for (i=0; i<7; i++)
       {
        if (ExtFiboType)
          {
           mediana=line_pesavento[i]*H_L+afrl[nc];
           tangens=(mediana-afrl[na])/(c_bar1+(1-line_pesavento[i])*c_bar2);
           cena=c_bar2*line_pesavento[i]*tangens+mediana;
           nameObj=vl+i+" " + ExtComplekt;
           ObjectDelete(nameObj);
           ObjectCreate(nameObj,OBJ_TREND,NumWindow,afr[na],afrl[na],afr[nc],cena);
           ObjectSetText(nameObj,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" "+vl+" "+DoubleToStr(line_pesavento[i]*100,1)+"");
           ObjectSet(nameObj,OBJPROP_COLOR,color_line);
          }
        else
          {
           mediana=line_fibo[i]*H_L+afrl[nc];
           tangens=(mediana-afrl[na])/(c_bar1+(1-line_fibo[i])*c_bar2);
           cena=c_bar2*line_fibo[i]*tangens+mediana;
           nameObj=vl+i+" " + ExtComplekt;
           ObjectDelete(nameObj);
           ObjectCreate(nameObj,OBJ_TREND,NumWindow,afr[na],afrl[na],afr[nc],cena);
           ObjectSetText(nameObj,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" "+vl+" "+DoubleToStr(line_fibo[i]*100,1)+"");
           ObjectSet(nameObj,OBJPROP_COLOR,color_line);
          }
       }
    }
   else
    {
     H_L=afrh[nc]-afrl[nb]; //   

     for (i=0; i<7; i++)
       {
        if (ExtFiboType)
          {
           mediana=afrh[nc]-line_pesavento[i]*H_L;
           tangens=(afrh[na]-mediana)/(c_bar1+(1-line_pesavento[i])*c_bar2);
           cena=mediana-c_bar2*line_pesavento[i]*tangens;
           nameObj=vl+i+" " + ExtComplekt;
           ObjectDelete(nameObj);
           ObjectCreate(nameObj,OBJ_TREND,NumWindow,afr[na],afrh[na],afr[nc],cena);
           ObjectSetText(nameObj,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" "+vl+" "+DoubleToStr(line_pesavento[i]*100,1)+"");
           ObjectSet(nameObj,OBJPROP_COLOR,color_line);
          }
        else
          {
           mediana=afrh[nc]-line_fibo[i]*H_L;
           tangens=(afrh[na]-mediana)/(c_bar1+(1-line_fibo[i])*c_bar2);
           cena=mediana-c_bar2*line_fibo[i]*tangens;
           nameObj=vl+i+" " + ExtComplekt;
           ObjectDelete(nameObj);
           ObjectCreate(nameObj,OBJ_TREND,NumWindow,afr[na],afrh[na],afr[nc],cena);
           ObjectSetText(nameObj,"ZUP"+ExtComplekt+" zz"+ExtIndicator+" "+vl+" "+DoubleToStr(line_fibo[i]*100,1)+"");
           ObjectSet(nameObj,OBJPROP_COLOR,color_line);
          }
       }
    }
  }
//--------------------------------------------------------
// Versum Levels. .
//--------------------------------------------------------



//--------------------------------------------------------
//    . .
//--------------------------------------------------------
void screenPitchforkS()
  {
   int k1,n,nbase1,nbase2;
   double a1,b1,c1,ab1,bc1,ab2,bc2,d,n1,cl1,ch1;
   datetime ta1,tb1,tc1,tab2,tbc2,tcl1,tch1;
   bool fo1=false,fo2=false;
   int    pitch_time[]={0,0,0}; 
   double pitch_cena[]={0,0,0};
   int    TLine_time[]={0,0,0};
   double TLine[]={0,0,0};
   int  m1,m2;

   if (ExtPitchforkCandle)
     {
      if (iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)==0)
        {
         if (ExtPitchfork_1_HighLow)
           {
            mPitchCena[2]=High[iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)];
           }
         else
           {
            mPitchCena[2]=Low[iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)];
           }
        }
     }

   if (ExtFiboFanStatic) {ExtFiboFanStatic=false;screenFiboFanS();}
 
   if (ExtPitchforkStatic>0)
     {
      if (ExtPitchforkCandle)
        {
         n=(iBarShift(Symbol(),Period(),mPitchTime[0])+iBarShift(Symbol(),Period(),mPitchTime[1]))/2.0;
        }
      else
        {
         n=(iBarShift(Symbol(),Period(),afr[mPitch[0]])+iBarShift(Symbol(),Period(),afr[mPitch[1]]))/2.0;
        }
      k1=MathCeil(n);
      if (n<k1) fo1=true;
      tab2=Time[k1];

      if (ExtPitchforkCandle)
        {
         n=(iBarShift(Symbol(),Period(),mPitchTime[1])+iBarShift(Symbol(),Period(),mPitchTime[2]))/2.0;
        }
      else
        {
         n=(iBarShift(Symbol(),Period(),afr[mPitch[1]])+iBarShift(Symbol(),Period(),afr[mPitch[2]]))/2.0;
        }
      k1=MathCeil(n);
      if (n<k1) fo2=true;
      tbc2=Time[k1];

      if (ExtPitchforkCandle)
        {
         n=iBarShift(Symbol(),Period(),mPitchTime[0])-iBarShift(Symbol(),Period(),mPitchTime[2]);
        }
      else
        {
         n=iBarShift(Symbol(),Period(),afr[mPitch[0]])-iBarShift(Symbol(),Period(),afr[mPitch[2]]);
        }

      nameObj="pmedianaS" + ExtComplekt;
      ObjectDelete(nameObj);

      if (ExtSave)
        {
         if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
           {
            nameObj=nameObj + save;
           }
         else
           {
            if (mPitch[2]>0)
              {
               nameObj=nameObj + save;
              }
           }
        }

      if (ExtPitchforkCandle)
        {
         if (!ExtPitchfork_1_HighLow)
           {
            d=(mPitchCena[2]-mPitchCena[0])/4/n;
            ab1=(mPitchCena[0]+mPitchCena[1])/2;
            if (fo1) {fo1=false; ab1=ab1+d;}
            bc1=(mPitchCena[1]+mPitchCena[2])/2;
            if (fo2) {fo2=false; bc1=bc1+d;}
           }
         else
           {
            d=(mPitchCena[2]-mPitchCena[0])/4/n;
            ab1=(mPitchCena[0]+mPitchCena[1])/2;
            if (fo1) {fo1=false; ab1=ab1+d;}
            bc1=(mPitchCena[1]+mPitchCena[2])/2;
            if (fo2) {fo2=false; bc1=bc1+d;}
           }
        }
      else
        {
         if (afrl[mPitch[0]]>0)
           {
            d=(afrl[mPitch[2]]-afrl[mPitch[0]])/4/n;
            ab1=(afrl[mPitch[0]]+afrh[mPitch[1]])/2;
            if (fo1) {fo1=false; ab1=ab1+d;}
            bc1=(afrh[mPitch[1]]+afrl[mPitch[2]])/2;
            if (fo2) {fo2=false; bc1=bc1+d;}
           }
         else
           {
            d=(afrh[mPitch[2]]-afrh[mPitch[0]])/4/n;
            ab1=(afrh[mPitch[0]]+afrl[mPitch[1]])/2;
            if (fo1) {fo1=false; ab1=ab1+d;}
            bc1=(afrl[mPitch[1]]+afrh[mPitch[2]])/2;
            if (fo2) {fo2=false; bc1=bc1+d;}
           }
        }

      pitch_time[0]=tab2;pitch_cena[0]=ab1;

      if (ExtPitchforkStatic==2)
        {
         ObjectCreate(nameObj,OBJ_TREND,NumWindow,tab2,ab1,tbc2,bc1);
         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DASH);
         ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

         nameObj="1-2pmedianaS" + ExtComplekt;

         if (ExtSave)
           {
            if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
              {
               nameObj=nameObj + save;
              }
            else
              {
               if (mPitch[2]>0)
                 {
                  nameObj=nameObj + save;
                 }
              }
           }
         ObjectDelete(nameObj);
         ObjectCreate(nameObj,OBJ_TEXT,NumWindow,tab2,ab1+3*Point);
         ObjectSetText(nameObj,"     1/2 ML",9,"Arial", ExtLinePitchforkS);
        }   
     }

   nameObj="pitchforkS" + ExtComplekt;
   if (ExtSave)
     {
      if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
        {
         nameObj=nameObj + save;
        }
      else
        {
         if (mPitch[2]>0)
           {
            nameObj=nameObj + save;
           }
        }
     }

   ObjectDelete(nameObj);

   if (ExtPitchforkCandle)
     {
      if (!ExtPitchfork_1_HighLow)
        {
         if (ExtPitchforkStatic!=4)
           {
            pitch_time[0]=mPitchTime[0];pitch_cena[0]=mPitchCena[0];
            if (ExtPitchforkStatic==3) pitch_cena[0]=ab1;
           }
         pitch_time[1]=mPitchTime[1];pitch_cena[1]=mPitchCena[1];
         pitch_time[2]=mPitchTime[2];pitch_cena[2]=mPitchCena[2];
        }
      else
        {
         if (ExtPitchforkStatic!=4)
           {
            pitch_time[0]=mPitchTime[0];pitch_cena[0]=mPitchCena[0];
            if (ExtPitchforkStatic==3) pitch_cena[0]=ab1;
           }
         pitch_time[1]=mPitchTime[1];pitch_cena[1]=mPitchCena[1];
         pitch_time[2]=mPitchTime[2];pitch_cena[2]=mPitchCena[2];
        }
     }
   else
     {
      if (afrl[mPitch[0]]>0)
        {
         if (ExtPitchforkStatic!=4)
           {
            pitch_time[0]=afr[mPitch[0]];pitch_cena[0]=afrl[mPitch[0]];
            if (ExtPitchforkStatic==3) pitch_cena[0]=ab1;
           }
         pitch_time[1]=afr[mPitch[1]];pitch_cena[1]=afrh[mPitch[1]];
         pitch_time[2]=afr[mPitch[2]];pitch_cena[2]=afrl[mPitch[2]];
        }
      else
        {
         if (ExtPitchforkStatic!=4)
           {
            pitch_time[0]=afr[mPitch[0]];pitch_cena[0]=afrh[mPitch[0]];
            if (ExtPitchforkStatic==3) pitch_cena[0]=ab1;
           }
         pitch_time[1]=afr[mPitch[1]];pitch_cena[1]=afrl[mPitch[1]];
         pitch_time[2]=afr[mPitch[2]];pitch_cena[2]=afrh[mPitch[2]];
        }
     }

   ObjectCreate(nameObj,OBJ_PITCHFORK,NumWindow,pitch_time[0],pitch_cena[0],pitch_time[1],pitch_cena[1],pitch_time[2],pitch_cena[2]);
   if (ExtPitchforkStyle<5)
     {
      ObjectSet(nameObj,OBJPROP_STYLE,ExtPitchforkStyle);
     }
   else if(ExtPitchforkStyle<11)
     {
      ObjectSet(nameObj,OBJPROP_WIDTH,ExtPitchforkStyle-5);
     }
   ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   if (ExtFiboFanMedianaStaticColor>0)
     {
      ta1=pitch_time[0];
      a1=pitch_cena[0];
      n1=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),pitch_time[1])+iBarShift(Symbol(),Period(),pitch_time[2]))/2.0;
      d=(pitch_cena[0]-(pitch_cena[1]+pitch_cena[2])/2.0)/n1;
      m1=iBarShift(Symbol(),Period(),pitch_time[0]);
      tb1=Time[0];
      b1=pitch_cena[0]-d*(m1+1);

      nameObj="FanMedianaStatic" + ExtComplekt;
/*
      if (ExtSave)
        {
         if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
           {
            nameObj=nameObj + save;
           }
         else
           {
            if (mPitch[2]>0)
              {
               nameObj=nameObj + save;
              }
           }
        }
*/
      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_FIBOFAN,NumWindow,ta1,a1,tb1,b1);
      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanMedianaStaticColor);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      screenFibo();

     }

   if (ExtUTL)
     {
      nameObj="UTL" + ExtComplekt;
      if (ExtSave)
        {
         if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
           {
            nameObj=nameObj + save;
           }
         else
           {
            if (mPitch[2]>0)
              {
               nameObj=nameObj + save;
              }
           }
        }

      ObjectDelete(nameObj);
      if (pitch_cena[1]>pitch_cena[2])
        {
         ObjectCreate(nameObj,OBJ_TREND,NumWindow,pitch_time[0],pitch_cena[0],pitch_time[1],pitch_cena[1]);
        }
      else
        {
         ObjectCreate(nameObj,OBJ_TREND,NumWindow,pitch_time[0],pitch_cena[0],pitch_time[2],pitch_cena[2]);
        }
      ObjectSet(nameObj,OBJPROP_STYLE,STYLE_SOLID);
      ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
     }

   if (ExtLTL)
     {
      nameObj="LTL" + ExtComplekt;
      if (ExtSave)
        {
         if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
           {
            nameObj=nameObj + save;
           }
         else
           {
            if (mPitch[2]>0)
              {
               nameObj=nameObj + save;
              }
           }
        }

      ObjectDelete(nameObj);
      if (pitch_cena[1]>pitch_cena[2])
        {
         ObjectCreate(nameObj,OBJ_TREND,NumWindow,pitch_time[0],pitch_cena[0],pitch_time[2],pitch_cena[2]);
        }
      else
        {
         ObjectCreate(nameObj,OBJ_TREND,NumWindow,pitch_time[0],pitch_cena[0],pitch_time[1],pitch_cena[1]);
        }
      ObjectSet(nameObj,OBJPROP_STYLE,STYLE_SOLID);
      ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
     }
/*
   if (ExtPivotZoneColor>0)
     {
      ta1=pitch_time[2];
      a1=pitch_cena[2];
      m1=iBarShift(Symbol(),Period(),pitch_time[0])-iBarShift(Symbol(),Period(),pitch_time[1]);
      m2=iBarShift(Symbol(),Period(),pitch_time[1])-iBarShift(Symbol(),Period(),pitch_time[2]);
      n1=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),pitch_time[1])+iBarShift(Symbol(),Period(),pitch_time[2]))/2.0;
      d=(pitch_cena[0]-(pitch_cena[1]+pitch_cena[2])/2.0)/n1;

      if (m1>m2)
        {
         tb1=Time[iBarShift(Symbol(),Period(),pitch_time[2])-m1+1];
         b1=pitch_cena[0]-d*(2*m1+m2);
        }
      else
        {
         tb1=Time[iBarShift(Symbol(),Period(),pitch_time[2])-m2+1];
         b1=pitch_cena[0]-d*(2*m2+m1);
        }

      nameObj="PivotZoneS" + ExtComplekt;
      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_RECTANGLE,0,ta1,a1,tb1,b1);
      ObjectSet(nameObj, OBJPROP_BACK, true);
      ObjectSet(nameObj, OBJPROP_COLOR, ExtPivotZoneColor); 
     }
*/
   if (ExtUWL || ExtLWL)
     {
      n1=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),pitch_time[1])+iBarShift(Symbol(),Period(),pitch_time[2]))/2.0;
      ta1=pitch_time[0];
      tb1=pitch_time[2];
      a1=pitch_cena[0];
      d=(pitch_cena[0]-(pitch_cena[1]+pitch_cena[2])/2.0)/n1;
      n1=(iBarShift(Symbol(),Period(),pitch_time[1])-iBarShift(Symbol(),Period(),pitch_time[2]))/2.0+1;
      b1=(pitch_cena[1]+pitch_cena[2])/2.0-d*n1;
      if (pitch_cena[1]>pitch_cena[2])
        {
         if (ExtUWL)
           {
            ch1=pitch_cena[1];
            tch1=pitch_time[1];
           }
         if (ExtLWL)
           {
            cl1=pitch_cena[2];
            tcl1=pitch_time[2];
           }
        }
      else
        {
         if (ExtUWL)
           {
            ch1=pitch_cena[2];
            tch1=pitch_time[2];
           }
         if (ExtLWL)
           {
            cl1=pitch_cena[1];
            tcl1=pitch_time[1];
           }
        }
      if (fo2) {fo2=false; b1=b1+d;}

      if (ExtUWL)
        {
         nameObj="UWL" + ExtComplekt;
         if (ExtSave)
           {
            if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
              {
               nameObj=nameObj + save;
              }
            else
              {
               if (mPitch[2]>0)
                 {
                  nameObj=nameObj + save;
                 }
              }
           }
  
         ObjectDelete(nameObj);

         ObjectCreate(nameObj,OBJ_FIBOCHANNEL,NumWindow,ta1,a1,tb1,b1,tch1,ch1);
         ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtLinePitchforkS);
         ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
         ObjectSet(nameObj,OBJPROP_COLOR,CLR_NONE);
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,6);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.618);
         ObjectSetFiboDescription(nameObj, 0, "U W L 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
         ObjectSetFiboDescription(nameObj, 1, "U W L 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.618);
         ObjectSetFiboDescription(nameObj, 2, "U W L 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,2.0);
         ObjectSetFiboDescription(nameObj, 3, "U W L 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,2.618);
         ObjectSetFiboDescription(nameObj, 4, "U W L 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,4.0);
         ObjectSetFiboDescription(nameObj, 5, "U W L 400.0"); 
        }

      if (ExtLWL)
        {
         nameObj="LWL" + ExtComplekt;
         if (ExtSave)
           {
            if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
              {
               nameObj=nameObj + save;
              }
            else
              {
               if (mPitch[2]>0)
                 {
                  nameObj=nameObj + save;
                 }
              }
           }

         ObjectDelete(nameObj);

         ObjectCreate(nameObj,OBJ_FIBOCHANNEL,NumWindow,ta1,a1,tb1,b1,tcl1,cl1);
         ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtLinePitchforkS);
         ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);
         ObjectSet(nameObj,OBJPROP_COLOR,CLR_NONE);
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,6);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.618);
         ObjectSetFiboDescription(nameObj, 0, "L W L 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
         ObjectSetFiboDescription(nameObj, 1, "L W L 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.618);
         ObjectSetFiboDescription(nameObj, 2, "L W L 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,2.0);
         ObjectSetFiboDescription(nameObj, 3, "L W L 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,2.618);
         ObjectSetFiboDescription(nameObj, 4, "L W L 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,4.0);
         ObjectSetFiboDescription(nameObj, 5, "L W L 400.0"); 
        }

     }


//      if (ExtPitchforkStaticColor!=CLR_NONE && ExtPitchforkStaticColor!=-16777216)
   if (ExtPitchforkStaticColor>0)
     {
      if (ExtPitchforkCandle)
        {
         n=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),mPitchTime[1])+iBarShift(Symbol(),Period(),mPitchTime[2]))/2.0;
         nbase1=iBarShift(Symbol(),Period(),mPitchTime[1]);
        }
      else
        {
         n=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),afr[mPitch[1]])+iBarShift(Symbol(),Period(),afr[mPitch[2]]))/2.0;
         nbase1=iBarShift(Symbol(),Period(),afr[mPitch[1]]);
        }

      nameObj="1L" + ExtComplekt;  //    1L

      ta1=Time[nbase1+n];

      if (ExtPitchforkCandle)
        {
         tc1=mPitchTime[1];
         TLine_time[0]=mPitchTime[1];
         TLine_time[2]=mPitchTime[2];

         if (!ExtPitchfork_1_HighLow)
           {
            a1=(pitch_cena[0]-(mPitchCena[1]+mPitchCena[2])/2)+mPitchCena[1];
           }
         else
           {
            a1=pitch_cena[0]-(mPitchCena[1]+mPitchCena[2])/2+mPitchCena[1];
           }

         c1=mPitchCena[1];
         ObjectCreate(nameObj,OBJ_TREND,NumWindow,ta1,a1,tc1,c1);
         TLine[0]=mPitchCena[1];
         TLine_time[1]=iTime(NULL, 0, 1);
         TLine[1]=ObjectGetValueByShift(nameObj, 1);
         TLine[2]=mPitchCena[2];
        }
      else
        {
         tc1=afr[mPitch[1]];
         TLine_time[0]=afr[mPitch[1]];
         TLine_time[2]=afr[mPitch[2]];
         if (afrh[mPitch[1]]>0)
           {
            a1=(pitch_cena[0]-(afrh[mPitch[1]]+afrl[mPitch[2]])/2)+afrh[mPitch[1]];
            c1=afrh[mPitch[1]];
            ObjectCreate(nameObj,OBJ_TREND,NumWindow,ta1,a1,tc1,c1);

            TLine[0]=afrh[mPitch[1]];
            TLine_time[1]=iTime(NULL, 0, 1);
            TLine[1]=ObjectGetValueByShift(nameObj, 1);
            TLine[2]=afrl[mPitch[2]];
           }
         else
           {
            a1=pitch_cena[0]-(afrl[mPitch[1]]+afrh[mPitch[2]])/2+afrl[mPitch[1]];
            c1=afrl[mPitch[1]];
            ObjectCreate(nameObj,OBJ_TREND,NumWindow,ta1,a1,tc1,c1);

            TLine[0]=afrl[mPitch[1]];
            TLine_time[1]=iTime(NULL, 0, 1); 
            TLine[1]=ObjectGetValueByShift(nameObj, 1);
            TLine[2]=afrh[mPitch[2]];
           }
        }
      ObjectDelete(nameObj); //     1L

      nameObj="CL" + ExtComplekt;
/*
      if (ExtSave)
        {
         if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
           {
            nameObj=nameObj + save;
           }
         else
           {
            if (mPitch[2]>0)
              {
               nameObj=nameObj + save;
              }
           }
        }
*/
      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_CHANNEL,NumWindow,TLine_time[0],TLine[0],TLine_time[1],TLine[1],TLine_time[2],TLine[2]);
      ObjectSet(nameObj, OBJPROP_BACK, true);
      ObjectSet(nameObj, OBJPROP_COLOR, ExtPitchforkStaticColor); 
     }

   if (ExtRLine)
     {

      if (ExtPitchforkCandle)
        {
         n=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),mPitchTime[1])+iBarShift(Symbol(),Period(),mPitchTime[2]))/2.0;

         nbase1=iBarShift(Symbol(),Period(),mPitchTime[1]);
         nbase2=iBarShift(Symbol(),Period(),mPitchTime[2]);
         tc1=mPitchTime[1];
        }
      else
        {
         n=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),afr[mPitch[1]])+iBarShift(Symbol(),Period(),afr[mPitch[2]]))/2.0;

         nbase1=iBarShift(Symbol(),Period(),afr[mPitch[1]]);
         nbase2=iBarShift(Symbol(),Period(),afr[mPitch[2]]);
         tc1=afr[mPitch[1]];
        }

      ta1=Time[nbase1+n];
      tb1=Time[nbase2+n];

      if (ExtPitchforkCandle)
        {
         c1=mPitchCena[1];
         if (!ExtPitchfork_1_HighLow)
           {
            a1=(pitch_cena[0]-(mPitchCena[1]+mPitchCena[2])/2)+mPitchCena[1];
            b1=(pitch_cena[0]-(mPitchCena[1]+mPitchCena[2])/2)+mPitchCena[2];
           }
         else
           {
            a1=pitch_cena[0]-(mPitchCena[1]+mPitchCena[2])/2+mPitchCena[1];
            b1=pitch_cena[0]-(mPitchCena[1]+mPitchCena[2])/2+mPitchCena[2];
           }
        }
      else
        {
         if (afrh[mPitch[1]]>0)
           {
            c1=afrh[mPitch[1]];
            a1=(pitch_cena[0]-(afrh[mPitch[1]]+afrl[mPitch[2]])/2)+afrh[mPitch[1]];
            b1=(pitch_cena[0]-(afrh[mPitch[1]]+afrl[mPitch[2]])/2)+afrl[mPitch[2]];
           }
         else
           {
            c1=afrl[mPitch[1]];
            a1=pitch_cena[0]-(afrl[mPitch[1]]+afrh[mPitch[2]])/2+afrl[mPitch[1]];
            b1=pitch_cena[0]-(afrl[mPitch[1]]+afrh[mPitch[2]])/2+afrh[mPitch[2]];
           }
        }

      nameObj="RLineS" + ExtComplekt;
      if (ExtSave)
        {
         if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
           {
            nameObj=nameObj + save;
           }
         else
           {
            if (mPitch[2]>0)
              {
               nameObj=nameObj + save;
              }
           }
        }

      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_FIBOCHANNEL,NumWindow,ta1,a1,tb1,b1,tc1,c1);

      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtLinePitchforkS);

      if (ExtRLineBase) 
        {
         ObjectSet(nameObj,OBJPROP_COLOR,CLR_NONE);
        }
      else
        {
         ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkS);
        }

      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
      ObjectSet(nameObj,OBJPROP_RAY,false);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      if (ExtFiboType)
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,15);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.382);
         ObjectSetFiboDescription(nameObj, 0, " RL 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.5);
         ObjectSetFiboDescription(nameObj, 1, " RL 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.618);
         ObjectSetFiboDescription(nameObj, 2, " RL 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.707);
         ObjectSetFiboDescription(nameObj, 3, " RL 70.7"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.786);
         ObjectSetFiboDescription(nameObj, 4, " RL 78.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.886);
         ObjectSetFiboDescription(nameObj, 5, " RL 88.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSetFiboDescription(nameObj, 6, " RL 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.128);
         ObjectSetFiboDescription(nameObj, 7, " RL 112.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.272);
         ObjectSetFiboDescription(nameObj, 8, " RL 127.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.414);
         ObjectSetFiboDescription(nameObj, 9, " RL 141.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,1.618);
         ObjectSetFiboDescription(nameObj, 10, " RL 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.0);
         ObjectSetFiboDescription(nameObj, 11, " RL 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,2.414);
         ObjectSetFiboDescription(nameObj, 12, " RL 241.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,2.618);
         ObjectSetFiboDescription(nameObj, 13, " RL 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,4.0);
         ObjectSetFiboDescription(nameObj, 14, " RL 400.0"); 

        }
      else
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,10);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
         ObjectSetFiboDescription(nameObj, 0, " RL 23.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
         ObjectSetFiboDescription(nameObj, 1, " RL 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
         ObjectSetFiboDescription(nameObj, 2, " RL 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
         ObjectSetFiboDescription(nameObj, 3, " RL 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.764);
         ObjectSetFiboDescription(nameObj, 4, " RL 76.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.0);
         ObjectSetFiboDescription(nameObj, 5, " RL 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.618);
         ObjectSetFiboDescription(nameObj, 6, " RL 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,2.0);
         ObjectSetFiboDescription(nameObj, 7, " RL 200"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
         ObjectSetFiboDescription(nameObj, 8, " RL 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,4.0);
         ObjectSetFiboDescription(nameObj, 9, " RL 400.0"); 
        }
     }

      //   
      if (ExtFiboTime1)
        {
         nameObj="fiboTime1" + ExtComplekt;
         if (ExtSave)
           {
            if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
              {
               nameObj=nameObj + save;
              }
            else
              {
               if (mPitch[2]>0)
                 {
                  nameObj=nameObj + save;
                 }
              }
           }

         ObjectDelete(nameObj);

         if (ExtPitchforkCandle)
           {
            if (!ExtPitchfork_1_HighLow)
              {
               if (mPitchCena[0]>mPitchCena[2])
                 {
                  ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,mPitchTime[0],mPitchCena[2]-5*Point,mPitchTime[2],mPitchCena[2]-5*Point);
                 }
               else
                 {
                  ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,mPitchTime[0],mPitchCena[0]-5*Point,mPitchTime[2],mPitchCena[0]-5*Point);
                 }
              }
            else
              {
               ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,mPitchTime[0],mPitchCena[1]-5*Point,mPitchTime[2],mPitchCena[1]-5*Point);
              }
           }
         else
           {
            if (afrl[mPitch[0]]>0)
              {
               if (afrl[mPitch[0]]>afrl[mPitch[2]])
                 {
                  ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,afr[mPitch[0]],afrl[mPitch[2]]-5*Point,afr[mPitch[2]],afrl[mPitch[2]]-5*Point);
                 }
               else
                 {
                  ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,afr[mPitch[0]],afrl[mPitch[0]]-5*Point,afr[mPitch[2]],afrl[mPitch[0]]-5*Point);
                 }
              }
            else
              {
               ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,afr[mPitch[0]],afrl[mPitch[1]]-5*Point,afr[mPitch[2]],afrl[mPitch[1]]-5*Point);
              }
           }

         ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboTime1C);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

         if (ExtFiboType)
           {
            ObjectSet(nameObj,OBJPROP_FIBOLEVELS,17);

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.0);
            ObjectSetFiboDescription(nameObj, 0, "0"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
            ObjectSetFiboDescription(nameObj, 1, "1"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.382);
            ObjectSetFiboDescription(nameObj, 2, "Ft .382"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.5);
            ObjectSetFiboDescription(nameObj, 3, "Ft .5"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.618);
            ObjectSetFiboDescription(nameObj, 4, "Ft .618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.707);
            ObjectSetFiboDescription(nameObj, 5, "Ft .707"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.786);
            ObjectSetFiboDescription(nameObj, 6, "Ft .786"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.841);
            ObjectSetFiboDescription(nameObj, 7, "Ft .841"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.0);
            ObjectSetFiboDescription(nameObj, 8, "Ft 1."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.272);
            ObjectSetFiboDescription(nameObj, 9, "Ft 1.272"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.414);
            ObjectSetFiboDescription(nameObj, 10, "Ft 1.414"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
            ObjectSetFiboDescription(nameObj, 11, "Ft 1.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,3.0);
            ObjectSetFiboDescription(nameObj, 12, "Ft 2."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,3.414);
            ObjectSetFiboDescription(nameObj, 13, "Ft 2.414"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,3.618);
            ObjectSetFiboDescription(nameObj, 15, "Ft 2.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,4.0);
            ObjectSetFiboDescription(nameObj, 16, "Ft 3."); 

           }
         else
           {
            ObjectSet(nameObj,OBJPROP_FIBOLEVELS,11);

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.0);
            ObjectSetFiboDescription(nameObj, 0, "0"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
            ObjectSetFiboDescription(nameObj, 1, "1"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.236);
            ObjectSetFiboDescription(nameObj, 2, "Ft .236"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.382);
            ObjectSetFiboDescription(nameObj, 3, "Ft .382"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.5);
            ObjectSetFiboDescription(nameObj, 4, "Ft .5"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.618);
            ObjectSetFiboDescription(nameObj, 5, "Ft .618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.764);
            ObjectSetFiboDescription(nameObj, 6, "Ft .764"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,2.0);
            ObjectSetFiboDescription(nameObj, 7, "Ft 1."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
            ObjectSetFiboDescription(nameObj, 8, "Ft 1.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,3.0);
            ObjectSetFiboDescription(nameObj, 9, "Ft 3."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.618);
            ObjectSetFiboDescription(nameObj, 10, "Ft 2.618"); 
           }

        }

      if (ExtFiboTime2)
        {
         nameObj="fiboTime2" + ExtComplekt;
         if (ExtSave)
           {
            if (ExtPitchforkCandle && iBarShift(Symbol(),Period(),ExtDateTimePitchfork_3)>0)
              {
               nameObj=nameObj + save;
              }
            else
              {
               if (mPitch[2]>0)
                 {
                  nameObj=nameObj + save;
                 }
              }
           }

         ObjectDelete(nameObj);

         if (ExtPitchforkCandle)
           {
            if (ExtPitchfork_1_HighLow)
              {
               ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,mPitchTime[1],mPitchCena[1]-8*Point,mPitchTime[2],mPitchCena[1]-8*Point);
              }
            else
              {
               ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,mPitchTime[1],mPitchCena[2]-8*Point,mPitchTime[2],mPitchCena[2]-8*Point);
              }
           }
         else
           {
            if (afrl[mPitch[1]]>0)
              {
               ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,afr[mPitch[1]],afrl[mPitch[1]]-8*Point,afr[mPitch[2]],afrl[mPitch[1]]-8*Point);
              }
            else
              {
               ObjectCreate(nameObj,OBJ_FIBOTIMES,NumWindow,afr[mPitch[1]],afrl[mPitch[2]]-8*Point,afr[mPitch[2]],afrl[mPitch[2]]-8*Point);
              }
           }

         ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
         ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboTime2C);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

         if (ExtFiboType)
           {
            ObjectSet(nameObj,OBJPROP_FIBOLEVELS,17);

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.0);
            ObjectSetFiboDescription(nameObj, 0, "0"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
            ObjectSetFiboDescription(nameObj, 1, "1"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.382);
            ObjectSetFiboDescription(nameObj, 2, "Ft .382"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.5);
            ObjectSetFiboDescription(nameObj, 3, "Ft .5"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.618);
            ObjectSetFiboDescription(nameObj, 4, "Ft .618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.707);
            ObjectSetFiboDescription(nameObj, 5, "Ft .707"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.786);
            ObjectSetFiboDescription(nameObj, 6, "Ft .786"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.841);
            ObjectSetFiboDescription(nameObj, 7, "Ft .841"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.0);
            ObjectSetFiboDescription(nameObj, 8, "Ft 1."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.272);
            ObjectSetFiboDescription(nameObj, 9, "Ft 1.272"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.414);
            ObjectSetFiboDescription(nameObj, 10, "Ft 1.414"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
            ObjectSetFiboDescription(nameObj, 11, "Ft 1.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,3.0);
            ObjectSetFiboDescription(nameObj, 12, "Ft 2."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,3.414);
            ObjectSetFiboDescription(nameObj, 13, "Ft 2.414"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,3.618);
            ObjectSetFiboDescription(nameObj, 15, "Ft 2.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,4.0);
            ObjectSetFiboDescription(nameObj, 16, "Ft 3."); 

           }
         else
           {
            ObjectSet(nameObj,OBJPROP_FIBOLEVELS,11);

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.0);
            ObjectSetFiboDescription(nameObj, 0, "0"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,1.0);
            ObjectSetFiboDescription(nameObj, 1, "1"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.236);
            ObjectSetFiboDescription(nameObj, 2, "Ft .236"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.382);
            ObjectSetFiboDescription(nameObj, 3, "Ft .382"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.5);
            ObjectSetFiboDescription(nameObj, 4, "Ft .5"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.618);
            ObjectSetFiboDescription(nameObj, 5, "Ft .618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.764);
            ObjectSetFiboDescription(nameObj, 6, "Ft .764"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,2.0);
            ObjectSetFiboDescription(nameObj, 7, "Ft 1."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
            ObjectSetFiboDescription(nameObj, 8, "Ft 1.618"); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,3.0);
            ObjectSetFiboDescription(nameObj, 9, "Ft 3."); 

            ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.618);
            ObjectSetFiboDescription(nameObj, 10, "Ft 2.618"); 
           }
        }

  }
//--------------------------------------------------------
//    . .
//--------------------------------------------------------

//--------------------------------------------------------
//    . .
//--------------------------------------------------------
void screenPitchforkD()
  {
   int k1,n,nbase1,nbase2;
   double a1,b1,c1,ab1,bc1,ab2,bc2,d,n1;
   datetime ta1,tb1,tc1,tab2,tbc2;
   bool fo1=false,fo2=false;
   int    pitch_time[]={0,0,0}; 
   double pitch_cena[]={0,0,0};
   int m1,m2;

   if (ExtPitchforkDinamic>0)
     {
      n=(iBarShift(Symbol(),Period(),afr[2])+iBarShift(Symbol(),Period(),afr[1]))/2.0;
      k1=MathCeil(n);
      if (n<k1) fo1=true;
      tab2=Time[k1];

      n=(iBarShift(Symbol(),Period(),afr[1])+iBarShift(Symbol(),Period(),afr[0]))/2.0;
      k1=MathCeil(n);
      if (n<k1) fo2=true;
      tbc2=Time[k1];

      n=iBarShift(Symbol(),Period(),afr[2])-iBarShift(Symbol(),Period(),afr[0]);

//            nameObj="pm" + Period() + "_" + afr[3];
      nameObj="pmedianaD" + ExtComplekt;
      ObjectDelete(nameObj);

      if (afrl[2]>0)
        {
         d=(afrl[0]-afrl[2])/4/n;
         ab1=(afrl[2]+afrh[1])/2;
         if (fo1) {fo1=false; ab1=ab1+d;}
         bc1=(afrh[1]+afrl[0])/2;
         if (fo2) {fo2=false; bc1=bc1+d;}
        }
      else
        {
         d=(afrh[0]-afrh[2])/4/n;
         ab1=(afrh[2]+afrl[1])/2;
         if (fo1) {fo1=false; ab1=ab1+d;}
         bc1=(afrl[1]+afrh[0])/2;
         if (fo2) {fo2=false; bc1=bc1+d;}
        }

      pitch_time[0]=tab2;pitch_cena[0]=ab1;

      if (ExtPitchforkDinamic==2)
        {
         ObjectCreate(nameObj,OBJ_TREND,NumWindow,tab2,ab1,tbc2,bc1);
         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DASH);
         ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkD);
         ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

         nameObj="1-2pmedianaD" + ExtComplekt;
         ObjectDelete(nameObj);
         ObjectCreate(nameObj,OBJ_TEXT,NumWindow,tab2,ab1+3*Point);
         ObjectSetText(nameObj,"     1/2 ML",9,"Arial", ExtLinePitchforkD);
        }
     }

//         nameObj="pf" + Period() + "_" + afr[2];
   nameObj="pitchforkD" + ExtComplekt;
   ObjectDelete(nameObj);

   if (afrl[2]>0)
     {
      if (ExtPitchforkDinamic!=4)
        {
         pitch_time[0]=afr[2];pitch_cena[0]=afrl[2];
         if (ExtPitchforkDinamic==3) pitch_cena[0]=ab1;
        }
      pitch_time[1]=afr[1];pitch_cena[1]=afrh[1];
      pitch_time[2]=afr[0];pitch_cena[2]=afrl[0];
     }
   else
     {
      if (ExtPitchforkDinamic!=4)
        {
         pitch_time[0]=afr[2];pitch_cena[0]=afrh[2];
         if (ExtPitchforkDinamic==3) pitch_cena[0]=ab1;
        }
      pitch_time[1]=afr[1];pitch_cena[1]=afrl[1];
      pitch_time[2]=afr[0];pitch_cena[2]=afrh[0];
     }

   ObjectCreate(nameObj,OBJ_PITCHFORK,NumWindow,pitch_time[0],pitch_cena[0],pitch_time[1],pitch_cena[1],pitch_time[2],pitch_cena[2]);
   if (ExtPitchforkStyle<5)
     {
      ObjectSet(nameObj,OBJPROP_STYLE,ExtPitchforkStyle);
     }
   else if(ExtPitchforkStyle<11)
     {
      ObjectSet(nameObj,OBJPROP_WIDTH,ExtPitchforkStyle-5);
     }
   ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkD);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   if (ExtFiboFanMedianaDinamicColor>0)
     {
      ta1=pitch_time[0];
      a1=pitch_cena[0];
      n1=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),pitch_time[1])+iBarShift(Symbol(),Period(),pitch_time[2]))/2.0;
      d=(pitch_cena[0]-(pitch_cena[1]+pitch_cena[2])/2.0)/n1;
      m1=iBarShift(Symbol(),Period(),pitch_time[0]);
      tb1=Time[0];
      b1=pitch_cena[0]-d*(m1+1);

      nameObj="FanMedianaDinamic" + ExtComplekt;
      ObjectDelete(nameObj);

      ObjectCreate(nameObj,OBJ_FIBOFAN,NumWindow,ta1,a1,tb1,b1);
      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanMedianaDinamicColor);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      screenFibo();
     }

   if (ExtRLine)
     {
      nameObj="RLineD" + ExtComplekt;
      ObjectDelete(nameObj);

      n=iBarShift(Symbol(),Period(),pitch_time[0])-(iBarShift(Symbol(),Period(),afr[1])+iBarShift(Symbol(),Period(),afr[0]))/2.0;
   
      nbase1=iBarShift(Symbol(),Period(),afr[1]);
      nbase2=iBarShift(Symbol(),Period(),afr[0]);
      tc1=afr[1];
      ta1=Time[nbase1+n];
      tb1=Time[nbase2+n];

      if (afrh[1]>0)
        {
            //     
//            d=(afrl[2]-(afrh[1]+afrl[0])/2)/n;

         c1=afrh[1];
         a1=(pitch_cena[0]-(afrh[1]+afrl[0])/2)+afrh[1];
         b1=(pitch_cena[0]-(afrh[1]+afrl[0])/2)+afrl[0];
        }
      else
        {
            //     
//            d=(afrh[2]-(afrl[1]+afrh[0])/2)/n;

         c1=afrl[1];
         a1=pitch_cena[0]-(afrl[1]+afrh[0])/2+afrl[1];
         b1=pitch_cena[0]-(afrl[1]+afrh[0])/2+afrh[0];
        }

      ObjectCreate(nameObj,OBJ_FIBOCHANNEL,NumWindow,ta1,a1,tb1,b1,tc1,c1);

      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtLinePitchforkD);

      if (ExtRLineBase) 
        {
         ObjectSet(nameObj,OBJPROP_COLOR,CLR_NONE);
        }
      else
        {
         ObjectSet(nameObj,OBJPROP_COLOR,ExtLinePitchforkD);
        }
 
      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
      ObjectSet(nameObj,OBJPROP_RAY,false);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      if (ExtFiboType)
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,15);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.382);
         ObjectSetFiboDescription(nameObj, 0, " RL 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.5);
         ObjectSetFiboDescription(nameObj, 1, " RL 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.618);
         ObjectSetFiboDescription(nameObj, 2, " RL 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.707);
         ObjectSetFiboDescription(nameObj, 3, " RL 70.7"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.786);
         ObjectSetFiboDescription(nameObj, 4, " RL 78.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.841);
         ObjectSetFiboDescription(nameObj, 5, " RL 84.1"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSetFiboDescription(nameObj, 6, " RL 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.128);
         ObjectSetFiboDescription(nameObj, 7, " RL 112.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.272);
         ObjectSetFiboDescription(nameObj, 8, " RL 127.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.414);
         ObjectSetFiboDescription(nameObj, 9, " RL 141.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,1.618);
         ObjectSetFiboDescription(nameObj, 10, " RL 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.0);
         ObjectSetFiboDescription(nameObj, 11, " RL 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,2.414);
         ObjectSetFiboDescription(nameObj, 12, " RL 241.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,2.618);
         ObjectSetFiboDescription(nameObj, 13, " RL 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,4.0);
         ObjectSetFiboDescription(nameObj, 14, " RL 400.0"); 

        }
      else
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,10);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
         ObjectSetFiboDescription(nameObj, 0, " RL 23.6"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
         ObjectSetFiboDescription(nameObj, 1, " RL 38.2"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
         ObjectSetFiboDescription(nameObj, 2, " RL 50.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
         ObjectSetFiboDescription(nameObj, 3, " RL 61.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.764);
         ObjectSetFiboDescription(nameObj, 4, " RL 76.4"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.0);
         ObjectSetFiboDescription(nameObj, 5, " RL 100.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.618);
         ObjectSetFiboDescription(nameObj, 6, " RL 161.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,2.0);
         ObjectSetFiboDescription(nameObj, 7, " RL 200.0"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
         ObjectSetFiboDescription(nameObj, 8, " RL 261.8"); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,4.0);
         ObjectSetFiboDescription(nameObj, 9, " RL 400.0"); 
        }
     }
  }
//--------------------------------------------------------
//    . .
//--------------------------------------------------------

//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void screenFiboFan()
  {
   double a1,b1;  

   if (afrl[mFan[0]]>0)
     {
      a1=afrl[mFan[0]]; b1=afrh[mFan[1]];
     }
   else
     {
      a1=afrh[mFan[0]]; b1=afrl[mFan[1]];
     }
  
   nameObj="FiboFan" + ExtComplekt;

   if (mFan[1]>0)
     {
      if (ExtSave)
        {
         nameObj=nameObj + save;
        }
     }

   ObjectDelete(nameObj);

   ObjectCreate(nameObj,OBJ_FIBOFAN,NumWindow,afr[mFan[0]],a1,afr[mFan[1]],b1);
   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanColor);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   screenFibo();
  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------


//--------------------------------------------------------
//  . .
//--------------------------------------------------------
void screenFibo()
  {
      if (!ExtFiboType)
        {
//         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,18);
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,9);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.764);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.854);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.618);
//         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.618);
/*
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,-0.236);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,-0.382);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,-0.5);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,-0.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,-0.764);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,-1.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,-1.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,-2.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+17,-2.618);
*/
//         if (ExtFiboFanHidden)
//           {
            ObjectSetFiboDescription(nameObj, 0, "23.6"); 
            ObjectSetFiboDescription(nameObj, 1, "38.2"); 
            ObjectSetFiboDescription(nameObj, 2, "50.0"); 
            ObjectSetFiboDescription(nameObj, 3, "61.8"); 
            ObjectSetFiboDescription(nameObj, 4, "76.4"); 
            ObjectSetFiboDescription(nameObj, 5, "85.4"); 
            ObjectSetFiboDescription(nameObj, 6, "100.0"); 
            ObjectSetFiboDescription(nameObj, 7, "161.8"); 
//            ObjectSetFiboDescription(nameObj, 8, "200.0"); 
            ObjectSetFiboDescription(nameObj, 8, "261.8"); 
/*
            ObjectSetFiboDescription(nameObj, 9, "-23.6"); 
            ObjectSetFiboDescription(nameObj, 10, "-38.2"); 
            ObjectSetFiboDescription(nameObj, 11, "-50.0"); 
            ObjectSetFiboDescription(nameObj, 12, "-61.8"); 
            ObjectSetFiboDescription(nameObj, 13, "-76.4"); 
            ObjectSetFiboDescription(nameObj, 14, "-100.0"); 
            ObjectSetFiboDescription(nameObj, 15, "-161.8"); 
            ObjectSetFiboDescription(nameObj, 16, "-200.0"); 
            ObjectSetFiboDescription(nameObj, 17, "-261.8"); 
*/
//           }
        }
      else
        {
//         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,24);
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,12);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.382);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.5);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.707);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.786);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.886);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.272);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.414);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
/*
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,-0.382);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,-0.5);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,-0.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,-0.707);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,-0.786);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+17,-0.886);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+18,-1.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+19,-1.272);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+20,-1.414);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+21,-1.618);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+22,-2.0);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+23,-2.618);
*/
//         if (ExtFiboFanHidden)
//           {
            ObjectSetFiboDescription(nameObj, 0, "38.2"); 
            ObjectSetFiboDescription(nameObj, 1, "50.0"); 
            ObjectSetFiboDescription(nameObj, 2, "61.8"); 
            ObjectSetFiboDescription(nameObj, 3, "70.7"); 
            ObjectSetFiboDescription(nameObj, 4, "78.6"); 
            ObjectSetFiboDescription(nameObj, 5, "88.6"); 
            ObjectSetFiboDescription(nameObj, 6, "100.0"); 
            ObjectSetFiboDescription(nameObj, 7, "127.2"); 
            ObjectSetFiboDescription(nameObj, 8, "141.4"); 
            ObjectSetFiboDescription(nameObj, 9, "161.8"); 
            ObjectSetFiboDescription(nameObj, 10, "200.0"); 
            ObjectSetFiboDescription(nameObj, 11, "261.8"); 
/*
            ObjectSetFiboDescription(nameObj, 12, "-38.2"); 
            ObjectSetFiboDescription(nameObj, 13, "-50.0"); 
            ObjectSetFiboDescription(nameObj, 14, "-61.8"); 
            ObjectSetFiboDescription(nameObj, 15, "-70.7"); 
            ObjectSetFiboDescription(nameObj, 16, "-78.6"); 
            ObjectSetFiboDescription(nameObj, 17, "-88.6"); 
            ObjectSetFiboDescription(nameObj, 18, "-100.0"); 
            ObjectSetFiboDescription(nameObj, 19, "-127.2"); 
            ObjectSetFiboDescription(nameObj, 20, "-141.4"); 
            ObjectSetFiboDescription(nameObj, 21, "-161.8"); 
            ObjectSetFiboDescription(nameObj, 22, "-200.0"); 
            ObjectSetFiboDescription(nameObj, 23, "-261.8"); 
*/
//           }
        }
  }
//--------------------------------------------------------
//  . .
//--------------------------------------------------------


//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void screenFiboS()
  {
   double fibo_0, fibo_100, fiboPrice, fiboPrice1;

   nameObj="fiboS" + ExtComplekt;

   if (mFibo[1]>0)
     {
      if (ExtSave)
        {
         nameObj=nameObj + save;
        }
     }

   ObjectDelete(nameObj);
   if (afrl[mFibo[1]]>0) 
     {
      if (!ExtFiboCorrectionExpansion)
        {
         fibo_0=afrh[mFibo[0]];fibo_100=afrl[mFibo[1]];
         fiboPrice=afrh[mFibo[0]]-afrl[mFibo[1]];fiboPrice1=afrl[mFibo[1]];
        }
      else
        {
         fibo_100=afrh[mFibo[0]];fibo_0=afrl[mFibo[1]];
         fiboPrice=afrl[mFibo[1]]-afrh[mFibo[0]];fiboPrice1=afrh[mFibo[0]];
        }
     }
   else 
     {
      if (!ExtFiboCorrectionExpansion)
        {
         fibo_0=afrl[mFibo[0]];fibo_100=afrh[mFibo[1]];
         fiboPrice=afrl[mFibo[0]]-afrh[mFibo[1]];fiboPrice1=afrh[mFibo[1]];
        }
      else
        {
         fibo_100=afrl[mFibo[0]];fibo_0=afrh[mFibo[1]];
         fiboPrice=afrh[mFibo[1]]-afrl[mFibo[0]];fiboPrice1=afrl[mFibo[0]];
        }
     }

   if (!ExtFiboCorrectionExpansion)
     {
      ObjectCreate(nameObj,OBJ_FIBO,NumWindow,afr[mFibo[0]],fibo_0,afr[mFibo[1]],fibo_100);
     }
   else
     {
      ObjectCreate(nameObj,OBJ_FIBO,NumWindow,afr[mFibo[1]],fibo_0,afr[mFibo[0]],fibo_100);
     }
   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboS);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   if (ExtFiboType)
     {
      ObjectSet(nameObj,OBJPROP_FIBOLEVELS,17);
      fibo_patterns(fiboPrice, fiboPrice1,"                    ");
     }
   else
     {
      ObjectSet(nameObj,OBJPROP_FIBOLEVELS,14);
      fibo_standart (fiboPrice, fiboPrice1,"                    ");
     }
  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------

//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void screenFiboD()
  {
   double fibo_0, fibo_100, fiboPrice, fiboPrice1;

   nameObj="fiboD" + ExtComplekt;

   ObjectDelete(nameObj);
   if (afrh[1]>0)
     {
      if (!ExtFiboCorrectionExpansion)
        {
         fibo_0=afrh[1];fibo_100=afrl[0];
         fiboPrice=afrh[1]-afrl[0];fiboPrice1=afrl[0];
        }
      else
        {
         fibo_100=afrh[1];fibo_0=afrl[0];
         fiboPrice=afrl[0]-afrh[1];fiboPrice1=afrh[1];
        }
     }
   else
     {
      if (!ExtFiboCorrectionExpansion)
        {
         fibo_0=afrl[1];fibo_100=afrh[0];
         fiboPrice=afrl[1]-afrh[0];fiboPrice1=afrh[0];
        }
      else
        {
         fibo_100=afrl[1];fibo_0=afrh[0];
         fiboPrice=afrh[0]-afrl[1];fiboPrice1=afrl[1];
        }
     }

   if (!ExtFiboCorrectionExpansion)
     {
      ObjectCreate(nameObj,OBJ_FIBO,NumWindow,afr[1],fibo_0,afr[0],fibo_100);
     }
   else
     {
      ObjectCreate(nameObj,OBJ_FIBO,NumWindow,afr[0],fibo_0,afr[1],fibo_100);
     }

   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboD);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   if (ExtFiboType)
     {
      ObjectSet(nameObj,OBJPROP_FIBOLEVELS,17);
      fibo_patterns(fiboPrice, fiboPrice1,"");
     }
   else
     {
      ObjectSet(nameObj,OBJPROP_FIBOLEVELS,14);
      fibo_standart (fiboPrice, fiboPrice1,"");
     }

  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------


//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void fibo_patterns(double fiboPrice,double fiboPrice1,string fibo)
  {
   if (!ExtFiboCorrectionExpansion)
     {   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,0);
      ObjectSetFiboDescription(nameObj, 0, "0  "+DoubleToStr(fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
      ObjectSetFiboDescription(nameObj, 1, "38.2  "+DoubleToStr(fiboPrice*0.382+fiboPrice1, Digits)+fibo); 
    
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
      ObjectSetFiboDescription(nameObj, 2, "50.0  "+DoubleToStr(fiboPrice*0.5+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
      ObjectSetFiboDescription(nameObj, 3, "61.8  "+DoubleToStr(fiboPrice*0.618+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.707);
      ObjectSetFiboDescription(nameObj, 4, "70.7  "+DoubleToStr(fiboPrice*0.707+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.786);
      ObjectSetFiboDescription(nameObj, 5, "78.6  "+DoubleToStr(fiboPrice*0.786+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,0.841);
      ObjectSetFiboDescription(nameObj, 6, "84.1  "+DoubleToStr(fiboPrice*0.841+fiboPrice1, Digits)+fibo); 
 
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,0.886);
      ObjectSetFiboDescription(nameObj, 7, "88.6  "+DoubleToStr(fiboPrice*0.886+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.0);
      ObjectSetFiboDescription(nameObj, 8, "100.0  "+DoubleToStr(fiboPrice+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.128);
      ObjectSetFiboDescription(nameObj, 9, "112.8  "+DoubleToStr(fiboPrice*1.128+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,1.272);
      ObjectSetFiboDescription(nameObj, 10, "127.2  "+DoubleToStr(fiboPrice*1.272+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,1.414);
      ObjectSetFiboDescription(nameObj, 11, "141.4  "+DoubleToStr(fiboPrice*1.414+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,1.618);
      ObjectSetFiboDescription(nameObj, 12, "161.8  "+DoubleToStr(fiboPrice*1.618+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,2.0);
      ObjectSetFiboDescription(nameObj, 13, "200.0  "+DoubleToStr(fiboPrice*2.0+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,2.414);
      ObjectSetFiboDescription(nameObj, 14, "241.4  "+DoubleToStr(fiboPrice*2.414+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,2.618);
      ObjectSetFiboDescription(nameObj, 15, "261.8  "+DoubleToStr(fiboPrice*2.618+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,4.0);
      ObjectSetFiboDescription(nameObj, 16, "400.0  "+DoubleToStr(fiboPrice*4.0+fiboPrice1, Digits)+fibo);
     }
   else
     {
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,0);
      ObjectSetFiboDescription(nameObj, 0, "Fe 1  "+DoubleToStr(fiboPrice+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,1);
      ObjectSetFiboDescription(nameObj, 1, "Fe 0  "+DoubleToStr(fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.382);
      ObjectSetFiboDescription(nameObj, 2, "Fe 38.2  "+DoubleToStr(fiboPrice*1.382+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.5);
      ObjectSetFiboDescription(nameObj, 3, "Fe 50.0  "+DoubleToStr(fiboPrice*1.5+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.618);
      ObjectSetFiboDescription(nameObj, 4, "Fe 61.8  "+DoubleToStr(fiboPrice*1.618+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.707);
      ObjectSetFiboDescription(nameObj, 5, "Fe 70.7  "+DoubleToStr(fiboPrice*1.707+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.786);
      ObjectSetFiboDescription(nameObj, 6, "Fe 78.6  "+DoubleToStr(fiboPrice*1.786+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.841);
      ObjectSetFiboDescription(nameObj, 7, "Fe 84.1  "+DoubleToStr(fiboPrice*1.841+fiboPrice1, Digits)+fibo); 
 
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.886);
      ObjectSetFiboDescription(nameObj, 8, "Fe 88.6  "+DoubleToStr(fiboPrice*1.886+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.0);
      ObjectSetFiboDescription(nameObj, 9, "Fe 100.0  "+DoubleToStr(fiboPrice*2+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.128);
      ObjectSetFiboDescription(nameObj, 10, "Fe 112.8  "+DoubleToStr(fiboPrice*2.128+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.272);
      ObjectSetFiboDescription(nameObj, 11, "Fe 127.2  "+DoubleToStr(fiboPrice*2.272+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,2.414);
      ObjectSetFiboDescription(nameObj, 12, "Fe 141.4  "+DoubleToStr(fiboPrice*2.414+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,2.618);
      ObjectSetFiboDescription(nameObj, 13, "Fe 161.8  "+DoubleToStr(fiboPrice*2.618+fiboPrice1, Digits)+fibo); 
     
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+14,3.0);
      ObjectSetFiboDescription(nameObj, 14, "Fe 200.0  "+DoubleToStr(fiboPrice*3.0+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+15,3.414);
      ObjectSetFiboDescription(nameObj, 15, "Fe 241.4  "+DoubleToStr(fiboPrice*3.414+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+16,3.618);
      ObjectSetFiboDescription(nameObj, 16, "Fe 261.8  "+DoubleToStr(fiboPrice*3.618+fiboPrice1, Digits)+fibo); 
     }
  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------


//--------------------------------------------------------
//  . .
//--------------------------------------------------------
void fibo_standart(double fiboPrice,double fiboPrice1,string fibo)
  {
   if (!ExtFiboCorrectionExpansion)
     {   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,0);
      ObjectSetFiboDescription(nameObj, 0, "0  "+DoubleToStr(fiboPrice1, Digits)+fibo); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.146);
      ObjectSetFiboDescription(nameObj, 1, "14.6  "+DoubleToStr(fiboPrice*0.146+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.236);
      ObjectSetFiboDescription(nameObj, 2, "23.6  "+DoubleToStr(fiboPrice*0.236+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.382);
      ObjectSetFiboDescription(nameObj, 3, "38.2  "+DoubleToStr(fiboPrice*0.382+fiboPrice1, Digits)+fibo); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.5);
      ObjectSetFiboDescription(nameObj, 4, "50.0  "+DoubleToStr(fiboPrice*0.5+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.618);
      ObjectSetFiboDescription(nameObj, 5, "61.8  "+DoubleToStr(fiboPrice*0.618+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,0.764);
      ObjectSetFiboDescription(nameObj, 6, "76.4  "+DoubleToStr(fiboPrice*0.764+fiboPrice1, Digits)+fibo); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,0.854);
      ObjectSetFiboDescription(nameObj, 7, "85.4  "+DoubleToStr(fiboPrice*0.854+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.0);
      ObjectSetFiboDescription(nameObj, 8, "100.0  "+DoubleToStr(fiboPrice+fiboPrice1, Digits)+fibo); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.236);
      ObjectSetFiboDescription(nameObj, 9, "1.236  "+DoubleToStr(fiboPrice*1.236+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,1.618);
      ObjectSetFiboDescription(nameObj, 10, "161.8  "+DoubleToStr(fiboPrice*1.618+fiboPrice1, Digits)+fibo); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
      ObjectSetFiboDescription(nameObj, 11, "261.8  "+DoubleToStr(fiboPrice*2.618+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,4.236);
      ObjectSetFiboDescription(nameObj, 12, "423.6  "+DoubleToStr(fiboPrice*4.236+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,6.854);
      ObjectSetFiboDescription(nameObj, 13, "685.4  "+DoubleToStr(fiboPrice*6.854+fiboPrice1, Digits)+fibo); 
     }
   else
     {
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,0);
      ObjectSetFiboDescription(nameObj, 0, "Fe 1  "+DoubleToStr(fiboPrice+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL,1);
      ObjectSetFiboDescription(nameObj, 1, "Fe 0  "+DoubleToStr(fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,1.236);
      ObjectSetFiboDescription(nameObj, 2, "Fe 23.6  "+DoubleToStr(fiboPrice*1.236+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,1.382);
      ObjectSetFiboDescription(nameObj, 3, "Fe 38.2  "+DoubleToStr(fiboPrice*1.382+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,1.5);
      ObjectSetFiboDescription(nameObj, 4, "Fe 50.0  "+DoubleToStr(fiboPrice*1.5+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,1.618);
      ObjectSetFiboDescription(nameObj, 5, "Fe 61.8  "+DoubleToStr(fiboPrice*1.618+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.764);
      ObjectSetFiboDescription(nameObj, 6, "Fe 76.4  "+DoubleToStr(fiboPrice*1.764+fiboPrice1, Digits)+fibo); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.854);
      ObjectSetFiboDescription(nameObj, 7, "Fe 85.4  "+DoubleToStr(fiboPrice*1.854+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,2.0);
      ObjectSetFiboDescription(nameObj, 8, "Fe 100.0  "+DoubleToStr(fiboPrice*2+fiboPrice1, Digits)+fibo); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.236);
      ObjectSetFiboDescription(nameObj, 9, "Fe 1.236  "+DoubleToStr(fiboPrice*2.236+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.618);
      ObjectSetFiboDescription(nameObj, 10, "Fe 161.8  "+DoubleToStr(fiboPrice*2.618+fiboPrice1, Digits)+fibo); 
   
      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,3.618);
      ObjectSetFiboDescription(nameObj, 11, "Fe 261.8>  "+DoubleToStr(fiboPrice*3.618+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+12,5.236);
      ObjectSetFiboDescription(nameObj, 12, "Fe 423.6  "+DoubleToStr(fiboPrice*5.236+fiboPrice1, Digits)+fibo); 

      ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+13,7.854);
      ObjectSetFiboDescription(nameObj, 13, "Fe 685.4  "+DoubleToStr(fiboPrice*7.854+fiboPrice1, Digits)+fibo); 
     }
  }
//--------------------------------------------------------
//  . .
//--------------------------------------------------------

//--------------------------------------------------------
//  - . .
//--------------------------------------------------------
void screenFiboFanS()
  {
   double fiboPrice1, fiboPrice2;

   nameObj="fiboFanS" + ExtComplekt;
   ObjectDelete(nameObj);

   if (ExtPitchforkCandle)
     {
      if (ExtPitchfork_1_HighLow)
        {
         fiboPrice1=mPitchCena[1];fiboPrice2=mPitchCena[2];
        }
      else 
        {
         fiboPrice1=mPitchCena[1];fiboPrice2=mPitchCena[2];
        }
      ObjectCreate(nameObj,OBJ_FIBOFAN,NumWindow,mPitchTime[1],fiboPrice1,mPitchTime[2],fiboPrice2);
     }
   else
     {
      if (afrl[mPitch[1]]>0) 
        {
         fiboPrice1=afrl[mPitch[1]];fiboPrice2=afrh[mPitch[2]];
        }
      else 
        {
         fiboPrice1=afrh[mPitch[1]];fiboPrice2=afrl[mPitch[2]];
        }
      ObjectCreate(nameObj,OBJ_FIBOFAN,NumWindow,afr[mPitch[1]],fiboPrice1,afr[mPitch[2]],fiboPrice2);
     }

   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanS);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   FiboFanLevel();

  }
//--------------------------------------------------------
//  - . .
//--------------------------------------------------------


//--------------------------------------------------------
//  - . .
//--------------------------------------------------------
void screenFiboFanD()
  {
   double fiboPrice1, fiboPrice2;

   nameObj="fiboFanD" + ExtComplekt;

   ObjectDelete(nameObj);

   if (afrl[1]>0) 
     {
      fiboPrice1=afrl[1];fiboPrice2=afrh[0];
     }
   else 
     {
      fiboPrice1=afrh[1];fiboPrice2=afrl[0];
     }
   ObjectCreate(nameObj,OBJ_FIBOFAN,NumWindow,afr[1],fiboPrice1,afr[0],fiboPrice2);
   ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DASH);
   ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboFanD);
   ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

   FiboFanLevel();
  }
//--------------------------------------------------------
//  - . .
//--------------------------------------------------------

//--------------------------------------------------------
//  -. .
//--------------------------------------------------------
void FiboFanLevel()
  {
   if(ExtFiboFanExp) ObjectSet(nameObj,OBJPROP_FIBOLEVELS,6); else ObjectSet(nameObj,OBJPROP_FIBOLEVELS,4);

   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
   ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);

   if (ExtFiboFanHidden)
     {
      ObjectSetFiboDescription(nameObj, 0, "23.6"); 
      ObjectSetFiboDescription(nameObj, 1, "38.2"); 
      ObjectSetFiboDescription(nameObj, 2, "50.0"); 
      ObjectSetFiboDescription(nameObj, 3, "61.8"); 
     }
   if(ExtFiboFanExp)
     {
      if (!ExtFiboType)
        {
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.764);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.854);

         if (ExtFiboFanHidden)
           {
            ObjectSetFiboDescription(nameObj, 4, "76.4"); 
            ObjectSetFiboDescription(nameObj, 5, "85.4"); 
           }
        }
      else
        {
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.786);
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.886);

         if (ExtFiboFanHidden)
           {
            ObjectSetFiboDescription(nameObj, 4, "78.6"); 
            ObjectSetFiboDescription(nameObj, 5, "88.6"); 
           }
        }
     }
  }
//--------------------------------------------------------
//   -. .
//--------------------------------------------------------


//--------------------------------------------------------
//   . .
//--------------------------------------------------------
void FiboExpansion()
  {
   if (ExtFiboExpansion>1)
     {
      double znach1,znach2;
      nameObj="fiboExpansion" + ExtComplekt;
      if (mExpansion[2]>0)
        {
         if (ExtSave)
           {
            nameObj=nameObj + save;
           }
        }

      ObjectDelete(nameObj);
      if (afrl[mExpansion[0]]>0)
        {
         ObjectCreate(nameObj,OBJ_EXPANSION,NumWindow,afr[mExpansion[0]],afrl[mExpansion[0]],afr[mExpansion[1]],afrh[mExpansion[1]],afr[mExpansion[2]],afrl[mExpansion[2]]);
         znach1=afrh[mExpansion[1]]-afrl[mExpansion[0]];
         znach2=afrl[mExpansion[2]];
        }
      else
        {
         ObjectCreate(nameObj,OBJ_EXPANSION,NumWindow,afr[mExpansion[0]],afrh[mExpansion[0]],afr[mExpansion[1]],afrl[mExpansion[1]],afr[mExpansion[2]],afrh[mExpansion[2]]);
         znach1=-(afrh[mExpansion[0]]-afrl[mExpansion[1]]);
         znach2=afrh[mExpansion[2]];
        }

      ObjectSet(nameObj,OBJPROP_LEVELSTYLE,STYLE_DOT);
      ObjectSet(nameObj,OBJPROP_LEVELCOLOR,ExtFiboExpansionColor);
      ObjectSet(nameObj,OBJPROP_BACK,ExtBack);

      if (!ExtFiboType)
        {   
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,11);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.236);
         ObjectSetFiboDescription(nameObj, 0, "FE 23.6  "+DoubleToStr(znach1*0.236+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.382);
         ObjectSetFiboDescription(nameObj, 1, "FE 38.2  "+DoubleToStr(znach1*0.382+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.5);
         ObjectSetFiboDescription(nameObj, 2, "FE 50.0  "+DoubleToStr(znach1*0.5+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.618);
         ObjectSetFiboDescription(nameObj, 3, "FE 61.8  "+DoubleToStr(znach1*0.618+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.764);
         ObjectSetFiboDescription(nameObj, 4, "FE 76.4  "+DoubleToStr(znach1*0.764+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.854);
         ObjectSetFiboDescription(nameObj, 5, "FE 85.4  "+DoubleToStr(znach1*0.854+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSetFiboDescription(nameObj, 6, "FE 100.0  "+DoubleToStr(znach1+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.236);
         ObjectSetFiboDescription(nameObj, 7, "FE 1.236  "+DoubleToStr(znach1*1.236+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.618);
         ObjectSetFiboDescription(nameObj, 8, "FE 161.8  "+DoubleToStr(znach1*1.618+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,2.0);
         ObjectSetFiboDescription(nameObj, 9, "FE 200.0  "+DoubleToStr(znach1*2+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.618);
         ObjectSetFiboDescription(nameObj, 10, "FE 261.8  "+DoubleToStr(znach1*2.618+znach2, Digits)); 
        }
      else
        {
         ObjectSet(nameObj,OBJPROP_FIBOLEVELS,12);

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+0,0.382);
         ObjectSetFiboDescription(nameObj, 0, "FE 38.2  "+DoubleToStr(znach1*0.382+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+1,0.5);
         ObjectSetFiboDescription(nameObj, 1, "FE 50.0  "+DoubleToStr(znach1*0.5+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+2,0.618);
         ObjectSetFiboDescription(nameObj, 2, "FE 61.8  "+DoubleToStr(znach1*0.618+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+3,0.707);
         ObjectSetFiboDescription(nameObj, 3, "FE 70.7  "+DoubleToStr(znach1*0.707+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+4,0.786);
         ObjectSetFiboDescription(nameObj, 4, "FE 78.6  "+DoubleToStr(znach1*0.786+znach2, Digits)); 
 
         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+5,0.886);
         ObjectSetFiboDescription(nameObj, 5, "FE 88.6  "+DoubleToStr(znach1*0.886+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+6,1.0);
         ObjectSetFiboDescription(nameObj, 6, "FE 100.0  "+DoubleToStr(znach1+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+7,1.272);
         ObjectSetFiboDescription(nameObj, 7, "FE 127.2  "+DoubleToStr(znach1*1.272+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+8,1.414);
         ObjectSetFiboDescription(nameObj, 8, "FE 141.4  "+DoubleToStr(znach1*1.414+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+9,1.618);
         ObjectSetFiboDescription(nameObj, 9, "FE 161.8  "+DoubleToStr(znach1*1.618+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+10,2.0);
         ObjectSetFiboDescription(nameObj, 10, "FE 200.0  "+DoubleToStr(znach1*2+znach2, Digits)); 

         ObjectSet(nameObj,OBJPROP_FIRSTLEVEL+11,2.618);
         ObjectSetFiboDescription(nameObj, 11, "FE 261.8  "+DoubleToStr(znach1*2.618+znach2, Digits)); 
        }
     }
  }
//--------------------------------------------------------
//   . .
//--------------------------------------------------------


//--------------------------------------------------------
//  . .
//     .
//--------------------------------------------------------
void delete_objects1()
  {
   int i;
   string txt;

   for (i=ObjectsTotal(); i>=0; i--)
     {
      txt=ObjectName(i);
      if (StringFind(txt,"" + ExtComplekt + "pl")>-1)ObjectDelete (txt);
      if (StringFind(txt,"" + ExtComplekt + "ph")>-1) ObjectDelete (txt);
     }
  }
//--------------------------------------------------------
//  . .
//     .
//--------------------------------------------------------


//--------------------------------------------------------
//  . .
//     .
//--------------------------------------------------------
void delete_objects2(string txt1)
  {
   int i;
   string txt;

   for (i=ObjectsTotal(); i>=0; i--)
     {
      txt=ObjectName(i);
      if (StringFind(txt,txt1)>-1)ObjectDelete (txt);
     }
  }
//--------------------------------------------------------
//  . .
//     .
//--------------------------------------------------------


//----------------------------------------------------
//  ZigZag  4  (  - Godzilla)
//     (nen). .
//----------------------------------------------------
/*
void ZigZag_new_nen1()
  {
   //----+         
   if (iBars(NULL,GrossPeriod)-1<minBars) return(0);
   //----+           
   static int time2,time3,time4;  
   //----+            
   static  double ZigZag2,ZigZag3,ZigZag4;
   //      "" 
   static int counted_bars_GrossPeriod=0;
   //----+               
   int MaxBar,limit,supr2_bar,supr3_bar,supr4_bar,counted_bars;
   if (GrossPeriod==0)
     {
      counted_bars_GrossPeriod=IndicatorCounted();
      if (Bars-counted_bars_GrossPeriod>2)
        {
         counted_bars_GrossPeriod=0;
         timeFirstBar=0;
        }
      //----      
      if (counted_bars_GrossPeriod>0) counted_bars_GrossPeriod--;
     }
   else
     {
      if (iBars(NULL,GrossPeriod)-counted_bars_GrossPeriod>2)
        {
         counted_bars_GrossPeriod=0;
         timeFirstBar=0;
        }
     }
   counted_bars=counted_bars_GrossPeriod;
   //----    
   if (counted_bars<0)return(-1);
   //----+      
   int    shift, back,lasthighpos,lastlowpos;
// zzH[] - TempBuffer[]; zzL[] - ZigZagBuffer[]
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;
   //----     ,         
   MaxBar=iBars(NULL,GrossPeriod)-minBars; 
   //----       ,         
   if (counted_bars==0)
     {
      limit=MaxBar;
     }
   else 
     {
      //----
      supr2_bar=iBarShift(NULL,GrossPeriod,time2,TRUE);
      supr3_bar=iBarShift(NULL,GrossPeriod,time3,TRUE);
      supr4_bar=iBarShift(NULL,GrossPeriod,time4,TRUE);
      //----
      limit=supr3_bar;      
      if ((supr2_bar<0)||(supr3_bar<0)||(supr4_bar<0))
         {
          limit=MaxBar;
         }
     }
     
   //----  
   if (limit>=MaxBar || timeFirstBar!=iTime(NULL,GrossPeriod,iBars(NULL,GrossPeriod)-1)) 
     {
      timeFirstBar=iTime(NULL,GrossPeriod,iBars(NULL,GrossPeriod)-counted_bars-1);
      for (shift=iBars(NULL,GrossPeriod)-1; shift>0;shift--)ZigZagBuffer [shift]=0.0; 
      limit=MaxBar; 
     } 
   //----  
   //----    
//   if(ArrayResize(TempBuffer,limit+ExtBackstep+1)!=limit+ExtBackstep+1)return(-1);
//   if(ArrayResize(ZigZagBuffer,limit+ExtBackstep+1)!=limit+ExtBackstep+1)return(-1);
     
   //----+-------------------------------------------------+ 
   
   //----+    
   for(shift=limit; shift>=0; shift--)
     {
      //--- 
      val=iLow(NULL,GrossPeriod,Lowest(NULL,GrossPeriod,MODE_LOW,minBars,shift));
      if(val==lastlow) val=0.0;
      else 
        { 
         lastlow=val; 
         if((iLow(NULL,GrossPeriod,shift)-val)>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
//               res=ZigZagBuffer[shift+back];
//               if((res!=0)&&(res>val)) ZigZagBuffer[shift+back]=0.0; 
               res=zzL[shift+back];
               if((res!=0)&&(res>val)) zzL[shift+back]=0.0; 
              }
           }
        }
//      if (Low[shift]==val) ZigZagBuffer[shift]=val;
      if (iLow(NULL,GrossPeriod,shift)==val) zzL[shift]=val;
      //--- 
      val=iHigh(NULL,GrossPeriod,Highest(NULL,GrossPeriod,MODE_HIGH,minBars,shift));
      if(val==lasthigh) val=0.0;
      else 
        {
         lasthigh=val;
         if((val-iHigh(NULL,GrossPeriod,shift))>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
//               res=TempBuffer[shift+back];
//               if((res!=0)&&(res<val)) TempBuffer[shift+back]=0.0; 
               res=zzH[shift+back];
               if((res!=0)&&(res<val)) zzH[shift+back]=0.0; 
              } 
           }
        }
//      if (High[shift]==val) TempBuffer[shift]=val;
      if (iHigh(NULL,GrossPeriod,shift)==val) zzH[shift]=val;
     }
   //----+     
      
   // final cutting 
      lasthigh=-1; lasthighpos=-1;
      lastlow= -1; lastlowpos= -1;
   //----+-------------------------------------------------+
   
   //----+    

   for(shift=limit; shift>=0; shift--)
     {
//      curlow=ZigZagBuffer[shift];
//      curhigh=TempBuffer[shift];
      curlow=zzL[shift];
      curhigh=zzH[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
         if(lasthigh>0) 
           {
//            if(lasthigh<curhigh) TempBuffer[lasthighpos]=0;
//            else TempBuffer[shift]=0;
            if(lasthigh<curhigh) zzH[lasthighpos]=0;
            else zzH[shift]=0;
           }
         //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
//            if(lastlow>curlow) ZigZagBuffer[lastlowpos]=0;
//            else ZigZagBuffer[shift]=0;
            if(lastlow>curlow) zzL[lastlowpos]=0;
            else zzL[shift]=0;
           }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
   //----+    
     
   //----+-------------------------------------------------+
   
   //----+   
   for(shift=limit; shift>=0; shift--)
     {
//       res=TempBuffer[shift];
//       if(res!=0.0) ZigZagBuffer[shift]=res;

      zz[shift]=zzL[shift];
      if(shift>=iBars(NULL,GrossPeriod)-minBars) {zzH[shift]=0.0; zzL[shift]=0.0; zz[shift]=0.0;}
      else
        {
          res=zzH[shift];
          if(res!=0.0) zz[shift]=res;
        }
     }
     //----+   

   //   
   int i=0,j=0;
   for (shift=0;i<3;shift++)
     {
      if (zz[shift]>0)
        {
         i++;
         if (i==1 && zz[shift]==iHigh(NULL,GrossPeriod,shift)) j=shift;
         if ((i==2 && j>0) && (zz[shift]==iHigh(NULL,GrossPeriod,shift)))
           {
            if(zz[shift]>=zz[j]) zz[j]=0; else zz[shift]=0;
            i=0;
            j=0;
           }
        }
     }
    
   //+---    ,     
   if (limit<MaxBar)
     {
      zz[supr2_bar]=ZigZag2; 
      zz[supr3_bar]=ZigZag3; 
      zz[supr4_bar]=ZigZag4; 
      for(int qqq=supr4_bar-1; qqq>supr3_bar; qqq--)zz[qqq]=0; 
      for(int ggg=supr3_bar-1; ggg>supr2_bar; ggg--)zz[ggg]=0;
     }
   //+---+============================================+
  
   //+---    
   double vel1, vel2, vel3, vel4;
   int bar1, bar2, bar3, bar4;
   int count;
   if (limit==MaxBar)supr4_bar=MaxBar;
   for(int bar=supr4_bar; bar>=0; bar--)
    {
     if (zz[bar]!=0)
      {
       count++;
       vel4=vel3;bar4=bar3;
       vel3=vel2;bar3=bar2;
       vel2=vel1;bar2=bar1;
       vel1=zz[bar];bar1=bar;
       if (count<3)continue; 

       if ((vel3<vel2)&&(vel2<vel1)){zz[bar2]=0;bar=bar3+1;}
       if ((vel3>vel2)&&(vel2>vel1)){zz[bar2]=0;bar=bar3+1;}
       if ((vel2==vel1)&&(vel1!=0 )){zz[bar1]=0;bar=bar3+1;}
     }
    } 
   //+---             
   time2=iTime(NULL,GrossPeriod,bar2);
   time3=iTime(NULL,GrossPeriod,bar3);
   time4=iTime(NULL,GrossPeriod,bar4);
   ZigZag2=vel2;  
   ZigZag3=vel3; 
   ZigZag4=vel4; 
   //+---          
   if (GrossPeriod>0)
     {
      counted_bars_GrossPeriod=iBars(NULL,GrossPeriod)-1;
     }
 //----    
  }
*/
//--------------------------------------------------------
//  ZigZag  4  (  - Godzilla)
//     (nen). . 
//--------------------------------------------------------



//----------------------------------------------------
//  ZigZag ( 4  ). .
//----------------------------------------------------
void ZigZag_()
  {
//  ZigZag  . .
   int    shift, back,lasthighpos,lastlowpos;
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;

   for(shift=Bars-minBars; shift>=0; shift--)
     {
      val=Low[Lowest(NULL,0,MODE_LOW,minBars,shift)];
      if(val==lastlow) val=0.0;
      else 
        { 
         lastlow=val; 
         if((Low[shift]-val)>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=zzL[shift+back];
               if((res!=0)&&(res>val)) zzL[shift+back]=0.0; 
              }
           }
        } 
      if (Low[shift]==val) zzL[shift]=val;
      //--- high
      val=High[Highest(NULL,0,MODE_HIGH,minBars,shift)];
      if(val==lasthigh) val=0.0;
      else 
        {
         lasthigh=val;
         if((val-High[shift])>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=zzH[shift+back];
               if((res!=0)&&(res<val)) zzH[shift+back]=0.0; 
              } 
           }
        }
      if (High[shift]==val) zzH[shift]=val;
     }

   // final cutting 
   lasthigh=-1; lasthighpos=-1;
   lastlow=-1;  lastlowpos=-1;

   for(shift=Bars-minBars; shift>=0; shift--)
     {
      curlow=zzL[shift];
      curhigh=zzH[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
         if(lasthigh>0) 
           {
            if(lasthigh<curhigh) zzH[lasthighpos]=0;
            else zzH[shift]=0;
           }
         //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow) zzL[lastlowpos]=0;
            else zzL[shift]=0;
           }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
  
   for(shift=Bars-1; shift>=0; shift--)
     {
      zz[shift]=zzL[shift];
      if(shift>=Bars-minBars) {zzH[shift]=0.0; zzL[shift]=0.0; zz[shift]=0.0;}
      else
        {
         res=zzH[shift];
         if(res!=0.0)
           {
//            if (zz[shift]!=0.0)zz[shift]=0.0; else zz[shift]=res;
            zz[shift]=res;
           }
        }
     }

  }
//--------------------------------------------------------
// ZigZag  . . 
//--------------------------------------------------------


//----------------------------------------------------
//  ZigZag   . .
//----------------------------------------------------
void ang_AZZ_()
 {
   int i,n;

//   cbi=Bars-IndicatorCounted()-1;
//---------------------------------
   for (i=cbi; i>=0; i--) 
     {
//-------------------------------------------------
      //     fs    si   
      if (ti!=Time[i]) {fsp=fs; sip=si;} ti=Time[i];
      //       
      if (minSize==0 && minPercent!=0) di=minPercent*Close[i]/2/100;
//-------------------------------------------------
      //   
      if (High[i]>=si+di && Low[i]<si-di) //        di
        {
         if (High[i]-si>=si-Low[i]) si=High[i]-di;  //        
         if (High[i]-si<si-Low[i]) si=Low[i]+di;  // , 
        } 
      else  //   
        {
         if (High[i]>=si+di) si=High[i]-di;   // 
         if (Low[i]<=si-di) si=Low[i]+di;   // 
        }

      //     
      if (i>Bars-2) {si=(High[i]+Low[i])/2;}

      //     
      if (chHL && chHL_PeakDet_or_vts) {ha[i]=si+di; la[i]=si-di;} 

      //      
      if (si>sip) fs=1; //  
      if (si<sip) fs=2; //  

//-------------------------------------------------

      if (fs==1 && fsp==2) //      
        {
         hm=High[i];

         zz[bi]=Low[bi];
         zzL[bi]=Low[bi];
         if (i>0) {if (PeakDet && chHL_PeakDet_or_vts) for (n=bip; n>=bi; n--) {lam[n]=Low[bip];}}
         aip=ai; 
         taip=Time[ai];
         ai=i;
         tai=Time[i];
         fsp=fs;
        }

      if (fs==2 && fsp==1) //      
        {
         lm=Low[i]; 

         zz[ai]=High[ai];
         zzH[ai]=High[ai];
         if (i>0) {if (PeakDet && chHL_PeakDet_or_vts) for (n=aip; n>=ai; n--) {ham[n]=High[aip];}}
         bip=bi; 
         tbip=Time[bi];
         bi=i;
         tbi=Time[i];
         fsp=fs;
        }

      //  t.  .
      if (fs==1 && High[i]>hm) 
        {hm=High[i]; ai=i; tai=Time[i];}
      if (fs==2 && Low[i]<lm) 
        {lm=Low[i]; bi=i; tbi=Time[i];}

//===================================================================================================
      //  .    ZigZag-a

      if (i==0) 
        {
         ai0=iBarShift(Symbol(),Period(),tai); 
         bi0=iBarShift(Symbol(),Period(),tbi);
         aip0=iBarShift(Symbol(),Period(),taip); 
         bip0=iBarShift(Symbol(),Period(),tbip);

         if (fs==1) {for (n=bi0-1; n>ai0; n--) {zzH[n]=0; zz[n]=0;} zz[ai0]=High[ai0]; zzH[ai0]=High[ai0]; zzL[ai0]=0;}         
         if (fs==2) {for (n=ai0-1; n>bi0; n--) {zzL[n]=0; zz[n]=0;} zz[bi0]=Low[bi0]; zzL[bi0]=Low[bi0]; zzH[bi0]=0;}

         if (PeakDet)
           {
            if (fs==1) 
              {
               for (n=aip0; n>=0; n--) {ham[n]=High[aip0];}
               for (n=bi0; n>=0; n--) {lam[n]=Low[bi0];}
              }
            if (fs==2)
              {
               for (n=bip0; n>=0; n--) {lam[n]=Low[bip0];} 
               for (n=ai0; n>=0; n--) {ham[n]=High[ai0];} 
              } 
           }

        }
//====================================================================================================
     }
//--------------------------------------------
 }

//--------------------------------------------------------
// ZigZag . . 
//--------------------------------------------------------


//----------------------------------------------------
//     Ensign. .
//----------------------------------------------------
void Ensign_ZZ()
 {
   int i,n;

//   cbi=Bars-IndicatorCounted()-1;
//---------------------------------
   for (i=cbi; i>=0; i--) 
     {
//-------------------------------------------------
      //       
      if (lLast==0) {lLast=Low[i];hLast=High[i]; if (ExtIndicator==3) di=hLast-lLast;}

      //        .
      //         .
      if (fs==0)
        {
         if (lLast<Low[i] && hLast<High[i]) {fs=1; hLast=High[i]; si=High[i]; ai=i; tai=Time[i]; if (ExtIndicator==3) di=High[i]-Low[i];}  //  
         if (lLast>Low[i] && hLast>High[i]) {fs=2; lLast=Low[i]; si=Low[i]; bi=i; tbi=Time[i]; if (ExtIndicator==3) di=High[i]-Low[i];}  //  
        }

      if (ti!=Time[i])
        {
         //     fs   
         ti=Time[i];

         ai0=iBarShift(Symbol(),Period(),tai); 
         bi0=iBarShift(Symbol(),Period(),tbi);

         fcount0=false;
         if ((fh || fl) && countBar>0) {countBar--; if (i==0 && countBar==0) fcount0=true;}
         // .    .
         if (fs==1)
           {
            if (hLast>High[i] && !fh) fh=true;

            if (i==0)
              {

               if (Close[i+1]<lLast && fh) {fs=2; countBar=minBars; fh=false;}
               if (countBar==0 && si-di>Low[i+1] && High[i+1]<hLast && ai0>i+1 && fh && !fcount0) {fs=2; countBar=minBars; fh=false;}

               if (fs==2) //         
                 {
                  zz[ai0]=High[ai0];
                  zzH[ai0]=High[ai0];
                  if (PeakDet && chHL_PeakDet_or_vts) for (n=aip; n>=ai; n--) {ham[n]=High[aip];}
                  lLast=Low[i+1];
                  if (ExtIndicator==3) di=High[i+1]-Low[i+1];
                  si=Low[i+1];
                  bip=bi0; 
                  tbip=Time[bi0];
                  bi=i+1;
                  tbi=Time[i+1];
                  if (chHL && chHL_PeakDet_or_vts) {ha[i+1]=si+di; la[i+1]=si;}
                }

              }
            else
              {
               if (Close[i]<lLast && fh) {fs=2; countBar=minBars; fh=false;}
               if (countBar==0 && si-di>Low[i] && High[i]<hLast && fh) {fs=2; countBar=minBars; fh=false;}

               if (fs==2) //      
                 {
                  zz[ai]=High[ai];
                  zzH[ai]=High[ai];
                  if (PeakDet && chHL_PeakDet_or_vts) for (n=aip; n>=ai; n--) {ham[n]=High[aip];}
                  lLast=Low[i];
                  if (ExtIndicator==3) di=High[i]-Low[i];
                  si=Low[i];
                  bip=bi; 
                  tbip=Time[bi];
                  bi=i;
                  tbi=Time[i];
                  if (chHL && chHL_PeakDet_or_vts) {ha[i]=si+di; la[i]=si;}
                 }
              }

           }
         else // fs==2
           {
            if (lLast<Low[i] && !fl) fl=true;

            if (i==0)
              {

               if (Close[i+1]>hLast && fl) {fs=1; countBar=minBars; fl=false;}
               if (countBar==0 && si+di<High[i+1] && Low[i+1]>lLast && bi0>i+1 && fl && !fcount0) {fs=1; countBar=minBars; fl=false;}

               if (fs==1) //         
                 {
                  zz[bi0]=Low[bi0];
                  zzL[bi0]=Low[bi0];
                  if (PeakDet && chHL_PeakDet_or_vts) for (n=bip; n>=bi; n--) {lam[n]=Low[bip];}
                  hLast=High[i+1];
                  if (ExtIndicator==3) di=High[i+1]-Low[i+1];
                  si=High[i+1];
                  aip=ai0; 
                  taip=Time[ai0];
                  ai=i+1;
                  tai=Time[i+1];
                  if (chHL && chHL_PeakDet_or_vts) {ha[i+1]=si; la[i+1]=si-di;}
                 }

              }
            else
              {
               if (Close[i]>hLast && fl) {fs=1; countBar=minBars; fl=false;}
               if (countBar==0 && si+di<High[i] && Low[i]>lLast && fl) {fs=1; countBar=minBars; fl=false;}

               if (fs==1) //      
                 {
                  zz[bi]=Low[bi];
                  zzL[bi]=Low[bi];
                  if (PeakDet && chHL_PeakDet_or_vts) for (n=bip; n>=bi; n--) {lam[n]=Low[bip];}
                  hLast=High[i];
                  if (ExtIndicator==3) di=High[i]-Low[i];
                  si=High[i];
                  aip=ai; 
                  taip=Time[ai];
                  ai=i;
                  tai=Time[i];
                  if (chHL && chHL_PeakDet_or_vts) {ha[i]=si; la[i]=si-di;}
                 }
              }
           }
        } 

      //  
      if (fs==1 && High[i]>si) {ai=i; tai=Time[i]; hLast=High[i]; si=High[i]; countBar=minBars; fh=false; if (ExtIndicator==3) di=High[i]-Low[i];}
      if (fs==2 && Low[i]<si) {bi=i; tbi=Time[i]; lLast=Low[i]; si=Low[i]; countBar=minBars; fl=false; if (ExtIndicator==3) di=High[i]-Low[i];}

      //     
      if (chHL && chHL_PeakDet_or_vts)
        {
         if (fs==1) {ha[i]=si; la[i]=si-di;}
         if (fs==2) {ha[i]=si+di; la[i]=si;}
        } 

//===================================================================================================
      //  .    ZigZag-a

      if (i==0) 
        {
         ai0=iBarShift(Symbol(),Period(),tai); 
         bi0=iBarShift(Symbol(),Period(),tbi);
         aip0=iBarShift(Symbol(),Period(),taip); 
         bip0=iBarShift(Symbol(),Period(),tbip);

         if (fs==1) {for (n=bi0-1; n>=0; n--) {zzH[n]=0; zz[n]=0;} zz[ai0]=High[ai0]; zzH[ai0]=High[ai0]; zzL[ai0]=0;}         
         if (fs==2) {for (n=ai0-1; n>=0; n--) {zzL[n]=0; zz[n]=0;} zz[bi0]=Low[bi0]; zzL[bi0]=Low[bi0]; zzH[bi0]=0;}

         if (PeakDet && chHL_PeakDet_or_vts)
           {
            if (fs==1) {for (n=aip0; n>=0; n--) {ham[n]=High[aip0];} for (n=bi0; n>=0; n--) {lam[n]=Low[bi0];} }
            if (fs==2) {for (n=bip0; n>=0; n--) {lam[n]=Low[bip0];} for (n=ai0; n>=0; n--) {ham[n]=High[ai0];} } 
           }
        }

//====================================================================================================
     }
//--------------------------------------------
 }
//--------------------------------------------------------
//     Ensign. . 
//--------------------------------------------------------


//----------------------------------------------------
//  ZigZag tauber. .
//----------------------------------------------------

void ZigZag_tauber()
  {
//  ZigZag  . .
   int    shift, back,lasthighpos,lastlowpos;
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;
   GetHigh(0,Bars,0.0,0);

   // final cutting 
   lasthigh=-1; lasthighpos=-1;
   lastlow=-1;  lastlowpos=-1;

   for(shift=Bars; shift>=0; shift--)
     {
      curlow=zzL[shift];
      curhigh=zzH[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
        if(lasthigh>0) 
           {
            if(lasthigh<curhigh) zzH[lasthighpos]=0;
            else zzH[shift]=0;
           }
        //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow) zzL[lastlowpos]=0;
            else zzL[shift]=0;
          }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
  

   for(shift=Bars-1; shift>=0; shift--)
     {
      zz[shift]=zzL[shift];
      res=zzH[shift];
      if(res!=0.0) zz[shift]=res;
     }

  }

void GetHigh(int start, int end, double price, int step)
  {
   int count=end-start;
   if (count<=0) return;
   int i=Highest(NULL,0,MODE_HIGH,count+1,start);
   double val=High[i];
   if ((val-price)>(minSize*Point))
     { 
      zzH[i]=val;
      if (i==start) {GetLow(start+step,end-step,val,1-step); if (zzL[start-1]>0) zzL[start]=0; return;}     
      if (i==end) {GetLow(start+step,end-step,val,1-step); if (zzL[end+1]>0) zzL[end]=0; return;} 
      GetLow(start,i-1,val,0);
      GetLow(i+1,end,val,0);
     }
  }

void GetLow(int start, int end, double price, int step)
  {
   int count=end-start;
   if (count<=0) return;
   int i=Lowest(NULL,0,MODE_LOW,count+1,start);
   double val=Low[i];
   if ((price-val)>(minSize*Point))
     {
      zzL[i]=val; 
      if (i==start) {GetHigh(start+step,end-step,val,1-step); if (zzH[start-1]>0) zzH[start]=0; return;}     
      if (i==end) {GetHigh(start+step,end-step,val,1-step); if (zzH[end+1]>0) zzH[end]=0; return;}   
      GetHigh(start,i-1,val,0);
      GetHigh(i+1,end,val,0);
     }
  }
//--------------------------------------------------------
// ZigZag tauber. . 
//--------------------------------------------------------

//----------------------------------------------------
//  . .
//----------------------------------------------------
void GannSwing()
 {
   int i,n,fs_tend=0;
// lLast, hLast -     
// lLast_m, hLast_m -    "" 

//   cbi=Bars-IndicatorCounted()-1;
//---------------------------------
   for (i=cbi; i>=0; i--) 
     {
//-------------------------------------------------
      //       
      if (lLast==0) {lLast=Low[i]; hLast=High[i]; ai=i; bi=i;}
      if (ti!=Time[i])
        {
         ti=Time[i];
         if (lLast_m==0 && hLast_m==0)
           {
            if (lLast>Low[i] && hLast<High[i]) //  
              {
               lLast=Low[i];hLast=High[i];lLast_m=Low[i];hLast_m=High[i];countBarExt++;
               if (fs==1) {countBarl=countBarExt; ai=i; tai=Time[i];}
               else if (fs==2) {countBarh=countBarExt; bi=i; tbi=Time[i];}
               else {countBarl++;countBarh++;}
              }
            else if (lLast<=Low[i] && hLast<High[i]) //     
              {
               lLast_m=0;hLast_m=High[i];countBarl=0;countBarExt=0;
               if (fs!=1) countBarh++;
               else {lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0; ai=i; tai=Time[i];}
              }
            else if (lLast>Low[i] && hLast>=High[i]) //     
              {
               lLast_m=Low[i];hLast_m=0;countBarh=0;countBarExt=0;
               if (fs!=2) countBarl++;
               else {lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0; bi=i; tbi=Time[i];}
              }
           }
         else  if (lLast_m>0 && hLast_m>0) //   ()
           {
            if (lLast_m>Low[i] && hLast_m<High[i]) //  
              {
               lLast=Low[i];hLast=High[i];lLast_m=Low[i];hLast_m=High[i];countBarExt++;
               if (fs==1) {countBarl=countBarExt; ai=i; tai=Time[i];}
               else if (fs==2) {countBarh=countBarExt; bi=i; tbi=Time[i];}
               else {countBarl++;countBarh++;}
              }
            else if (lLast_m<=Low[i] && hLast_m<High[i]) //     
              {
               lLast_m=0;hLast_m=High[i];countBarl=0;countBarExt=0;
               if (fs!=1) countBarh++;
               else {lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0; ai=i; tai=Time[i];}
              }
            else if (lLast_m>Low[i] && hLast_m>=High[i]) //     
              {
               lLast_m=Low[i];hLast_m=0;countBarh=0;countBarExt=0;
               if (fs!=2) countBarl++;
               else {lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0; bi=i; tbi=Time[i];}
              }
           }
         else  if (lLast_m>0)
           {
            if (lLast_m>Low[i] && hLast<High[i]) //  
              {
               lLast=Low[i];hLast=High[i];lLast_m=Low[i];hLast_m=High[i];countBarExt++;
               if (fs==1) {countBarl=countBarExt; ai=i; tai=Time[i];}
               else if (fs==2) {countBarh=countBarExt; bi=i; tbi=Time[i];}
               else {countBarl++;countBarh++;}
              }
            else if (lLast_m<=Low[i] && hLast<High[i]) //     
              {
               lLast_m=0;hLast_m=High[i];countBarl=0;countBarExt=0;
               if (fs!=1) countBarh++;
               else {lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0; ai=i; tai=Time[i];}
              }
            else if (lLast_m>Low[i] && hLast>=High[i]) //     
              {
               lLast_m=Low[i];hLast_m=0;countBarh=0;countBarExt=0;
               if (fs!=2) countBarl++;
               else {lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0; bi=i; tbi=Time[i];}
              }
           }
         else  if (hLast_m>0)
           {
            if (lLast>Low[i] && hLast_m<High[i]) //  
              {
               lLast=Low[i];hLast=High[i];lLast_m=Low[i];hLast_m=High[i];countBarExt++;
               if (fs==1) {countBarl=countBarExt; ai=i; tai=Time[i];}
               else if (fs==2) {countBarh=countBarExt; bi=i; tbi=Time[i];}
               else {countBarl++;countBarh++;}
              }
            else if (lLast<=Low[i] && hLast_m<High[i]) //     
              {
               lLast_m=0;hLast_m=High[i];countBarl=0;countBarExt=0;
               if (fs!=1) countBarh++;
               else {lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0; ai=i; tai=Time[i];}
              }
            else if (lLast>Low[i] && hLast_m>=High[i]) //     
              {
               lLast_m=Low[i];hLast_m=0;countBarh=0;countBarExt=0;
               if (fs!=2) countBarl++;
               else {lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0; bi=i; tbi=Time[i];}
              }
           }

         //   . 
         if (fs==0)
           {
            if (lLast<lLast_m && hLast>hLast_m) //  
              {
               lLast=Low[i]; hLast=High[i]; ai=i; bi=i; countBarl=0;countBarh=0;countBarExt=0;
              }
              
            if (countBarh>countBarl && countBarh>countBarExt && countBarh>minBars)
              {
               lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0;
               fs=1;countBarh=0;countBarl=0;countBarExt=0;
               zz[bi]=Low[bi];
               zzL[bi]=Low[bi];
               zzH[bi]=0;
               ai=i;
               tai=Time[i];
              }
            else if (countBarl>countBarh && countBarl>countBarExt && countBarl>minBars)
              {
               lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0;
               fs=2;countBarl=0;countBarh=0;countBarExt=0;
               zz[ai]=High[ai];
               zzH[ai]=High[ai];
               zzL[ai]=0;
               bi=i;
               tbi=Time[i];
              }
           }
         else
           {
            if (lLast_m==0 && hLast_m==0)
              {
               countBarl=0;countBarh=0;countBarExt=0;
              }

            //  
            if (fs==1)
              {
                  if (countBarl>countBarh && countBarl>countBarExt && countBarl>minBars) //    .
                    {
                     //     fs   
                     ai0=iBarShift(Symbol(),Period(),tai); 
                     bi0=iBarShift(Symbol(),Period(),tbi);
                     fs=2;
                     countBarl=0;

                     zz[ai]=High[ai];
                     zzH[ai]=High[ai];
                     zzL[ai]=0;
                     bi=i;
                     tbi=Time[i];

                     lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0;

                     for (n=0;countBarExt<minBars;n++) 
                       {
                        if (lLast<Low[i+n+1] && hLast>High[i+n+1]) {countBarExt++; countBarh++; lLast=Low[i+n+1]; hLast=High[i+n+1]; hLast_m=High[i];}
                        else break;
                       }

                     lLast=Low[i]; hLast=High[i];

                    }
              }

            //  
            if (fs==2)
              {
                  if (countBarh>countBarl && countBarh>countBarExt && countBarh>minBars) //    .
                    {
                     //     fs   
                     ai0=iBarShift(Symbol(),Period(),tai); 
                     bi0=iBarShift(Symbol(),Period(),tbi);
                     fs=1;
                     countBarh=0;

                     zz[bi]=Low[bi];
                     zzL[bi]=Low[bi];
                     zzH[bi]=0;
                     ai=i;
                     tai=Time[i];

                     lLast=Low[i]; hLast=High[i]; lLast_m=0; hLast_m=0;

                     for (n=0;countBarExt<minBars;n++) 
                       {
                        if (lLast<Low[i+n+1] && hLast>High[i+n+1]) {countBarExt++; countBarl++; lLast=Low[i+n+1]; hLast=High[i+n+1]; lLast_m=Low[i];}
                        else break;
                       }

                     lLast=Low[i]; hLast=High[i];

                    }
              }
           } 
        } 
       if (i==0)
         {
          if (hLast<High[i] && fs==1) //     
            {
             ai=i; tai=Time[i]; zz[ai]=High[ai]; zzH[ai]=High[ai]; zzL[ai]=0;
            }
          else if (lLast>Low[i] && fs==2) //     
            {
             bi=i; tbi=Time[i]; zz[bi]=Low[bi]; zzL[bi]=Low[bi]; zzH[bi]=0;
            }
//===================================================================================================
      //  .    ZigZag-a

          ai0=iBarShift(Symbol(),Period(),tai); 
          bi0=iBarShift(Symbol(),Period(),tbi);

          if (bi0>1) if (fs==1) {for (n=bi0-1; n>=0; n--) {zzH[n]=0.0; zz[n]=0.0;} zz[ai0]=High[ai0]; zzH[ai0]=High[ai0]; zzL[ai0]=0.0;}         
          if (ai0>1) if (fs==2) {for (n=ai0-1; n>=0; n--) {zzL[n]=0.0; zz[n]=0.0;} zz[bi0]=Low[bi0]; zzL[bi0]=Low[bi0]; zzH[bi0]=0.0;}

          if (ti<Time[1]) i=2;

         }
//====================================================================================================

     }
//--------------------------------------------
 }
//--------------------------------------------------------
//  . . 
//--------------------------------------------------------


//----------------------------------------------------
// nen-ZigZag. .
//----------------------------------------------------
void nenZigZag()
 {
  if (cbi>0)
    {
     datetime nen_time=iTime(NULL,GrossPeriod,0);
     int i=0, j=0; // j -      ( )   nen-ZigZag
     double nen_dt=0, last_j=0, last_nen=0; //last_j -    ( )   nen_ZigZag
     int limit, big_limit, bigshift=0;

     if (init_zz)
       {
        limit=Bars-1;
        big_limit=iBars(NULL,GrossPeriod)-1;
       }
     else
       {
        limit=iBarShift(NULL,0,afr[2]);
        big_limit=iBarShift(NULL,GrossPeriod,afr[2]);
       }

     while (bigshift<big_limit && i<limit) //    nen-ZigZag ("")
       {
        if (Time[i]>=nen_time)
          {
           if (ExtIndicator==6) nen_ZigZag[i]=iCustom(NULL,GrossPeriod,"ZigZag_new_nen3",minBars,ExtDeviation,ExtBackstep,0,bigshift);
           else  if (ExtIndicator==7) nen_ZigZag[i]=iCustom(NULL,GrossPeriod,"DT_ZZ",minBars,0,bigshift);
           else  if (ExtIndicator==8) nen_ZigZag[i]=iCustom(NULL,GrossPeriod,"CZigZag",minBars,ExtDeviation,0,bigshift);
           i++;
          }
        else {bigshift++;nen_time=iTime(NULL,GrossPeriod,bigshift);}
       }

     if (init_zz) //  
       {
        double i1=0, i2=0;
        init_zz=false;

        for (i=limit;i>0;i--) //    
          {
           if (nen_ZigZag[i]>0)
             {
              if (i1==0) i1=nen_ZigZag[i];
              else if (i1>0 && i1!=nen_ZigZag[i]) i2=nen_ZigZag[i];
              if (i2>0) 
                {
                 if (i1>i2) hi_nen=true;
                 else hi_nen=false;
                 break;
                }
             }
          }
       }
     else //   
       {
        if (afrl[2]>0) hi_nen=false; else hi_nen=true;
       }

     for (i=limit;i>=0;i--)
       {
//        if (i<limit) 
        {zz[i]=0; zzH[i]=0; zzL[i]=0;}

        if (nen_ZigZag[i]>0)
          {
           if (nen_dt>0 && nen_dt!=nen_ZigZag[i])
             {
              if (hi_nen) {hi_nen=false;zzH[j]=last_nen;}
              else {hi_nen=true;zzL[j]=last_nen;}
              last_j=0;nen_dt=0;zz[j]=last_nen;
             }

           if (hi_nen)
             {
              nen_dt=nen_ZigZag[i];
              if (last_j<High[i]) {j=i;last_j=High[i];last_nen=nen_ZigZag[i];}
             }
           else
             {
              nen_dt=nen_ZigZag[i];
              if (last_j==0) {j=i;last_j=Low[i];last_nen=nen_ZigZag[i];}
              if (last_j>Low[i]) {j=i;last_j=Low[i];last_nen=nen_ZigZag[i];}
             }

           if (nen_dt>0 && i==0)  //      GrossPeriod
             {
              zz[j]=last_nen;
              if (hi_nen) zzH[j]=last_nen; else zzL[j]=last_nen;
             }
          }
        else
          {
           if (last_j>0)
             {
              if (hi_nen) {hi_nen=false;zzH[j]=last_nen;}
              else {hi_nen=true;zzL[j]=last_nen;}
              last_j=0;nen_dt=0;zz[j]=last_nen;
             }
          }
       }
     }
 }
//--------------------------------------------------------
// nen-ZigZag. . 
//--------------------------------------------------------


//----------------------------------------------------
//  ZigZag   RSI. .
//----------------------------------------------------
void RSI_ZZ()
 {
   int i,n;

//   cbi=Bars-IndicatorCounted()-1;
//---------------------------------
   for (i=cbi; i>=0; i--) 
     {
//-------------------------------------------------
      //     fs    si   
      if (ti!=Time[i]) {fsp=fs; sip=si;} ti=Time[i];
//-------------------------------------------------
      //   
      if (iRSI(NULL,0,minBars,Price,i)>=si+minPercent) si=iRSI(NULL,0,minBars,Price,i)-minPercent;   // 
      if (iRSI(NULL,0,minBars,Price,i)<=si-minPercent) si=iRSI(NULL,0,minBars,Price,i)+minPercent;   // 

      //     
      if (i>Bars-2) si=iRSI(NULL,0,minBars,Price,i);

      //     
      if (chHL && chHL_PeakDet_or_vts) {ha[i]=si+di; la[i]=si-di;} 

      //      
      if (si>sip) fs=1; //  
      if (si<sip) fs=2; //  

//-------------------------------------------------

      if (fs==1 && fsp==2) //      
        {
         hm=iRSI(NULL,0,minBars,Price,i);

         zz[bi]=iRSI(NULL,0,minBars,Price,bi);
         zzL[bi]=iRSI(NULL,0,minBars,Price,bi);
         if (i>0) {if (PeakDet && chHL_PeakDet_or_vts) for (n=bip; n>=bi; n--) {lam[n]=iRSI(NULL,0,minBars,Price,bip);}}
         aip=ai; 
         taip=Time[ai];
         ai=i;
         tai=Time[i];
         fsp=fs;
        }

      if (fs==2 && fsp==1) //      
        {
         lm=iRSI(NULL,0,minBars,Price,i); 

         zz[ai]=iRSI(NULL,0,minBars,Price,ai);
         zzH[ai]=iRSI(NULL,0,minBars,Price,ai);
         if (i>0) {if (PeakDet && chHL_PeakDet_or_vts) for (n=aip; n>=ai; n--) {ham[n]=iRSI(NULL,0,minBars,Price,aip);}}
         bip=bi; 
         tbip=Time[bi];
         bi=i;
         tbi=Time[i];
         fsp=fs;
        }

      //  t.  .
      if (fs==1 && iRSI(NULL,0,minBars,Price,i)>hm) 
        {hm=iRSI(NULL,0,minBars,Price,i); ai=i; tai=Time[i];}
      if (fs==2 && iRSI(NULL,0,minBars,Price,i)<lm) 
        {lm=iRSI(NULL,0,minBars,Price,i); bi=i; tbi=Time[i];}

//===================================================================================================
      //  .    ZigZag-a

      if (i==0) 
        {
         ai0=iBarShift(Symbol(),Period(),tai); 
         bi0=iBarShift(Symbol(),Period(),tbi);
         aip0=iBarShift(Symbol(),Period(),taip); 
         bip0=iBarShift(Symbol(),Period(),tbip);

         if (fs==1) {for (n=bi0-1; n>ai0; n--) {zzH[n]=0; zz[n]=0;} zz[ai0]=iRSI(NULL,0,minBars,Price,ai0); zzH[ai0]=iRSI(NULL,0,minBars,Price,ai0); zzL[ai0]=0;}         
         if (fs==2) {for (n=ai0-1; n>bi0; n--) {zzL[n]=0; zz[n]=0;} zz[bi0]=iRSI(NULL,0,minBars,Price,bi0); zzL[bi0]=iRSI(NULL,0,minBars,Price,bi0); zzH[bi0]=0;}

         if (PeakDet)
           {
            if (fs==1) 
              {
               for (n=aip0; n>=0; n--) {ham[n]=iRSI(NULL,0,minBars,Price,aip0);}
               for (n=bi0; n>=0; n--) {lam[n]=iRSI(NULL,0,minBars,Price,bi0);}
              }
            if (fs==2)
              {
               for (n=bip0; n>=0; n--) {lam[n]=iRSI(NULL,0,minBars,Price,bip0);} 
               for (n=ai0; n>=0; n--) {ham[n]=iRSI(NULL,0,minBars,Price,ai0);} 
              } 
           }

        }
//====================================================================================================
     }
//--------------------------------------------
 }

//--------------------------------------------------------
// ZigZag   RSI. .
//--------------------------------------------------------



//--------------------------------------------------------
//  i-vts . . 
//--------------------------------------------------------
//+------------------------------------------------------------------+
//|                                                        i-VTS.mq4 |
//|                                                     & KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//|  06.12.2005   VTS                                       |
//+------------------------------------------------------------------+
//
//       MQL  MQ4
//
void i_vts() //
  {
   int    LoopBegin, sh;

 	if (NumberOfBars==0) LoopBegin=Bars-1;
   else LoopBegin=NumberOfBars-1;
   LoopBegin=MathMin(Bars-25, LoopBegin);

   for (sh=LoopBegin; sh>=0; sh--)
     {
      GetValueVTS("", 0, NumberOfVTS, sh);
      ha[sh]=ms[0];
      la[sh]=ms[1];
     }
  }

void i_vts1() //
  {
   int    LoopBegin, sh;

 	if (NumberOfBars==0) LoopBegin=Bars-1;
   else LoopBegin=NumberOfBars-1;
   LoopBegin=MathMin(Bars-25, LoopBegin);

   for (sh=LoopBegin; sh>=0; sh--)
     {
      GetValueVTS("", 0, NumberOfVTS1, sh);
      ham[sh]=ms[0];
      lam[sh]=ms[1];
     }
  }
//+------------------------------------------------------------------+
//-------    ---------------------------------
//+------------------------------------------------------------------+
//| :                                                       |
//|   sym -                                   |
//|   tf  -  ( )                             |
//|   ng  -                                               |
//|   nb  -                                                 |
//|   ms  -                                            |
//+------------------------------------------------------------------+
void GetValueVTS(string sym, int tf, int ng, int nb)
  {
   if (sym=="") sym=Symbol();
   double f1, f2, s1, s2;

   f1=iClose(sym, tf, nb)-3*iATR(sym, tf, 10, nb);
   f2=iClose(sym, tf, nb)+3*iATR(sym, tf, 10, nb);
   for (int i=1; i<=ng; i++)
     {
      s1=iClose(sym, tf, nb+i)-3*iATR(sym, tf, 10, nb+i);
      s2=iClose(sym, tf, nb+i)+3*iATR(sym, tf, 10, nb+i);
      if (f1<s1) f1=s1;
      if (f2>s2) f2=s2;
     }
    ms[0]=f2;   //  
    ms[1]=f1;   //  
  }
//+------------------------------------------------------------------+
//--------------------------------------------------------
//  i-vts . . 
//--------------------------------------------------------

//--------------------------------------------------------
//   . . 
//--------------------------------------------------------
void info_TF ()
  {
   string info, txt;
   int i,pips;

   openTF[0]=iOpen(NULL,PERIOD_MN1,0);
   closeTF[0]=iClose(NULL,PERIOD_MN1,0);
   lowTF[0]=iLow(NULL,PERIOD_MN1,0);
   highTF[0]=iHigh(NULL,PERIOD_MN1,0);
   
   openTF[1]=iOpen(NULL,PERIOD_W1,0);
   closeTF[1]=iClose(NULL,PERIOD_W1,0);
   lowTF[1]=iLow(NULL,PERIOD_W1,0);
   highTF[1]=iHigh(NULL,PERIOD_W1,0);
   
   openTF[2]=iOpen(NULL,PERIOD_D1,0);
   closeTF[2]=iClose(NULL,PERIOD_D1,0);
   lowTF[2]=iLow(NULL,PERIOD_D1,0);
   highTF[2]=iHigh(NULL,PERIOD_D1,0);
   
   openTF[3]=iOpen(NULL,PERIOD_H4,0);
   closeTF[3]=iClose(NULL,PERIOD_H4,0);
   lowTF[3]=iLow(NULL,PERIOD_H4,0);
   highTF[3]=iHigh(NULL,PERIOD_H4,0);
   
   openTF[4]=iOpen(NULL,PERIOD_H1,0);
   closeTF[4]=iClose(NULL,PERIOD_H1,0);
   lowTF[4]=iLow(NULL,PERIOD_H1,0);
   highTF[4]=iHigh(NULL,PERIOD_H1,0);
   
   info="|  ";

   for (i=0;i<5;i++)
     {
      pips=(highTF[i]-lowTF[i])/Point;
      if (pips>0)
        {
         if (openTF[i]>closeTF[i]) {txt=" < ";}
         else if (openTF[i]==closeTF[i]) {txt=" = ";}
         else if (openTF[i]<closeTF[i]) {txt=" > ";}
         info=info + TF[i] + txt + DoubleToStr(pips,0) + "   " +  DoubleToStr((closeTF[i]-lowTF[i])/(pips*Point),3) + " |  ";
        }
     }
   Comment(info);
   close_TF=Close[0];
  }
//--------------------------------------------------------
//   . . 
//--------------------------------------------------------

