#include <stdlib.mqh>
//+------------------------------------------------------------------+
//|                                           ZigZagReal-pointer.mq4 |
//|                                                                  |
//|                                                                  |
//|                                        Converted by Mql2Mq4 v2.0 |
//|                                            http://yousky.free.fr |
//|                                  Copyright (c) 2006, Yousky Soft |
//+------------------------------------------------------------------+

#property copyright " Istoniz "
#property link      " http://www.kg/ "

#property indicator_chart_window
#property indicator_color1 Blue
#property indicator_buffers 2
#property indicator_color2 White

//+------------------------------------------------------------------+
//| Common External variables                                        |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| External variables                                               |
//+------------------------------------------------------------------+
extern double barn = 250;
extern double LengthInput = 6;
extern double delaymin = 60;
extern double nSymbolHi = 242;
extern double nSymbolLow = 241;

//+------------------------------------------------------------------+
//| Special Convertion Functions                                     |
//+------------------------------------------------------------------+

int LastTradeTime;
double ExtHistoBuffer[];
double ExtHistoBuffer2[];

void SetLoopCount(int loops)
{
}

void SetIndexValue(int shift, double value)
{
  ExtHistoBuffer[shift] = value;
}

void SetIndexValue2(int shift, double value)
{
  ExtHistoBuffer2[shift] = value;
}

void SetArrow(datetime ArrowTime, double Price, double ArrowCode, color ArrowColor)
{
 int err;
 string ArrowName = DoubleToStr(ArrowTime,0);
   if (ObjectFind(ArrowName) != -1) ObjectDelete(ArrowName);
   if(!ObjectCreate(ArrowName, OBJ_ARROW, 0, ArrowTime, Price))
    {
      err=GetLastError();
      Print("error: can't create Arrow! code #",err," ",ErrorDescription(err));
      return;
    }
   else
   {
     ObjectSet(ArrowName, OBJPROP_ARROWCODE, ArrowCode);
     ObjectSet(ArrowName, OBJPROP_COLOR , ArrowColor);
     ObjectsRedraw();
   }
}

//+------------------------------------------------------------------+
//| End                                                              |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Initialization                                                   |
//+------------------------------------------------------------------+

int init()
{
   SetIndexStyle(0, DRAW_LINE, STYLE_SOLID);
   SetIndexBuffer(0, ExtHistoBuffer);
   SetIndexStyle(1, DRAW_LINE, STYLE_SOLID);
   SetIndexBuffer(1, ExtHistoBuffer2);
   return(0);
}
int start()
{
//+------------------------------------------------------------------+
//| Local variables                                                  |
//+------------------------------------------------------------------+
int shift = 0;
double LL = 0;
double HH = 0;
double Swing = 0;
double Swing_n = 0;
double BH = 0;
double BL = 0;
int i = 0;
double zu = 0;
double zd = 0;
double NH = 0;
double NL = 0;
double uzl = 0;
double summ = 0;
double current = 0;
double lasttime = 0;
double file_handle = 0;
double Length = 6;
double Uzel[10000,3];

/*[[ 
Name := High_Low v2 (ZigZag)
Author := Istoniz 
Link := http://www.kg/ 
Separate Window := No 
First Color := Blue 
First Draw Type := Line 
First Symbol := 217 
Use Second Data := Yes 
Second Color := White
Second Draw Type := Line 
Second Symbol := 218 
]]*/ 


 



 

SetLoopCount(0); 
// loop from first bar to current bar (with shift=0) 
Swing_n=0;Swing=0;uzl=0; 
BH =High[barn];BL=Low[barn];zu=barn;zd=barn; 

for(shift=barn;shift>=0 ;shift--){ 
LL=10000000;HH=-100000000; 
for(i=shift+Length;i>=shift+1 ;i--){ 
if( Low[i]< LL ) {LL=Low[i];} 
if( High[i]>HH ) {HH=High[i];} 
} 


if( Low[shift]<LL && High[shift]>HH ) 
{ 
Swing=2; 
if( Swing_n == 1 ) {zu=shift+1;} 
if( Swing_n == -1 ) {zd=shift+1;} 

} 
 else 
{ 
if( Low[shift]<LL ) {Swing=-1;} 
if( High[shift]>HH ) {Swing=1;} 
} 

if( Swing != Swing_n && Swing_n != 0 ) 
{ 
if( Swing == 2 ) {Swing=-Swing_n;BH = High[shift];BL = Low[shift]; } 
uzl=uzl+1; 
if( Swing == 1 ) {Uzel[uzl,1]=zd;Uzel[uzl,2]=BL;Uzel[uzl,3]=shift;} 
if( Swing == - 1 ) {Uzel[uzl,1]=zu;Uzel[uzl,2]=BH;Uzel[uzl,3]=shift;} 
BH = High[shift];BL = Low[shift]; 
} 

if( Swing == 1 ) { if( High[shift] >= BH ) {BH=High[shift];zu=shift;}} 
if( Swing == -1 ) { if( Low[shift]<=BL ) {BL=Low[shift]; zd=shift;}} 
Swing_n=Swing; 

} 

for(i =1;i <=uzl ;i ++){ 
SetIndexValue(Uzel[i,1],Uzel[i,2]); 
SetIndexValue2(Uzel[i,3],Uzel[i,2]); 
if( Uzel[i,2]-Uzel[i-1,2]<0 ) 
	SetArrow(Time[Uzel[i,3]], MathMin(Uzel[i,2], Low[Uzel[i,3]])-10*Point,nSymbolLow, Red);
if( Uzel[i,2]-Uzel[i-1,2]>0 ) 
	SetArrow(Time[Uzel[i,3]], MathMax(Uzel[i,2], High[Uzel[i,3]])+20*Point, nSymbolHi, Red);

}

// eugene5 added something here
summ=0;
for(i =1;i <=uzl-1 ;i ++){ 
	if( Uzel[i+1,2]-Uzel[i,2]>0 ) 
	//it means that we must sell now (calculating profit using the previous buy
		summ=summ+Close[Uzel[i+1,3]]-Close[Uzel[i,3]];
	if( Uzel[i+1,2]-Uzel[i,2]<0 ) 
	//it means that we must buy now (calculating profit using the previous sell)
		summ=summ-(Close[Uzel[i+1,3]]-Close[Uzel[i,3]]);
} 
Comment("Total profit in points=", summ/Point, " for the last ", barn, " bars, starting from ", 
		TimeToStr(Time[barn]), "'#10'",
		"min/max for the bars 1-7=",LL,"/",HH, " swing/swing_n=", Swing, "/", Swing_n, "'#10'",
		"BL/BH=",BL,"/",BH);

//if more than delaymin-mimutes - exit
//If CurTime < lasttime + delaymin*60 Then exit;
//lasttime = CurTime;
//FileDelete("report"+Symbol);
//file_handle = FileOpen("report"+Symbol," ");
summ=0;
for(i =1;i <=uzl-1;i ++){ 
	if( Uzel[i+1,2]-Uzel[i,2]>0 ) 
	//seems necessary to sell now (write in log using previous buy)
	{
		summ=summ+Close[Uzel[i+1,3]]-Close[Uzel[i,3]];
/*		FileWrite(file_handle,"  buy at", TimeToStr(Time[Uzel[i,3]]), "on the price of", Close[Uzel[i,3]]);
		FileWrite(file_handle,"close at", TimeToStr(Time[Uzel[i+1,3]]), "on the price of", Close[Uzel[i+1,3]]);
		FileWrite(file_handle,"profit on this position=", (Close[Uzel[i+1,3]]-Close[Uzel[i,3]])/Point, 
		"Totally in points=", summ/Point);
*/	}
	if( Uzel[i+1,2]-Uzel[i,2]<0 ) 
	//seems necessary to buy now (write in log using previous sell)
	{
		summ=summ-(Close[Uzel[i+1,3]]-Close[Uzel[i,3]]);
/*		FileWrite(file_handle," sell at", TimeToStr(Time[Uzel[i,3]]), "on the price of", Close[Uzel[i,3]]);
		FileWrite(file_handle,"close at", TimeToStr(Time[Uzel[i+1,3]]), "on the price of", Close[Uzel[i+1,3]]);
		FileWrite(file_handle,"profit on this position=", -(Close[Uzel[i+1,3]]-Close[Uzel[i,3]])/Point, 
		"Totally in points=", summ/Point);
*/	}
} 
//FileClose(file_handle);
  return(0);
}