//Version: 2
//Time: October 06, 2006
//+------------------------------------------------------------------+
//|              ZigZag Channels w/Auto Quadrant Lines               | 
//|                          ZigZag_Channels+Auto_Quadrant_lines.mq4 |
//|                              Originally Developed by Coders Guru |
//|                                   Auto Quadrant Lines by Xard777 |
//+------------------------------------------------------------------+


#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Silver
#property indicator_width1 2


//---- indicator parameters
extern   int      ExtDepth       = 20;//100
extern   int      ExtDeviation   = 15;//75
extern   int      ExtBackstep    = 3;//15
extern   int      back           = 0;
extern   color    trend.line1.color  = Blue;
extern   color    trend.line2.color  = Blue;
extern int trend.line.width   = 0;
extern int trend.line.style   = 0;

extern int Quadrant.line.width = 0;
extern int Quadrant.line.style = 0;
extern int Quadrant.line.color =Crimson;
extern int Quadrant.text.color =Crimson;
extern int Quadrant.text.size = 8;
//---- indicator buffers
double ExtMapBuffer[];
double ExtMapBuffer2[];
double upperband[];
double lowerband[];
//+------------------------------------------------------------------+
extern bool show.comments=false;
double  minus.two.four = 0,
        minus.one.four = 0,
        zero.four = 0,
        one.four = 0,
        two.four = 0,
        three.four = 0,
        four.four = 0,
        plus.one.four = 0,
        plus.two.four = 0;
string  ln_txt[9];        
//+------------------------------------------------------------------+

int deinit()
{
   ObjectDelete("trend_1"); 
   ObjectDelete("trend_2"); 
   ObjectsDeleteAll(0,OBJ_HLINE);
   ObjectsDeleteAll(0,OBJ_TEXT);
   return (0);
}

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   ln_txt[0]  = "Q0 ";
   ln_txt[1]  = "Q1 "; 
   ln_txt[2]  = "Q2 ";
   ln_txt[3]  = "Q3 ";
   ln_txt[4]  = "Q4 ";
   ln_txt[5]  = "Q+1 ";
   ln_txt[6]  = "Q+2 ";
   ln_txt[7]  = "Q-1 ";
   ln_txt[8]  = "Q-2 ";
   
   IndicatorBuffers(4);
//---- drawing settings
   SetIndexStyle(0,DRAW_SECTION);
//---- indicator buffers mapping
   SetIndexBuffer(0,ExtMapBuffer);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexBuffer(2,upperband);
   SetIndexBuffer(3,lowerband);
   
   SetIndexLabel(0,NULL) ;
   SetIndexLabel(1,NULL) ;
   SetIndexLabel(2,"Upper band") ;
   SetIndexLabel(3,"Lower band") ;
   
   SetIndexEmptyValue(0,0.0);
   ArraySetAsSeries(ExtMapBuffer,true);
   ArraySetAsSeries(ExtMapBuffer2,true);
   ArraySetAsSeries(upperband,true);
   ArraySetAsSeries(lowerband,true);

   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   int    shift, back,lasthighpos,lastlowpos;
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;

   for(shift=Bars-ExtDepth; shift>=0; shift--)
     {
      val=Low[Lowest(NULL,0,MODE_LOW,ExtDepth,shift)];
      if(val==lastlow) val=0.0;
      else 
        { 
         lastlow=val; 
         if((Low[shift]-val)>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ExtMapBuffer[shift+back];
               if((res!=0)&&(res>val)) ExtMapBuffer[shift+back]=0.0; 
              }
           }
        } 
      ExtMapBuffer[shift]=val;
      //--- high
      val=High[Highest(NULL,0,MODE_HIGH,ExtDepth,shift)];
      if(val==lasthigh) val=0.0;
      else 
        {
         lasthigh=val;
         if((val-High[shift])>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ExtMapBuffer2[shift+back];
               if((res!=0)&&(res<val)) ExtMapBuffer2[shift+back]=0.0; 
              } 
           }
        }
      ExtMapBuffer2[shift]=val;
     }

   // final cutting 
   lasthigh=-1; lasthighpos=-1;
   lastlow=-1;  lastlowpos=-1;

   for(shift=Bars-ExtDepth; shift>=0; shift--)
     {
      curlow=ExtMapBuffer[shift];
      curhigh=ExtMapBuffer2[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
         if(lasthigh>0) 
           {
            if(lasthigh<curhigh) ExtMapBuffer2[lasthighpos]=0;
            else ExtMapBuffer2[shift]=0;
           }
         //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow) ExtMapBuffer[lastlowpos]=0;
            else ExtMapBuffer[shift]=0;
           }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
  
   for(shift=Bars-1; shift>=0; shift--)
     {
      if(shift>=Bars-ExtDepth) ExtMapBuffer[shift]=0.0;
      else
        {
         res=ExtMapBuffer2[shift];
         if(res!=0.0) ExtMapBuffer[shift]=res;
        }
     }
     DrawTrends();
     
     for(shift=Bars-1; shift>=0; shift--)
     {
       upperband[shift]=    ObjectGetValueByShift("trend_1",shift);
       lowerband[shift]=    ObjectGetValueByShift("trend_2",shift);
     }
}
  
  
void DrawTrends()
{
   double temp = 0;
   static int count = 0;
   double save_0 , save_1 , save_2 , save_3;
   int    t_0 , t_1 , t_2 , t_3;

   //get last up
   for(int i = 0 ; i < Bars ; i++)
   {
      temp = ExtMapBuffer[i];
      if (temp != 0) count++;
      if(count == back + 1 && temp != 0) {save_0 = temp; t_0 = i;}
      if(count == back + 2 && temp != 0) {save_1 = temp; t_1 = i;}
      if(count == back + 3 && temp != 0) {save_2 = temp; t_2 = i;}
      if(count == back + 4 && temp != 0) {save_3 = temp; t_3 = i;}
      if(count == back + 5) break;
   }

if (show.comments) {  
  Comment("zz1  ",save_3,"\nzz2  ",save_2,"\nzz3  ",save_1,"\nzz4  ",save_0);}
//+------------------------------------------------------------------+                      
//Quadrant Calculation by Xard777
   zero.four = save_3;
   four.four = save_2;
   minus.two.four = zero.four - ((four.four - zero.four) * 2/4);
   minus.one.four = zero.four - ((four.four - zero.four) * 1/4);
   one.four = zero.four + ((four.four - zero.four) * 1/4);
   two.four = zero.four + ((four.four - zero.four) * 2/4);
   three.four = zero.four + ((four.four - zero.four) * 3/4);
   plus.one.four = zero.four + ((four.four - zero.four) * 5/4);
   plus.two.four = zero.four + ((four.four - zero.four) * 6/4);
//End of Quadrant Calculation                     
//+------------------------------------------------------------------+
//Draw our Quadrant Lines
   ObjectDelete("final.zero_Line");
      
   ObjectCreate("zero.four_Line", OBJ_HLINE,0, CurTime(),zero.four); ObjectSet("zero.four_Line",OBJPROP_COLOR,Quadrant.line.color);
   ObjectSet("zero.four_Line",OBJPROP_STYLE,Quadrant.line.style); ObjectSet("zero.four_Line",OBJPROP_WIDTH,Quadrant.line.width);
   ObjectCreate("zero.four_Text", OBJ_TEXT,0, CurTime(),zero.four); ObjectSetText("zero.four_Text",ln_txt[0],Quadrant.text.size, "Arial Bold",Quadrant.text.color);
   
   ObjectCreate("one.four_Line", OBJ_HLINE,0, CurTime(),one.four); ObjectSet("one.four_Line",OBJPROP_COLOR,Quadrant.line.color);
   ObjectSet("one.four_Line",OBJPROP_STYLE,Quadrant.line.style); ObjectSet("one.four_Line",OBJPROP_WIDTH,Quadrant.line.width);
   ObjectCreate("one.four_Text", OBJ_TEXT,0, CurTime(),one.four); ObjectSetText("one.four_Text",ln_txt[1],Quadrant.text.size, "Arial Bold",Quadrant.text.color);
   
   ObjectCreate("two.four_Line", OBJ_HLINE,0, CurTime(),two.four); ObjectSet("two.four_Line",OBJPROP_COLOR,Quadrant.line.color);
   ObjectSet("two.four_Line",OBJPROP_STYLE,Quadrant.line.style); ObjectSet("two.four_Line",OBJPROP_WIDTH,Quadrant.line.width);
   ObjectCreate("two.four_Text", OBJ_TEXT,0, CurTime(),two.four); ObjectSetText("two.four_Text",ln_txt[2],Quadrant.text.size, "Arial Bold",Quadrant.text.color);
   
   ObjectCreate("three.four_Line", OBJ_HLINE,0, CurTime(),three.four); ObjectSet("three.four_Line",OBJPROP_COLOR,Quadrant.line.color);
   ObjectSet("three.four_Line",OBJPROP_STYLE,Quadrant.line.style); ObjectSet("three.four_Line",OBJPROP_WIDTH,Quadrant.line.width);
   ObjectCreate("three.four_Text", OBJ_TEXT,0, CurTime(),three.four); ObjectSetText("three.four_Text",ln_txt[3],Quadrant.text.size, "Arial Bold",Quadrant.text.color);
   
   ObjectCreate("four.four_Line", OBJ_HLINE,0, CurTime(),four.four); ObjectSet("four.four_Line",OBJPROP_COLOR,Quadrant.line.color);
   ObjectSet("four.four_Line",OBJPROP_STYLE,Quadrant.line.style); ObjectSet("four.four_Line",OBJPROP_WIDTH,Quadrant.line.width);
   ObjectCreate("four.four_Text", OBJ_TEXT,0, CurTime(),four.four); ObjectSetText("four.four_Text",ln_txt[4],Quadrant.text.size, "Arial Bold",Quadrant.text.color);
   
   ObjectCreate("plus.one.four_Line", OBJ_HLINE,0, CurTime(),plus.one.four); ObjectSet("plus.one.four_Line",OBJPROP_COLOR,Quadrant.line.color);
   ObjectSet("plus.one.four_Line",OBJPROP_STYLE,Quadrant.line.style); ObjectSet("plus.one.four_Line",OBJPROP_WIDTH,Quadrant.line.width);
   ObjectCreate("plus.one.four_Text", OBJ_TEXT,0, CurTime(),plus.one.four); ObjectSetText("plus.one.four_Text",ln_txt[5],Quadrant.text.size, "Arial Bold",Quadrant.text.color);
   
   ObjectCreate("plus.two.four_Line", OBJ_HLINE,0, CurTime(),plus.two.four); ObjectSet("plus.two.four_Line",OBJPROP_COLOR,Quadrant.line.color);
   ObjectSet("plus.two.four_Line",OBJPROP_STYLE,Quadrant.line.style); ObjectSet("plus.two.four_Line",OBJPROP_WIDTH,Quadrant.line.width);
   ObjectCreate("plus.two.four_Text", OBJ_TEXT,0, CurTime(),plus.two.four); ObjectSetText("plus.two.four_Text",ln_txt[6],Quadrant.text.size, "Arial Bold",Quadrant.text.color);
   
   ObjectCreate("minus.one.four_Line", OBJ_HLINE,0, CurTime(),minus.one.four); ObjectSet("minus.one.four_Line",OBJPROP_COLOR,Quadrant.line.color);
   ObjectSet("minus.one.four_Line",OBJPROP_STYLE,Quadrant.line.style); ObjectSet("minus.one.four_Line",OBJPROP_WIDTH,Quadrant.line.width);
   ObjectCreate("minus.one.four_Text", OBJ_TEXT,0, CurTime(),minus.one.four); ObjectSetText("minus.one.four_Text",ln_txt[7],Quadrant.text.size, "Arial Bold",Quadrant.text.color);
     
   ObjectCreate("minus.two.four_Line", OBJ_HLINE,0, CurTime(),minus.two.four); ObjectSet("minus.two.four_Line",OBJPROP_COLOR,Quadrant.line.color);
   ObjectSet("minus.two.four_Line",OBJPROP_STYLE,Quadrant.line.style); ObjectSet("minus.two.four_Line",OBJPROP_WIDTH,Quadrant.line.width);
   ObjectCreate("minus.two.four_Text", OBJ_TEXT,0, CurTime(),minus.two.four); ObjectSetText("minus.two.four_Text",ln_txt[8],Quadrant.text.size, "Arial Bold",Quadrant.text.color);
//End of Quadrant Lines                 
//+------------------------------------------------------------------+    
   
   
   //draw trends
   Print(save_0,":",save_1,":",save_2,":",save_3);
   ObjectCreate("trend_2",OBJ_TREND,0,iTime(NULL,0,t_3),save_3,iTime(NULL,0,t_1),save_1);
   ObjectCreate("trend_1",OBJ_TREND,0,iTime(NULL,0,t_2),save_2,iTime(NULL,0,t_0),save_0);
   ObjectSet("trend_1",OBJPROP_STYLE,trend.line.style);
   ObjectSet("trend_2",OBJPROP_STYLE,trend.line.style);
   ObjectSet("trend_1",OBJPROP_WIDTH,trend.line.width);
   ObjectSet("trend_2",OBJPROP_WIDTH,trend.line.width);
   ObjectSet("trend_1",OBJPROP_COLOR,trend.line1.color);
   ObjectSet("trend_2",OBJPROP_COLOR,trend.line2.color);
}


