//+------------------------------------------------------------------+
//|                                                  rvmGann_sv6.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 DeepSkyBlue
#property indicator_color2 Black
//---- input parameters
extern int GSv_tend=2;
//---- buffers
double Buf1[];
double Buf2[];
double sH[];
double sL[];
double fp[];
double sp[];
double dup[];
double ddn[];
//----
bool draw_up=0,draw_dn=0,initfl=0;
int lb,fpoint,spoint;
double aH,aL,lH,lL;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(8);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_NONE);
   SetIndexStyle(3,DRAW_NONE);
   SetIndexStyle(4,DRAW_NONE);
   SetIndexStyle(5,DRAW_NONE);
   SetIndexStyle(6,DRAW_NONE);
   SetIndexStyle(7,DRAW_NONE);
   SetIndexBuffer(0,Buf1);
   SetIndexBuffer(1,Buf2);
   SetIndexBuffer(2,sH);
   SetIndexBuffer(3,sL);
   SetIndexBuffer(4,fp);
   SetIndexBuffer(5,sp);
   SetIndexBuffer(6,dup);
   SetIndexBuffer(7,ddn);
   SetIndexLabel(0," ");
   SetIndexLabel(1," ");
   SetIndexLabel(2,"..");
   SetIndexLabel(3,"..");
   SetIndexLabel(4,"1- ");
   SetIndexLabel(5,"2- ");
   SetIndexLabel(6,"");
   SetIndexLabel(7,"");
   SetIndexEmptyValue(0,0);
   SetIndexEmptyValue(1,0);
   SetIndexEmptyValue(2,-1);
   SetIndexEmptyValue(3,-1);
   SetIndexEmptyValue(4,-1);
   SetIndexEmptyValue(5,-1);
   SetIndexEmptyValue(6,-1);
   SetIndexEmptyValue(7,-1);
//----
   return(0);
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int counted_bars=IndicatorCounted();
   int cb,ai,limit,index,i;
//---- 
   index=Bars-1;
   if( counted_bars>=0 )
   {
      if( index-counted_bars<=0 )
      {
         limit=0;
      }
      else
      {
         limit=index-counted_bars;
         if( limit>index-2 )
         {
            if( initfl!=1 )
            {
               myInit();
               if( initfl!=1 )
               {
                  Alert("  !");
                  return(-1);
               }
            }
            limit=index-2;
         }
      }
   }
   else
   {
      Alert("  !");
      return(-1);
   }
   //  
   for( cb=limit;cb>=0;cb-- )
   {
      ai=index-cb;
      //   
      if( lb!=ai )
      {
         lb=ai;
         //   ""...
         if( High[cb+1]<=aH && Low[cb+1]>=aL )
         {
         }
      }
      //   ""...
      if( High[cb]<=aH && Low[cb]>=aL )
      {
         //   
         continue;
      }
      //   -
      if( cb==0 && counted_bars>0 )
      {
      }
      else //   
      {
         //  
         if( High[cb]>aH && Low[cb]<aL )
         {
            //   
            if( Close[cb]<Open[cb] || ( Close[cb]==Open[cb] && Close[cb]<(Low[cb]+High[cb])/2 ) )
            {
               sL[cb]=1;
               if( High[cb]>High[cb+1] && sH[cb+1]>=GSv_tend-1 )
               {
                  sH[cb]=sH[cb+1]+1;
               }
            }
            else //    
            {
               sH[cb]=1;
               if( Low[cb]<Low[cb+1] && sL[cb+1]>=GSv_tend-1 )
               {
                  sL[cb]=sL[cb+1]+1;
               }
            }
            if( sH[cb]>=GSv_tend )
            {
               if( draw_dn==1 )
               {
                  fpoint=spoint;
                  draw_dn=0;
               }
               draw_up=1;
            }
            else
            {
               if( sL[cb]>=GSv_tend )
               {
                  if( draw_up==1 )
                  {
                     fpoint=spoint;
                     draw_up=0;
                  }
                  draw_dn=1;
               }
            }
            //       
            if( draw_up!=draw_dn || sH[cb]>=GSv_tend || sL[cb]>=GSv_tend )
            {
               aH=High[cb];
               aL=Low[cb];
               spoint=ai;
            }
         }
         else //   
         {
            //  
            if( High[cb]>aH )
            {
               if( sH[cb+1]>0 && High[cb]>High[cb+1] )
               {
                  sH[cb]=sH[cb+1]+1;
               }
               else
               {
                  sH[cb]=1;
               }
               if( sH[cb]>=GSv_tend )
               {
                  if( draw_dn==1 )
                  {
                     fpoint=spoint;
                     draw_dn=0;
                  }
                  draw_up=1;
               }
               //       
               if( draw_up==1 || sH[cb]>=GSv_tend )
               {
                  aH=High[cb];
                  aL=Low[cb];
                  spoint=ai;
               }
            }
            else //  
            {
               if( sL[cb+1]>0 && Low[cb]<Low[cb+1] )
               {
                  sL[cb]=sL[cb+1]+1;
               }
               else
               {
                  sL[cb]=1;
               }
               if( sL[cb]>=GSv_tend )
               {
                  if( draw_up==1 )
                  {
                     fpoint=spoint;
                     draw_up=0;
                  }
                  draw_dn=1;
               }
               //       
               if( draw_dn==1 || sL[cb]>=GSv_tend )
               {
                  aH=High[cb];
                  aL=Low[cb];
                  spoint=ai;
               }
            }
         }
         fp[cb]=fpoint;
         sp[cb]=spoint;
         dup[cb]=draw_up;
         ddn[cb]=draw_dn;
         if( draw_up==1 && spoint==ai)
         {
            up_draw();
         }
         else
         {
            if( draw_dn==1 && spoint==ai)
            {
               dn_draw();
            }
         }
      }
   }

//----
   return(0);
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                      |
//+------------------------------------------------------------------+
int myInit()
  {
//---- 
   //  
   if( Bars<GSv_tend+1 )
   {
      Alert("   !");
      return(-1);
   }
   if( GSv_tend<2 )
   {
      Alert("  !");
      return(-1);
   }
   aH=High[Bars-1];
   aL=Low[Bars-1];
   lH=aH;
   lL=aL;
   if( High[Bars-2]>aH )
   {
      if( Low[Bars-2]>=aL || (Close[Bars-2]>Open[Bars-2] || Close[Bars-2]>(Close[Bars-2]+Open[Bars-2])/2 ) )
      {
         sH[Bars-2]=1;
      }
   }
   if( Low[Bars-2]<aL )
   {
      if(  High[Bars-2]<=aH || (Close[Bars-2]<Open[Bars-2] || Close[Bars-2]<(Close[Bars-2]+Open[Bars-2])/2 ) )
      {
         sL[Bars-2]=1;
      }
   }
   fpoint=0;
   spoint=0;
   initfl=1;
//----
   return(0);
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
int up_draw()
  {
//---- 
   double a;
   int index=Bars-1,i;
   Buf1[index-fpoint]=Low[index-fpoint];
   Buf1[index-spoint]=High[index-spoint];
   a=(spoint-fpoint)/(High[index-spoint]-Low[index-fpoint]);
   for( i=index-fpoint-1;i>index-spoint;i--)
   {
      Buf1[i]=(index-fpoint-i)/a+Low[index-fpoint];
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
int dn_draw()
  {
//---- 
   double a;
   int index=Bars-1,i;
   
   Buf1[index-fpoint]=High[index-fpoint];
   Buf1[index-spoint]=Low[index-spoint];
   a=(High[index-fpoint]-Low[index-spoint])/(spoint-fpoint);
   if( index-spoint==26 ) Print(fpoint," ",spoint," ",a);
   for( i=index-fpoint-1;i>index-spoint;i--)
   {
      Buf1[i]=High[index-fpoint]-(index-fpoint-i)*a;
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+

