//| wizardserg@mail.ru 
//| Revised by IgorAD,igorad2003@yahoo.co.uk |   
//| Personalized by iGoR AKA FXiGoR for the Trend Slope Trading method (T_S_T) 
//| Mod code By Lowphat based on http://www.forex-tsd.com/indicators-metatrader-4/7346-need-help-give-sound-alert-indicator.html                                                               
//+------------------------------------------------------------------+

#property indicator_chart_window 
#property indicator_buffers 4 
#property indicator_color1 LightBlue 
#property indicator_color2 Tomato
#property indicator_color3 Blue 
#property indicator_color4 Blue

//---- input parameters 
extern int       period=4; 
extern int       method=3;                         // MODE_SMA 
extern int       price=0;                          // PRICE_CLOSE 
extern double Bands=0.04;
extern bool EnableAlert=false;
//---- buffers 
double Uptrend[];
double Dntrend[];
double eu[];
double el[];
double eup;
double elp;
double bufp,buf;
double ExtMapBuffer[]; 
string position;
string lastposition;
bool enablea=false;
//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int init() 
{ 
    IndicatorBuffers(5);  
    SetIndexBuffer(0, Uptrend); 
    SetIndexBuffer(1, Dntrend); 
    SetIndexBuffer(4, ExtMapBuffer); 
    ArraySetAsSeries(ExtMapBuffer, true); 
    
    SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);
    SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);
    
    SetIndexBuffer(2, eu); 
    SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,2);
    
    SetIndexBuffer(3, el); 
    SetIndexStyle(3,DRAW_LINE,STYLE_SOLID,2);
    
    
    IndicatorShortName("Slope Direction Line("+period+")"); 
    return(0); 
} 

//+------------------------------------------------------------------+ 
//| Custor indicator deinitialization function                       | 
//+------------------------------------------------------------------+ 
int deinit() 
{ 
    return(0); 
} 

//+------------------------------------------------------------------+ 
//| ?????????? ???????                                               | 
//+------------------------------------------------------------------+ 
double WMA(int x, int p) 
{ 
    return(iMA(NULL, 0, p, 0, method, price, x));    
} 

//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int start() 
{ 
    int counted_bars = IndicatorCounted(); 
    
    if(counted_bars < 0) 
        return(-1); 
                  
    int x = 0; 
    int p = MathSqrt(period);              
    int e = Bars - counted_bars + period + 1; 
    
    double vect[], trend[]; 
    
    if(e > Bars) 
        e = Bars;    

    ArrayResize(vect, e); 
    ArraySetAsSeries(vect, true);
    ArrayResize(trend, e); 
    ArraySetAsSeries(trend, true); 
    
    for(x = 0; x < e; x++) 
    { 
        eu[x]=iEnvelopes(NULL, 0,4,MODE_LWMA,0,PRICE_CLOSE,Bands,MODE_UPPER,x);
        el[x]=iEnvelopes(NULL, 0,4,MODE_LWMA,0,PRICE_CLOSE,Bands,MODE_LOWER,x);
        eup=iEnvelopes(NULL, 0,4,MODE_LWMA,0,PRICE_CLOSE,Bands,MODE_UPPER,x+1);
        elp=iEnvelopes(NULL, 0,4,MODE_LWMA,0,PRICE_CLOSE,Bands,MODE_LOWER,x+1);       
        vect[x] = 2*WMA(x, period/2) - WMA(x, period);        
 //       Print("Bar date/time: ", TimeToStr(Time[x]), " close: ", Close[x], " vect[", x, "] = ", vect[x], " 2*WMA(p/2) = ", 2*WMA(x, period/2), " WMA(p) = ",  WMA(x, period)); 
    } 

    for(x = 0; x < e-period; x++)
     
        ExtMapBuffer[x] = iMAOnArray(vect, 0, p, 0, method, x);   
                   bufp = iMAOnArray(vect, 0, p, 0, method, x+1);  
    for(x = e-period; x >= 0; x--)
    {  
  
        trend[x] = trend[x+1];
        if (ExtMapBuffer[x]> ExtMapBuffer[x+1]) trend[x] =1;
        if (ExtMapBuffer[x]< ExtMapBuffer[x+1]) trend[x] =-1;
    
    if (trend[x]>0)
    { Uptrend[x] = ExtMapBuffer[x]; 
      if (trend[x+1]<0) Uptrend[x+1]=ExtMapBuffer[x+1];
      Dntrend[x] = EMPTY_VALUE;
    }
    else              
    if (trend[x]<0)
    { 
      Dntrend[x] = ExtMapBuffer[x]; 
      if (trend[x+1]>0) Dntrend[x+1]=ExtMapBuffer[x+1];
      Uptrend[x] = EMPTY_VALUE;
    }              
      
 
       if (ExtMapBuffer[0]>eu[0])position="Above";
  else if (ExtMapBuffer[0]<el[0])position="Below";     
  else  position = "Middle";

 if (enablea && EnableAlert && (position=="Above"||position=="Below")) 
 {
  if (lastposition!=position)Alert (Symbol()," ",Period(), " Signal Change from ",lastposition, " to ",position," @ bidprice ",Bid);
 } 
  lastposition=position;
  enablea=true;
    
 
    }
    
    return(0); 
} 
//+------------------------------------------------------------------+ 