//| wizardserg@mail.ru
//| Revised by IgorAD,igorad2003@yahoo.co.uk 
//| Personalized by iGoR AKA FXiGoR for the Trend Slope Trading method (T_S_T)
//| Band hak by Lowphat http://codecopy.com hack idea from onetarmizi

#property link "code hack by Lowphat http://codecopy.com | original MT4 rel. WizardSerg <wizardserg@mail.ru>, ?? ??????? ForexMagazine #104"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Lime 
#property indicator_color2 Tomato

#property indicator_level1 0

extern int        period=4;
extern int        method=3;
extern int        price=0;
extern double     Bands=0.04;
extern int        bandPer=4;

double upper[];
double lower[],ExtMapBuffer[];
double eu,el;
string position;
string lastposition;

int init() 
{ 
    IndicatorBuffers(3);  

    SetIndexBuffer(2, ExtMapBuffer); 
    ArraySetAsSeries(ExtMapBuffer, true); 
    
    SetIndexBuffer(0, upper); 
    SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,2);
    
    SetIndexBuffer(1, lower); 
    SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,2);
 
    IndicatorShortName("Slope Bands("+period+")"); 
    return(0); 
} 

//+------------------------------------------------------------------+ 
//| Custor indicator deinitialization function                       | 
//+------------------------------------------------------------------+ 
int deinit() { return(0);} 

double WMA(int x, int p) 
{ 
    return(iMA(NULL, 0, p, 0, method, price, x));    
} 

//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int start() 
{ 
    int counted_bars = IndicatorCounted(); 
    
    if(counted_bars < 0) 
        return(-1); 
                  
    int x = 0; 
    int p = MathSqrt(period);              
    int e = Bars - counted_bars + period + 1; 
    
    double vect[], trend[]; 
    
    if(e > Bars) 
        e = Bars;    

    ArrayResize(vect, e); 
    ArraySetAsSeries(vect, true);
    ArrayResize(trend, e); 
    ArraySetAsSeries(trend, true); 
    
    for(x = 0; x < e; x++) 
    { 
        vect[x] = 2*WMA(x, period/2) - WMA(x, period);        
    } 

    for(x = 0; x < e-period; x++){
        ExtMapBuffer[x] = iMAOnArray(vect, 0, p, 0, method, x);   


}
    for(x = e-period; x >= 0; x--)
    {  
        eu=iEnvelopes(NULL, 0,bandPer,MODE_LWMA,0,PRICE_CLOSE,Bands,MODE_UPPER,x);
        el=iEnvelopes(NULL, 0,bandPer,MODE_LWMA,0,PRICE_CLOSE,Bands,MODE_LOWER,x);

        if (ExtMapBuffer[x]>eu)lower[x]=ExtMapBuffer[x]-eu;
        else lower[x]=0;
        if (ExtMapBuffer[x]<el)upper[x]=ExtMapBuffer[x]-el;
        else upper[x]=0;
    }
    
    return(0); 
} 
//+------------------------------------------------------------------+ 