//+------------------------------------------------------------------+
//|                                                  Speed by Maloma |
//+------------------------------------------------------------------+

#property indicator_chart_window
//#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Magenta
#property indicator_color2 Aqua
#property indicator_color3 Red
//---- input parameters
extern int     Shift     =  002;
extern int     DrawBars  =  200;
extern int     Speed     =  30;
extern int     BackSpeed =  10;
//---- buffers
double Speed_Buffer[];
double Speed_Buffer_Sig_Up[];
double Speed_Buffer_Sig_Dn[];
//----
int a_begin;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,Speed_Buffer);
   SetIndexDrawBegin(0,Bars-DrawBars);
   SetIndexShift(0,0);
   SetIndexLabel(0,"Maloma speed");
//----   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1, 225);
   SetIndexBuffer(1,Speed_Buffer_Sig_Up);
   SetIndexDrawBegin(1,Bars-DrawBars);
   SetIndexShift(1,0);
   SetIndexLabel(1,"Maloma signal Up");
//----   
   SetIndexStyle(2,DRAW_ARROW);
   SetIndexArrow(2, 226);
   SetIndexBuffer(2,Speed_Buffer_Sig_Dn);
   SetIndexDrawBegin(2,Bars-DrawBars);
   SetIndexShift(2,0);
   SetIndexLabel(2,"Maloma signal Down");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Body                                                             |
//+------------------------------------------------------------------+
int start()
  {
   int    i;
   double BCL, OCL, CL, RSpeed=Speed, RBSpeed=BackSpeed;
   int limit, PDir;
   
     int counted_bars=IndicatorCounted();
  //---- check for possible errors
     if(counted_bars<0) return(-1);
  //---- last counted bar will be recounted
     if(counted_bars>0) counted_bars--;
     limit=Bars-counted_bars-1;
  //---- main loop
     for(i=1;i<=Digits;i++)
       {RSpeed=RSpeed/10;
        RBSpeed=RBSpeed/10;}
     for(i=0; i<limit; i++)
       {
        CL=((Close[i]-Open[Shift+i])/Shift);
        {Speed_Buffer[i]=Close[i]+CL;}
       }
     for(i=0; i<limit; i++)
       {
        CL=(Speed_Buffer[i]-Close[i]);
        OCL=(Speed_Buffer[i+2]-Close[i+2]);
        BCL=(Speed_Buffer[i+1]-Close[i+1]);
        if (((Open[i+2]-Close[i+2])>0) && ((Open[i+1]-Close[i+1])<0) && (MathAbs(OCL)>=RSpeed) && (MathAbs(BCL)>=RBSpeed))
          {Speed_Buffer_Sig_Up[i]=Open[i]+CL-10*Point;}
        if (((Open[i+2]-Close[i+2])<0) && ((Open[i+1]-Close[i+1])>0) && (MathAbs(OCL)>=RSpeed) && (MathAbs(BCL)>=RBSpeed))
          {Speed_Buffer_Sig_Dn[i]=Open[i]+CL+10*Point;}

/*
        CL=(Speed_Buffer[i]-Close[i]);
        OCL=(Speed_Buffer[i+2]-Close[i+2]);
        BCL=MathAbs(Speed_Buffer[i+1]-Close[i+1]);
        if (Open[i+1]>Close[i+1]) {PDir=-1;}
        if (Open[i+1]<Close[i+1]) {PDir=1;}
        if (Open[i+1]==Close[i+1]) {PDir=0;}
        Speed_Buffer_Sig_Up[i]=0;
        Speed_Buffer_Sig_Dn[i]=0;
        if (((OCL)<=-RSpeed) && (PDir==1) && (BCL>=RBSpeed))
          {
           Speed_Buffer_Sig_Up[i]=Open[i]+CL-10*Point;
          }
        if (((OCL)>=RSpeed) && (PDir==-1) && (BCL>=RBSpeed))
          {
           Speed_Buffer_Sig_Dn[i]=Open[i]+CL+10*Point;
          }
        Comment ("Current speed=",CL," -2Speed=",OCL," -1Speed=",BCL," PDir=",PDir," ?Signal=",(((OCL)<=-RSpeed) && (PDir==1) && (BCL>=RBSpeed)));
*/        
       }
  //---- done

}

