//+------------------------------------------------------------------+
//|                              |
//+------------------------------------------------------------------+
#property copyright "Ron T"
#property link      "http://www.lightpatch.com"

#property indicator_chart_window
#property indicator_buffers 2

#property indicator_color1 White
#property indicator_color2 Red


//---- buffers
double Buffer1[];
double Buffer2[];

// User Input
extern double MovingAvg=23;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|

int init()
  {

   // 233 up arrow
   // 234 down arrow
   // 159 big dot
   // 158 little dot
   // 168 open square
   // 120 box with X
   
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexBuffer(0, Buffer1);
   SetIndexArrow(0,159);  //big dot
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexBuffer(1, Buffer2);
   SetIndexArrow(1,159);  //big dot

   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   int i;
   
   for( i=0; i<Bars; i++ ) Buffer1[i]=0;
   for( i=0; i<Bars; i++ ) Buffer2[i]=0;

   return(0);
  }


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

int start()
  {
   int      pos=500; // leave room for moving average periods

   double   cMA=0, pMA=0;

   bool     found=false;
   bool    rising=false;
   bool   falling=false;
   bool    bought=false;
   bool      sold=false;
   
   int      cnt=0;
   int      err=0;
   
   // get 1 & 2 MA (avoid 0, as it's too noisy)
   // (possible mod - open of 0 and 1 has no noise)
   cMA=iMA(Symbol(), 0, MovingAvg, 0, MODE_LWMA, PRICE_CLOSE, pos);
   pMA=iMA(Symbol(), 0, MovingAvg, 0, MODE_LWMA, PRICE_CLOSE, pos+1);

   if (pMA<=cMA) {Buffer1[pos]=Low[pos];}
   if (pMA>=cMA) {Buffer2[pos]=High[pos];}

   pos--;

   return(0);
  }
//+------------------------------------------------------------------+