//+------------------------------------------------------------------+
//|                                           MultiMovingAverage.mq4 |
//+------------------------------------------------------------------+
#property copyright "Ron T"
#property link      "http://www.lightpatch.com"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Red
#property indicator_color2 White
#property indicator_color3 DeepSkyBlue

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];

//----
int ExtCountedBars=0;

//---- indicator parameters
extern int MA_Period=13;
extern int Plot_Character=159;
extern double indChange=0.01;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|
int init()
  {

//---- indicators

   SetIndexStyle(0,DRAW_ARROW);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexArrow(0,Plot_Character);
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexBuffer(1, ExtMapBuffer2);
   SetIndexArrow(1,Plot_Character);

   SetIndexStyle(2,DRAW_ARROW);
   SetIndexBuffer(2, ExtMapBuffer3);
   SetIndexArrow(2,224);

   if(MA_Period<2) MA_Period=13;

   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- TODO: add your code here
   
//----
   return(0);
  }


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
     double sum=0;
     double oldsum=0;
     double change=0;

     int    i;
     int pos=Bars-ExtCountedBars-1;

//---- initial accumulation
   if(pos<MA_Period) pos=MA_Period;
   for(i=1;i<MA_Period;i++,pos--)
      sum+=Close[pos];

  
   if(Bars<=10) return(0);
   ExtCountedBars=IndicatorCounted();

//---- check for possible errors
   if (ExtCountedBars<0) return(-1);

//---- last counted bar will be recounted
   if (ExtCountedBars>0) ExtCountedBars--;


//---- main calculation loop
   while(pos>=0)
     {
      oldsum=sum;

      // add in the leading value to make MA_Period samples
      sum+=Close[pos];

      change=MathAbs(Close[pos]-Close[pos+6]);

      if(oldsum/(MA_Period-1) > sum/MA_Period)
         {
         ExtMapBuffer1[pos]=sum/MA_Period;
         ExtMapBuffer2[pos]=0;

         if (change>indChange) 
            ExtMapBuffer3[pos]=sum/MA_Period;
         else
            ExtMapBuffer3[pos]=0;
         }
         else
         {
         ExtMapBuffer1[pos]=0;
         ExtMapBuffer2[pos]=sum/MA_Period;

         if (change>indChange) 
            ExtMapBuffer3[pos]=sum/MA_Period;
         else
            ExtMapBuffer3[pos]=0;
         }
         
      // remove the trailing period to make MA_Period-1 samples
      sum-=Close[pos+MA_Period-1];
 	   pos--;
     }

//---- zero initial bars
   if(ExtCountedBars<1)
      {
      for(i=1;i<MA_Period;i++) ExtMapBuffer1[Bars-i]=0;
      for(i=1;i<MA_Period;i++) ExtMapBuffer2[Bars-i]=0;
      for(i=1;i<MA_Period;i++) ExtMapBuffer3[Bars-i]=0;
      }

   return(0);
  }
  
//+------------------------------------------------------------------+