//+------------------------------------------------------------------+
//| Large Close Swings Indicator.mq4                                           |
//+------------------------------------------------------------------+
#property copyright "Ron T"
#property link      "http://www.lightpatch.com/forex"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 White

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];

//----
int ExtCountedBars=0;

// indicator parameters
extern double Swing=0.0010;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|
int init()
  {
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexArrow(0,226);
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexBuffer(1, ExtMapBuffer2);
   SetIndexArrow(1,225);

   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- TODO: add your code here
   
//----
   return(0);
  }


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
     double sum=0;
     double oldsum=0;
     double change=0;

     int i;
     int pos=Bars-ExtCountedBars-1;

  
     if(Bars<=10) return(0);
     ExtCountedBars=IndicatorCounted();

     // check for possible errors
     if (ExtCountedBars<0) return(-1);

     // last counted bar will be recounted
     if (ExtCountedBars>0) ExtCountedBars--;


     while(pos>=0)
        {

        change=Open[pos]-Close[pos];
        if (change>Swing)
           { 
              ExtMapBuffer1[pos]=Close[pos];
              ExtMapBuffer2[pos]=0;
           }
        if (change<(Swing*(-1)))
           {
              ExtMapBuffer1[pos]=0;
              ExtMapBuffer2[pos]=Close[pos];
           }
         
 	     pos--;
     }

//---- zero initial bars
//   if(ExtCountedBars<1)
//      {
//      for(i=1;i<MA_Period;i++) ExtMapBuffer1[Bars-i]=0;
//      for(i=1;i<MA_Period;i++) ExtMapBuffer2[Bars-i]=0;
//      }

   return(0);
  }
  
//+------------------------------------------------------------------+