//+------------------------------------------------------------------+
//| test.mq4                                                         |
//+------------------------------------------------------------------+
#property copyright "Ron T"
#property link      "http://www.lightpatch.com"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Red
#property indicator_color2 White
#property indicator_color3 DeepSkyBlue
#property indicator_color4 White

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];

// User Input
extern double Gap_Size=0.0030;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|

int init()
  {

   SetIndexStyle(0,DRAW_ARROW);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexArrow(0,234); //down red
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexBuffer(1, ExtMapBuffer2);
   SetIndexArrow(1,233); //up white

   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2, ExtMapBuffer3);
   //SetIndexArrow(2,224);

   SetIndexStyle(3,DRAW_ARROW);
   SetIndexBuffer(3, ExtMapBuffer4);
   SetIndexArrow(3,168); //dot

   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   int i;
   
   for( i=0; i<Bars; i++ ) ExtMapBuffer1[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer2[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer3[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer4[i]=0;

   return(0);
  }


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   double oTYP0=0, oTYP1=0, oTYP2=0, oTYP3=0, oTYP4=0, oTYP5=0;

   int pos=Bars;
      
   while(pos>=0)
     {
      // six-period typical
      oTYP0=(High[pos+0]+Low[pos+0]+Close[pos+0])/3;
      oTYP1=(High[pos+1]+Low[pos+1]+Close[pos+1])/3;
      oTYP2=(High[pos+2]+Low[pos+2]+Close[pos+2])/3;
      oTYP3=(High[pos+3]+Low[pos+3]+Close[pos+3])/3;
      oTYP4=(High[pos+4]+Low[pos+4]+Close[pos+4])/3;
      oTYP5=(High[pos+5]+Low[pos+5]+Close[pos+5])/3;

      ExtMapBuffer3[pos]=oTYP0;

      // +++++++++++++++++++++ LONG

      //three-period ten-pip gap
      if ( (oTYP3-oTYP2)+(oTYP2-oTYP1)+(oTYP1-oTYP0) >= Gap_Size )
        {
         ExtMapBuffer4[pos]=oTYP0;
        }
           

      // six-period run-up
      if(oTYP5 > oTYP4 && oTYP4 > oTYP3 && oTYP3 > oTYP2 && oTYP2 > oTYP1 && oTYP1 > oTYP0)
        {
         ExtMapBuffer1[pos]=oTYP0+0.0015;  //up white
         ExtMapBuffer2[pos]=0;
         
         //ExtMapBuffer4[pos+5]=oTYP5;
         //ExtMapBuffer4[pos+4]=oTYP4;
         //ExtMapBuffer4[pos+3]=oTYP3;
         //ExtMapBuffer4[pos+2]=oTYP2;
         //ExtMapBuffer4[pos+1]=oTYP1;
         //ExtMapBuffer4[pos+0]=oTYP0;
        }

      // +++++++++++++++++++++ SHORT
      //three-period ten-pip gap
      if ( (oTYP3-oTYP2)+(oTYP2-oTYP1)+(oTYP1-oTYP0) <= Gap_Size*(-1) )
        {
         ExtMapBuffer4[pos]=oTYP0;
        }
           
      if(
         oTYP5 < oTYP4 &&
         oTYP4 < oTYP3 &&
         oTYP3 < oTYP2 &&
         oTYP2 < oTYP1 &&
         oTYP1 < oTYP0 
         )
        {
         // six-period run-down
         ExtMapBuffer1[pos]=0;
         ExtMapBuffer2[pos]=oTYP0-0.0015;  //down red

         // five-period run-down
         //ExtMapBuffer4[pos+5]=oTYP5;
         //ExtMapBuffer4[pos+4]=oTYP4;
         //ExtMapBuffer4[pos+3]=oTYP3;
         //ExtMapBuffer4[pos+2]=oTYP2;
         //ExtMapBuffer4[pos+1]=oTYP1;
         //ExtMapBuffer4[pos+0]=oTYP0;
        }
 	   pos--;
     }

   return(0);
  }
//+------------------------------------------------------------------+