//+------------------------------------------------------------------+
//|                                           MultiMovingAverage.mq4 |
//+------------------------------------------------------------------+
#property copyright "Ron T"
#property link      "http://www.lightpatch.com"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Red
#property indicator_color2 White
#property indicator_color3 White

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];


// user input
extern double GapVal=0.0005;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|

int init()
  {

   SetIndexStyle(0,DRAW_ARROW);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexArrow(0,234); //down red
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexBuffer(1, ExtMapBuffer2);
   SetIndexArrow(1,233); //up white

   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2, ExtMapBuffer3);
   //SetIndexArrow(2,158);  //marker blue

   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   int i;
   
   for( i=0; i<Bars; i++ ) ExtMapBuffer1[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer2[i]=0;
   for( i=0; i<Bars; i++ ) ExtMapBuffer3[i]=0;

   return(0);
  }


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   double curTYP=0;
   double oldTYP=0;
   double change=0;

   int pos=Bars/5;
   
   // Print ("Start SHOW5TICKS with bars=",pos);

   while(pos>=0)
     {
      oldTYP=curTYP;
      curTYP=(High[pos]+Low[pos]+Close[pos])/3;
      change=curTYP-oldTYP;

      if ( change < ( GapVal * (-1) ) )
        {
         ExtMapBuffer1[pos]=curTYP;  //up white
         ExtMapBuffer2[pos]=0;
         //Print ("would SELL here ",CurTime());
        }

      if ( change > GapVal )
        {
         ExtMapBuffer1[pos]=0;
         ExtMapBuffer2[pos]=curTYP;  //down red
         //Print ("would BUY  here ",CurTime());
        }

      // marker for all typicals so they're visual
      ExtMapBuffer3[pos]=curTYP;  //marker blue

 	   pos--;
     }

   return(0);
  }
//+------------------------------------------------------------------+