//+------------------------------------------------------------------+
//|                                         EMA-Crossover_Signal.mq4 |
//|         Copyright  2005, Jason Robinson (jnrtrading)            |
//|                   http://www.jnrtading.co.uk                     |
//+------------------------------------------------------------------+

/*
  +------------------------------------------------------------------+
  | Allows you to enter two ema periods and it will then show you at |
  | Which point they crossed over. It is more usful on the shorter   |
  | periods that get obscured by the bars / candlesticks and when    |
  | the zoom level is out. Also allows you then to remove the emas   |
  | from the chart. (emas are initially set at 5 and 6)              |
  +------------------------------------------------------------------+
*/   
#property copyright "Copyright  2005, Jason Robinson (jnrtrading)"
#property link      "http://www.jnrtrading.co.uk"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 LightSkyBlue
#property indicator_color2 Red
#property indicator_color3 Yellow
#property indicator_color4 MistyRose

double CrossUp[];
double CrossDown[];
extern int FasterMode = 1; //0=sma, 1=ema, 2=smma, 3=lwma//orig o, second 2
extern int FasterMA =   144;//orig 21,  second orig 5
extern int SlowerMode = 1; //0=sma, 1=ema, 2=smma, 3=lwma// orig 0 second 0
extern int SlowerMA =   169;// orig 55, second 40
double ExtMapBuffer1[];
double ExtMapBuffer2[];
extern bool SoundON=true;
double alertTag;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_ARROW, STYLE_SOLID,5);
   SetIndexArrow(0, 233);
   SetIndexBuffer(0, CrossUp);
   SetIndexStyle(1, DRAW_ARROW, STYLE_SOLID,5);
   SetIndexArrow(1, 234);
   SetIndexBuffer(1, CrossDown);
   //---- indicators
   SetIndexStyle(2,DRAW_LINE,0,5);
   SetIndexBuffer(2,ExtMapBuffer1);
   SetIndexStyle(3,DRAW_LINE,0,5);
   SetIndexBuffer(3,ExtMapBuffer2);
//----
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {
   int limit, i, counter;
   double fasterMAnow, slowerMAnow, fasterMAprevious, slowerMAprevious, 
fasterMAafter, slowerMAafter;
   double Range, AvgRange;
   int counted_bars=IndicatorCounted();
   int counted_bars1=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;

   limit=Bars-counted_bars;
   
   for(i = 0; i <= limit; i++) {
   
      counter=i;
      Range=0;
      AvgRange=0;
      for (counter=i ;counter<=i+9;counter++)
      {
         AvgRange=AvgRange+MathAbs(High[counter]-Low[counter]);
      }
      Range=AvgRange/10;
       
      fasterMAnow = iMA(NULL, 0, FasterMA, 0, FasterMode, PRICE_CLOSE, 
i);
      fasterMAprevious = iMA(NULL, 0, FasterMA, 0, FasterMode, 
PRICE_CLOSE, i+1);
      fasterMAafter = iMA(NULL, 0, FasterMA, 0, FasterMode, 
PRICE_CLOSE, i-1);

      slowerMAnow = iMA(NULL, 0, SlowerMA, 0, SlowerMode, PRICE_CLOSE, 
i);
      slowerMAprevious = iMA(NULL, 0, SlowerMA, 0, SlowerMode, 
PRICE_CLOSE, i+1);
      slowerMAafter = iMA(NULL, 0, SlowerMA, 0, SlowerMode, 
PRICE_CLOSE, i-1);
      
      if ( (fasterMAnow > slowerMAnow) && (fasterMAprevious < 
slowerMAprevious) && (fasterMAafter > slowerMAafter)) {
         CrossUp[i] = Low[i] - Range*0.5;
         if (SoundON==true && alertTag!=Time[0]){
  //     Alert("EMA Cross Trend going UP on ",Symbol(),Period());
        PlaySound("trendup.wav");
        alertTag = Time[0];}
      }
      else if ((fasterMAnow < slowerMAnow) && (fasterMAprevious > 
slowerMAprevious) && (fasterMAafter < slowerMAafter)) {
         CrossDown[i] = High[i] + Range*0.5;
         if (SoundON==true && alertTag!=Time[0]){
  //        Alert("EMA Cross Trend going Down on ",Symbol(),Period());
          PlaySound("trendn.wav");
          alertTag = Time[0];
        }
      }
   }


//---- check for possible errors
   if (counted_bars1<0) return(-1);
//---- last counted bar will be recounted
   if (counted_bars1>0) counted_bars1--;
   
   int pos=Bars-counted_bars1;
   
     
 
   while(pos>=0)
     {
         ExtMapBuffer1[pos]= iMA(NULL,0,FasterMA,0,FasterMode,PRICE_CLOSE,pos);

         ExtMapBuffer2[pos]= iMA(NULL,0,SlowerMA,0,SlowerMode,PRICE_CLOSE,pos);

         
         pos--;
     }
//----      

   return(0);
}


       