/*[[
	Name := Gann_HiLo
	Author := Copyright  2004, MechanicalTrade Co.
	Link := http://www.mechanicaltrade.ru
	Separate Window := No
	First Color := LightGreen
	First Draw Type := Symbol
	First Symbol := 159
	Use Second Data := Yes
	Second Color := Chocolate
	Second Draw Type := Symbol
	Second Symbol := 159
]]*/

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 LightGreen
#property indicator_color2 Chocolate

//Input: Periods(2);
extern int Periods = 2;

//Variable : shift(0),First(True),Trend(0),Llow(0),Hhig(0),prevbars(0),loopbegin1(0),ttime(0);
int shift = 0;
bool first = true;
int trend = 0;
double Llow = 0;
double Hhig = 0;
int prevbars = 0;
int loopbegin1 = 0;
datetime ttime = 0;

double zero[];
double one[];

void SetIndexValue(int n,double v) { zero[ n ] = v; }
void SetIndexValue2(int n,double v) { one[ n ] = v; }

int init()
{
    SetIndexBuffer( 0, zero );
    SetIndexStyle( 0, DRAW_ARROW );
    SetIndexArrow( 0, 159 );

    SetIndexBuffer( 1, one );
    SetIndexStyle( 1, DRAW_ARROW );
    SetIndexArrow( 1, 159 );

    return( 0 );
}

int deinit()
{
    return( 0 );
}

int start()
{
    //if ttime=time and loopbegin1=-1 then exit;
    if ( ttime == Time[0] && loopbegin1 == -1 ) return( 0 );
    //ttime=time;
    ttime = Time[0];

    //If Bars < prevbars Or Bars-prevbars>1 Then first = True;
    if ( Bars < prevbars || Bars - prevbars > 1 ) first = true;
    //prevbars = Bars;
    prevbars = Bars;
    //If first Then Begin
    if ( first ) {
        //if C[Bars-100]>O[Bars-100] then trend=1 else trend=-1;
        if ( Close[ Bars - 100 ] > Open[ Bars - 100 ] ) trend = 1; else trend = -1;
        //loopbegin1 = Bars-100;
        loopbegin1 = Bars - 100;
        //If loopbegin1 < 0 Then Exit;      // not enough bars for counting
        if ( loopbegin1 < 0 ) return( 0 );      // not enough bars for counting
        //first = False;                    // this block is to be evaluated once only
        first = false;                    // this block is to be evaluated once only
    //End;
    }

    //loopbegin1 = loopbegin1+1;
    loopbegin1 = loopbegin1 + 1;
    //For shift = loopbegin1 Downto 0 Begin
    for ( shift = loopbegin1; shift >= 0; shift-- ) {
        //----------------------------------------------

        //SetLoopCount(0);
        // loop from first bar to current bar (with shift=0)

        //LLow=iMAEx(Periods,MODE_SMA,1,PRICE_LOW, Shift);
        Llow = iMA( Symbol(), Period(), Periods, 1, MODE_SMA, PRICE_LOW, shift );
        //Hhig=iMAEx(Periods,MODE_SMA,1,PRICE_High,Shift);
        Hhig = iMA( Symbol(), Period(), Periods, 1, MODE_SMA, PRICE_HIGH, shift );
        //If C[Shift+1]<LLow and Trend=-1 then Trend=1;
        if ( Close[ shift + 1 ] < Llow && trend == -1 ) trend = 1;
        //If C[Shift+1]>Hhig and Trend=1 then Trend=-1;
        if ( Close[ shift + 1 ] > Hhig && trend == 1 ) trend = -1;

        //If Trend= 1 then  SetIndexValue2(Shift,LLow);
        if ( trend == 1 ) SetIndexValue2( shift, Llow );
   
        //If Trend=-1 then SetIndexValue(Shift,Hhig);
        if ( trend == -1 ) SetIndexValue( shift, Hhig );

        //loopbegin1 = loopbegin1-1;
        loopbegin1 = loopbegin1 - 1;   
    //End;
    }

    return( 0 );
}

