
#property indicator_separate_window
#property indicator_buffers 1 
#property indicator_color1 Red 
#property indicator_maximum 0
#property indicator_minimum -100
#property indicator_level1 -5
#property indicator_level2 -95
//#property indicator_level3 -50
#property indicator_levelwidth 1
#property indicator_levelstyle STYLE_SOLID
#property indicator_levelcolor Aqua

extern int PeriodM1 = 90;
extern int PeriodM5 = 90;
extern int PeriodM15 = 36;
extern int PeriodM30 = 36;
extern int PeriodH1 = 36;
extern int PeriodH4 = 36;
extern int PeriodD1 = 36;
extern int PeriodW1 = 36;
extern int PeriodMN = 36;

extern bool Alerts = true;
extern bool UseSendMail = false;

double ExtMapBuffer1[]; 
int shortA;
int longA;
datetime lasttime = 0;
int WPRPeriod;

int init() 
  { 
   SetIndexStyle(0,DRAW_LINE); 
   SetIndexBuffer(0,ExtMapBuffer1);
   IndicatorShortName("%R(WPRPeriod)");
   
   return(0); 
  } 

int deinit() 
  { 
//----  
    
//---- 
   return(0); 
  } 


int start() 
  { 
    int    counted_bars=IndicatorCounted(); 
   if (counted_bars<0) return(-1); 
   if (counted_bars>0) counted_bars--; 
    
   int pos=Bars-counted_bars; 
 //  Alert(TimeCurrent());
 
    switch(Period()) 
      {
         case 1: 
            WPRPeriod=PeriodM1; 
            break;
         case 5: 
            WPRPeriod=PeriodM5;
            break;
         case 15: 
            WPRPeriod=PeriodM15;
            break;
         case 30: 
            WPRPeriod=PeriodM30;
            break;
         case 60: 
            WPRPeriod=PeriodH1;
            break;
         case 240: 
            WPRPeriod=PeriodH4;
            break;
         case 1440: 
            WPRPeriod=PeriodD1;
            break;
         case 10080: 
            WPRPeriod=PeriodW1;
            break;
         case 43200: 
            WPRPeriod=PeriodMN;
            break;
      }
 
   while(pos>=0) 
     { 
         ExtMapBuffer1[pos] = iWPR(NULL, 0, WPRPeriod, pos);          
         pos--; 
     } 
     
    

      if ( iWPR(NULL, 0, WPRPeriod, 0) > -95) {
         longA = 0;
         IndicatorShortName("%R("+WPRPeriod+")");
      }
      if ( iWPR(NULL, 0, WPRPeriod, 0) < -5) {
         shortA = 0;
          IndicatorShortName("%R("+WPRPeriod+")");
      }
      
          
      if ( iWPR(NULL, 0, WPRPeriod, 0) < -95 && longA != 1) {
         if (lasttime != Time[0]) {
          if (Alerts == true)Alert(Symbol()+" %R("+WPRPeriod+") is below -95. Buy if in blue zone.");
          if (UseSendMail == true)  SendMail(Symbol()+" %R("+WPRPeriod+") is below -95. Buy if in blue zone"," ");
          lasttime = Time[0];
         }
           IndicatorShortName("%R("+WPRPeriod+") Current signal: LONG  ");
          longA=1;        
      }
      if ( iWPR(NULL, 0, WPRPeriod, 0) > -5 && shortA != 1) {
      if (lasttime != Time[0]) {
          if (Alerts == true)Alert(Symbol()+" %R("+WPRPeriod+") is above -5. Sell if in red zone.");    
          if (UseSendMail == true) SendMail(Symbol()+" %R("+WPRPeriod+") is above -5. Sell if in red zone"," ");
          lasttime = Time[0];
        }
          IndicatorShortName("%R("+WPRPeriod+") Current signal: SHORT  ");
          shortA = 1;   
      }      
   return(0); 
  } 

