//+------------------------------------------------------------------+
//|                                                       
//|                                                          Kalenzo |
//|                                                  simone@konto.pl |
//+------------------------------------------------------------------+

#property copyright "Kalenzo"
#property link      "simone@konto.pl"

#property indicator_chart_window
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_color3 Aqua
#property indicator_color4 DeepPink
extern bool UseSound = True;
extern bool TypeChart = True;
extern string NameFileSound = "alert.wav";
extern int ShortPeriod = 5;
extern int BigPeriod = 50;
extern int ExitPeriod = 20;

#property indicator_buffers 4
//---- input parameters
//---- buffers
double UpBuffer[];
double DnBuffer[];
double ExitLong[];
double ExitShort[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators

  // IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_ARROW,EMPTY,1);
   SetIndexStyle(1,DRAW_ARROW,EMPTY,1);
   SetIndexStyle(2,DRAW_ARROW,EMPTY,1);
  SetIndexStyle(3,DRAW_ARROW,EMPTY,1);
  
   SetIndexBuffer(0,UpBuffer);
   SetIndexBuffer(1,DnBuffer);
   SetIndexBuffer(2,ExitLong);
   SetIndexBuffer(3,ExitShort);
  
   SetIndexArrow(0,108);
   SetIndexArrow(1,108);
   SetIndexArrow(2,251);
   SetIndexArrow(3,251);

   SetIndexLabel(0,"Up Signal");
   SetIndexLabel(1,"Down Signal");
   SetIndexLabel(2,"Exit Long");
   SetIndexLabel(3,"Exit Short");

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) counted_bars=0;
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   
  
   for(int i = 0 ;i < limit ;i++)
   { 
      double pwma5 = iMA(Symbol(),0,ShortPeriod,0,MODE_LWMA,PRICE_CLOSE,i+1);
      double cwma5 = iMA(Symbol(),0,ShortPeriod,0,MODE_LWMA,PRICE_CLOSE,i);
      
      double pwma50 = iMA(Symbol(),0,BigPeriod,0,MODE_LWMA,PRICE_CLOSE,i+1);
      double cwma50 = iMA(Symbol(),0,BigPeriod,0,MODE_LWMA,PRICE_CLOSE,i);
      
      double pwma20 = iMA(Symbol(),0,ExitPeriod,0,MODE_LWMA,PRICE_CLOSE,i+1);
      double cwma20 = iMA(Symbol(),0,ExitPeriod,0,MODE_LWMA,PRICE_CLOSE,i);
       
      if( cwma5 > cwma50 && pwma5 <= pwma50)
      {  
        UpBuffer[i] = iLow(Symbol(),0,i)-(3*Point);
        DnBuffer[i] = EMPTY_VALUE;
      if (UseSound==1) PlaySound(NameFileSound);
      if (TypeChart==1) Comment ("Buy signal at Ask=",Ask,", Bid=",Bid,", Date=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime())," Symbol=",Symbol()," Period=",Period());
      }
      
      else if( pwma5 >= pwma50 && cwma5 < cwma50)
      {
        UpBuffer[i] = EMPTY_VALUE;
        DnBuffer[i] = iHigh(Symbol(),0,i)+(3*Point);
      if (UseSound==1) PlaySound(NameFileSound);
      if (TypeChart==1) Comment ("Sell signal at Ask=",Ask,", Bid=",Bid,", Date=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime())," Symbol=",Symbol()," Period=",Period());
      }
      else
      {
        DnBuffer[i] = EMPTY_VALUE;
        UpBuffer[i] = EMPTY_VALUE;
      }
      
      if( cwma5 > cwma20 && pwma5 <= pwma20 && iClose(Symbol(),0,i) < cwma50)
      {  
        ExitShort[i] = iHigh(Symbol(),0,i)+(3*Point);
        ExitLong[i] =  EMPTY_VALUE;
      }
      else if( pwma5 >= pwma20 && cwma5 < cwma20 && iClose(Symbol(),0,i) > cwma50)
      {
        ExitShort[i] = EMPTY_VALUE;
        ExitLong[i] = iLow(Symbol(),0,i)-(3*Point);
      }
      else
      {
        ExitShort[i] = EMPTY_VALUE;
        ExitLong[i] = EMPTY_VALUE;
      }
  
   }
//----

   return(0);
  }
//+------------------------------------------------------------------+



