//+------------------------------------------------------------------+
//|                                                                  |
//|                                                          Kalenzo |
//|                                                  simone@konto.pl |
//|                                    Modified by Newdigital        |
//+------------------------------------------------------------------+

#property copyright "Kalenzo"
#property link      "simone@konto.pl"

#property indicator_chart_window
#property indicator_color1 Aqua
#property indicator_color2 Magenta
extern bool UseSound = True;
extern bool TypeChart = True;
extern string NameFileSound = "alert.wav";
extern int ShortEMAPeriod = 5;
extern int ShortMAMode =  1; //0=sma, 1=ema, 2=smma, 3=lwma
extern int ConfirmEMAPeriod = 62;
extern int ConfirmMAMode =  1; //0=sma, 1=ema, 2=smma, 3=lwma
extern int BigEMAPeriod = 13;
extern int BigMAMode =  1; //0=sma, 1=ema, 2=smma, 3=lwma

#property indicator_buffers 2
//---- input parameters
//---- buffers
double UpBuffer[];
double DnBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators

  // IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_ARROW,EMPTY,1);
   SetIndexStyle(1,DRAW_ARROW,EMPTY,1);
   
  
   SetIndexBuffer(0,UpBuffer);
   SetIndexBuffer(1,DnBuffer);
   
  
   SetIndexArrow(0,108);
   SetIndexArrow(1,108);
   

   SetIndexLabel(0,"Up Signal");
   SetIndexLabel(1,"Down Signal");
   

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) counted_bars=0;
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   
  
   for(int i = 0 ;i < limit ;i++)
   { 
      double pwma5 = iMA(Symbol(),0,ShortEMAPeriod,0,ShortMAMode,PRICE_CLOSE,i+1);
      double cwma5 = iMA(Symbol(),0,ShortEMAPeriod,0,ShortMAMode,PRICE_CLOSE,i);
      
      double pwma50 = iMA(Symbol(),0,ConfirmEMAPeriod,0,ConfirmMAMode,PRICE_CLOSE,i+1);
      double cwma50 = iMA(Symbol(),0,ConfirmEMAPeriod,0,ConfirmMAMode,PRICE_CLOSE,i);
      
      double pwma20 = iMA(Symbol(),0,BigEMAPeriod,0,BigMAMode,PRICE_CLOSE,i+1);
      double cwma20 = iMA(Symbol(),0,BigEMAPeriod,0,BigMAMode,PRICE_CLOSE,i);
       
      if( cwma5 > cwma50 && cwma20 > cwma50 && pwma5 <= pwma50 && pwma20 <= pwma50)
      {  
        UpBuffer[i] = iLow(Symbol(),0,i)-(3*Point);
        DnBuffer[i] = EMPTY_VALUE;
      if (UseSound==1) PlaySound(NameFileSound);
      if (TypeChart==1) Comment ("Buy signal at Ask=",Ask,", Bid=",Bid,", Date=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime())," Symbol=",Symbol()," Period=",Period());
      }
      
      else if(cwma5 < cwma50 && cwma20 < cwma50 && pwma5 >= pwma50 && pwma20 >= pwma50)
      {
        UpBuffer[i] = EMPTY_VALUE;
        DnBuffer[i] = iHigh(Symbol(),0,i)+(3*Point);
      if (UseSound==1) PlaySound(NameFileSound);
      if (TypeChart==1) Comment ("Sell signal at Ask=",Ask,", Bid=",Bid,", Date=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime())," Symbol=",Symbol()," Period=",Period());
      }
      else
      {
        DnBuffer[i] = EMPTY_VALUE;
        UpBuffer[i] = EMPTY_VALUE;
      }
      
      
      
  
   }
//----

   return(0);
  }
//+------------------------------------------------------------------+



