//+------------------------------------------------------------------+
//|                                                                  |
//|                                                          Kalenzo |
//|                                                  simone@konto.pl |
//|                                    Modified by Newdigital        |
//+------------------------------------------------------------------+

#property copyright "Kalenzo"
#property link      "simone@konto.pl"

#property indicator_chart_window
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_width1 5
#property indicator_width2 5

extern bool UseSound = False;
extern bool TypeChart = False;
extern bool UseAlert = true;
extern string NameFileSound = "alert.wav";
extern double ShortPeriod = 6;
extern int ShortPeriodMode =  1; //0=sma, 1=ema, 2=smma, 3=lwma
extern double BigPeriod = 21;
extern int BigPeriodMode =  0; //0=sma, 1=ema, 2=smma, 3=lwma
extern int DeltaForSell = 0;
extern int DeltaForBuy = 0;

#property indicator_buffers 2
//---- input parameters
//---- buffers
double UpBuffer[];
double DnBuffer[];
double alertBar;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators

  // IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_ARROW,EMPTY);
   SetIndexStyle(1,DRAW_ARROW,EMPTY);
  
   SetIndexBuffer(0,UpBuffer);
   SetIndexBuffer(1,DnBuffer);
  
   SetIndexArrow(0,233);
   SetIndexArrow(1,234);

   SetIndexLabel(0,"Up Signal");
   SetIndexLabel(1,"Down Signal");

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) counted_bars=0;
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   
  
   for(int i = 0 ;i < limit ;i++)
   { 
      double pwma5 = iMA(Symbol(),0,ShortPeriod,0,ShortPeriodMode,PRICE_CLOSE,i+1);
      double cwma5 = iMA(Symbol(),0,ShortPeriod,0,ShortPeriodMode,PRICE_CLOSE,i);
      
      double pwma50 = iMA(Symbol(),0,BigPeriod,0,BigPeriodMode,PRICE_CLOSE,i+1);
      double cwma50 = iMA(Symbol(),0,BigPeriod,0,BigPeriodMode,PRICE_CLOSE,i);
            
      if( cwma5 > (cwma50 +(DeltaForBuy*Point)) && pwma5 <= pwma50)
      {  
        UpBuffer[i] = iLow(Symbol(),0,i)-(3*Point);
        DnBuffer[i] = EMPTY_VALUE;
      if (UseSound==1) PlaySound(NameFileSound);
      if (UseAlert==1 && Bars>alertBar) {Alert(Symbol(), "Buy signal", Period());alertBar = Bars;}
      if (TypeChart==1) Comment ("Buy signal at Ask=",Ask,", Bid=",Bid,", Date=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime())," Symbol=",Symbol()," Period=",Period());
      }
      
      else if( pwma5 >= pwma50 && cwma5 < (cwma50 - (DeltaForSell*Point)))
      {
        UpBuffer[i] = EMPTY_VALUE;
        DnBuffer[i] = iHigh(Symbol(),0,i)+(3*Point);
      if (UseSound==1) PlaySound(NameFileSound);
      if (UseAlert==1 && Bars>alertBar) {Alert(Symbol(), "Sell signal", Period());alertBar = Bars;} 
      if (TypeChart==1) Comment ("Sell signal at Ask=",Ask,", Bid=",Bid,", Date=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime())," Symbol=",Symbol()," Period=",Period());
      }
      else
      {
        DnBuffer[i] = EMPTY_VALUE;
        UpBuffer[i] = EMPTY_VALUE;
      }
      
      
  
   }
//----

   return(0);
  }
//+------------------------------------------------------------------+



