//Version: 9
//Updated: December 22, 2006
//+------------------------------------------------------------------+
//|                       XP Moving Average                          | 
//|                                                         xpMA.mq4 |
//|                                         Developed by Coders Guru |
//|                                            http://www.xpworx.com |
//+------------------------------------------------------------------+

#property link      "http://www.xpworx.com"


#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Yellow
#property indicator_color2 Blue
#property indicator_color3 Red
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 2

#define MODE_DEMA    5
#define MODE_TEMA    4
#define MODE_T3MA    6
#define MODE_JMA     7
#define MODE_HMA     8
#define MODE_DECEMA  9
#define MODE_SATL    10
#define MODE_FATL    11
#define MODE_RSTL    12
#define MODE_SDL     13
#define MODE_KAMA    14
   
/* Moving average types constants:
------------------------------------
MODE_SMA       0     Simple moving average, 
MODE_EMA       1     Exponential moving average, 
MODE_SMMA      2     Smoothed moving average, 
MODE_LWMA      3     Linear weighted moving average.
MODE_DEMA      5     Double Exponential Moving Average. 
MODE_TEMA      4     Triple Exponential Moving Average.
MODE_T3MA      6     T3 Moving Average. 
MODE_JMA       7     Jurik Moving Average. 
MODE_HMA       8     Hull Moving Average. 
MODE_DECEMA    9     DECEMA Moving Average. 
MODE_SATL      10    Slow Adaptive Trend Line. 
MODE_FATL      11    Fast Adaptive Trend Line.
MODE_RSTL      12    Reference Slow Trend Line. 
MODE_SDL       13    Slope Direction Line. / HMA_Russian. 
MODE_KAMA      14    KAMA / Kaufman2 indicator.
------------------------------------*/

/* Applied price constants:
-------------------------------
PRICE_CLOSE    0     Close price. 
PRICE_OPEN     1     Open price. 
PRICE_HIGH     2     High price. 
PRICE_LOW      3     Low price. 
PRICE_MEDIAN   4     Median price, (high+low)/2. 
PRICE_TYPICAL  5     Typical price, (high+low+close)/3. 
PRICE_WEIGHTED 6     Weighted close price, (high+low+close+close)/4.
--------------------------------- */


   int      TimeFrame               = 0;
extern   int      MA_Period               = 34;
extern   string   MA_Type                 = "EMA";
   int      _maType                 = MODE_EMA;
extern   int      MA_Price                = PRICE_CLOSE;
extern   int      MA_Period2              = 34; // applies to DEMA, TEMA, KAMA(fast) only
extern   int      MA_Period3              = 34; // applies to TEMA, KAMA(slow) only
extern   double   T3MA_VolumeFactor       = 0.8;
extern   double   JMA_Phase               = 0;
extern   int      SDL_MAType              = MODE_EMA;
extern   int      Step_Period             = 4;
extern   bool     Show_Name               = true;
extern   bool     Alerts                  = true;
extern   bool     DebugMode               = false;

bool     Alert_On                = true;
bool     Arrows_On               = true;
int      UpArrowCode             = 241;
int      DownArrowCode           = 242;
color    UpArrowColor            = Red;
color    DownArrowColor          = Blue;
int      UpArrowSize             = 3;
int      DownArrowSize           = 3;
bool     Email_Alert             = false;
string   pro  = "xpMA_v9";
string   ver  = "";


double UpBuffer[];
double DownBuffer[];
double Buffer3[];
double buffer[];
double tempbuffer[];
double matriple[];
double signal[];

int    nShift;   

int init()
{
   if(!Alerts){
    Alert_On = false;
    Arrows_On = false;
   }


   if(MA_Type == "SMMA" || MA_Type == "2") _maType = MODE_SMMA;
   else if(MA_Type == "SMA" || MA_Type == "0") _maType = MODE_SMA;
   else if(MA_Type == "LWMA" || MA_Type == "3") _maType = MODE_LWMA;
   else if(MA_Type == "DEMA" || MA_Type == "5") _maType = MODE_DEMA;
   else if(MA_Type == "TEMA" || MA_Type == "4") _maType = MODE_TEMA;
   else if(MA_Type == "T3MA" || MA_Type == "6") _maType = MODE_T3MA;
   else if(MA_Type == "HMA" || MA_Type == "8") _maType = MODE_HMA;
   else if(MA_Type == "JMA" || MA_Type == "7") _maType = MODE_JMA;
   else if(MA_Type == "DECEMA" || MA_Type == "9") _maType = MODE_DECEMA;
   else if(MA_Type == "SATL" || MA_Type == "10") _maType = MODE_SATL;
   else if(MA_Type == "FATL" || MA_Type == "11") _maType = MODE_FATL;
   else if(MA_Type == "RSTL" || MA_Type == "12") _maType = MODE_RSTL;
   else if(MA_Type == "SDL" || MA_Type == "13") _maType = MODE_SDL;
   else if(MA_Type == "KAMA" || MA_Type == "14") _maType = MODE_KAMA;
   else _maType = MODE_EMA;

   DeleteStamp();
   ver = GenVer();
   DeleteAllObjects();
   IndicatorBuffers(7); 

   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,UpBuffer);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,DownBuffer);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,Buffer3);
   
   SetIndexBuffer(3,signal);
   SetIndexBuffer(4,buffer);
   SetIndexBuffer(5,tempbuffer);
   SetIndexBuffer(6,matriple);
   
   SetIndexLabel(0,"XP Moving Average");
   SetIndexLabel(1,"DownBuffer");
   SetIndexLabel(2,"UpBuffer");
   SetIndexLabel(3,"Signal");
   
    switch(Period())
      {
        case     1: nShift = 5;   break;    
        case     5: nShift = 7;   break; 
        case    15: nShift = 10;   break; 
        case    30: nShift = 15;  break; 
        case    60: nShift = 20;  break; 
        case   240: nShift = 30;  break; 
        case  1440: nShift = 80;  break; 
        case 10080: nShift = 150; break; 
        case 43200: nShift = 250; break;               
      }
   IndicatorShortName("xpMA " + GenVer());
 
   return(0);
}

int deinit()
{
   DeleteStamp();
   DeleteAllObjects();
   return(0);
}



void start()
{
   
   if(Show_Name) StampVersion(pro,ver,5,20);
   
   int limit;
   int i = 0;
   
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   
   switch (_maType)
   {
      case 0:
      case 1:
      case 2:
      case 3:
            {
                  for(i=0; i<limit; i++)
                  {
                     buffer[i] = iMA(NULL,TimeFrame,MA_Period,0,_maType,MA_Price,i);
                  }
            }
            break;
      
      case MODE_TEMA:
            {
                  for(i=0; i<limit; i++)
                  {
                     tempbuffer[i] = iMA(NULL,TimeFrame,MA_Period,0,MODE_EMA,MA_Price,i);
                  }
                  for(i=0; i<limit; i++)
                  {
                     matriple[i] = iMAOnArray(tempbuffer,0,MA_Period2,0,MODE_EMA,i);
                  }
                  for(i=0; i<limit; i++)
                  {
                     buffer[i] = iMAOnArray(matriple,0,MA_Period3,0,MODE_EMA,i);
                  }
            }
            break;
      
      case MODE_DEMA:
            {
                  for(i=0; i<limit; i++)
                  {
                     tempbuffer[i] = iMA(NULL,TimeFrame,MA_Period,0,MODE_EMA,MA_Price,i);
                  }
                  for(i=0; i<limit; i++)
                  {
                     buffer[i] = iMAOnArray(tempbuffer,0,MA_Period2,0,MODE_EMA,i);
                  }
            }
            break;
      
      case 6:
            {
                  for(i=0; i<limit; i++)
                  {
                     buffer[i] = iCustom(NULL,TimeFrame,"T3MA",MA_Period,T3MA_VolumeFactor,0,i);
                  }
            }
            break;
      case 7:
            {
                  for(i=0; i<limit; i++)
                  {
                     buffer[i] = iCustom(NULL,TimeFrame,"JMA",MA_Period,JMA_Phase,0,i);
                  }
            }
            break;
      
      case 8:
            {
                  for(i=0; i<limit; i++)
                  {
                     buffer[i] = iCustom(NULL,TimeFrame,"HMA",MA_Period,0,i);
                  }
            }
            break;
      
      case 9:
            {
                  for(i=0; i<limit; i++)
                  {
                     buffer[i] = iCustom(NULL,TimeFrame,"DECEMA_v1",MA_Period,MA_Price,0,i);
                  }
            }
            break;

      case MODE_SATL:
            if(limit > 64) for(i=0; i<limit; i++) buffer[i] = SATL(i, MA_Price);    
            break;
      case MODE_FATL:
            if(limit > 44) for(i=0; i<limit; i++) buffer[i] = FATL(i, MA_Price);    
            break;
      case MODE_RSTL:
            if(limit > 98) for(i=0; i<limit; i++) buffer[i] = RSTL(i, MA_Price);    
            break;
      case MODE_SDL:
            for(i=0; i<limit; i++)
              buffer[i] = iCustom(NULL, TimeFrame, "Slope Direction Line", MA_Period, SDL_MAType, MA_Price, 0,i);
            break;
      case MODE_KAMA:            
            i = limit-180; 
            if(i < 180) i = 180;
            if(i < Bars){
              double AMA0 = price(MA_Price, i+1);              
              while(i >= 0){
                if(i == 0) AMA0 = buffer[1]; 
                buffer[i] = Kaufman2(MA_Period, MA_Period2, MA_Period3, 2, i, AMA0, MA_Price);
                AMA0 = buffer[i];  
                i--;
              }
            }
            break;
   }

   for(int shift=0; shift<limit; shift++)
   {
       UpBuffer[shift] = buffer[shift];
       DownBuffer[shift] = buffer[shift];
       Buffer3[shift] = buffer[shift];
   }                   
   
   /*for(shift=0; shift<limit; shift++)
   {
      if (buffer[shift]<buffer[shift+1])
      {
         UpBuffer[shift] = EMPTY_VALUE;
      }
      else if (buffer[shift]>buffer[shift+1] )
      {
         DownBuffer[shift] = EMPTY_VALUE;
      } 
     else
      {
         UpBuffer[shift] = CLR_NONE;
         DownBuffer[shift] = CLR_NONE;
      }
   }*/
   
   for(shift=0; shift<limit; shift++)
   {
      double dMA = 0;
      for(int k = shift+1; k <= shift+Step_Period; k++){
         dMA += buffer[k];
      }
      dMA = dMA / Step_Period;

      if (buffer[shift] < dMA)
      {
         UpBuffer[shift] = EMPTY_VALUE;
      }
      else if (buffer[shift]>dMA)
      {
         DownBuffer[shift] = EMPTY_VALUE;
      } 
      else
      {
         UpBuffer[shift] = EMPTY_VALUE;
         DownBuffer[shift] = EMPTY_VALUE;
      }
   }
   for(shift=0; shift<limit; shift++)
   {
         signal[shift]=0;
         if(UpBuffer[shift+1] == EMPTY_VALUE &&  UpBuffer[shift] != EMPTY_VALUE && Buffer3[shift+1] != UpBuffer[shift] )
            {
               if(Arrows_On && shift !=0) DrawObject(1,shift, buffer[shift] - nShift*Point);
               if(Arrows_On && shift ==0) DrawOnce(1,shift, buffer[shift] - nShift*Point,1);
               signal[shift] = 1;
            }
            
         if(DownBuffer[shift+1] == EMPTY_VALUE &&  DownBuffer[shift] != EMPTY_VALUE && Buffer3[shift+1] != DownBuffer[shift])
           {
               if(Arrows_On && shift !=0) DrawObject(2,shift, buffer[shift] + nShift*Point);
               if(Arrows_On && shift ==0) DrawOnce(2,shift, buffer[shift] + nShift*Point,2);
               signal[shift] = -1;
           }
   } 
   
   if(Alert_On)
   {                  
      if(UpBuffer[1] == EMPTY_VALUE &&  UpBuffer[0] != EMPTY_VALUE && Buffer3[1] != UpBuffer[0])
         AlertOnce(Symbol()+ ":" + PeriodToText() + "  -  Up Signal",1);
      if(DownBuffer[1] == EMPTY_VALUE &&  DownBuffer[0] != EMPTY_VALUE && Buffer3[1] != DownBuffer[0])   
         AlertOnce(Symbol()+ ":" + PeriodToText() + "  -  Down Signal",2);
   }
   
   if(Email_Alert)
   {                  
      if(UpBuffer[1] == EMPTY_VALUE &&  UpBuffer[0] != EMPTY_VALUE && Buffer3[1] != UpBuffer[0])
         SendMailOnce("xpMA Signal",Symbol()+ ":" + PeriodToText() + "  -  Up Signal",1);
      if(DownBuffer[1] == EMPTY_VALUE &&  DownBuffer[0] != EMPTY_VALUE && Buffer3[1] != DownBuffer[0])   
         SendMailOnce("xpMA Signal",Symbol()+ ":" + PeriodToText() + "  -  Down Signal",2);
   }

   
   if(DebugMode)
   { 
      TakeScreenShot(40);
   }

   return(0);
}

bool DrawOnce(int direction, int bar , double price, int ref)
{  
   static int LastDraw_1 = 0;
   static int LastDraw_2 = 0;
   static int LastDraw_3 = 0;
   static int LastDraw_4 = 0;
   
   switch(ref)
   {
      case 1:
         if( LastDraw_1 == 0 || LastDraw_1 < Bars )
         {
            DrawObject(direction, bar , price);
            LastDraw_1 = Bars;
            return (1);
         }
      break;
      case 2:
         if( LastDraw_2 == 0 || LastDraw_2 < Bars )
         {
            DrawObject(direction, bar , price);
            LastDraw_2 = Bars;
            return (1);
         }
      break;
      case 3:
         if( LastDraw_3 == 0 || LastDraw_3 < Bars )
         {
            DrawObject(direction, bar , price);
            LastDraw_3 = Bars;
            return (1);
         }
      break;
      case 4:
         if( LastDraw_4 == 0 || LastDraw_4 < Bars )
         {
            DrawObject(direction, bar , price);
            LastDraw_4 = Bars;
            return (1);
         }
      break;
   }
}

void DrawObject(int direction, int bar , double price)
{

   static int count = 0;
   count++;
   string Obj = "";
   if (direction==1) //up arrow
   {
      Obj = "xpMA_up_" + DoubleToStr(count,0);
      ObjectCreate(Obj,OBJ_ARROW,0,Time[bar],price);
      ObjectSet(Obj,OBJPROP_COLOR,UpArrowColor);
      ObjectSet(Obj,OBJPROP_ARROWCODE,UpArrowCode);
      ObjectSet(Obj,OBJPROP_WIDTH,DownArrowSize);
   }
   if (direction==2) //down arrow
   {
      Obj = "xpMA_down_" + DoubleToStr(count,0);
      ObjectCreate(Obj,OBJ_ARROW,0,Time[bar],price);
      ObjectSet(Obj,OBJPROP_COLOR,DownArrowColor);
      ObjectSet(Obj,OBJPROP_ARROWCODE,DownArrowCode);
      ObjectSet(Obj,OBJPROP_WIDTH,DownArrowSize);
   }
   ObjectsRedraw();
}

void DeleteAllObjects()
{
   int objs = ObjectsTotal();
   string name;
   for(int cnt=ObjectsTotal()-1;cnt>=0;cnt--)
   {
      name=ObjectName(cnt);
      if (StringFind(name,"xpMA",0)>-1) ObjectDelete(name);
      ObjectsRedraw();
   }
}

bool AlertOnce(string alert_msg, int ref)
{  
   static int LastAlert_1 = 0;
   static int LastAlert_2 = 0;
   static int LastAlert_3 = 0;
   static int LastAlert_4 = 0;
   
   switch(ref)
   {
      case 1:
         if( LastAlert_1 == 0 || LastAlert_1 < Bars )
         {
            Alert(alert_msg);
            LastAlert_1 = Bars;
            return (1);
         }
      break;
      case 2:
         if( LastAlert_2 == 0 || LastAlert_2 < Bars )
         {
            Alert(alert_msg);
            LastAlert_2 = Bars;
            return (1);
         }
      break;
      case 3:
         if( LastAlert_3 == 0 || LastAlert_3 < Bars )
         {
            Alert(alert_msg);
            LastAlert_3 = Bars;
            return (1);
         }
      break;
      case 4:
         if( LastAlert_4 == 0 || LastAlert_4 < Bars )
         {
            Alert(alert_msg);
            LastAlert_4 = Bars;
            return (1);
         }
      break;
   }
}

bool SendMailOnce(string subject, string mail_msg, int ref)
{  
   static int LastMail_1 = 0;
   static int LastMail_2 = 0;
   static int LastMail_3 = 0;
   static int LastMail_4 = 0;
   
   switch(ref)
   {
      case 1:
         if( LastMail_1 == 0 || LastMail_1 < Bars )
         {
            SendMail(subject,mail_msg);
            LastMail_1 = Bars;
            return (1);
         }
      break;
      case 2:
         if( LastMail_2 == 0 || LastMail_2 < Bars )
         {
            SendMail(subject,mail_msg);
            LastMail_2 = Bars;
            return (1);
         }
      break;
      case 3:
         if( LastMail_3 == 0 || LastMail_3 < Bars )
         {
            SendMail(subject,mail_msg);
            LastMail_3 = Bars;
            return (1);
         }
      break;
      case 4:
         if( LastMail_4 == 0 || LastMail_4 < Bars )
         {
            SendMail(subject,mail_msg);
            LastMail_4 = Bars;
            return (1);
         }
      break;
   }
}

void TakeScreenShot(int exit_on = -1)
{
   int count = 1;
   
   if(!GlobalVariableCheck("ssc"))
   {
    GlobalVariableSet("ssc",1);
    count = 1;
   }
   else
   {
      count = GlobalVariableGet("ssc") + 1;
      GlobalVariableSet("ssc",count); 
   }
   
   if ( exit_on > 0 && count > exit_on ) return(0);
   
   string filename = "xpMA\\" + "xpMA_" + Symbol() +  "_" + DoubleToStr(count,0) + ".jpg";
   ScreenShot(filename,320,480);
}
string PeriodToText()
{
   switch (Period())
   {
      case 1:
            return("M1");
            break;
      case 5:
            return("M5");
            break;
      case 15:
            return("M15");
            break;
      case 30:
            return("M30");
            break;
      case 60:
            return("H1");
            break;
      case 240:
            return("H4");
            break;
      case 1440:
            return("D1");
            break;
      case 10080:
            return("W1");
            break;
      case 43200:
            return("MN1");
            break;
   }
}

void StampVersion(string pro , string ver , int x , int y)
{
   string Obj="Stamp_" + pro;
   int objs = ObjectsTotal();
   string name;
  
   for(int cnt=0;cnt<ObjectsTotal();cnt++)
   {
      name=ObjectName(cnt);
      if (StringFind(name,Obj,0)>-1) 
      {
         ObjectSet(Obj,OBJPROP_XDISTANCE,x);
         ObjectSet(Obj,OBJPROP_YDISTANCE,y);
         ObjectsRedraw();
      }
      else
      {
         ObjectCreate(Obj,OBJ_LABEL,0,0,0);
         ObjectSetText(Obj,pro + " - " + ver,8,"arial",Orange);
         ObjectSet(Obj,OBJPROP_XDISTANCE,x);
         ObjectSet(Obj,OBJPROP_YDISTANCE,y);
         ObjectsRedraw();
      }
   }
   if (ObjectsTotal() == 0)
   {
         ObjectCreate(Obj,OBJ_LABEL,0,0,0);
         ObjectSetText(Obj,pro + " - " + ver,8,"arial",Orange);
         ObjectSet(Obj,OBJPROP_XDISTANCE,x);
         ObjectSet(Obj,OBJPROP_YDISTANCE,y);
         ObjectsRedraw();

   }
   
   return(0);
}
void DeleteStamp()
{
   int objs = ObjectsTotal();
   string name;
   for(int cnt=ObjectsTotal()-1;cnt>=0;cnt--)
   {
      name=ObjectName(cnt);
      if (StringFind(name,"Stamp",0)>-1) ObjectDelete(name);
      ObjectsRedraw();
   }
}

string GenVer()
{
   string t1 = "";
   if(_maType == MODE_SMA) t1="SMA"; 
   else if(_maType == MODE_EMA) t1="EMA"; 
   else if(_maType == MODE_SMMA) t1="SMMA"; 
   else if(_maType == MODE_LWMA) t1="LWMA"; 
   else if(_maType == MODE_DEMA) t1="DEMA"; 
   else if(_maType == MODE_TEMA) t1="TEMA"; 
   else if(_maType == MODE_T3MA) t1="T3MA"; 
   else if(_maType == MODE_JMA) t1="JMA"; 
   else if(_maType == MODE_HMA) t1="HMA";
   else if(_maType == MODE_DECEMA) t1="DECEMA";
   else if(_maType == MODE_FATL) return("FATL");
   else if(_maType == MODE_SATL) return("SATL");
   else if(_maType == MODE_RSTL) return("RSTL");
   else if(_maType == MODE_SDL) return("SDL ("+MA_Period+","+SDL_MAType+")");
   else if(_maType == MODE_KAMA) return("KAMA ("+MA_Period+","+MA_Period2+","+MA_Period3+")");
   
   return (t1+"("+MA_Period+")"); 
}



double FATL(int i, int price){
  return(
  -0.02232324*price(price, i+0) 
  +0.02268676*price(price, i+1) 
  +0.08389067*price(price, i+2) 
  +0.14630380*price(price, i+3) 
  +0.19282649*price(price, i+4) 
  +0.21002638*price(price, i+5) 
  +0.19282649*price(price, i+6) 
  +0.14630380*price(price, i+7) 
  +0.08389067*price(price, i+8) 
  +0.02268676*price(price, i+9) 
  -0.02232324*price(price, i+10) 
  -0.04296564*price(price, i+11) 
  -0.03980614*price(price, i+12) 
  -0.02082171*price(price, i+13) 
  +0.00243636*price(price, i+14) 
  +0.01950580*price(price, i+15) 
  +0.02460929*price(price, i+16) 
  +0.01799295*price(price, i+17) 
  +0.00470540*price(price, i+18) 
  -0.00831985*price(price, i+19) 
  -0.01544722*price(price, i+20) 
  -0.01456262*price(price, i+21) 
  -0.00733980*price(price, i+22) 
  +0.00201852*price(price, i+23) 
  +0.00902504*price(price, i+24) 
  +0.01093067*price(price, i+25) 
  +0.00766099*price(price, i+26) 
  +0.00145478*price(price, i+27) 
  -0.00447175*price(price, i+28) 
  -0.00750446*price(price, i+29) 
  -0.00671646*price(price, i+30) 
  -0.00304016*price(price, i+31) 
  +0.00143433*price(price, i+32) 
  +0.00457475*price(price, i+33) 
  +0.00517589*price(price, i+34) 
  +0.00336708*price(price, i+35) 
  +0.00034406*price(price, i+36) 
  -0.00233637*price(price, i+37) 
  -0.00352280*price(price, i+38) 
  -0.00293522*price(price, i+39) 
  -0.00114249*price(price, i+40) 
  +0.00083536*price(price, i+41) 
  +0.00215524*price(price, i+42) 
  +0.00604133*price(price, i+43) 
  -0.00013046*price(price, i+44));
}


double SATL(int i, int price){
 //if(i < 64) return(0);

 return(  
  0.0982862174*price(price, i+0)
  +0.0975682269*price(price, i+1) 
  +0.0961401078*price(price, i+2) 
  +0.0940230544*price(price, i+3) 
  +0.0912437090*price(price, i+4) 
  +0.0878391006*price(price, i+5) 
  +0.0838544303*price(price, i+6) 
  +0.0793406350*price(price, i+7) 
  +0.0743569346*price(price, i+8) 
  +0.0689666682*price(price, i+9) 
  +0.0632381578*price(price, i+10) 
  +0.0572428925*price(price, i+11) 
  +0.0510534242*price(price, i+12) 
  +0.0447468229*price(price, i+13) 
  +0.0383959950*price(price, i+14) 
  +0.0320735368*price(price, i+15) 
  +0.0258537721*price(price, i+16) 
  +0.0198005183*price(price, i+17) 
  +0.0139807863*price(price, i+18) 
  +0.0084512448*price(price, i+19) 
  +0.0032639979*price(price, i+20) 
  -0.0015350359*price(price, i+21) 
  -0.0059060082*price(price, i+22) 
  -0.0098190256*price(price, i+23) 
  -0.0132507215*price(price, i+24) 
  -0.0161875265*price(price, i+25) 
  -0.0186164872*price(price, i+26) 
  -0.0205446727*price(price, i+27) 
  -0.0219739146*price(price, i+28) 
  -0.0229204861*price(price, i+29) 
  -0.0234080863*price(price, i+30) 
  -0.0234566315*price(price, i+31) 
  -0.0231017777*price(price, i+32) 
  -0.0223796900*price(price, i+33) 
  -0.0213300463*price(price, i+34) 
  -0.0199924534*price(price, i+35) 
  -0.0184126992*price(price, i+36) 
  -0.0166377699*price(price, i+37) 
  -0.0147139428*price(price, i+38) 
  -0.0126796776*price(price, i+39) 
  -0.0105938331*price(price, i+40) 
  -0.0084736770*price(price, i+41) 
  -0.0063841850*price(price, i+42) 
  -0.0043466731*price(price, i+43) 
  -0.0023956944*price(price, i+44) 
  -0.0005535180*price(price, i+45) 
  +0.0011421469*price(price, i+46) 
  +0.0026845693*price(price, i+47) 
  +0.0040471369*price(price, i+48) 
  +0.0052380201*price(price, i+49) 
  +0.0062194591*price(price, i+50) 
  +0.0070340085*price(price, i+51) 
  +0.0076266453*price(price, i+52) 
  +0.0080376628*price(price, i+53) 
  +0.0083037666*price(price, i+54) 
  +0.0083694798*price(price, i+55) 
  +0.0082901022*price(price, i+56) 
  +0.0080741359*price(price, i+57) 
  +0.0077543820*price(price, i+58) 
  +0.0073260526*price(price, i+59) 
  +0.0068163569*price(price, i+60) 
  +0.0062325477*price(price, i+61) 
  +0.0056078229*price(price, i+62) 
  +0.0049516078*price(price, i+63) 
  +0.0161380976*price(price, i+64));
}


double price(int type, int shift){
 switch(type){
  case 1: return(Open[shift]);
  case 2: return(High[shift]);
  case 3: return(Low[shift]);
  case 4: return((High[shift]+Low[shift])/2);
  case 5: return((High[shift]+Low[shift]+Close[shift])/3);
  case 6: return((High[shift]+Low[shift]+Close[shift]+Close[shift])/4);
  default: return(Close[shift]);
 }
}


double RSTL(int i, int price){
  return(
  -0.00514293*price(price, i+0) 
  -0.00398417*price(price, i+1) 
  -0.00262594*price(price, i+2) 
  -0.00107121*price(price, i+3) 
  +0.00066887*price(price, i+4) 
  +0.00258172*price(price, i+5) 
  +0.00465269*price(price, i+6) 
  +0.00686394*price(price, i+7) 
  +0.00919334*price(price, i+8) 
  +0.01161720*price(price, i+9) 
  +0.01411056*price(price, i+10) 
  +0.01664635*price(price, i+11) 
  +0.01919533*price(price, i+12) 
  +0.02172747*price(price, i+13) 
  +0.02421320*price(price, i+14) 
  +0.02662203*price(price, i+15) 
  +0.02892446*price(price, i+16) 
  +0.03109071*price(price, i+17) 
  +0.03309496*price(price, i+18) 
  +0.03490921*price(price, i+19) 
  +0.03651145*price(price, i+20) 
  +0.03788045*price(price, i+21) 
  +0.03899804*price(price, i+22) 
  +0.03984915*price(price, i+23) 
  +0.04042329*price(price, i+24) 
  +0.04071263*price(price, i+25) 
  +0.04071263*price(price, i+26) 
  +0.04042329*price(price, i+27) 
  +0.03984915*price(price, i+28) 
  +0.03899804*price(price, i+29) 
  +0.03788045*price(price, i+30) 
  +0.03651145*price(price, i+31) 
  +0.03490921*price(price, i+32) 
  +0.03309496*price(price, i+33) 
  +0.03109071*price(price, i+34) 
  +0.02892446*price(price, i+35) 
  +0.02662203*price(price, i+36) 
  +0.02421320*price(price, i+37) 
  +0.02172747*price(price, i+38) 
  +0.01919533*price(price, i+39) 
  +0.01664635*price(price, i+40) 
  +0.01411056*price(price, i+41) 
  +0.01161720*price(price, i+42) 
  +0.00919334*price(price, i+43) 
  +0.00686394*price(price, i+44) 
  +0.00465269*price(price, i+45) 
  +0.00258172*price(price, i+46) 
  +0.00066887*price(price, i+47) 
  -0.00107121*price(price, i+48) 
  -0.00262594*price(price, i+49) 
  -0.00398417*price(price, i+50) 
  -0.00514293*price(price, i+51) 
  -0.00609634*price(price, i+52) 
  -0.00684602*price(price, i+53) 
  -0.00739452*price(price, i+54) 
  -0.00774847*price(price, i+55) 
  -0.00791630*price(price, i+56) 
  -0.00790940*price(price, i+57) 
  -0.00774085*price(price, i+58) 
  -0.00742482*price(price, i+59) 
  -0.00697718*price(price, i+60) 
  -0.00641613*price(price, i+61) 
  -0.00576108*price(price, i+62) 
  -0.00502957*price(price, i+63) 
  -0.00423873*price(price, i+64) 
  -0.00340812*price(price, i+65) 
  -0.00255923*price(price, i+66) 
  -0.00170217*price(price, i+67) 
  -0.00085902*price(price, i+68) 
  -0.00004113*price(price, i+69) 
  +0.00073700*price(price, i+70) 
  +0.00146422*price(price, i+71) 
  +0.00213007*price(price, i+72) 
  +0.00272649*price(price, i+73) 
  +0.00324752*price(price, i+74) 
  +0.00368922*price(price, i+75) 
  +0.00405000*price(price, i+76) 
  +0.00433024*price(price, i+77) 
  +0.00453068*price(price, i+78) 
  +0.00465046*price(price, i+79) 
  +0.00469058*price(price, i+80) 
  +0.00466041*price(price, i+81) 
  +0.00457855*price(price, i+82) 
  +0.00442491*price(price, i+83) 
  +0.00423019*price(price, i+84) 
  +0.00399201*price(price, i+85) 
  +0.00372169*price(price, i+86) 
  +0.00342736*price(price, i+87) 
  +0.00311822*price(price, i+88) 
  +0.00280309*price(price, i+89) 
  +0.00249088*price(price, i+90) 
  +0.00219089*price(price, i+91) 
  +0.00191283*price(price, i+92) 
  +0.00166683*price(price, i+93) 
  +0.00146419*price(price, i+94) 
  +0.00131867*price(price, i+95) 
  +0.00124645*price(price, i+96) 
  +0.00126836*price(price, i+97) 
  -0.00401854*price(price, i+98));
}


double RFTL(int i, int price){
  return(
  -0.02232324*price(price, i+0)
  +0.02268676*price(price, i+1)
  +0.08389067*price(price, i+2)
  +0.14630380*price(price, i+3)
  +0.19282649*price(price, i+4)
  +0.21002638*price(price, i+5)
  +0.19282649*price(price, i+6)
  +0.14630380*price(price, i+7)
  +0.08389067*price(price, i+8)
  +0.02268676*price(price, i+9)
  -0.02232324*price(price, i+10)
  -0.04296564*price(price, i+11)
  -0.03980614*price(price, i+12)
  -0.02082171*price(price, i+13)
  +0.00243636*price(price, i+14)
  +0.01950580*price(price, i+15)
  +0.02460929*price(price, i+16)
  +0.01799295*price(price, i+17)
  +0.00470540*price(price, i+18)
  -0.00831985*price(price, i+19)
  -0.01544722*price(price, i+20)
  -0.01456262*price(price, i+21)
  -0.00733980*price(price, i+22)
  +0.00201852*price(price, i+23)
  +0.00902504*price(price, i+24)
  +0.01093067*price(price, i+25)
  +0.00766099*price(price, i+26)
  +0.00145478*price(price, i+27)
  -0.00447175*price(price, i+28)
  -0.00750446*price(price, i+29)
  -0.00671646*price(price, i+30)
  -0.00304016*price(price, i+31)
  +0.00143433*price(price, i+32)
  +0.00457475*price(price, i+33)
  +0.00517589*price(price, i+34)
  +0.00336708*price(price, i+35)
  +0.00034406*price(price, i+36)
  -0.00233637*price(price, i+37)
  -0.00352280*price(price, i+38)
  -0.00293522*price(price, i+39)
  -0.00114249*price(price, i+40)
  +0.00083536*price(price, i+41)
  +0.00215524*price(price, i+42)
  +0.00604133*price(price, i+43)
  -0.00013046*price(price, i+44));
}

double Kaufman2(int periodAMA, int nfast, int nslow, int G, int shift, double prevKaufman, int p){
  double signal = MathAbs(price(p,shift) - price(p, shift+periodAMA));
  double noise=0, slowSC = 2.0 /(nslow+1), fastSC = 2.0 /(nfast+1);
  for(int i=0; i<periodAMA; i++)
    noise = noise + MathAbs(price(p, shift+i) - price(p, shift+i+1));
  double ER = signal / noise;
  double dSC = (fastSC - slowSC);
  double ERSC = ER * dSC;
  double wlxSSC = ERSC + slowSC;
  return(prevKaufman + (MathPow(wlxSSC,G) * (price(p, shift)-prevKaufman)));
}


