//Version: 1
//Time: November 30, 2006
//+------------------------------------------------------------------+
//|                              xpVolume                            | 
//|                                                     xpVolume.mq4 |
//|                                         Developed by Coders Guru |
//|                                            http://www.xpworx.com |
//+------------------------------------------------------------------+

#property link      "http://www.xpworx.com"


#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Green
#property indicator_color2 Red


 
extern   int      MA_Period_1               = 6;
extern   int      MA_Period_2               = 24;
extern   int      MA_Type_1                 = MODE_SMA;
extern   int      MA_Type_2                 = MODE_SMA;

double UpBuffer[];
double DnBuffer[];
double Vol[];

int init()
{
   IndicatorBuffers(3); 

   SetIndexStyle(0,DRAW_HISTOGRAM, STYLE_SOLID,4);
   SetIndexBuffer(0,UpBuffer);
    SetIndexStyle(1,DRAW_HISTOGRAM, STYLE_SOLID,4);
   SetIndexBuffer(1,DnBuffer);
   SetIndexBuffer(2,Vol);
   return(0);
}

int deinit()
{
   return(0);
}



void start()
{
   int limit;
   double ma_1,ma_2;
   
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   limit=Bars-counted_bars-1;
   

   for(int shift=0; shift<limit; shift++)
       Vol[shift] = iVolume(NULL,0,shift);

   for(shift=0; shift<limit; shift++)
   {       
      ma_1 = iMAOnArray(Vol,0,MA_Period_1,0,MA_Type_1,shift);
      ma_2 = iMAOnArray(Vol,0,MA_Period_2,0,MA_Type_2,shift);
      
      UpBuffer[shift]=0;
      DnBuffer[shift]=0;
      Vol[shift]=0;
       
       if(ma_1-ma_2>=0)
       { 
         UpBuffer[shift] = ma_1-ma_2 ;
       }
       else
       { 
         DnBuffer[shift] = ma_1-ma_2 ;
       }
   }                   

   

   return(0);
}


