//+------------------------------------------------------------------+
//|                                                        Clock.mq4 |
//|                                                           Jerome |
//|                                              4xCoder@4xCoder.com |
//+------------------------------------------------------------------+
#property copyright "Jerome"
#property link      "4xCoder@4xCoder.com"

//------------------------------------------------------------------
// Instructions
//    BrokerTZ  - Timezone of your Broker (in hours from GMT)
//    LocalTz   - Your timezone in hours from GMT
//    DST       - Is it daylight savings time?
//    ShowLocal - Set to tru to show your local time zone
//    corner    - 0 = top left, 1 = top right, 2 = bottom left, 3 = bottom right
//    topOff    - pixels from top to show the clock
//    labelColor- Color of label
//    clockColor- Color of clock
//    show12HourTime - true show 12 hour time, false, show 24 hour time
//
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Red


//---- input parameters
extern double       BrokerTZ=1;
extern double       LocalTz=1;
extern bool         ShowLocal=true;
extern bool         AsianZone=true;
extern bool         DST=false;
extern int          corner=2;
extern int          topOff=100;
extern color        labelColor=Red;
extern color        clockColor=Red;
extern bool         show12HourTime=false;

//---- buffers
double ExtMapBuffer1[];
int TokyoTZ = 8;
int LondonTZ = 1;
int NewYorkTZ = -4;

string TimeToString( datetime when ) {
   if ( !show12HourTime )
      return (TimeToStr( when, TIME_MINUTES ));
      
   int hour = TimeHour( when );
   int minute = TimeMinute( when );
   
   string ampm = " AM";
   
   string timeStr;
   if ( hour >= 12 ) {
      hour = hour - 12;
      ampm = " PM";
   }
      
   if ( hour == 0 )
      hour = 12;
   timeStr = DoubleToStr( hour, 0 ) + ":";
   if ( minute < 10 )
      timeStr = timeStr + "0";
   timeStr = timeStr + DoubleToStr( minute, 0 );
   timeStr = timeStr + ampm;
   
   return (timeStr);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----
   int dstDelta=-1;
   if ( DST )
      dstDelta = 0;
   double local;
   datetime brokerTime = CurTime();
   datetime GMT = brokerTime - (BrokerTZ)*3600;
     if ( AsianZone ) 
          local = GMT + (LocalTz ) * 3600;
     else local = GMT + (LocalTz+dstDelta) * 3600;
  
   datetime london = GMT + (LondonTZ+dstDelta) * 3600;
   datetime tokyo = GMT + (TokyoTZ )* 3600;
   datetime newyork = GMT + (NewYorkTZ+dstDelta) * 3600;
   
   //Print( brokerTime, " ", GMT, " ", local, " ", london, " ", tokyo, " ", newyork  );
   string GMTs = TimeToString( GMT );
   string locals = TimeToString( local );
   string londons = TimeToString( london );
   string tokyos = TimeToString( tokyo );
   string newyorks = TimeToString( newyork );
   string brokers = TimeToString( CurTime() );
   string bars = TimeToStr( CurTime() - Time[0], TIME_MINUTES );
      
   if ( ShowLocal ) {
      ObjectSetText( "locl", "Local:", 10, "Arial", labelColor );
      ObjectSetText( "loct", locals, 10, "Arial", clockColor );
   }
   ObjectSetText( "gmtl", "GMT", 8, "Arial", labelColor );
   ObjectSetText( "gmtt", GMTs, 8, "Arial", clockColor );
   ObjectSetText( "brol", "Broker:", 8, "Arial", labelColor );
   ObjectSetText( "brot", brokers, 8, "Arial", clockColor );
   ObjectSetText( "nyl", "New York:", 8, "Arial", labelColor );
   ObjectSetText( "nyt", newyorks, 8, "Arial", clockColor );
   ObjectSetText( "lonl", "London:", 8, "Arial", labelColor );
   ObjectSetText( "lont", londons, 8, "Arial", clockColor );
   ObjectSetText( "tokl", "Tokyo:", 8, "Arial", labelColor );
   ObjectSetText( "tokt", tokyos, 8, "Arial", clockColor );
   ObjectSetText( "barl", "Bar:", 8, "Arial", labelColor );
   ObjectSetText( "bart", bars, 8, "Arial", clockColor );
   
//----
   return(0);
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int ObjectMakeLabel( string n, int xoff, int yoff ) {
   ObjectCreate( n, OBJ_LABEL, 0, 0, 0 );
   ObjectSet( n, OBJPROP_CORNER, corner );
   ObjectSet( n, OBJPROP_XDISTANCE, xoff );
   ObjectSet( n, OBJPROP_YDISTANCE, yoff );
   ObjectSet( n, OBJPROP_BACK, true );
}

int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   
   int top=topOff;
   int left = 90;
   if ( show12HourTime )
      left = 102;
   if ( ShowLocal ) {
      ObjectMakeLabel( "locl", left-25, top );
      ObjectMakeLabel( "loct", 7, top );
   }
   ObjectMakeLabel( "brol", left-25, top-15 );
   ObjectMakeLabel( "brot", 7, top-15 );
   ObjectMakeLabel( "gmtl", left-25, top-30 );
   ObjectMakeLabel( "gmtt", 7, top-30 );
   ObjectMakeLabel( "nyl",  left-25, top-45 );
   ObjectMakeLabel( "nyt",  7, top-45 );
   ObjectMakeLabel( "lonl", left-25, top-60 );
   ObjectMakeLabel( "lont", 7, top-60 );
   ObjectMakeLabel( "tokl", left-25, top-75 );
   ObjectMakeLabel( "tokt", 7, top-75 );
   ObjectMakeLabel( "barl", left-25, top-90 );
   ObjectMakeLabel( "bart", 7, top-90 );
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   ObjectDelete( "locl" );
   ObjectDelete( "loct" );
   ObjectDelete( "nyl" );
   ObjectDelete( "nyt" );
   ObjectDelete( "gmtl" );
   ObjectDelete( "gmtt" );
   ObjectDelete( "lonl" );
   ObjectDelete( "lont" );
   ObjectDelete( "tokl" );
   ObjectDelete( "tokt" );
   ObjectDelete( "brol" );
   ObjectDelete( "brot" );
   ObjectDelete( "barl" );
   ObjectDelete( "bart" );
//----
   return(0);
  }



