//+------------------------------------------------------------------+
//|                                            BucCrossLineAlert.mq4 |
//|                                    Copyright  2007, Petr Kouril |
//|                                           http://www.jaktrade.cz |
//+------------------------------------------------------------------+

// Revision 1

#property copyright "Copyright  2007, Petr Kouril"
#property link      "http://www.jaktrade.cz"

#property indicator_chart_window


extern color      LineColor        = Coral;
extern color      LineColorDone    = DimGray;
extern bool       SendMailPossible = true;  
extern bool       AlertPossible    = true;               
extern string     AlertSound       = "crossline.wav";

#define MAXLINES     32
#define PRICEDIFF    100.0

double LineArray[MAXLINES];
string StringArray[MAXLINES];
int    LineNum = 0;
int    DoneNum = 0;
bool   DashDot = true;

int init()
{
   return(0);
}

int deinit()
{
   Comment("");
   return(0);
}

int start()
{
   FindLines();
   CheckCrossLine();
      
// Comment(LineNum, ", ", LineArray[0]);
   return(0);
}

void FindLines()
{
   int    ObjType, ObjTotal = ObjectsTotal();
   string ObjName;
   double ObjValue;

   if (DashDot)
      DashDot = false;
   else
      DashDot = true;
         
   LineNum = 0;   
   for(int i = 0; i < ObjTotal; i++)
   {
      ObjName = ObjectName(i);
      ObjType = ObjectType(ObjName);
      if ((ObjType == OBJ_HLINE) || (ObjType == OBJ_TREND))
      {
         if ((StringGetChar(ObjName, 0) == 'C') || (StringGetChar(ObjName, 0) == 'c')) 
         {
            switch (ObjType)
            {
               case OBJ_HLINE: ObjValue = ObjectGet(ObjName, OBJPROP_PRICE1); break;
               case OBJ_TREND: ObjValue = ObjectGetValueByShift(ObjName, 0);  break;
            }
               
            if (GetObjectDoneValueString(ObjName) != ObjectDescription(ObjName))
            {
               ObjectSet(ObjName, OBJPROP_COLOR, LineColor);
               ObjectSet(ObjName, OBJPROP_WIDTH, 1);
               if (DashDot)
                  ObjectSet(ObjName, OBJPROP_STYLE, STYLE_DASHDOT);
               else
                  ObjectSet(ObjName, OBJPROP_STYLE, STYLE_DASHDOTDOT);
               
               LineArray[LineNum]   = ObjValue;                  
               StringArray[LineNum] = ObjName;
               LineNum++;
            }
         }
         if (LineNum == MAXLINES) break;
      }
   }
}

string GetObjectDoneValueString(string ObjName)
{
   return (StringConcatenate(ObjectGet(ObjName, OBJPROP_PRICE1), "  ", ObjectGet(ObjName, OBJPROP_PRICE2)));
}

void CheckCrossLine()
{
   double cHigh = iHigh(Symbol(), PERIOD_M1, 0);
   double cLow  = iLow (Symbol(), PERIOD_M1, 0);
   
   for (int i = 0; i < LineNum; i++)
   {
      if ((LineArray[i] < cHigh) && (LineArray[i] > cLow))
      {
         AlertCrossLine(i);
         ObjectSet(StringArray[i], OBJPROP_COLOR,  LineColorDone);
         ObjectSetText(StringArray[i], GetObjectDoneValueString(StringArray[i]), 10);            
      }
   }
}

void AlertCrossLine(int Index)
{
   string Notice, LineName;

   switch (ObjectType(StringArray[Index]))
   {
      case OBJ_HLINE: LineName = "L";  break;
      case OBJ_TREND: LineName = "TL"; break;
   }
   
   Notice = StringConcatenate(Symbol(), " Cross", LineName, " ", StringArray[Index], ":", DoubleToStr(LineArray[Index], Digits));
   if (SendMailPossible)	SendMail(Notice, "");
	if (AlertPossible)      {PlaySound(AlertSound); Alert(Notice);}
}