//+------------------------------------------------------------------+
//|                                                     Range_v3.mq4 |
//|                                  Copyright  2006, Forex-TSD.com |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |                                      
//+------------------------------------------------------------------+
string Revision = "Revize 2";

#property copyright "Copyright  2006, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 DodgerBlue
#property indicator_color2 Tomato
#property indicator_color3 Lime
#property indicator_color4 Orange

#property indicator_width1 0
#property indicator_width2 0
#property indicator_width3 1
#property indicator_width4 1
#property indicator_style1 2
#property indicator_style2 2

#define FIB_SUP1 "FIB_SUP_1"
#define FIB_SUP1T "FIB_SUP_1T"
#define FIB_SUP1B "FIB_SUP_1B"
#define FIB_SUP2 "FIB_SUP_2"
#define FIB_SUP2T "FIB_SUP_2T"
#define FIB_SUP2B "FIB_SUP_2B"
#define FIB_RES1 "FIB_RES_1"
#define FIB_RES1T "FIB_RES_1T"
#define FIB_RES1B "FIB_RES_1B"
#define FIB_RES2 "FIB_RES_2"
#define FIB_RES2T "FIB_RES_2T"
#define FIB_RES2B "FIB_RES_2B"

//---- input parameters

extern int TimeFrame =1440;
extern int Shift = 0;
extern int TP_koef = 7;
extern bool ShowComment = false;
extern bool ShowOpen = false;
extern bool ShowClose = false;
extern bool ShowRange = false;
extern bool ShowFiboPivots = true;
extern bool ShowFiboZones = true;
extern bool Show_SR_FiboZones =false;
extern bool Show_Pivot = True;   
extern bool Show_SR_1 = True;   
extern bool Show_SR_2 = True;   
extern bool Show_SR_3 = True;
extern bool ShowAVGRangeArrow = true;
extern bool ShowMarketInfo = false;
extern color clrSup1 = DimGray; // DeepSkyBlue;
extern color clrSup2 = DimGray; // Aqua;
extern color clrRes1 = DimGray; // Coral;
extern color clrRes2 = DimGray; // Tan;

double A, B, C, D, E;
double A1, B1, D1, E1;

double UpBuffer[];
double DnBuffer[];
double OpenBuffer[];
double CloseBuffer[];
double TodayHigh=0,TodayLow=0;
double SwapShort=0,SwapLong=0;
double Spread,ToHighPips=0,ToLowPips=0;
int TodayRange=0;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
{
   string short_name;
   //IndicatorBuffers(4);

   ObjectDelete("S1");
   ObjectDelete("S2");
   ObjectDelete("S3");
   ObjectDelete("R1");
   ObjectDelete("R2");
   ObjectDelete("R3");
   ObjectDelete("PIVOT");
   ObjectDelete("S1 ");
   ObjectDelete("S2 ");
   ObjectDelete("S3 ");
   ObjectDelete("R1 ");
   ObjectDelete("R2 ");
   ObjectDelete("R3 ");
   ObjectDelete("PIVOT ");  
   ObjectDelete("TOP_Range");     
   ObjectDelete("BOTTOM_Range"); 
   ObjectDelete(FIB_SUP1);
   ObjectDelete(FIB_SUP1T);
   ObjectDelete(FIB_SUP1B);
   ObjectDelete(FIB_SUP2);
   ObjectDelete(FIB_SUP2T);
   ObjectDelete(FIB_SUP2B);
   ObjectDelete(FIB_RES1);
   ObjectDelete(FIB_RES1T);
   ObjectDelete(FIB_RES1B);
   ObjectDelete(FIB_RES2);
   ObjectDelete(FIB_RES2T);
   ObjectDelete(FIB_RES2B);
   ObjectDelete("RES1");   
   ObjectDelete("SUP1");  

   Recalc();

if (ShowRange)
{   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,UpBuffer);
   SetIndexLabel(0,"High");
   SetIndexDrawBegin(0,0);
   
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,DnBuffer);
   SetIndexLabel(1,"Low");
   SetIndexDrawBegin(1,0);
 }  
if (ShowOpen)
{  
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,OpenBuffer);
   SetIndexLabel(2,"Open");
   SetIndexDrawBegin(2,0);
 }  
if (ShowClose)
{     
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,CloseBuffer);
   SetIndexLabel(3,"Close");
   SetIndexDrawBegin(3,0);
 }     
   SetIndexShift(0,Shift*TimeFrame/Period());
   SetIndexShift(1,Shift*TimeFrame/Period());
   SetIndexShift(2,Shift*TimeFrame/Period());
   SetIndexShift(3,Shift*TimeFrame/Period());
   
   short_name="Range_v3("+TimeFrame+")";
   IndicatorShortName(short_name);
   
   
   switch(TimeFrame) 
   {
   case 1    : TimeFrame=PERIOD_M1;  break; 
   case 5    : TimeFrame=PERIOD_M5;  break;
   case 15   : TimeFrame=PERIOD_M15; break;
   case 30   : TimeFrame=PERIOD_M30; break;
   case 60   : TimeFrame=PERIOD_H1;  break;
   case 240  : TimeFrame=PERIOD_H4;  break;
   case 1440 : TimeFrame=PERIOD_D1;  break;
   case 7200 : TimeFrame=PERIOD_W1;  break;
   case 28800: TimeFrame=PERIOD_MN1; break;
   default  : TimeFrame=Period();   break;
   }
return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   Comment("");
   ObjectDelete("S1");
   ObjectDelete("S2");
   ObjectDelete("S3");
   ObjectDelete("R1");
   ObjectDelete("R2");
   ObjectDelete("R3");
   ObjectDelete("PIVOT");
   ObjectDelete("S1 ");
   ObjectDelete("S2 ");
   ObjectDelete("S3 ");
   ObjectDelete("R1 ");
   ObjectDelete("R2 ");
   ObjectDelete("R3 ");
   ObjectDelete("PIVOT ");  
   ObjectDelete("TOP_Range");     
   ObjectDelete("BOTTOM_Range"); 
   ObjectDelete(FIB_SUP1);
   ObjectDelete(FIB_SUP1T);
   ObjectDelete(FIB_SUP1B);
   ObjectDelete(FIB_SUP2);
   ObjectDelete(FIB_SUP2T);
   ObjectDelete(FIB_SUP2B);
   ObjectDelete(FIB_RES1);
   ObjectDelete(FIB_RES1T);
   ObjectDelete(FIB_RES1B);
   ObjectDelete(FIB_RES2);
   ObjectDelete(FIB_RES2T);
   ObjectDelete(FIB_RES2B);
   ObjectDelete("RES1");   
   ObjectDelete("SUP1");     
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
int digits=MarketInfo(Symbol(),MODE_DIGITS);
if (ShowFiboPivots)
{
//----
double rates[1][6],yesterday_close,yesterday_high,yesterday_low;
ArrayCopyRates(rates, Symbol(), PERIOD_D1);

if(DayOfWeek() == 1)
{
   if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,1)) == 5)
   {
       yesterday_close = rates[1][4];
       yesterday_high = rates[1][3];
       yesterday_low = rates[1][2];
   }
   else
   {
      for(int d = 5;d>=0;d--)
      {
         if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,d)) == 5)
         {
             yesterday_close = rates[d][4];
             yesterday_high = rates[d][3];
             yesterday_low = rates[d][2];
         }
         
      }  
   }
}
else
{
    yesterday_close = rates[1][4];
    yesterday_high = rates[1][3];
    yesterday_low = rates[1][2];
}

//---- Calculate Pivots

// Comment("\nYesterday quotations:\nH ",yesterday_high,"\nL ",yesterday_low, "\nC ",yesterday_close);
double R = yesterday_high - yesterday_low;//range
double p = (yesterday_high + yesterday_low + yesterday_close)/3;// Standard Pivot
double r3 = p + (R * 1.000);
double r2 = p + (R * 0.618);
double r1 = p + (R * 0.382);
double s1 = p - (R * 0.382);
double s2 = p - (R * 0.618);
double s3 = p - (R * 1.000);

if (Show_SR_3==true)  
  {
   drawLine(r3,"R3", Lime,0);
   drawLabel("R3 ",r3,Lime);
   drawLine(s3,"S3",Red,0);
   drawLabel("S3 ",s3,Red);
  }
if (Show_SR_2==true)  
  {
   drawLine(r2,"R2", Green,0);
   drawLabel("R2 ",r2,Green);
   drawLine(s2,"S2",Crimson,0);
   drawLabel("S2",s2 ,Crimson);
  }
if (Show_SR_1==true) 
  { 
   drawLine(r1,"R1", DarkGreen,0);
   drawLabel("R1 ",r1,DarkGreen);
   drawLine(s1,"S1",Maroon,0);
   drawLabel("S1 ",s1,Maroon);
  }
if (Show_Pivot==true)  
  { 
   drawLine(p,"PIVOT",Blue,0);
   drawLabel("PIVOT ",p,Blue);
  }
//----
}

if (ShowFiboZones)
{
   static datetime dt = 0;
   if (dt != iTime(NULL, PERIOD_D1,0))
   {
      Recalc();
      dt = iTime(NULL, PERIOD_D1,0);

      ObjectDelete("S1");
      ObjectDelete("S2");
      ObjectDelete("S3");
      ObjectDelete("R1");
      ObjectDelete("R2");
      ObjectDelete("R3");
      ObjectDelete("PIVOT");
      ObjectDelete("S1 ");
      ObjectDelete("S2 ");
      ObjectDelete("S3 ");
      ObjectDelete("R1 ");
      ObjectDelete("R2 ");
      ObjectDelete("R3 ");
      ObjectDelete("PIVOT ");  
      ObjectDelete("TOP_Range");     
      ObjectDelete("BOTTOM_Range"); 
      ObjectDelete("RES1");   
      ObjectDelete("SUP1");  
   }  
   
   if (NewBar())
   {
      ObjectDelete(FIB_SUP1);
      ObjectDelete(FIB_SUP1T);
      ObjectDelete(FIB_SUP1B);
      ObjectDelete(FIB_SUP2);
      ObjectDelete(FIB_SUP2T);
      ObjectDelete(FIB_SUP2B);
      ObjectDelete(FIB_RES1);
      ObjectDelete(FIB_RES1T);
      ObjectDelete(FIB_RES1B);
      ObjectDelete(FIB_RES2);
      ObjectDelete(FIB_RES2T);
      ObjectDelete(FIB_RES2B);
          
      if (Show_SR_FiboZones==true) 
         { 
             drawLine(B,"SUP1",DeepSkyBlue,0);
             drawLine(D,"RES1",Coral,0);     
         } 
         
    ObjectCreate(FIB_SUP1, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), B, Time[0], B1);ObjectSet(FIB_SUP1, OBJPROP_COLOR, clrSup1);      
    ObjectCreate(FIB_SUP2, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), A, Time[0], A1);ObjectSet(FIB_SUP2, OBJPROP_COLOR, clrSup2);      
    ObjectCreate(FIB_RES1, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), D, Time[0], D1);ObjectSet(FIB_RES1, OBJPROP_COLOR, clrRes1);      
    ObjectCreate(FIB_RES2, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), E, Time[0], E1);ObjectSet(FIB_RES2, OBJPROP_COLOR, clrRes2);      

    if (digits==2)
    {
    ObjectCreate(FIB_SUP1B, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), B, Time[0], B-0.005);ObjectSet(FIB_SUP1B, OBJPROP_COLOR, DeepSkyBlue);      
    ObjectCreate(FIB_RES1T, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), D, Time[0], D+0.005);ObjectSet(FIB_RES1T, OBJPROP_COLOR, Coral); 
    ObjectCreate(FIB_SUP2B, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), A, Time[0], A-0.005);ObjectSet(FIB_SUP2B, OBJPROP_COLOR, DeepSkyBlue);      
    ObjectCreate(FIB_RES2T, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), E, Time[0], E+0.005);ObjectSet(FIB_RES2T, OBJPROP_COLOR, Coral); 
    } else
    {
    ObjectCreate(FIB_SUP1B, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), B, Time[0], B-0.0001);ObjectSet(FIB_SUP1B, OBJPROP_COLOR, DeepSkyBlue);      
    ObjectCreate(FIB_RES1T, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), D, Time[0], D+0.0001);ObjectSet(FIB_RES1T, OBJPROP_COLOR, Coral); 
    ObjectCreate(FIB_SUP2B, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), A, Time[0], A-0.0001);ObjectSet(FIB_SUP2B, OBJPROP_COLOR, DeepSkyBlue);      
    ObjectCreate(FIB_RES2T, OBJ_RECTANGLE, 0, iTime(NULL, PERIOD_D1, 0), E, Time[0], E+0.0001);ObjectSet(FIB_RES2T, OBJPROP_COLOR, Coral); 
    }    
  }

}

   double R1=0,R5=0,R10=0,R20=0,RAvg=0,TP=0,LongUsed=0,ShortUsed=0;

   SwapLong = MarketInfo(Symbol(),MODE_SWAPLONG);
   SwapShort = MarketInfo(Symbol(),MODE_SWAPSHORT);
   Spread =  MarketInfo(Symbol(),MODE_SPREAD);
//------------------------
   datetime TimeArray[];
   int i=0,y=0, prevy=0;  
   int counted_bars=IndicatorCounted();
   double LowArray[],HighArray[],OpenArray[],CloseArray[];
   
   
      if (TimeFrame<Period()) 
      {
      SetIndexDrawBegin(0,Bars);  
      SetIndexDrawBegin(1,Bars);
      Comment("Incorrect TimeFrame");
      return(0);
      }

   if ( counted_bars > 0 )  int limit=Bars-counted_bars+TimeFrame/Period();
   if ( counted_bars < 0 )  return(0);
   if ( counted_bars ==0 )  limit=Bars-1; 
     
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame);
   ArrayCopySeries(LowArray,MODE_LOW,Symbol(),TimeFrame);  
   ArrayCopySeries(HighArray,MODE_HIGH,Symbol(),TimeFrame);
   ArrayCopySeries(OpenArray,MODE_OPEN,Symbol(),TimeFrame);  
   ArrayCopySeries(CloseArray,MODE_CLOSE,Symbol(),TimeFrame);
     
      for(i=0,y=0;i<limit;i++)
      {
      prevy = y;
      if (Time[i]<TimeArray[y]) y++;
      UpBuffer[i]=HighArray[y];    
      DnBuffer[i]=LowArray[y];
      OpenBuffer[i]=OpenArray[y];    

      if(y!=prevy) 
      CloseBuffer[i]=CloseArray[y];
      else CloseBuffer[i]=CloseArray[prevy];     
      } 
      TodayHigh=iHigh(NULL,1440,0);
      TodayLow=iLow(NULL,1440,0);
      TodayRange=(TodayHigh-TodayLow)/Point;
    
//+------------------------------------------------------------------+
//| Daily Range iteration function                              
//+------------------------------------------------------------------+ 

      double HI2 = iHigh(NULL,1440,0);
      double LOW2 = iLow(NULL,1440,0); 
      double HI3 = iHigh(NULL,1440,0+1);
      double LOW3 = iLow(NULL,1440,0+1);
      double HI4 = iHigh(NULL,1440,0);
      double LOW4 = iLow(NULL,1440,0);
      double HI5 = iHigh(NULL,1440,2);
      double LOW5 = iLow(NULL,1440,2);
      double HI6 = iHigh(NULL,1440,3);
      double LOW6 = iLow(NULL,1440,3);
      double HI7 = iHigh(NULL,1440,4);
      double LOW7 = iLow(NULL,1440,4);
      double HI8 = iHigh(NULL,1440,5);
      double LOW8 = iLow(NULL,1440,5);
      double HI9 = iHigh(NULL,1440,6);
      double LOW9 = iLow(NULL,1440,6);
      double HI10 = iHigh(NULL,1440,7);
      double LOW10 = iLow(NULL,1440,7);
      double HI11 = iHigh(NULL,1440,8);
      double LOW11 = iLow(NULL,1440,8);
      double HI12 = iHigh(NULL,1440,9);
      double LOW12 = iLow(NULL,1440,9);
      double HI13 = iHigh(NULL,1440,10);
      double LOW13 = iLow(NULL,1440,10);
      double HI14 = iHigh(NULL,1440,11);
      double LOW14 = iLow(NULL,1440,11);
      double HI15 = iHigh(NULL,1440,12);
      double LOW15 = iLow(NULL,1440,12);
      double HI16 = iHigh(NULL,1440,13);
      double LOW16 = iLow(NULL,1440,13);
      double HI17 = iHigh(NULL,1440,14);
      double LOW17 = iLow(NULL,1440,14);
      double HI18 = iHigh(NULL,1440,15);
      double LOW18 = iLow(NULL,1440,15);
      double HI19 = iHigh(NULL,1440,16);
      double LOW19 = iLow(NULL,1440,16);
      double HI20 = iHigh(NULL,1440,17);
      double LOW20 = iLow(NULL,1440,17);
      double HI21 = iHigh(NULL,1440,18);
      double LOW21 = iLow(NULL,1440,18); 
      double HI22 = iHigh(NULL,1440,19);
      double LOW22 = iLow(NULL,1440,19);
      double HI23 = iHigh(NULL,1440,20);
      double LOW23 = iLow(NULL,1440,20);
 
      double ONE2 = (HI3-LOW3)/2;
      double FIVE2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8))/10;
      double TEN2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8)+
                    (HI9-LOW9)+(HI10-LOW10)+(HI11-LOW11)+(HI12-LOW12)+(HI13-LOW13))/20;  

  double TWENTY2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8)+
               (HI9-LOW9)+(HI10-LOW10)+(HI11-LOW11)+(HI12-LOW12)+(HI13-LOW13)+
               (HI14-LOW14)+(HI15-LOW15)+(HI16-LOW16)+(HI17-LOW17)+(HI18-LOW18)+
               (HI19-LOW19)+(HI20-LOW20)+(HI21-LOW21)+(HI22-LOW22)+(HI23-LOW23))/40;  
               
  double AV2 = (ONE2+FIVE2+TEN2+TWENTY2)/4;
      
  double HIDaily2 = iHigh(NULL,1440,0)-(AV2)*2; 
  double LOWDaily2 =iLow(NULL,1440,0)+(AV2)*2; 

  string TDR =   DoubleToStr(LOWDaily2,Digits);
  string BDR =   DoubleToStr(HIDaily2,Digits);
  double TDR2 =  StrToDouble(TDR);
  double BDR2 =  StrToDouble(BDR);  
  

   R1 =  (iHigh(NULL,PERIOD_D1,1)-iLow(NULL,PERIOD_D1,1))/Point;
   for(i=1;i<=5;i++)    R5    =  R5  +  (iHigh(NULL,PERIOD_D1,i)-iLow(NULL,PERIOD_D1,i))/Point;
   for(i=1;i<=10;i++)   R10   =  R10 +  (iHigh(NULL,PERIOD_D1,i)-iLow(NULL,PERIOD_D1,i))/Point;
   for(i=1;i<=20;i++)   R20   =  R20 +  (iHigh(NULL,PERIOD_D1,i)-iLow(NULL,PERIOD_D1,i))/Point;

   R5    = R5/5;
   R10   = R10/10;
   R20   = R20/20;
   RAvg  = NormalizeDouble((R5+R10+R20)/3,0); 
   TP    = NormalizeDouble(RAvg/TP_koef,0); 
   Spread=(Ask - Bid);
   ToHighPips=(TodayHigh-Ask+Spread)/Point;
   ToLowPips=(Ask-TodayLow-Spread)/Point;   
   LongUsed=NormalizeDouble((ToLowPips/RAvg*100),2);
   ShortUsed=NormalizeDouble((ToHighPips/RAvg*100),2);

if (ShowAVGRangeArrow){
     if(ObjectFind("TOP_Range") != 0)
     {
        ObjectCreate("TOP_Range", OBJ_ARROW, 0, Time[0],TDR2);
        ObjectSet("TOP_Range", OBJPROP_ARROWCODE, 6);
        ObjectSet("TOP_Range", OBJPROP_COLOR,Magenta );
     }
     else
     {
        ObjectMove("TOP_Range",0, Time[0],TDR2);
     }   
     if(ObjectFind("BOTTOM_Range") != 0)
     {
        ObjectCreate("BOTTOM_Range", OBJ_ARROW, 0, Time[0],BDR2);
        ObjectSet("BOTTOM_Range", OBJPROP_ARROWCODE, 6);        
        ObjectSet("BOTTOM_Range", OBJPROP_COLOR,Magenta );
     }
     else
     {
        ObjectMove("BOTTOM_Range",0, Time[0],BDR2);
     }     
  }      


//----------------------------
      if (ShowComment)
      {      
      if (ShowMarketInfo)
      {
      Comment("\n","* TODAYS RANGE: ",TodayRange,
              "\n","* LONG USED: ",LongUsed,"%",
              "\n","* SHORT USED: ",ShortUsed,"%",
              "\n","* AVG. DAILY RANGE: ",RAvg,
              "\n","* PROFIT TARGET: ",TP,
              "\n","* SWAP L: ",SwapLong,", S: ", SwapShort,            
              "\n","* LEVERAGE: ",AccountLeverage(), ", SPREAD: ",Spread/Point
              );
      } else
      {
      Comment("\n","* TODAYS RANGE: ",TodayRange,
              "\n","* LONG USED: ",LongUsed,"%",
              "\n","* SHORT USED: ",ShortUsed,"%",
              "\n","* AVG. DAILY RANGE: ",RAvg,
              "\n","* PROFIT TARGET: ",TP
              );      
      }
      }
   return(0);
}


//+------------------------------------------------------------------+
void drawLabel(string name,double lvl,color Color)
{
    if(ObjectFind(name) != 0)
    {
        ObjectCreate(name, OBJ_TEXT, 0, Time[10], lvl);
        ObjectSetText(name, name, 8, "Arial", EMPTY);
        ObjectSet(name, OBJPROP_COLOR, Color);
    }
    else
    {
        ObjectMove(name, 0, Time[10], lvl);
    }
}


void drawLine(double lvl,string name, color Col,int type)
{
         if(ObjectFind(name) != 0)
         {
            ObjectCreate(name, OBJ_HLINE, 0, Time[0], lvl,Time[0],lvl);
            
            if(type == 1)
            ObjectSet(name, OBJPROP_STYLE, STYLE_SOLID);
            else
            ObjectSet(name, OBJPROP_STYLE, STYLE_DOT);
            
            ObjectSet(name, OBJPROP_COLOR, Col);
            ObjectSet(name,OBJPROP_WIDTH,1);
            
         }
         else
         {
            ObjectDelete(name);
            ObjectCreate(name, OBJ_HLINE, 0, Time[0], lvl,Time[0],lvl);
            
            if(type == 1)
            ObjectSet(name, OBJPROP_STYLE, STYLE_SOLID);
            else
            ObjectSet(name, OBJPROP_STYLE, STYLE_DOT);
            
            ObjectSet(name, OBJPROP_COLOR, Col);        
            ObjectSet(name,OBJPROP_WIDTH,1);
          
         }
}

//+------------------------------------------------------------------+

bool NewBar()
{
   static datetime dt = 0;
   if (dt != Time[0])
   {
      dt = Time[0];
      return(true);
   }
   return(false);
}

void Recalc()
{
double C=0, L=0, H=0;
int digits=MarketInfo(Symbol(),MODE_DIGITS);

    if(DayOfWeek() == 1)
    {
      C = iClose(NULL, PERIOD_D1, 3); // Yesterday close
      L = iLow(NULL, PERIOD_D1, 3); // Yesterday Low
      H = iHigh(NULL, PERIOD_D1, 3); // Yesterday High    
    } else
    {
      C = iClose(NULL, PERIOD_D1, 1); // Yesterday close
      L = iLow(NULL, PERIOD_D1, 1); // Yesterday Low
      H = iHigh(NULL, PERIOD_D1, 1); // Yesterday High
    } 
      double R = (H-L);
      
      C = NormalizeDouble(((H+L+C) / 3),digits);
      D = NormalizeDouble(((R/2) + C),digits);
      B = NormalizeDouble((C - (R/2)),digits);
      E = NormalizeDouble((R + C),digits);
      A = NormalizeDouble((C - R),digits);
      
      B1 = NormalizeDouble((C - ( R * 0.618 )),digits);
      A1 = NormalizeDouble((C - ( R * 1.382 )),digits);
      
      D1 = NormalizeDouble((C + ( R * 0.618 )),digits);
      E1 = NormalizeDouble((C + ( R * 1.382 )),digits);

}

