//+----------------------------------------------------------------------------+
//|                                                    fromHistoryOnGraph.mq4  |
//|                                                                            |
//|                                                      . aka KimIV  |
//|                                                       http://www.kimiv.ru  |
//|                                                                            |
//|  01.11.2007          .        |
//|              Carrying the Deals from History on Graph.                     |
//|                                                                            |
//|                      |
//|         .                 |
//+----------------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"
#property show_inputs

extern bool   DeleteOldObjects = True;      //   
extern string _P_Objects = "----------  ";
extern int    TypeObjects      = 1;         //   (0-. 1-)
extern color  clObjBuy         = Aqua;      //   
extern color  clObjBuyLoss     = Blue;      //   
extern color  clObjSell        = Salmon;    //   
extern color  clObjSellLoss    = Red;       //   
extern string _P_Arrows = "----------  ";
extern bool   ShowArrow        = True;      //  
extern int    KodArrowBuy      = 241;       //   
extern int    OffSetArrowBuy   = -15;       //   
extern color  clArrowBuy       = Blue;      //   
extern int    KodArrowSell     = 242;       //   
extern int    OffSetArrowSell  = 15;        //   
extern color  clArrowSell      = Red;       //   
extern string _P_Text = "----------  ";
extern bool   ShowTextBalance  = True;      //   
extern int    OffSetText       = 50;       //  
extern int    SizeText         = 9;         //  
extern color  clTextProfit     = Green;     //   
extern color  clTextLoss       = Red;       //   
extern color  clTextBalans     = Green;     //   

//-------   -----------------------------------------------+
int    frogBalance     = 0;
string frogNameObjLine = "LDeal";      //   
string frogNameObjRect = "RDeal";      //   


//+----------------------------------------------------------------------------+
//|  script program start function                                             |
//+----------------------------------------------------------------------------+
void start()
{
  datetime ot, ct;
  double   op, cp;
  int      i, k=OrdersHistoryTotal(), s=0, ty;

  if (DeleteOldObjects) ObjectsDeleteAll();
  for (i=0; i<k; i++)
  {
    if (OrderSelect(i, SELECT_BY_POS, MODE_HISTORY))
    {
      ty=OrderType();
      if (OrderSymbol()==Symbol() && ty<2)
      {
        ot=OrderOpenTime();
        op=OrderOpenPrice();
        ct=OrderCloseTime();
        cp=OrderClosePrice();
        SetProp(i, ty, ot, op, ct, cp); s++;
        if (ShowArrow) SetPropArrow(i, ty, ot, op);
        if (ShowTextBalance) SetPropText(i, ct, cp);
      }
      Comment(": ",i+1,"   ",k,"\n",
              "  : ",s);
    }
  }
}

//+----------------------------------------------------------------------------+
//|                                                    |
//|  :                                                                |
//|    or -                                                        |
//|    ty -                                                            |
//|    ot - ,                                                 |
//|    op -                                                        |
//|    ct - ,                                                 |
//|    cp -                                                        |
//+----------------------------------------------------------------------------+
void SetProp(int or, int ty, datetime ot, double op, datetime ct, double cp)
{
  string no;
  if (TypeObjects==0) no=frogNameObjRect; else no=frogNameObjLine;

  if (ObjectFind(no+or)<0) {
    if (TypeObjects==0) ObjectCreate(no+or, OBJ_RECTANGLE, 0, 0,0, 0,0);
    else ObjectCreate(no+or, OBJ_TREND, 0, 0,0, 0,0);
  }
  ObjectSet(no+or, OBJPROP_TIME1 , ot);
  ObjectSet(no+or, OBJPROP_PRICE1, op);
  ObjectSet(no+or, OBJPROP_TIME2 , ct);
  ObjectSet(no+or, OBJPROP_PRICE2, cp);
  if (ty==OP_BUY)
  {
    if (op<cp) ObjectSet(no+or, OBJPROP_COLOR, clObjBuy);
    if (op>cp) ObjectSet(no+or, OBJPROP_COLOR, clObjBuyLoss);
  }
  if (ty==OP_SELL)
  {
    if (op>cp) ObjectSet(no+or, OBJPROP_COLOR, clObjSell);
    if (op<cp) ObjectSet(no+or, OBJPROP_COLOR, clObjSellLoss);
  }
  if (TypeObjects==1) ObjectSet(no+or, OBJPROP_RAY , False);
}

//+----------------------------------------------------------------------------+
//|                                            |
//|  :                                                                |
//|    or -   ()                                             |
//|    op -                                                            |
//|    ot - ,                                                         |
//|    op -                                                                |
//+----------------------------------------------------------------------------+
void SetPropArrow(int or, int ty, datetime ot, double op)
{
  string no="ADeal";

  if (ObjectFind(no+or)<0) ObjectCreate(no+or, OBJ_ARROW, 0, 0,0);
  ObjectSet(no+or, OBJPROP_TIME1, ot);
  if (ty==OP_BUY)
  {
    ObjectSet(no+or, OBJPROP_PRICE1   , op+OffSetArrowBuy*Point);
    ObjectSet(no+or, OBJPROP_COLOR    , clArrowBuy);
    ObjectSet(no+or, OBJPROP_ARROWCODE, KodArrowBuy);
  }
  if (ty==OP_SELL)
  {
    ObjectSet(no+or, OBJPROP_PRICE1   , op+OffSetArrowSell*Point);
    ObjectSet(no+or, OBJPROP_COLOR    , clArrowSell);
    ObjectSet(no+or, OBJPROP_ARROWCODE, KodArrowSell);
  }
}

//+----------------------------------------------------------------------------+
//|                                               |
//|  :                                                                |
//|    or -   ()                                             |
//|    dt - ,                                                         |
//|    pp -                                                                |
//+----------------------------------------------------------------------------+
void SetPropText(int or, datetime dt, double pp)
{
  color  cl, clText;
  double p1, p2, ss;
  string no, no1="T1Deal", no2="T2Deal";

  if (TypeObjects==0) no=frogNameObjRect; else no=frogNameObjLine;

  p1=ObjectGet(no+or, OBJPROP_PRICE1);
  p2=ObjectGet(no+or, OBJPROP_PRICE2);
  cl=ObjectGet(no+or, OBJPROP_COLOR);

  if (p1!=0 && p2!=0)
  {
    if (ObjectFind(no1+or)<0) ObjectCreate(no1+or, OBJ_TEXT, 0, 0,0);
    if (ObjectFind(no2+or)<0) ObjectCreate(no2+or, OBJ_TEXT, 0, 0,0);
    ObjectSet(no1+or, OBJPROP_TIME1 , dt);
    ObjectSet(no2+or, OBJPROP_TIME1 , dt);
    ObjectSet(no1+or, OBJPROP_PRICE1, pp+OffSetText*Point);
    ObjectSet(no2+or, OBJPROP_PRICE1, pp-OffSetText*Point);
    if (cl==clObjBuy || cl==clObjBuyLoss)
    {
      ss=(p2-p1)/Point;
      frogBalance+=ss;
      if (ss<0) clText=clTextLoss; else clText=clTextProfit;
      ObjectSetText(no1+or, DoubleToStr(ss, 0), SizeText, "", clText);
      ObjectSetText(no2+or, DoubleToStr(frogBalance, 0), SizeText, "", clTextBalans);
    }
    if (cl==clObjSell || cl==clObjSellLoss)
    {
      ss=(p1-p2)/Point;
      frogBalance+=ss;
      if (ss<0) clText=clTextLoss; else clText=clTextProfit;
      ObjectSetText(no1+or, DoubleToStr(ss, 0), SizeText, "", clText);
      ObjectSetText(no2+or, DoubleToStr(frogBalance, 0), SizeText, "", clTextBalans);
    }
  }
}
//+----------------------------------------------------------------------------+

