//+------------------------------------------------------------------+
//|                                                 BucCM_Master.mq4 |
//|                                    Copyright  2007, Petr Kouril |
//|                                           http://www.jaktrade.cz |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, Petr Kouril"
#property link      "http://www.bucafon.cz"

#define           REVISION                "1.1"

#property indicator_chart_window

#property indicator_buffers 7

extern bool ShowComment = true;
extern bool ShowMarketInfo = false;
extern bool  ShowName = true;
extern bool  ShowPrice = true;
extern color Color_PP = Blue;
extern color Color_R1 = DarkGreen;
extern color Color_R2 = Green;
extern color Color_R3 = Lime;
extern color Color_S1 = Maroon;
extern color Color_S2 = Crimson;
extern color Color_S3 = Red;
extern int TP_koef = 7;

double TodayHigh=0,TodayLow=0;
double SwapShort=0,SwapLong=0;
double Spread,ToHighPips=0,ToLowPips=0;
int TodayRange=0;

//---- buffers
double            PivotBuff[], R1Buff[], R2Buff[], R3Buff[], S1Buff[], S2Buff[], S3Buff[];
int               TimeFrame;

int init()
{
   string PerName;
   
   PerName   = "Daily";
   TimeFrame = PERIOD_D1;

	IndicatorBuffers(7);

   SetIndexStyle (0, DRAW_LINE,2,1,Color_PP);
   SetIndexBuffer(0, PivotBuff);
   SetIndexLabel (0, PerName + " Pivot");

   SetIndexStyle (1, DRAW_LINE,2,1,Color_R1);
   SetIndexBuffer(1, R1Buff);
   SetIndexLabel (1, PerName + " R1");

   SetIndexStyle (2, DRAW_LINE,2,1,Color_R2);
   SetIndexBuffer(2, R2Buff);
   SetIndexLabel (2, PerName + " R2");

   SetIndexStyle (3, DRAW_LINE,2,1,Color_R3);
   SetIndexBuffer(3, R3Buff);
   SetIndexLabel (3, PerName + " R3");

   SetIndexStyle (4, DRAW_LINE,2,1,Color_S1);
   SetIndexBuffer(4, S1Buff);
   SetIndexLabel (4, PerName + " S1");

   SetIndexStyle (5, DRAW_LINE,2,1,Color_S2);
   SetIndexBuffer(5, S2Buff);
   SetIndexLabel (5, PerName + " S2");

   SetIndexStyle (6, DRAW_LINE,2,1,Color_S3);
   SetIndexBuffer(6, S3Buff);
   SetIndexLabel (6, PerName + " S3");
   
   return(0);
}

int deinit()
{
   ObjectDelete("DailyP");
   ObjectDelete("txtDailyP");
   ObjectDelete("DailyR1");
   ObjectDelete("txtDailyR1");
   ObjectDelete("DailyR2");
   ObjectDelete("txtDailyR2");
   ObjectDelete("DailyR3");
   ObjectDelete("txtDailyR3");   
   ObjectDelete("DailyS1");
   ObjectDelete("txtDailyS1");
   ObjectDelete("DailyS2");
   ObjectDelete("txtDailyS2");
   ObjectDelete("DailyS3");
   ObjectDelete("txtDailyS3");   

   Comment("");
   return(0);
}

int start()
{
   double R1=0,R5=0,R10=0,R20=0,RAvg=0,TP=0,LongUsed=0,ShortUsed=0;
   int k=0;  

   int digits=MarketInfo(Symbol(),MODE_DIGITS);
   SwapLong = MarketInfo(Symbol(),MODE_SWAPLONG);
   SwapShort = MarketInfo(Symbol(),MODE_SWAPSHORT);
   Spread =  MarketInfo(Symbol(),MODE_SPREAD);

   TodayHigh=iHigh(NULL,1440,0);
   TodayLow=iLow(NULL,1440,0);   
   TodayRange=(TodayHigh-TodayLow)/Point;

//+------------------------------------------------------------------+
//| Daily Range iteration function                              
//+------------------------------------------------------------------+ 

      double HI2 = iHigh(NULL,1440,0);
      double LOW2 = iLow(NULL,1440,0); 
      double HI3 = iHigh(NULL,1440,0+1);
      double LOW3 = iLow(NULL,1440,0+1);
      double HI4 = iHigh(NULL,1440,0);
      double LOW4 = iLow(NULL,1440,0);
      double HI5 = iHigh(NULL,1440,2);
      double LOW5 = iLow(NULL,1440,2);
      double HI6 = iHigh(NULL,1440,3);
      double LOW6 = iLow(NULL,1440,3);
      double HI7 = iHigh(NULL,1440,4);
      double LOW7 = iLow(NULL,1440,4);
      double HI8 = iHigh(NULL,1440,5);
      double LOW8 = iLow(NULL,1440,5);
      double HI9 = iHigh(NULL,1440,6);
      double LOW9 = iLow(NULL,1440,6);
      double HI10 = iHigh(NULL,1440,7);
      double LOW10 = iLow(NULL,1440,7);
      double HI11 = iHigh(NULL,1440,8);
      double LOW11 = iLow(NULL,1440,8);
      double HI12 = iHigh(NULL,1440,9);
      double LOW12 = iLow(NULL,1440,9);
      double HI13 = iHigh(NULL,1440,10);
      double LOW13 = iLow(NULL,1440,10);
      double HI14 = iHigh(NULL,1440,11);
      double LOW14 = iLow(NULL,1440,11);
      double HI15 = iHigh(NULL,1440,12);
      double LOW15 = iLow(NULL,1440,12);
      double HI16 = iHigh(NULL,1440,13);
      double LOW16 = iLow(NULL,1440,13);
      double HI17 = iHigh(NULL,1440,14);
      double LOW17 = iLow(NULL,1440,14);
      double HI18 = iHigh(NULL,1440,15);
      double LOW18 = iLow(NULL,1440,15);
      double HI19 = iHigh(NULL,1440,16);
      double LOW19 = iLow(NULL,1440,16);
      double HI20 = iHigh(NULL,1440,17);
      double LOW20 = iLow(NULL,1440,17);
      double HI21 = iHigh(NULL,1440,18);
      double LOW21 = iLow(NULL,1440,18); 
      double HI22 = iHigh(NULL,1440,19);
      double LOW22 = iLow(NULL,1440,19);
      double HI23 = iHigh(NULL,1440,20);
      double LOW23 = iLow(NULL,1440,20);
 
      double ONE2 = (HI3-LOW3)/2;
      double FIVE2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8))/10;
      double TEN2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8)+
                    (HI9-LOW9)+(HI10-LOW10)+(HI11-LOW11)+(HI12-LOW12)+(HI13-LOW13))/20;  

  double TWENTY2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8)+
               (HI9-LOW9)+(HI10-LOW10)+(HI11-LOW11)+(HI12-LOW12)+(HI13-LOW13)+
               (HI14-LOW14)+(HI15-LOW15)+(HI16-LOW16)+(HI17-LOW17)+(HI18-LOW18)+
               (HI19-LOW19)+(HI20-LOW20)+(HI21-LOW21)+(HI22-LOW22)+(HI23-LOW23))/40;  
               
  double AV2 = (ONE2+FIVE2+TEN2+TWENTY2)/4;
      
  double HIDaily2 = iHigh(NULL,1440,0)-(AV2)*2; 
  double LOWDaily2 =iLow(NULL,1440,0)+(AV2)*2; 

  string TDR =   DoubleToStr(LOWDaily2,Digits);
  string BDR =   DoubleToStr(HIDaily2,Digits);
  double TDR2 =  StrToDouble(TDR);
  double BDR2 =  StrToDouble(BDR);  
  

   R1 =  (iHigh(NULL,PERIOD_D1,1)-iLow(NULL,PERIOD_D1,1))/Point;
   for(k=1;k<=5;k++)    R5    =  R5  +  (iHigh(NULL,PERIOD_D1,k)-iLow(NULL,PERIOD_D1,k))/Point;
   for(k=1;k<=10;k++)   R10   =  R10 +  (iHigh(NULL,PERIOD_D1,k)-iLow(NULL,PERIOD_D1,k))/Point;
   for(k=1;k<=20;k++)   R20   =  R20 +  (iHigh(NULL,PERIOD_D1,k)-iLow(NULL,PERIOD_D1,k))/Point;

   R5    = R5/5;
   R10   = R10/10;
   R20   = R20/20;
   RAvg  = NormalizeDouble((R5+R10+R20)/3,0); 
   TP    = NormalizeDouble(RAvg/TP_koef,0); 
   Spread=(Ask - Bid);
   ToHighPips=(TodayHigh-Ask+Spread)/Point;
   ToLowPips=(Ask-TodayLow-Spread)/Point;   
   LongUsed=NormalizeDouble((ToLowPips/RAvg*100),2);
   ShortUsed=NormalizeDouble((ToHighPips/RAvg*100),2);

//---

   int counted_bars = IndicatorCounted();
   if (counted_bars<0) return(-1);
   if (counted_bars>0) counted_bars--;
   int i, limit = Bars-counted_bars;

   double Cl, Hi, Lo;
   for (i = (limit-1); i >= 0; i--)
	{
	   GetCHL(i, Cl, Hi, Lo);

      if (NewBar())
      {
        ObjectDelete("DailyP");
        ObjectDelete("txtDailyP");
        ObjectDelete("DailyR1");
        ObjectDelete("txtDailyR1");
        ObjectDelete("DailyR2");
        ObjectDelete("txtDailyR2");
        ObjectDelete("DailyR3");
        ObjectDelete("txtDailyR3");   
        ObjectDelete("DailyS1");
        ObjectDelete("txtDailyS1");
        ObjectDelete("DailyS2");
        ObjectDelete("txtDailyS2");
        ObjectDelete("DailyS3");
        ObjectDelete("txtDailyS3");       
      }
	   
      PivotBuff[i] = ((Hi + Lo + Cl)/3);
      if (ShowPrice) SetPrice("DailyP", Time[i], PivotBuff[i], Color_PP);
      if (ShowName) SetText("txtDailyP", "Pivot", Time[10], PivotBuff[i], Color_PP);

      R1Buff[i]    = (2 * PivotBuff[i]) - Lo;
      if (ShowPrice) SetPrice("DailyR1", Time[i], R1Buff[i], Color_R1);
      if (ShowName) SetText("txtDailyR1", "R1", Time[10], R1Buff[i], Color_R1);

      S1Buff[i]    = (2 * PivotBuff[i]) - Hi;
      if (ShowPrice) SetPrice("DailyS1", Time[i], S1Buff[i], Color_S1);
      if (ShowName) SetText("txtDailyS1", "S1", Time[10], S1Buff[i], Color_S1);

      R2Buff[i]    = PivotBuff[i] + (R1Buff[i] - S1Buff[i]);
      if (ShowPrice) SetPrice("DailyR2", Time[i], R2Buff[i], Color_R2);
      if (ShowName) SetText("txtDailyR2", "R2", Time[10], R2Buff[i], Color_R2);

      S2Buff[i]    = PivotBuff[i] - (R1Buff[i] - S1Buff[i]);
      if (ShowPrice) SetPrice("DailyS2", Time[i], S2Buff[i], Color_S2);
      if (ShowName) SetText("txtDailyS2", "S2", Time[10], S2Buff[i], Color_S2);

      S3Buff[i]    = (Lo - (2 * (Hi - PivotBuff[i])));
      if (ShowPrice) SetPrice("DailyS3", Time[i], S3Buff[i], Color_S3);
      if (ShowName) SetText("txtDailyS3", "S3", Time[10], S3Buff[i], Color_S3);
            
      R3Buff[i]    = (Hi + (2 * (PivotBuff[i] - Lo)));
      if (ShowPrice) SetPrice("DailyR3", Time[i], R3Buff[i], Color_R3);
      if (ShowName) SetText("txtDailyR3", "R3", Time[10], R3Buff[i], Color_R3);      

	}

      if (ShowComment)
      {      
      if (ShowMarketInfo)
      {
      Comment("\n","* TODAYS RANGE: ",TodayRange,
              "\n","* LONG USED: ",LongUsed,"%",
              "\n","* SHORT USED: ",ShortUsed,"%",
              "\n","* AVG. DAILY RANGE: ",RAvg,
              "\n","* PROFIT TARGET: ",TP,
              "\n","* SWAP L: ",SwapLong,", S: ", SwapShort,            
              "\n","* LEVERAGE: ",AccountLeverage(), ", SPREAD: ",Spread/Point
              );
      } else
      {
      Comment("\n","* TODAYS RANGE: ",TodayRange,
              "\n","* LONG USED: ",LongUsed,"%",
              "\n","* SHORT USED: ",ShortUsed,"%",
              "\n","* AVG. DAILY RANGE: ",RAvg,
              "\n","* PROFIT TARGET: ",TP
              );      
      }
      }

}

void GetCHL(int Shift, double &Cl, double &Hi, double &Lo)
{
   double Cl1, Hi1, Lo1;
   int PeriodShift = iBarShift(Symbol(), TimeFrame, Time[Shift]);

   if ((TimeFrame == PERIOD_D1) && (TimeDayOfWeek(Time[Shift]) == 0)) PeriodShift++;
      
   Cl = iClose(Symbol(), TimeFrame, PeriodShift + 1);
   Hi = iHigh (Symbol(), TimeFrame, PeriodShift + 1);
   Lo = iLow  (Symbol(), TimeFrame, PeriodShift + 1);

   if ((TimeFrame == PERIOD_D1) && (TimeDayOfWeek(Time[Shift]) == 1))
   {
      Hi1 = iHigh (Symbol(), TimeFrame, PeriodShift + 2);
      Lo1 = iLow  (Symbol(), TimeFrame, PeriodShift + 2);
      
      if (Hi1 > Hi) Hi = Hi1;
      if (Lo1 < Lo) Lo = Lo1;
   }

}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void SetPrice(string name, datetime Tm, double Prc, color clr)
  {
   if(ObjectFind(name) == -1)
     {
       ObjectCreate(name, OBJ_ARROW, 0, Tm, Prc);
       ObjectSet(name, OBJPROP_COLOR, clr);
       ObjectSet(name, OBJPROP_WIDTH, 1);
       ObjectSet(name, OBJPROP_ARROWCODE, SYMBOL_RIGHTPRICE);
     }
   else
     {
       ObjectSet(name, OBJPROP_TIME1, Tm);
       ObjectSet(name, OBJPROP_PRICE1, Prc);
       ObjectSet(name, OBJPROP_COLOR, clr);
       ObjectSet(name, OBJPROP_WIDTH, 1);
       ObjectSet(name, OBJPROP_ARROWCODE, SYMBOL_RIGHTPRICE);
     } 
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void SetText(string name, string txt, datetime Tm, double Prc, color clr)
  {
   if(ObjectFind(name) == -1)
     {
       ObjectCreate(name, OBJ_TEXT, 0, Tm, Prc);
       ObjectSetText(name, txt, 8, "Times New Roman", clr);
       ObjectSet(name, OBJPROP_CORNER, 2);
     }
   else
     {
       ObjectSet(name, OBJPROP_TIME1, Tm);
       ObjectSet(name, OBJPROP_PRICE1, Prc);
       ObjectSetText(name, txt, 8, "Times New Roman", clr);
       ObjectSet(name, OBJPROP_CORNER, 2);
     } 
  }
//+------------------------------------------------------------------+

bool NewBar()
{
   static datetime dt = 0;
   if (dt != Time[0])
   {
      dt = Time[0];
      return(true);
   }
   return(false);
}


