//+-----------------------------------------------------------------------+
//|                                  #MTF_Heiken_Ashi_cw.mq4              |
//|                                      http://www.metaquotes.net;       |    
//|                                      http://www.forex-tsd.com    ki   |
//+-----------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"



#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 DarkKhaki
#property indicator_color2 DarkKhaki
#property indicator_color3 OrangeRed
#property indicator_color4 LimeGreen
#property indicator_width3 2
#property indicator_width4 2
//---- input parameters
/*************************************************************************
PERIOD_M1   1
PERIOD_M5   5
PERIOD_M15  15
PERIOD_M30  30 
PERIOD_H1   60
PERIOD_H4   240
PERIOD_D1   1440
PERIOD_W1   10080
PERIOD_MN1  43200
You must use the numeric value of the timeframe that you want to use
when you set the TimeFrame' value with the indicator inputs.
**************************************************************************/
extern int TimeFrame=0;
extern int Shift=0;
extern int xShift=0;
extern string note_TimeFrames = "0-current TF; M1;5,15,30,60H1;240H4;1440D1;10080W1;43200MN; ";

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {

//---- indicator line
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0, ExtMapBuffer1);
    if(TimeFrame==0) TimeFrame = Period();
   SetIndexShift(0,xShift+Shift*TimeFrame/Period());
     SetIndexLabel(0,"HAlo/hi ["+TimeFrame+"]"+Shift+"");
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1, ExtMapBuffer2);
    SetIndexShift(1, xShift+Shift*TimeFrame/Period());
     SetIndexLabel(1," HAhi/lo["+TimeFrame+"]"+Shift+"");
   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexBuffer(2, ExtMapBuffer3);
    SetIndexShift(2, xShift+Shift*TimeFrame/Period());
    SetIndexLabel(2,"HAopen ["+TimeFrame+"]"+Shift+"");
   SetIndexStyle(3,DRAW_HISTOGRAM);
   SetIndexBuffer(3, ExtMapBuffer4);
   SetIndexShift(3, xShift+Shift*TimeFrame/Period());
   SetIndexLabel(3,"HAclose ["+TimeFrame+"]"+Shift+"");
   if (TimeFrame < Period()) TimeFrame = Period();

//---- name for DataWindow and indicator subwindow label   
   switch(TimeFrame)
   {
      case 1 : string TimeFrameStr="Period_M1"; break;
      case 5 : TimeFrameStr="Period_M5"; break;
      case 15 : TimeFrameStr="Period_M15"; break;
      case 30 : TimeFrameStr="Period_M30"; break;
      case 60 : TimeFrameStr="Period_H1"; break;
      case 240 : TimeFrameStr="Period_H4"; break;
      case 1440 : TimeFrameStr="Period_D1"; break;
      case 10080 : TimeFrameStr="Period_W1"; break;
      case 43200 : TimeFrameStr="Period_MN1"; break;
      default : TimeFrameStr="Current Timeframe";
   }
   IndicatorShortName("MTF_Heikin_Ashi");   
  }
//----
   return(0);
 
//+------------------------------------------------------------------+
//| MTF Parabolic Sar                                         |
//+------------------------------------------------------------------+
int start()
  {
   datetime TimeArray[];
   int    i,limit,y=0,counted_bars=IndicatorCounted(),ExtMapBuffer1prev,ExtMapBuffer2prev;
 
// Plot defined time frame on to current time frame
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
   
   limit=Bars-counted_bars+TimeFrame/Period();
   for(i=0,y=0;i<limit;i++)
   {
   if (Time[i]<TimeArray[y]) y++;

/***********************************************************   
   Add your main indicator loop below.  You can add the full
      indicator code or you can just reference an existing
      indicator with its iValue or iCustom.
   Rule 1:  Add extern inputs above for all neccesary values   
   Rule 2:  Use 'TimeFrame' for the indicator time frame
   Rule 3:  Use 'y' for your indicator's shift value
 **********************************************************/ 
 
   ExtMapBuffer1[i]=iCustom(NULL,TimeFrame,"Heiken Ashi",0,y);
   ExtMapBuffer2[i]=iCustom(NULL,TimeFrame,"Heiken Ashi",1,y);
   ExtMapBuffer3[i]=iCustom(NULL,TimeFrame,"Heiken Ashi",2,y);
   ExtMapBuffer4[i]=iCustom(NULL,TimeFrame,"Heiken Ashi",3,y);
  
   }  
     
   //----  Refresh buffers +++++++++++++++++++++++++ upgrade by Raff  
   if (TimeFrame>Period()) {
     int PerINT=TimeFrame/Period()+1;
     datetime TimeArr[]; ArrayResize(TimeArr,PerINT);
     ArrayCopySeries(TimeArr,MODE_TIME,Symbol(),Period()); 
     for(i=0;i<PerINT+1;i++) {if (TimeArr[i]>=TimeArray[0]) {
 /********************************************************     
    Refresh buffers:         buffer[i] = buffer[0];
 ********************************************************/  

   ExtMapBuffer1[i]=ExtMapBuffer1[0];
   ExtMapBuffer2[i]=ExtMapBuffer2[0];
   ExtMapBuffer3[i]=ExtMapBuffer3[0];
   ExtMapBuffer4[i]=ExtMapBuffer4[0];
 
  } } }
//++++++++++++++++++++++++++++++++++++++++++++++++   Raff 
  
   return(0);
  }
//+---------------------------------------------------------------+