//+------------------------------------------------------------------+
//|                                                 BucCM_Master.mq4 |
//|                                    Copyright  2007, Petr Kouril |
//|                                           http://www.jaktrade.cz |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, Petr Kouril"
#property link      "http://www.bucafon.cz"

#define           REVISION                "1.2"

#property indicator_chart_window

extern bool ShowMarketInfo   = false;
extern bool Alert_M5_Cross   = false;
extern bool Alert_M15_Cross  = true;
extern bool Alert_H1_Cross   = true;
extern bool Alert_H4_Cross   = true;
extern bool Alert_D1_Cross   = true;
extern bool Alert_W1_Cross   = true;
extern bool Alert_MN1_Cross  = true;
extern bool AlertOnlySound   = true;
extern string Sound          = "tick.wav";
extern bool SendMailPossible = false;
extern int TolerancePips     = 2;
extern int TP_koef           = 6;

double TodayHigh=0,TodayLow=0;
double SwapShort=0,SwapLong=0;
double Spread,ToHighPips=0,ToLowPips=0;
double EMA20_M5,EMA20_M15,EMA20_H1,EMA20_H4,EMA20_D1,EMA20_W1,EMA20_MN1;
int diffEMA20_M5,diffEMA20_M15,diffEMA20_H1,diffEMA20_H4,diffEMA20_D1,diffEMA20_W1,diffEMA20_MN1;
int TodayRange=0;
bool AlertPossible = true;

int init()
{
   return(0);
}

int deinit()
{
   Comment("");
   return(0);
}

int start()
{
   double R1=0,R5=0,R10=0,R20=0,RAvg=0,TP=0,LongUsed=0,ShortUsed=0;
   int k=0;  

   int digits=MarketInfo(Symbol(),MODE_DIGITS);
   SwapLong = MarketInfo(Symbol(),MODE_SWAPLONG);
   SwapShort = MarketInfo(Symbol(),MODE_SWAPSHORT);
   Spread =  MarketInfo(Symbol(),MODE_SPREAD);

   TodayHigh=iHigh(NULL,1440,0);
   TodayLow=iLow(NULL,1440,0);   
   TodayRange=(TodayHigh-TodayLow)/Point;

//+------------------------------------------------------------------+
//| Daily Range iteration function                              
//+------------------------------------------------------------------+ 

      double HI2 = iHigh(NULL,1440,0);
      double LOW2 = iLow(NULL,1440,0); 
      double HI3 = iHigh(NULL,1440,0+1);
      double LOW3 = iLow(NULL,1440,0+1);
      double HI4 = iHigh(NULL,1440,0);
      double LOW4 = iLow(NULL,1440,0);
      double HI5 = iHigh(NULL,1440,2);
      double LOW5 = iLow(NULL,1440,2);
      double HI6 = iHigh(NULL,1440,3);
      double LOW6 = iLow(NULL,1440,3);
      double HI7 = iHigh(NULL,1440,4);
      double LOW7 = iLow(NULL,1440,4);
      double HI8 = iHigh(NULL,1440,5);
      double LOW8 = iLow(NULL,1440,5);
      double HI9 = iHigh(NULL,1440,6);
      double LOW9 = iLow(NULL,1440,6);
      double HI10 = iHigh(NULL,1440,7);
      double LOW10 = iLow(NULL,1440,7);
      double HI11 = iHigh(NULL,1440,8);
      double LOW11 = iLow(NULL,1440,8);
      double HI12 = iHigh(NULL,1440,9);
      double LOW12 = iLow(NULL,1440,9);
      double HI13 = iHigh(NULL,1440,10);
      double LOW13 = iLow(NULL,1440,10);
      double HI14 = iHigh(NULL,1440,11);
      double LOW14 = iLow(NULL,1440,11);
      double HI15 = iHigh(NULL,1440,12);
      double LOW15 = iLow(NULL,1440,12);
      double HI16 = iHigh(NULL,1440,13);
      double LOW16 = iLow(NULL,1440,13);
      double HI17 = iHigh(NULL,1440,14);
      double LOW17 = iLow(NULL,1440,14);
      double HI18 = iHigh(NULL,1440,15);
      double LOW18 = iLow(NULL,1440,15);
      double HI19 = iHigh(NULL,1440,16);
      double LOW19 = iLow(NULL,1440,16);
      double HI20 = iHigh(NULL,1440,17);
      double LOW20 = iLow(NULL,1440,17);
      double HI21 = iHigh(NULL,1440,18);
      double LOW21 = iLow(NULL,1440,18); 
      double HI22 = iHigh(NULL,1440,19);
      double LOW22 = iLow(NULL,1440,19);
      double HI23 = iHigh(NULL,1440,20);
      double LOW23 = iLow(NULL,1440,20);
 
      double ONE2 = (HI3-LOW3)/2;
      double FIVE2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8))/10;
      double TEN2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8)+
                    (HI9-LOW9)+(HI10-LOW10)+(HI11-LOW11)+(HI12-LOW12)+(HI13-LOW13))/20;  

  double TWENTY2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8)+
               (HI9-LOW9)+(HI10-LOW10)+(HI11-LOW11)+(HI12-LOW12)+(HI13-LOW13)+
               (HI14-LOW14)+(HI15-LOW15)+(HI16-LOW16)+(HI17-LOW17)+(HI18-LOW18)+
               (HI19-LOW19)+(HI20-LOW20)+(HI21-LOW21)+(HI22-LOW22)+(HI23-LOW23))/40;  
               
  double AV2 = (ONE2+FIVE2+TEN2+TWENTY2)/4;
      
  double HIDaily2 = iHigh(NULL,1440,0)-(AV2)*2; 
  double LOWDaily2 =iLow(NULL,1440,0)+(AV2)*2; 

  string TDR =   DoubleToStr(LOWDaily2,Digits);
  string BDR =   DoubleToStr(HIDaily2,Digits);
  double TDR2 =  StrToDouble(TDR);
  double BDR2 =  StrToDouble(BDR);  
  

   R1 =  (iHigh(NULL,PERIOD_D1,1)-iLow(NULL,PERIOD_D1,1))/Point;
   for(k=1;k<=5;k++)    R5    =  R5  +  (iHigh(NULL,PERIOD_D1,k)-iLow(NULL,PERIOD_D1,k))/Point;
   for(k=1;k<=10;k++)   R10   =  R10 +  (iHigh(NULL,PERIOD_D1,k)-iLow(NULL,PERIOD_D1,k))/Point;
   for(k=1;k<=20;k++)   R20   =  R20 +  (iHigh(NULL,PERIOD_D1,k)-iLow(NULL,PERIOD_D1,k))/Point;

   R5    = R5/5;
   R10   = R10/10;
   R20   = R20/20;
   RAvg  = NormalizeDouble((R5+R10+R20)/3,0); 
   TP    = NormalizeDouble(RAvg/TP_koef,0); 
   Spread=(Ask - Bid);
   ToHighPips=(TodayHigh-Ask+Spread)/Point;
   ToLowPips=(Ask-TodayLow-Spread)/Point;   
   LongUsed=NormalizeDouble((ToLowPips/RAvg*100),2);
   ShortUsed=NormalizeDouble((ToHighPips/RAvg*100),2);

   EMA20_M5 = NormalizeDouble(iMA(NULL,PERIOD_M5,20,0,MODE_EMA,PRICE_CLOSE,0),Digits);
   EMA20_M15 = NormalizeDouble(iMA(NULL,PERIOD_M15,20,0,MODE_EMA,PRICE_CLOSE,0),Digits);
   EMA20_H1 = NormalizeDouble(iMA(NULL,PERIOD_H1,20,0,MODE_EMA,PRICE_CLOSE,0),Digits);
   EMA20_H4 = NormalizeDouble(iMA(NULL,PERIOD_H4,20,0,MODE_EMA,PRICE_CLOSE,0),Digits);
   EMA20_D1 = NormalizeDouble(iMA(NULL,PERIOD_D1,20,0,MODE_EMA,PRICE_CLOSE,0),Digits);
   EMA20_W1 = NormalizeDouble(iMA(NULL,PERIOD_W1,20,0,MODE_EMA,PRICE_CLOSE,0),Digits);   
   EMA20_MN1 = NormalizeDouble(iMA(NULL,PERIOD_MN1,20,0,MODE_EMA,PRICE_CLOSE,0),Digits);   
   diffEMA20_M5 = (Bid-EMA20_M5)/Point;
   diffEMA20_M15 = (Bid-EMA20_M15)/Point;
   diffEMA20_H1 = (Bid-EMA20_H1)/Point;
   diffEMA20_H4 = (Bid-EMA20_H4)/Point;   
   diffEMA20_D1 = (Bid-EMA20_D1)/Point;   
   diffEMA20_W1 = (Bid-EMA20_W1)/Point;      
   diffEMA20_MN1 = (Bid-EMA20_MN1)/Point; 

   if (Alert_M5_Cross){if (diffEMA20_M5<=TolerancePips && diffEMA20_M5>=-TolerancePips) {MakeAlert("M5 Cross EMA20",1); }}   
   if (Alert_M15_Cross){if (diffEMA20_M15<=TolerancePips && diffEMA20_M15>=-TolerancePips) {MakeAlert("M15 Cross EMA20",1); }}
   if (Alert_H1_Cross){if (diffEMA20_H1<=TolerancePips && diffEMA20_H1>=-TolerancePips) {MakeAlert("H1 Cross EMA20",1); }}
   if (Alert_H4_Cross){if (diffEMA20_H4<=TolerancePips && diffEMA20_H4>=-TolerancePips) {MakeAlert("H4 Cross EMA20",1); }}    
   if (Alert_D1_Cross){if (diffEMA20_D1<=TolerancePips && diffEMA20_D1>=-TolerancePips) {MakeAlert("D1 Cross EMA20",1); }} 
   if (Alert_W1_Cross){if (diffEMA20_W1<=TolerancePips && diffEMA20_W1>=-TolerancePips) {MakeAlert("W1 Cross EMA20",1); }}
   if (Alert_MN1_Cross){if (diffEMA20_MN1<=TolerancePips && diffEMA20_MN1>=-TolerancePips) {MakeAlert("MN1 Cross EMA20",1); }}
   
//---
    
   if (ShowMarketInfo)
      {
      Comment("\n","* M5(",diffEMA20_M5,") M15(",diffEMA20_M15,") H1(",diffEMA20_H1,") H4(",diffEMA20_H4,") D1(",diffEMA20_D1,") W1(",diffEMA20_W1,") MN(",diffEMA20_MN1,")",
              "\n","* TODAYS RANGE: ",TodayRange,
              "\n","* LONG USED: ",LongUsed,"%",
              "\n","* SHORT USED: ",ShortUsed,"%",
              "\n","* AVG. DAILY RANGE: ",RAvg,
              "\n","* PROFIT TARGET: ",TP,
              "\n","* SWAP L: ",SwapLong,", S: ", SwapShort,            
              "\n","* LEVERAGE: ",AccountLeverage(), ", SPREAD: ",Spread/Point
              );
      } else
      {
      Comment("\n","* M5(",diffEMA20_M5,") M15(",diffEMA20_M15,") H1(",diffEMA20_H1,") H4(",diffEMA20_H4,") D1(",diffEMA20_D1,") W1(",diffEMA20_W1,") MN(",diffEMA20_MN1,")",
              "\n","* TODAYS RANGE: ",TodayRange,
              "\n","* LONG USED: ",LongUsed,"%",
              "\n","* SHORT USED: ",ShortUsed,"%",
              "\n","* AVG. DAILY RANGE: ",RAvg,
              "\n","* PROFIT TARGET: ",TP
              );      
   }
}

//+------------------------------------------------------------------+

datetime	AlertTime;
void MakeAlert(string _Notice, int Index)
{
	if (Index >= 1)            								 return;
	if (AlertTime == iTime(Symbol(), Period(), Index)) return;
	
	AlertTime = iTime(Symbol(), Period(), Index);
	string Notice = StringConcatenate("Cross ", Symbol(), " ", _Notice);
	if (AlertPossible)    {PlaySound(Sound); if (AlertOnlySound==false) {Alert(Notice);}}
	if (SendMailPossible) SendMail(Notice, "");
}


