//+------------------------------------------------------------------+
//|                                                 BucCM_Master.mq4 |
//|                                    Copyright  2007, Petr Kouril |
//|                                           http://www.jaktrade.cz |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, Petr Kouril"
#property link      "http://www.bucafon.cz"

#define           REVISION                "1.2"

#property indicator_chart_window

#property indicator_buffers 7

extern bool  ShowName        = true;
extern bool  ShowPrice       = false;
extern bool AlertPossible    = true;
extern bool AlertOnlySound   = true;
extern string Sound          = "tick.wav";
extern bool SendMailPossible = false;
extern color Color_PP = SteelBlue;
extern color Color_R1 = SteelBlue;
extern color Color_R2 = SteelBlue;
extern color Color_R3 = SteelBlue;
extern color Color_S1 = SteelBlue;
extern color Color_S2 = SteelBlue;
extern color Color_S3 = SteelBlue;

//---- buffers
double            PivotBuff[], R1Buff[], R2Buff[], R3Buff[], S1Buff[], S2Buff[], S3Buff[];
int               TimeFrame;

int init()
{
   string PerName;
   
   PerName   = "Weekly";
   TimeFrame = PERIOD_W1;

	IndicatorBuffers(7);

   SetIndexStyle (0, DRAW_LINE,1,1,Color_PP);
   SetIndexBuffer(0, PivotBuff);
   SetIndexLabel (0, PerName + "Weekly PP");

   SetIndexStyle (1, DRAW_LINE,1,1,Color_R1);
   SetIndexBuffer(1, R1Buff);
   SetIndexLabel (1, PerName + "Weekly R1");

   SetIndexStyle (2, DRAW_LINE,1,1,Color_R2);
   SetIndexBuffer(2, R2Buff);
   SetIndexLabel (2, PerName + "Weekly R2");

   SetIndexStyle (3, DRAW_LINE,1,1,Color_R3);
   SetIndexBuffer(3, R3Buff);
   SetIndexLabel (3, PerName + "Weekly R3");

   SetIndexStyle (4, DRAW_LINE,1,1,Color_S1);
   SetIndexBuffer(4, S1Buff);
   SetIndexLabel (4, PerName + "Weekly S1");

   SetIndexStyle (5, DRAW_LINE,1,1,Color_S2);
   SetIndexBuffer(5, S2Buff);
   SetIndexLabel (5, PerName + "Weekly S2");

   SetIndexStyle (6, DRAW_LINE,1,1,Color_S3);
   SetIndexBuffer(6, S3Buff);
   SetIndexLabel (6, PerName + "Weekly S3");
   
   return(0);
}

int deinit()
{
   ObjectDelete("WeeklyP");
   ObjectDelete("txtWeeklyP");
   ObjectDelete("WeeklyR1");
   ObjectDelete("txtWeeklyR1");
   ObjectDelete("WeeklyR2");
   ObjectDelete("txtWeeklyR2");
   ObjectDelete("WeeklyR3");
   ObjectDelete("txtWeeklyR3");   
   ObjectDelete("WeeklyS1");
   ObjectDelete("txtWeeklyS1");
   ObjectDelete("WeeklyS2");
   ObjectDelete("txtWeeklyS2");
   ObjectDelete("WeeklyS3");
   ObjectDelete("txtWeeklyS3");   

   Comment("");
   return(0);
}

int start()
{
   int counted_bars = IndicatorCounted();
   if (counted_bars<0) return(-1);
   if (counted_bars>0) counted_bars--;
   int i, limit = Bars-counted_bars;

   double Cl, Hi, Lo;
   for (i = (limit-1); i >= 0; i--)
	{
	   GetCHL(i, Cl, Hi, Lo);

      if (NewBar())
      {
        ObjectDelete("WeeklyP");
        ObjectDelete("txtWeeklyP");
        ObjectDelete("WeeklyR1");
        ObjectDelete("txtWeeklyR1");
        ObjectDelete("WeeklyR2");
        ObjectDelete("txtWeeklyR2");
        ObjectDelete("WeeklyR3");
        ObjectDelete("txtWeeklyR3");   
        ObjectDelete("WeeklyS1");
        ObjectDelete("txtWeeklyS1");
        ObjectDelete("WeeklyS2");
        ObjectDelete("txtWeeklyS2");
        ObjectDelete("WeeklyS3");
        ObjectDelete("txtWeeklyS3");       
      }
      	   
      PivotBuff[i] = ((Hi + Lo + Cl)/3);
      if (ShowPrice) SetPrice("WeeklyP", Time[i], PivotBuff[i], Color_PP);
      if (ShowName) SetText("txtWeeklyP", "Weekly Pivot", Time[20], PivotBuff[i], Color_PP);
      if (PivotBuff[i]==Bid) {MakeAlert("Weekly Pivot", i); }

      R1Buff[i]    = (2 * PivotBuff[i]) - Lo;
      if (ShowPrice) SetPrice("WeeklyR1", Time[i], R1Buff[i], Color_R1);
      if (ShowName) SetText("txtWeeklyR1", "Weekly R1", Time[20], R1Buff[i], Color_R1);
      if (R1Buff[i]==Bid) {MakeAlert("Weekly R1", i); }

      S1Buff[i]    = (2 * PivotBuff[i]) - Hi;
      if (ShowPrice) SetPrice("WeeklyS1", Time[i], S1Buff[i], Color_S1);
      if (ShowName) SetText("txtWeeklyS1", "Weekly S1", Time[20], S1Buff[i], Color_S1);
      if (S1Buff[i]==Bid) {MakeAlert("Weekly S1", i); }

      R2Buff[i]    = PivotBuff[i] + (R1Buff[i] - S1Buff[i]);
      if (ShowPrice) SetPrice("WeeklyR2", Time[i], R2Buff[i], Color_R2);
      if (ShowName) SetText("txtWeeklyR2", "Weekly R2", Time[20], R2Buff[i], Color_R2);
      if (R2Buff[i]==Bid) {MakeAlert("Weekly R2", i); }

      S2Buff[i]    = PivotBuff[i] - (R1Buff[i] - S1Buff[i]);
      if (ShowPrice) SetPrice("WeeklyS2", Time[i], S2Buff[i], Color_S2);
      if (ShowName) SetText("txtWeeklyS2", "Weekly S2", Time[20], S2Buff[i], Color_S2);
      if (S2Buff[i]==Bid) {MakeAlert("Weekly S2", i); }

      R3Buff[i]    = (Hi + (2 * (PivotBuff[i] - Lo)));
      if (ShowPrice) SetPrice("WeeklyR3", Time[i], R3Buff[i], Color_R3);
      if (ShowName) SetText("txtWeeklyR3", "Weekly R3", Time[20], R3Buff[i], Color_R3);      
      if (R3Buff[i]==Bid) {MakeAlert("Weekly R3", i); }

      S3Buff[i]    = (Lo - (2 * (Hi - PivotBuff[i])));
      if (ShowPrice) SetPrice("WeeklyS3", Time[i], S3Buff[i], Color_S3);
      if (ShowName) SetText("txtWeeklyS3", "Weekly S3", Time[20], S3Buff[i], Color_S3);
      if (S3Buff[i]==Bid) {MakeAlert("Weekly S3", i); }
            
	}
}

void GetCHL(int Shift, double &Cl, double &Hi, double &Lo)
{
   double Cl1, Hi1, Lo1;
   int PeriodShift = iBarShift(Symbol(), TimeFrame, Time[Shift]);

   if ((TimeFrame == PERIOD_D1) && (TimeDayOfWeek(Time[Shift]) == 0)) PeriodShift++;
      
   Cl = iClose(Symbol(), TimeFrame, PeriodShift + 1);
   Hi = iHigh (Symbol(), TimeFrame, PeriodShift + 1);
   Lo = iLow  (Symbol(), TimeFrame, PeriodShift + 1);

   if ((TimeFrame == PERIOD_D1) && (TimeDayOfWeek(Time[Shift]) == 1))
   {
      Hi1 = iHigh (Symbol(), TimeFrame, PeriodShift + 2);
      Lo1 = iLow  (Symbol(), TimeFrame, PeriodShift + 2);
      
      if (Hi1 > Hi) Hi = Hi1;
      if (Lo1 < Lo) Lo = Lo1;
      
   }

}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void SetPrice(string name, datetime Tm, double Prc, color clr)
  {
   if(ObjectFind(name) == -1)
     {
       ObjectCreate(name, OBJ_ARROW, 0, Tm, Prc);
       ObjectSet(name, OBJPROP_COLOR, clr);
       ObjectSet(name, OBJPROP_WIDTH, 1);
       ObjectSet(name, OBJPROP_ARROWCODE, SYMBOL_RIGHTPRICE);
     }
   else
     {
       ObjectSet(name, OBJPROP_TIME1, Tm);
       ObjectSet(name, OBJPROP_PRICE1, Prc);
       ObjectSet(name, OBJPROP_COLOR, clr);
       ObjectSet(name, OBJPROP_WIDTH, 1);
       ObjectSet(name, OBJPROP_ARROWCODE, SYMBOL_RIGHTPRICE);
     } 
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void SetText(string name, string txt, datetime Tm, double Prc, color clr)
  {
   if(ObjectFind(name) == -1)
     {
       ObjectCreate(name, OBJ_TEXT, 0, Tm, Prc);
       ObjectSetText(name, txt, 8, "Times New Roman", clr);
       ObjectSet(name, OBJPROP_CORNER, 2);
     }
   else
     {
       ObjectSet(name, OBJPROP_TIME1, Tm);
       ObjectSet(name, OBJPROP_PRICE1, Prc);
       ObjectSetText(name, txt, 8, "Times New Roman", clr);
       ObjectSet(name, OBJPROP_CORNER, 2);
     } 
  }
//+------------------------------------------------------------------+

bool NewBar()
{
   static datetime dt = 0;
   if (dt != Time[0])
   {
      dt = Time[0];
      return(true);
   }
   return(false);
}

//+------------------------------------------------------------------+

datetime	AlertTime;
void MakeAlert(string _Notice, int Index)
{
	if (Index >= 1)            								 return;
	if (AlertTime == iTime(Symbol(), Period(), Index)) return;
	
	AlertTime = iTime(Symbol(), Period(), Index);
	string Notice = StringConcatenate("Cross ", Symbol(), " ", _Notice);
	if (AlertPossible)    {PlaySound(Sound); if (AlertOnlySound==false) {Alert(Notice);}}
	if (SendMailPossible) SendMail(Notice, "");
}

