//+------------------------------------------------------------------+
//|                                                 BucCM_Master.mq4 |
//|                                    Copyright  2007, Petr Kouril |
//|                                           http://www.jaktrade.cz |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, Petr Kouril"
#property link      "http://www.bucafon.cz"

#define           REVISION                "1.2"

#property indicator_chart_window

#property indicator_buffers 1

extern bool ShowName         = true;
extern bool ShowPrice        = true;
extern bool AlertPossible    = true;
extern bool AlertOnlySound   = true;
extern string Sound          = "tick.wav";
extern bool SendMailPossible = false;
extern color Color_PP = DeepSkyBlue;

extern int SundayData = 2;      // 0 - Monday pivot use Sunday data
                                // 1 - Monday pivot use Friday data
                                // 2 - Monday pivot use Friday + Sunday data


//---- buffers
double            PivotBuff[];
int               TimeFrame;

int init()
{
   string PerName;
   
   PerName   = "Daily";
   TimeFrame = PERIOD_D1;

	IndicatorBuffers(1);

   SetIndexStyle (0, DRAW_LINE,0,1,Color_PP);
   SetIndexBuffer(0, PivotBuff);
   SetIndexLabel (0, PerName + " Pivot");
   
   return(0);
}

int deinit()
{
   ObjectDelete("DailyP");
   ObjectDelete("txtDailyP");

   Comment("");
   return(0);
}

int start()
{
   
//---

   int counted_bars = IndicatorCounted();
   if (counted_bars<0) return(-1);
   if (counted_bars>0) counted_bars--;
   int i, limit = Bars-counted_bars;

   double Cl, Hi, Lo;
   for (i = (limit-1); i >= 0; i--)
	{
	   GetCHL(i, Cl, Hi, Lo);

      if (NewBar())
      {
        ObjectDelete("DailyP");
        ObjectDelete("txtDailyP");      
      }
	   
      PivotBuff[i] = ((Hi + Lo + Cl)/3);
      if (ShowPrice) SetPrice("DailyP", Time[i], PivotBuff[i], Color_PP);
      if (ShowName) SetText("txtDailyP", "dp", Time[10], PivotBuff[i], Color_PP);
      if (PivotBuff[i]==Bid) {MakeAlert("Pivot", i); }        
	}
}

void GetCHL(int Shift, double &Cl, double &Hi, double &Lo)
{
   double Cl1, Hi1, Lo1;
   int PeriodShift = iBarShift(Symbol(), TimeFrame, Time[Shift]);

   if ((TimeFrame == PERIOD_D1) && (TimeDayOfWeek(Time[Shift]) == 0)) PeriodShift++;
      
   Cl = iClose(Symbol(), TimeFrame, PeriodShift + 1);
   Hi = iHigh (Symbol(), TimeFrame, PeriodShift + 1);
   Lo = iLow  (Symbol(), TimeFrame, PeriodShift + 1);

   if ((TimeFrame == PERIOD_D1) && (TimeDayOfWeek(Time[Shift]) == 1))
   {
      if (SundayData == 1)
      {
         Cl = iClose(Symbol(), TimeFrame, PeriodShift + 2);
         Hi = iHigh (Symbol(), TimeFrame, PeriodShift + 2);
         Lo = iLow  (Symbol(), TimeFrame, PeriodShift + 2);
      }   
      if (SundayData == 2)
      {
         Hi1 = iHigh (Symbol(), TimeFrame, PeriodShift + 2);
         Lo1 = iLow  (Symbol(), TimeFrame, PeriodShift + 2);
      
         if (Hi1 > Hi) Hi = Hi1;
         if (Lo1 < Lo) Lo = Lo1;
      }
   }

}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void SetPrice(string name, datetime Tm, double Prc, color clr)
  {
   if(ObjectFind(name) == -1)
     {
       ObjectCreate(name, OBJ_ARROW, 0, Tm, Prc);
       ObjectSet(name, OBJPROP_COLOR, clr);
       ObjectSet(name, OBJPROP_WIDTH, 1);
       ObjectSet(name, OBJPROP_ARROWCODE, SYMBOL_RIGHTPRICE);
     }
   else
     {
       ObjectSet(name, OBJPROP_TIME1, Tm);
       ObjectSet(name, OBJPROP_PRICE1, Prc);
       ObjectSet(name, OBJPROP_COLOR, clr);
       ObjectSet(name, OBJPROP_WIDTH, 1);
       ObjectSet(name, OBJPROP_ARROWCODE, SYMBOL_RIGHTPRICE);
     } 
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void SetText(string name, string txt, datetime Tm, double Prc, color clr)
  {
   if(ObjectFind(name) == -1)
     {
       ObjectCreate(name, OBJ_TEXT, 0, Tm, Prc);
       ObjectSetText(name, txt, 8, "Times New Roman", clr);
       ObjectSet(name, OBJPROP_CORNER, 2);
     }
   else
     {
       ObjectSet(name, OBJPROP_TIME1, Tm);
       ObjectSet(name, OBJPROP_PRICE1, Prc);
       ObjectSetText(name, txt, 8, "Times New Roman", clr);
       ObjectSet(name, OBJPROP_CORNER, 2);
     } 
  }
//+------------------------------------------------------------------+

bool NewBar()
{
   static datetime dt = 0;
   if (dt != Time[0])
   {
      dt = Time[0];
      return(true);
   }
   return(false);
}

//+------------------------------------------------------------------+

datetime	AlertTime;
void MakeAlert(string _Notice, int Index)
{
	if (Index >= 1)            								 return;
	if (AlertTime == iTime(Symbol(), Period(), Index)) return;
	
	AlertTime = iTime(Symbol(), Period(), Index);
	string Notice = StringConcatenate("Cross ", Symbol(), " ", _Notice);
	if (AlertPossible)    {PlaySound(Sound); if (AlertOnlySound==false) {Alert(Notice);}}
	if (SendMailPossible) SendMail(Notice, "");
}

