//-----------------------------------------------------------------------------
// File: 5scalp_EA.mq4
//
// Desc: 5scalp EA ;-)
//
//
// Copyright (c) japapatramtara@gmail.com & cleve@email.cz
//-----------------------------------------------------------------------------


#property copyright "japapatramtara@gmail.com & cleve@email.cz"

#include <WinUser32.mqh>

#import "FunFraLib.dll"   
   double GetDummyVal();
   int POSITION_SHORT();
   int POSITION_LONG();
   void ShowSimpleMessage(string text, string caption);
#import

   int magic = 20090509;
////////////////////////////////////
/// properties

   /// risk(in %)
   extern double g_percentageOfRisk = 1;

   extern double g_maximalSize = 5.0;
   /// profit target
   extern int g_PT = 7;

   /// maximal allowed SL 
   /**
      if algorithm computes larger SL than value bellow, 
      order won't be placed. If you want to swith off this behaviour, 
      simply fill the value with some big number
   */
   extern int g_maxSL = 1000;   
   extern int g_minSL = 10;
   extern int g_SLOffsetThanLastHigh = 5;
   
   extern double g_longRSI  = 70;
   extern double g_shortRSI = 30;
/////////////////////////////////////////////////////< properties

//-----------------------------------------------------------------------------
// assembly near position equal to [percentageOfRisk]%
double GetPositionSize(int SL)
{
   double minimalSize = 0.1;
   double ammount = AccountBalance()*g_percentageOfRisk*0.01;
   double size = ammount/SL*minimalSize;
      
   if (size<minimalSize)
      size = minimalSize;
      
   if (size>g_maximalSize)
      size = g_maximalSize;
   Print ("SL: ", SL, "ms: ", minimalSize,"acc: ", AccountBalance(), 
      " ammount: ",ammount, " size: ", size);
//   ShowSimpleMessage("","");
   return (size);
}

//-----------------------------------------------------------------------------
bool IsStopLossInRange(int SLpips)
{
   return (SLpips<g_maxSL);
}

//-----------------------------------------------------------------------------
// try to open position at given price and mode
int OpenPosition(double price, int positionMode)
{
   double orderSL    = GetDummyVal();
   double orderSize  = GetDummyVal();   
   
   if (positionMode==POSITION_LONG())
   {      
      orderSL = Low[1]-g_SLOffsetThanLastHigh*Point;
      
      if (MathAbs(orderSL-price)<g_minSL*Point)
         orderSL = 
            NormalizeDouble(price-g_minSL*Point,Digits);
    
      int orderSLpips = MathAbs(orderSL-price)/Point;
      if (!IsStopLossInRange(orderSLpips))
      {
         Print ("SL is greater than maxSL. Order won't be filled");
         return (1);
      }   
      // we won't set pt here.. 
      // pt will be set when order will be filled
      int orderTicket = 
         OrderSend(Symbol(),OP_BUY,GetPositionSize(orderSLpips),
            price,0,orderSL,price+g_PT*Point,"",magic,0,Orange);
      
      return (orderTicket);
   }
   else if (positionMode==POSITION_SHORT())
   {
      orderSL = High[1]+g_SLOffsetThanLastHigh*Point;
      
      if (MathAbs(orderSL-price)<g_minSL*Point)
         orderSL = 
            NormalizeDouble(price+g_minSL*Point,Digits);
    
      orderSLpips = MathAbs(orderSL-price)/Point;
      if (!IsStopLossInRange(orderSLpips))
      {
         Print ("SL is greater than maxSL. Order won't be filled");
         return (1);
      }   
      // we won't set pt here.. 
      // pt will be set when order will be filled
      orderTicket = 
         OrderSend(Symbol(),OP_SELL,GetPositionSize(orderSLpips),
            price,0,orderSL,price-g_PT*Point,"",magic,0,Orange);
      
      return (orderTicket);
   }
   
   return (0);
}

//-----------------------------------------------------------------------------
void OpenPosIfPossible()
{
   double lastRSI  = iRSI(NULL,0,14,PRICE_CLOSE,1);
   double emaHigh = iMA(NULL,0,5,0,MODE_EMA,PRICE_HIGH,0);
   double emaLow  = iMA(NULL,0,5,0,MODE_EMA,PRICE_LOW,0);
   double lastClose = Close[1];
   double lastOpen  = Open[1];
   
   // check short
   if ((lastClose>lastOpen) && (lastClose>emaHigh) && (lastRSI>g_longRSI))
   {
      OpenPosition(Bid,POSITION_SHORT());
      
      return;
   }
   
   // check long
   if ((lastClose<lastOpen) && (lastClose<emaLow) && (lastRSI<g_shortRSI))
   {
      OpenPosition(Ask,POSITION_LONG());
      
      return;
   }   
}

//-----------------------------------------------------------------------------
int start()
{         
   // basic invariants
   if (Bars<1)
      return (0);
      
   if (Volume[0]>1)
      return (0);

   OpenPosIfPossible();
   
   return(0);
}

//-----------------------------------------------------------------------------
int init()
{

   return(0);
}

//-----------------------------------------------------------------------------
int deinit()
{   
   Print ("-------------FINAL---------------");
   // NOTHING TO DO HERE(close all orders maybe?)
   return(0);
}

