//-----------------------------------------------------------------------------
// File: FunFraCpp.mq4
//
// Desc: ultra cool EA ;-)
//
//
// Copyright (c) japapatramtara@gmail.com & cleve@email.cz
//-----------------------------------------------------------------------------


#property copyright "japapatramtara@gmail.com & cleve@email.cz"

#include <WinUser32.mqh>

#import "FunFraLib.dll"   
   double GetMagic();
   double GetDummyVal();
   double GetLastFract();
   void SetLastFract(double val);
   int GetMinBarsNeeded();
   int FRACT_LOW();
   int FRACT_HIGH();
   int POSITION_SHORT();
   int POSITION_LONG();
   bool LookingForFract(double dataArray[], int arrSize, int mode, double &out[1]);
   bool CanProcessTrade();
   bool CanStart(int bars);

   int GetIBoolTrueVal();
   int GetIBoolFalseVal();
   bool GetBoolTrueVal();
   bool GetBoolFalseVal();
   void ShowSimpleMessage(string text, string caption);
#import


////////////////////////////////////
/// properties

   /// risk(in %)
   extern double g_percentageOfRisk = 1;

   /// time to live of orders(in days)
   extern int g_ordersTTL =  30;

   /// order price offset
   /**
         (e.g. my broker doesn't allow put stop/limit 
         orders at actual price)
   */
   extern int g_pipsDistFromPrice = 5;
   extern double g_maximalSize = 5.0;
   /// profit target
   extern int g_PT = 20;

   /// maximal allowed SL 
   /**
      if algorithm computes larger SL than value bellow, 
      order won't be placed. If you want to swith off this behaviour, 
      simply fill the value with some big number
   */
   extern int g_maxSL = 1000;   
   extern int g_minSL = 10;
/////////////////////////////////////////////////////< properties

//-----------------------------------------------------------------------------
// assembly near position equal to [percentageOfRisk]%
double GetPositionSize(int SL)
{
   double minimalSize = 0.1;
   double ammount = AccountBalance()*g_percentageOfRisk*0.01;
   double size = ammount/SL*minimalSize;
      
   if (size<minimalSize)
      size = minimalSize;
      
   if (size>g_maximalSize)
      size = g_maximalSize;
   Print ("SL: ", SL, "ms: ", minimalSize,"acc: ", AccountBalance(), 
      " ammount: ",ammount, " size: ", size);
//   ShowSimpleMessage("","");
   return (size);
}

//-----------------------------------------------------------------------------
bool IsStopLossInRange(int SLpips)
{
   return (SLpips<g_maxSL);
}

//-----------------------------------------------------------------------------
// try to open position at given price and mode
int OpenPosition(double price, int positionMode)
{
//   return (1);
   double orderPrice = GetDummyVal();
   double orderSL    = GetDummyVal();
   double orderSize  = GetDummyVal();
   datetime orderExp = TimeCurrent()+60*60*24*g_ordersTTL;
   
   if (positionMode==POSITION_LONG())
   {      
      orderPrice = price + g_pipsDistFromPrice*Point;   
      orderSL    = 
         NormalizeDouble(orderPrice-MathAbs(orderPrice-GetLastFract())/2,Digits);
      
      if (MathAbs(orderSL-orderPrice)<g_minSL*Point)
         orderSL = 
            NormalizeDouble(orderPrice-g_minSL*Point,Digits);
    
      int orderSLpips = MathAbs(orderSL-orderPrice)/Point;
      if (!IsStopLossInRange(orderSLpips))
      {
         Print ("SL is greater than maxSL. Order won't be filled");
         return (1);
      }   
      // we won't set pt here.. 
      // pt will be set when order will be filled
      int orderTicket = 
         OrderSend(Symbol(),OP_BUYSTOP,GetPositionSize(orderSLpips),
            orderPrice,0,orderSL,0,"My order #2",GetMagic(),orderExp,Orange);
      
      return (orderTicket);
   }
   else if (positionMode==POSITION_SHORT())
   {
      orderPrice = price - g_pipsDistFromPrice*Point;
      orderSL    = 
         NormalizeDouble(orderPrice+MathAbs(orderPrice-GetLastFract())/2,Digits);
    
      
      if (MathAbs(orderSL-orderPrice)<g_minSL*Point)
         orderSL = 
            NormalizeDouble(orderPrice+g_minSL*Point,Digits);
   
      orderSLpips = MathAbs(orderSL-orderPrice)/Point;   
      if (!IsStopLossInRange(orderSLpips))
      {
         Print ("SL is greater than maxSL. Order won't be filled");
         return (1);
      }   

      // we won't set pt here.. 
      // pt will be set when order will be filled
      orderTicket = 
         OrderSend(Symbol(),OP_SELLSTOP,GetPositionSize(orderSLpips),
            orderPrice,0,orderSL,0,"My order #2",GetMagic(),orderExp,Orange);
      
      return (orderTicket);
   }
   
   return (0);
}

//-----------------------------------------------------------------------------
double ComputePT(int posType)
{
   double val=0.0;
   
   if (posType==POSITION_LONG())
      val = Open[0]+g_PT*Point;
   else if (posType==POSITION_SHORT())
      val = Open[0]-g_PT*Point;
  
   return (val);
}

//-----------------------------------------------------------------------------
void SetProfitTargetsIfNeeded()
{
   for( int i=0;i<OrdersTotal();i++)
   {
      if (OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==false)
      {
         string text = "select order by pos at: " + i + " failed";
         MessageBox(text,"error",MB_OK);
         continue;
      }
      
      // order was sucessfully selected
      // let's set new PT
      if (OrderSymbol()==Symbol() && OrderMagicNumber()==GetMagic())
      {
         
         if (OrderType()==OP_BUY)
         {
            Print ("modifing buy price: ", OrderOpenPrice(),
               " OpenBarPrice: ", Open[0]);
            // buy.. so we modify the PT
            // to open price of current Bar
            // but only of BarOpenValue>=OrderOpenPrice()
            if (OrderOpenPrice()<=Open[0])            
               if (!OrderModify(OrderTicket(),OrderOpenPrice(),
                  OrderStopLoss(), ComputePT(POSITION_LONG()),0,Blue))
                  {
                     // no changes were made,
                     // we can continue
                     if (GetLastError()==1)
                        continue;
                        
                     Print ("ot: ",OrderTicket()," op: ",OrderOpenPrice(),
                        " os: ",OrderStopLoss()," opt: ",
                           ComputePT(POSITION_LONG()));
                           
                     ShowSimpleMessage(GetLastError(),"Order modify");
                  }                  
         }
         
         if (OrderType()==OP_SELL)
         {
            Print ("modifing buy price: ", OrderOpenPrice(),
               " OpenBarPrice: ", Open[0]);
            // sell.. so we modify the PT
            // to open price of current Bar
            // but only of BarOpenValue<=OrderOpenPrice()
            if (OrderOpenPrice()>=Open[0])            
               if (!OrderModify(OrderTicket(),OrderOpenPrice(),
                  OrderStopLoss(), ComputePT(POSITION_SHORT()),0,Blue))
                  {
                     // no changes were made,
                     // we can continue
                     if (GetLastError()==1)
                        continue;
                        
                     Print ("ot: ",OrderTicket()," op: ",OrderOpenPrice(),
                        " os: ",OrderStopLoss()," opt: ",
                           ComputePT(POSITION_SHORT()));
                        
                     ShowSimpleMessage(GetLastError(),"Order modify");
                  }
         }
      }
   }
}

//-----------------------------------------------------------------------------
int start()
{         
   // basic invariants
   if (!CanStart(Bars))
      return (0);
      
   if (Volume[0]>1)
      return (0);

   // modify PT by first open price in next bar
   SetProfitTargetsIfNeeded();
   
   // get delta of drawn bars and actual bars
   // and process changes(if any)

      // temporary referenced value
      double value[1];
      // we're working with 5 bars fractal method
      // (can be changed later.. )
      // let's compute up fracts
      double highArray[1];
      ArrayResize(highArray,GetMinBarsNeeded()+1);
      ArrayCopy(highArray,High,0,0,GetMinBarsNeeded()+1);
      
      double lowArray[1];
      ArrayResize(lowArray,GetMinBarsNeeded()+1);
      ArrayCopy(lowArray,Low,0,0,GetMinBarsNeeded()+1);
   
      if (LookingForFract(highArray,GetMinBarsNeeded()+1,FRACT_HIGH(),value))
      {
         double val = value[0];
         
         // if fractVal is higher than actual ask price, open position
         if ((Ask<val) && (CanProcessTrade()))
            if (OpenPosition(val,POSITION_LONG())<0)
               Alert("OrderSend failed with error #",GetLastError());
  
         
         if (GetLastFract()!=val)
         {    
            Comment("\nlastFrac: ",GetLastFract(), " ", val);
            SetLastFract(val);
         }
      }
      //and now down too :-)
      else if (LookingForFract(lowArray,GetMinBarsNeeded()+1,FRACT_LOW(),value)==true)
     {         
         val = value[0];

         // if fractVal is higher than actual ask price, open position
         if ((Bid>val) && (CanProcessTrade()))            
            if (OpenPosition(val,POSITION_SHORT())<0)
               Alert("OrderSend failed with error #",GetLastError());

         if (GetLastFract()!=val)
         {    
            Comment("\nlastFrac: ",GetLastFract(), " ", val);
            SetLastFract(val);
         }
     }    
      
   return(0);
}

//-----------------------------------------------------------------------------
int init()
{
   // init of last low and last high fract to DUMMY_VALUE
//   m_lastLowFract  = DUMMY_VALUE;
//   m_lastHighFract = DUMMY_VALUE;
   
   return(0);
}

//-----------------------------------------------------------------------------
int deinit()
{   
   Print ("-------------FINAL---------------");
   // NOTHING TO DO HERE(close all orders maybe?)
   return(0);
}

