//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private EDS[] cacheEDS = null;

        private static EDS checkEDS = new EDS();

        /// <summary>
        /// Ensign Data Server Indicator
        /// </summary>
        /// <returns></returns>
        public EDS EDS()
        {
            return EDS(Input);
        }

        /// <summary>
        /// Ensign Data Server Indicator
        /// </summary>
        /// <returns></returns>
        public EDS EDS(Data.IDataSeries input)
        {

            if (cacheEDS != null)
                for (int idx = 0; idx < cacheEDS.Length; idx++)
                    if (cacheEDS[idx].EqualsInput(input))
                        return cacheEDS[idx];

            EDS indicator = new EDS();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.SetUp();

            EDS[] tmp = new EDS[cacheEDS == null ? 1 : cacheEDS.Length + 1];
            if (cacheEDS != null)
                cacheEDS.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cacheEDS = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Ensign Data Server Indicator
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EDS EDS()
        {
            return _indicator.EDS(Input);
        }

        /// <summary>
        /// Ensign Data Server Indicator
        /// </summary>
        /// <returns></returns>
        public Indicator.EDS EDS(Data.IDataSeries input)
        {
            return _indicator.EDS(input);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Ensign Data Server Indicator
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.EDS EDS()
        {
            return _indicator.EDS(Input);
        }

        /// <summary>
        /// Ensign Data Server Indicator
        /// </summary>
        /// <returns></returns>
        public Indicator.EDS EDS(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.EDS(input);
        }

    }
}
#endregion
