// 
// Copyright (C) 2009 Brouky

#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Vykreslovani dennich High/ Low a Power Lines
	/// 
	/// </summary>
    [Description("Vykreslovani dennich High/Low a Power Lines")]
    public class PowerZones_v06 : Indicator
    {
        #region Variables
		
       	private double power_pct = 33.33;
		private int dist_tcks = 10;
		private bool display_Dist = true;
		private int text_dist_tcks = 6;
		private int min_dist_tcks = 0;
		private int rb_tcks = 8;
		
		private int fill_Zones_Type = 2;
		
		private double lastHigh = double.MinValue;
		private double lastLow	= double.MaxValue;
		private const double nonValue = -999.99;
		private Font fontText;
		private	System.Drawing.Font		textFont		= new Font("Arial", 10);
        
		#endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
			Add(new Plot( new Pen( Color.Green,1), PlotStyle.Line, "DayHigh"));
            Add(new Plot( new Pen( Color.LimeGreen,1), PlotStyle.Line, "DayHigh_Dist"));
			Add(new Plot( new Pen( Color.LimeGreen,1), PlotStyle.Line, "DayHigh_Power"));
			Add(new Plot( new Pen( Color.PaleVioletRed,1), PlotStyle.Line, "DayLow"));
            Add(new Plot( new Pen( Color.LightPink,1), PlotStyle.Line, "DayLow_Dist"));
			Add(new Plot( new Pen( Color.LightPink,1), PlotStyle.Line, "DayLow_Power"));
			Add(new Plot( new Pen( Color.Cyan,1), PlotStyle.Line, "PowerNeutral"));
            
			CalculateOnBarClose	= false;
            Overlay				= true;
            PriceTypeSupported	= false;
			
			fontText = new Font("Arial", 10);
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {	
			if ( Bars.SessionBreak )
			{		
				lastHigh = double.MinValue;
				lastLow = double.MaxValue;
			}
			
			lastHigh	=	( High[0]	> lastHigh ) 	? High[0] 	: lastHigh;
			lastLow		=	( Low[0]	< lastLow ) 	? Low[0] 	: lastLow;
			
			double dblDayRange = lastHigh - lastLow;
			double dblPowerNeutral = lastLow + dblDayRange/2;
			double dblDayHighDist = lastHigh - dist_tcks * TickSize;
			double dblDayLowDist = lastLow + dist_tcks * TickSize;
			double dblDayHighPower = lastHigh - power_pct * dblDayRange / 100;
			double dblDayLowPower = lastLow + power_pct * dblDayRange / 100;
						
            Plot0.Set( lastHigh );
			Plot1.Set( dblDayHighDist );
			Plot2.Set( dblDayHighPower );
			
			Plot3.Set( lastLow );
			Plot4.Set( dblDayLowDist );
			Plot5.Set( dblDayLowPower );			
			
			Plot6.Set( dblPowerNeutral );
			
			if (display_Dist)				
			{
				double dblDist_tcks = 0;
				double dblMaxDist_tcks = 0;
				bool LgStatus = false;
				if (Open [0] > dblPowerNeutral)	LgStatus = true ;
			
				if (LgStatus)
				{
					dblDist_tcks = (dblDayHighDist - Low[0])/TickSize - rb_tcks ;
					dblMaxDist_tcks = (lastHigh - Low[0])/TickSize - rb_tcks ;
				}
				else
				{
					dblDist_tcks = (High[0] - dblDayLowDist)/TickSize - rb_tcks ;
					dblMaxDist_tcks = (High[0] - lastLow)/TickSize - rb_tcks ;
				}
				
				if (fill_Zones_Type == 1)
				{
					DrawRegion("PowerUp", CurrentBar, 0, Plot0, Plot2, Color.Empty, Color.PaleGreen, 2);	
					DrawRegion("PowerDown", CurrentBar, 0, Plot3, Plot5, Color.Empty, Color.LightPink, 2);	
				}

				if (fill_Zones_Type == 2)
				{
					if (Plot1[0]>Plot2[0])
					{
						DrawRegion("PowerUp", CurrentBar, 0, Plot1, Plot2, Color.Empty, Color.PaleGreen, 2);	
					}
					else
					{
						DrawRegion("PowerUp", CurrentBar, 0, Plot1, Plot2, Color.Empty, Color.Empty, 2);	
					}
					if (Plot4[0]<Plot5[0]) DrawRegion("PowerDown", CurrentBar, 0, Plot4, Plot5, Color.Empty, Color.Red,1);	
				}
				bool DistOK = true;
				if (dblDist_tcks < min_dist_tcks) DistOK = false;
				string txt2 = dblDist_tcks.ToString("0") + " ΔDist" + "\n"
							+ dblMaxDist_tcks.ToString("0") + " ΔH/L";
				
				if (LgStatus)
				{
					if (DistOK)
					{
						DrawText("",true,txt2,0,Low[0] - text_dist_tcks * TickSize,Color.Black,textFont,StringAlignment.Near ,Color.White,Color.White,5);
					}
					else
					{
						DrawText("",true,txt2,0,Low[0] - text_dist_tcks * TickSize,Color.Black,textFont,StringAlignment.Near ,Color.White,Color.Red,5);
					}
				}
				else
				{
					if (DistOK)
					{
						DrawText("",true,txt2,0,High[0] + text_dist_tcks * TickSize,Color.Black,textFont,StringAlignment.Near ,Color.White,Color.White,5);
					}
					else
					{
						DrawText("",true,txt2,0,High[0] + text_dist_tcks * TickSize,Color.Black,textFont,StringAlignment.Near ,Color.White,Color.Red,5);
					}
				}
        	}
		}

		
        #region Properties
		
        [Browsable(false)]
        [XmlIgnore()]
        public DataSeries Plot0
        {
            get { return Values[0]; }
        }
		[Browsable(false)]
        [XmlIgnore()]
        public DataSeries Plot1
        {
            get { return Values[1]; }
        }
		[Browsable(false)]
        [XmlIgnore()]
        public DataSeries Plot2
        {
            get { return Values[2]; }
        }
		[Browsable(false)]
        [XmlIgnore()]
        public DataSeries Plot3
        {
            get { return Values[3]; }
        }
		[Browsable(false)]
        [XmlIgnore()]
        public DataSeries Plot4
        {
            get { return Values[4]; }
        }
		[Browsable(false)]
        [XmlIgnore()]
        public DataSeries Plot5
        {
            get { return Values[5]; }
        }
		[Browsable(false)]
        [XmlIgnore()]
        public DataSeries Plot6
        {
            get { return Values[6]; }
        }
		[Browsable(false)]
        [XmlIgnore()]
        public DataSeries Plot7
        {
            get { return Values[7]; }
        }

        [Description("Vzdalenost Power Lines od dennich maxim v procentech denniho rozpeti")]
        [Category("Parameters")]
        public double Power_pct
        {
            get { return power_pct; }
            set { power_pct = Math.Max(1, value); }
        }

        [Description("Vzdalenost Dist Lines od dennich maxim v tickach")]
        [Category("Parameters")]
        public int Dist_tcks
        {
            get { return dist_tcks; }
            set { dist_tcks = Math.Max(0, value); }
        }

		[Description("Vybarvit PowerZones a zobrazit vzdalenost predpokladane close od Dist Line")]
        [Category("Parameters")]
        public bool View_Dist
        {
            get { return display_Dist; }
            set { display_Dist = value; }
        }
		
		[Description("Minimalni vzdalenost v tickach predpokladane High svice od Dist Line (pro longy; obdobne shorty)")]
        [Category("Parameters")]
        public int Min_Dist_tcks
        {
            get { return min_dist_tcks; }
            set { min_dist_tcks = Math.Max(1, value); }
        }

		[Description("Vzdalenost textu v tickach od Low svice (pro longy - obdobne shorty)")]
        [Category("Parameters")]
        public int Text_Dist_tcks
        {
            get { return text_dist_tcks; }
            set { text_dist_tcks = value; }
		}
		
		[Description("Velikost Range Bars v tickach")]
        [Category("Parameters")]
        public int RB_tcks
        {
            get { return rb_tcks; }
            set { rb_tcks = Math.Max(1, value); }
        }
	
		[Description("Typ vybarvovani Power Zones: 0 - nic; 1 - color od Power Line k max dne; 2 - vybarveni od Power Line k Dist Line")]
        [Category("Parameters")]
        public int Fill_Zones_Type
        {
            get { return fill_Zones_Type; }
            set { fill_Zones_Type = Math.Max(0, value); }
        }

		
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private PowerZones_v06[] cachePowerZones_v06 = null;

        private static PowerZones_v06 checkPowerZones_v06 = new PowerZones_v06();

        /// <summary>
        /// Vykreslovani dennich High/Low a Power Lines
        /// </summary>
        /// <returns></returns>
        public PowerZones_v06 PowerZones_v06(int dist_tcks, int fill_Zones_Type, int min_Dist_tcks, double power_pct, int rB_tcks, int text_Dist_tcks, bool view_Dist)
        {
            return PowerZones_v06(Input, dist_tcks, fill_Zones_Type, min_Dist_tcks, power_pct, rB_tcks, text_Dist_tcks, view_Dist);
        }

        /// <summary>
        /// Vykreslovani dennich High/Low a Power Lines
        /// </summary>
        /// <returns></returns>
        public PowerZones_v06 PowerZones_v06(Data.IDataSeries input, int dist_tcks, int fill_Zones_Type, int min_Dist_tcks, double power_pct, int rB_tcks, int text_Dist_tcks, bool view_Dist)
        {
            checkPowerZones_v06.Dist_tcks = dist_tcks;
            dist_tcks = checkPowerZones_v06.Dist_tcks;
            checkPowerZones_v06.Fill_Zones_Type = fill_Zones_Type;
            fill_Zones_Type = checkPowerZones_v06.Fill_Zones_Type;
            checkPowerZones_v06.Min_Dist_tcks = min_Dist_tcks;
            min_Dist_tcks = checkPowerZones_v06.Min_Dist_tcks;
            checkPowerZones_v06.Power_pct = power_pct;
            power_pct = checkPowerZones_v06.Power_pct;
            checkPowerZones_v06.RB_tcks = rB_tcks;
            rB_tcks = checkPowerZones_v06.RB_tcks;
            checkPowerZones_v06.Text_Dist_tcks = text_Dist_tcks;
            text_Dist_tcks = checkPowerZones_v06.Text_Dist_tcks;
            checkPowerZones_v06.View_Dist = view_Dist;
            view_Dist = checkPowerZones_v06.View_Dist;

            if (cachePowerZones_v06 != null)
                for (int idx = 0; idx < cachePowerZones_v06.Length; idx++)
                    if (cachePowerZones_v06[idx].Dist_tcks == dist_tcks && cachePowerZones_v06[idx].Fill_Zones_Type == fill_Zones_Type && cachePowerZones_v06[idx].Min_Dist_tcks == min_Dist_tcks && Math.Abs(cachePowerZones_v06[idx].Power_pct - power_pct) <= double.Epsilon && cachePowerZones_v06[idx].RB_tcks == rB_tcks && cachePowerZones_v06[idx].Text_Dist_tcks == text_Dist_tcks && cachePowerZones_v06[idx].View_Dist == view_Dist && cachePowerZones_v06[idx].EqualsInput(input))
                        return cachePowerZones_v06[idx];

            PowerZones_v06 indicator = new PowerZones_v06();
            indicator.BarsRequired = BarsRequired;
            indicator.CalculateOnBarClose = CalculateOnBarClose;
            indicator.Input = input;
            indicator.Dist_tcks = dist_tcks;
            indicator.Fill_Zones_Type = fill_Zones_Type;
            indicator.Min_Dist_tcks = min_Dist_tcks;
            indicator.Power_pct = power_pct;
            indicator.RB_tcks = rB_tcks;
            indicator.Text_Dist_tcks = text_Dist_tcks;
            indicator.View_Dist = view_Dist;
            indicator.SetUp();

            PowerZones_v06[] tmp = new PowerZones_v06[cachePowerZones_v06 == null ? 1 : cachePowerZones_v06.Length + 1];
            if (cachePowerZones_v06 != null)
                cachePowerZones_v06.CopyTo(tmp, 0);
            tmp[tmp.Length - 1] = indicator;
            cachePowerZones_v06 = tmp;
            Indicators.Add(indicator);

            return indicator;
        }

    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Vykreslovani dennich High/Low a Power Lines
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PowerZones_v06 PowerZones_v06(int dist_tcks, int fill_Zones_Type, int min_Dist_tcks, double power_pct, int rB_tcks, int text_Dist_tcks, bool view_Dist)
        {
            return _indicator.PowerZones_v06(Input, dist_tcks, fill_Zones_Type, min_Dist_tcks, power_pct, rB_tcks, text_Dist_tcks, view_Dist);
        }

        /// <summary>
        /// Vykreslovani dennich High/Low a Power Lines
        /// </summary>
        /// <returns></returns>
        public Indicator.PowerZones_v06 PowerZones_v06(Data.IDataSeries input, int dist_tcks, int fill_Zones_Type, int min_Dist_tcks, double power_pct, int rB_tcks, int text_Dist_tcks, bool view_Dist)
        {
            return _indicator.PowerZones_v06(input, dist_tcks, fill_Zones_Type, min_Dist_tcks, power_pct, rB_tcks, text_Dist_tcks, view_Dist);
        }

    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Vykreslovani dennich High/Low a Power Lines
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PowerZones_v06 PowerZones_v06(int dist_tcks, int fill_Zones_Type, int min_Dist_tcks, double power_pct, int rB_tcks, int text_Dist_tcks, bool view_Dist)
        {
            return _indicator.PowerZones_v06(Input, dist_tcks, fill_Zones_Type, min_Dist_tcks, power_pct, rB_tcks, text_Dist_tcks, view_Dist);
        }

        /// <summary>
        /// Vykreslovani dennich High/Low a Power Lines
        /// </summary>
        /// <returns></returns>
        public Indicator.PowerZones_v06 PowerZones_v06(Data.IDataSeries input, int dist_tcks, int fill_Zones_Type, int min_Dist_tcks, double power_pct, int rB_tcks, int text_Dist_tcks, bool view_Dist)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.PowerZones_v06(input, dist_tcks, fill_Zones_Type, min_Dist_tcks, power_pct, rB_tcks, text_Dist_tcks, view_Dist);
        }

    }
}
#endregion
